/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.report.client.AbstractMTOBillTraceFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class MTOBillTraceFilterUI
extends AbstractMTOBillTraceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MTOBillTraceFilterUI.class);
    public static final String REPORT_RESOURCE = "com.kingdee.eas.mm.report.ReportResource";
    private DataChangeListener storageDataChanged = null;

    public MTOBillTraceFilterUI() throws Exception {
        this.isReport = false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboBillStatus.removeAllItems();
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.NULL);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.SUBMITED);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.DELETED);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.AUDITED);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.RELEASED);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.BLOCKED);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.CLOSED);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.COMPLETE);
        this.comboBillStatus.addItem((Object)BillBaseStatusEnum.FINCLOSED);
        this.prmtStorageOrgUnit.setValue((Object)this.getPermittedOrgUnit((OrgUnitInfo)SysContext.getSysContext().getCurrentUserInfo().getDefOrgUnit(), OrgType.Storage, this.getViewPermission()));
        this.setSelectTrackNumberEnabled();
        this.initFilterElements();
    }

    protected void setDefaultValue() {
        this.setSelectTrackNumberEnabled();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageDataChanged);
        super.loadData(entityViewInfo);
        if (this.rbtTrackNumber.isSelected()) {
            this.prmtTrackNumber.setEnabled(true);
            this.prmtSaleOrgUnit.setEnabled(false);
            this.prmtSaleOrderNumberFrom.setEnabled(false);
            this.prmtSaleOrderNumberTo.setEnabled(false);
            this.pkOrderDateFrom.setEnabled(false);
            this.pkOrderDateTo.setEnabled(false);
            this.prmtMaterialNumFrom.setEnabled(false);
            this.prmtMaterialNumTo.setEnabled(false);
            this.prmtCustomerNumFrom.setEnabled(false);
            this.prmtCustomerNumTo.setEnabled(false);
            this.pkDateFrom.setEnabled(false);
            this.pkDateTo.setEnabled(false);
            this.prmtTrackNumFrom.setEnabled(false);
            this.prmtTrackNumTo.setEnabled(false);
            this.comboBillStatus.setEnabled(false);
        } else {
            this.prmtSaleOrgUnit.setEnabled(true);
            this.prmtSaleOrderNumberFrom.setEnabled(true);
            this.prmtSaleOrderNumberTo.setEnabled(true);
            this.pkOrderDateFrom.setEnabled(true);
            this.pkOrderDateTo.setEnabled(true);
            this.prmtMaterialNumFrom.setEnabled(true);
            this.prmtMaterialNumTo.setEnabled(true);
            this.prmtCustomerNumFrom.setEnabled(true);
            this.prmtCustomerNumTo.setEnabled(true);
            this.pkDateFrom.setEnabled(true);
            this.pkDateTo.setEnabled(true);
            this.prmtTrackNumFrom.setEnabled(true);
            this.prmtTrackNumTo.setEnabled(true);
            this.comboBillStatus.setEnabled(true);
            this.prmtTrackNumber.setEnabled(false);
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageDataChanged);
    }

    public void initListener() {
        this.rbtTrackNumber.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MTOBillTraceFilterUI.this.setSelectTrackNumberEnabled();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.rbtSaleOrder.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MTOBillTraceFilterUI.this.setSelectSaleOrderEnabled();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.storageDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MTOBillTraceFilterUI.this.prmtTrackNumber.setValue(null);
                MTOBillTraceFilterUI.this.resetValue();
                if (MTOBillTraceFilterUI.this.prmtSaleOrgUnit.isEnabled()) {
                    MTOBillTraceFilterUI.this.prmtSaleOrgUnit.setValue((Object)MTOBillTraceFilterUI.this.getSaleOrgUnit());
                    Date today = new Date();
                    Date dayFrom = new Date();
                    MTOBillTraceFilterUI.this.pkOrderDateTo.setValue((Object)today);
                    dayFrom.setMonth(today.getMonth() - 1);
                    MTOBillTraceFilterUI.this.pkOrderDateFrom.setValue((Object)dayFrom);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageDataChanged);
    }

    private void resetValue() {
        this.prmtSaleOrgUnit.setValue(null);
        this.prmtSaleOrderNumberFrom.setValue(null);
        this.prmtSaleOrderNumberTo.setValue(null);
        this.pkOrderDateFrom.setValue(null);
        this.pkOrderDateTo.setValue(null);
        this.prmtMaterialNumFrom.setValue(null);
        this.prmtMaterialNumTo.setValue(null);
        this.prmtCustomerNumFrom.setValue(null);
        this.prmtCustomerNumTo.setValue(null);
        this.pkDateFrom.setValue(null);
        this.pkDateTo.setValue(null);
        this.prmtTrackNumFrom.setValue(null);
        this.prmtTrackNumTo.setValue(null);
        this.comboBillStatus.setSelectedItem(null);
    }

    public void setSelectTrackNumberEnabled() {
        this.rbtTrackNumber.setSelected(true);
        this.prmtTrackNumber.setEnabled(true);
        this.resetValue();
        this.prmtSaleOrgUnit.setEnabled(false);
        this.prmtSaleOrderNumberFrom.setEnabled(false);
        this.prmtSaleOrderNumberTo.setEnabled(false);
        this.pkOrderDateFrom.setEnabled(false);
        this.pkOrderDateTo.setEnabled(false);
        this.prmtMaterialNumFrom.setEnabled(false);
        this.prmtMaterialNumTo.setEnabled(false);
        this.prmtCustomerNumFrom.setEnabled(false);
        this.prmtCustomerNumTo.setEnabled(false);
        this.pkDateFrom.setEnabled(false);
        this.pkDateTo.setEnabled(false);
        this.prmtTrackNumFrom.setEnabled(false);
        this.prmtTrackNumTo.setEnabled(false);
        this.comboBillStatus.setEnabled(false);
    }

    public void setSelectSaleOrderEnabled() {
        this.rbtSaleOrder.setSelected(true);
        this.prmtSaleOrgUnit.setEnabled(true);
        this.kDContainer1.requestFocus();
        this.prmtSaleOrderNumberFrom.setEnabled(true);
        this.prmtSaleOrderNumberTo.setEnabled(true);
        this.pkOrderDateFrom.setEnabled(true);
        this.pkOrderDateTo.setEnabled(true);
        Date today = new Date();
        Date dayFrom = new Date();
        this.pkOrderDateTo.setValue((Object)today);
        dayFrom.setMonth(today.getMonth() - 1);
        this.pkOrderDateFrom.setValue((Object)dayFrom);
        this.prmtMaterialNumFrom.setEnabled(true);
        this.prmtMaterialNumTo.setEnabled(true);
        this.prmtCustomerNumFrom.setEnabled(true);
        this.prmtCustomerNumTo.setEnabled(true);
        this.pkDateFrom.setEnabled(true);
        this.pkDateTo.setEnabled(true);
        this.prmtTrackNumFrom.setEnabled(true);
        this.prmtTrackNumTo.setEnabled(true);
        this.comboBillStatus.setEnabled(true);
        this.prmtSaleOrgUnit.setValue((Object)this.getSaleOrgUnit());
        this.prmtTrackNumber.setValue(null);
        this.prmtTrackNumber.setEnabled(false);
    }

    public void initFilterElements() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)REPORT_RESOURCE, (String)"STORAGEORGUNIT_CANT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        SingleFilterElement btTrackNumberElement = new SingleFilterElement("btTrackNumber", (Component)this.rbtTrackNumber);
        elements.add((FilterElement)btTrackNumberElement);
        SingleFilterElement btSaleOrderElement = new SingleFilterElement("btSaleOrder", (Component)this.rbtSaleOrder);
        elements.add((FilterElement)btSaleOrderElement);
        SingleFilterElement trackNumberElement = new SingleFilterElement("trackNumber", (Component)this.prmtTrackNumber);
        elements.add((FilterElement)trackNumberElement);
        SingleFilterElement saleOrgUnitElement = new SingleFilterElement("saleOrgUnit", (Component)this.prmtSaleOrgUnit);
        elements.add((FilterElement)saleOrgUnitElement);
        elements.add((FilterElement)new RangeFilterElement("orderDateRange", (Component)this.pkOrderDateFrom, (Component)this.pkOrderDateTo));
        elements.add((FilterElement)new RangeFilterElement("saleOrderNumberRange", (Component)this.prmtSaleOrderNumberFrom, (Component)this.prmtSaleOrderNumberTo));
        elements.add((FilterElement)new RangeFilterElement("materialNumRange", (Component)this.prmtMaterialNumFrom, (Component)this.prmtMaterialNumTo));
        elements.add((FilterElement)new RangeFilterElement("customerNumRange", (Component)this.prmtCustomerNumFrom, (Component)this.prmtCustomerNumTo));
        elements.add((FilterElement)new RangeFilterElement("dateRange", (Component)this.pkDateFrom, (Component)this.pkDateTo));
        elements.add((FilterElement)new RangeFilterElement("trackNumRange", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        SingleFilterElement billStatus = new SingleFilterElement("billStatus", (Component)this.comboBillStatus);
        elements.add((FilterElement)billStatus);
        SingleFilterElement saleOrderInSale = new SingleFilterElement("saleOrderInSale", (Component)this.chkSaleOrderInSale);
        elements.add((FilterElement)saleOrderInSale);
        SingleFilterElement plannedOrderInSale = new SingleFilterElement("plannedOrderInSale", (Component)this.chkPlannedOrderInSale);
        elements.add((FilterElement)plannedOrderInSale);
        SingleFilterElement manufactureOrderInSale = new SingleFilterElement("manufactureOrderInSale", (Component)this.chkManufactureOrderInSale);
        elements.add((FilterElement)manufactureOrderInSale);
        SingleFilterElement productionOrderInSale = new SingleFilterElement("productionOrderInSale", (Component)this.chkProductionOrderInSale);
        elements.add((FilterElement)productionOrderInSale);
        SingleFilterElement purRequestInSale = new SingleFilterElement("purRequestInSale", (Component)this.chkPurRequestInSale);
        elements.add((FilterElement)purRequestInSale);
        SingleFilterElement purOrderInSale = new SingleFilterElement("purOrderInSale", (Component)this.chkPurOrderInSale);
        elements.add((FilterElement)purOrderInSale);
        SingleFilterElement purReqInSale = new SingleFilterElement("purReqInSale", (Component)this.chkPurReqInSale);
        elements.add((FilterElement)purReqInSale);
        SingleFilterElement stockTransferBillInSale = new SingleFilterElement("stockTransferBillInSale", (Component)this.chkStockTransferBillInSale);
        elements.add((FilterElement)stockTransferBillInSale);
        SingleFilterElement transferOrderBillInSale = new SingleFilterElement("transferOrderBillInSale", (Component)this.chkTransferOrderBillInSale);
        elements.add((FilterElement)transferOrderBillInSale);
        SingleFilterElement saleIssueBillInSale = new SingleFilterElement("saleIssueBillInSale", (Component)this.chkSaleIssueBillInSale);
        elements.add((FilterElement)saleIssueBillInSale);
        SingleFilterElement manufactureOrderInManu = new SingleFilterElement("manufactureOrderInManu", (Component)this.chkManufactureOrderInManu);
        elements.add((FilterElement)manufactureOrderInManu);
        SingleFilterElement materialReqBillInManu = new SingleFilterElement("materialReqBillInManu", (Component)this.chkMaterialReqBillInManu);
        elements.add((FilterElement)materialReqBillInManu);
        SingleFilterElement wPTransferBillInManu = new SingleFilterElement("wPTransferBillInManu", (Component)this.chkWPTransferBillInManu);
        elements.add((FilterElement)wPTransferBillInManu);
        SingleFilterElement completionReportInManu = new SingleFilterElement("completionReportInManu", (Component)this.chkCompletionReportInManu);
        elements.add((FilterElement)completionReportInManu);
        SingleFilterElement scrapOrderInManu = new SingleFilterElement("scrapOrderInManu", (Component)this.chkScrapOrderInManu);
        elements.add((FilterElement)scrapOrderInManu);
        SingleFilterElement stockTransferBillInManu = new SingleFilterElement("stockTransferBillInManu", (Component)this.chkStockTransferBillInManu);
        elements.add((FilterElement)stockTransferBillInManu);
        SingleFilterElement transferOrderBillInManu = new SingleFilterElement("transferOrderBillInManu", (Component)this.chkTransferOrderBillInManu);
        elements.add((FilterElement)transferOrderBillInManu);
        SingleFilterElement manufactureRecBillInManu = new SingleFilterElement("manufactureRecBillInManu", (Component)this.chkManufactureRecBillInManu);
        elements.add((FilterElement)manufactureRecBillInManu);
        SingleFilterElement productionOrderInProd = new SingleFilterElement("productionOrderInProd", (Component)this.chkProductionOrderInProd);
        elements.add((FilterElement)productionOrderInProd);
        SingleFilterElement taskDispBillInProd = new SingleFilterElement("taskDispBillInProd", (Component)this.chkTaskDispBillInProd);
        elements.add((FilterElement)taskDispBillInProd);
        SingleFilterElement pickingSlipBillInProd = new SingleFilterElement("pickingSlipBillInProd", (Component)this.chkPickingSlipBillInProd);
        elements.add((FilterElement)pickingSlipBillInProd);
        SingleFilterElement materialReqBillInProd = new SingleFilterElement("materialReqBillInProd", (Component)this.chkMaterialReqBillInProd);
        elements.add((FilterElement)materialReqBillInProd);
        SingleFilterElement finishedRptInProd = new SingleFilterElement("finishedRptInProd", (Component)this.chkFinishedRptInProd);
        elements.add((FilterElement)finishedRptInProd);
        SingleFilterElement manufactureRecBillInProd = new SingleFilterElement("manufactureRecBillInProd", (Component)this.chkManufactureRecBillInProd);
        elements.add((FilterElement)manufactureRecBillInProd);
        SingleFilterElement purRequestInReq = new SingleFilterElement("purRequestInReq", (Component)this.chkPurRequestInReq);
        elements.add((FilterElement)purRequestInReq);
        SingleFilterElement subContractOrderInReq = new SingleFilterElement("subContractOrderInReq", (Component)this.chkSubContractOrderInReq);
        elements.add((FilterElement)subContractOrderInReq);
        SingleFilterElement purInWarehsBillInReq = new SingleFilterElement("purInWarehsBillInReq", (Component)this.chkPurInWarehsBillInReq);
        elements.add((FilterElement)purInWarehsBillInReq);
        SingleFilterElement materialRequestBillInReq = new SingleFilterElement("materialRequestBillInReq", (Component)this.chkMaterialRequestBillInReq);
        elements.add((FilterElement)materialRequestBillInReq);
        this.getFilterManager().setElement((FilterElement)elements);
        this.initNeedMainOrgF7s();
    }

    public boolean verify() {
        boolean isVerifyPass = super.verify();
        if (!isVerifyPass) {
            return isVerifyPass;
        }
        if (this.rbtSaleOrder.isSelected()) {
            if (this.prmtSaleOrgUnit.getText() == null || "".equals(this.prmtSaleOrgUnit.getText())) {
                this.prmtSaleOrgUnit.requestFocus();
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"SALEORGUNIT_CANT_NULL"));
                return false;
            }
            if (this.pkOrderDateFrom.getValue() == null) {
                this.pkOrderDateFrom.requestFocus();
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"ORDERDATE_CANT_NULL"));
                return false;
            }
            if (this.pkOrderDateTo.getValue() == null) {
                this.pkOrderDateTo.requestFocus();
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"ORDERDATE_CANT_NULL"));
                return false;
            }
            if (!this.copareDate((Date)this.pkOrderDateFrom.getValue(), (Date)this.pkOrderDateTo.getValue())) {
                this.pkOrderDateTo.requestFocus();
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"ORDER_ENDDATE_LESSTHAN_STARTDATE"));
                return false;
            }
            if (!this.copareDate((Date)this.pkDateFrom.getValue(), (Date)this.pkDateTo.getValue())) {
                this.pkDateTo.requestFocus();
                MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"DELIVER_ENDDATE_LESSTHAN_STARTDATE"));
                return false;
            }
        } else if (this.prmtTrackNumber.getText() == null || "".equals(this.prmtTrackNumber.getText())) {
            this.prmtTrackNumber.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)REPORT_RESOURCE, (String)"TRACKNUMBER_CANT_NULL"));
            return false;
        }
        return isVerifyPass;
    }

    private boolean copareDate(Date startDate, Date endDate) {
        boolean compareResult = true;
        if (startDate != null && endDate != null) {
            int i = DateTimeUtils.truncateDate((Date)startDate).compareTo(DateTimeUtils.truncateDate((Date)endDate));
            compareResult = i <= 0;
        }
        return compareResult;
    }

    protected void initNeedMainOrgF7s() {
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumber);
        this.prmtSaleOrgUnit.setEnabledMultiSelection(true);
        this.setSaleOrgUnitF7(this.prmtStorageOrgUnit, this.prmtSaleOrgUnit);
        this.setSaleOrderF7(this.prmtSaleOrgUnit, this.prmtSaleOrderNumberFrom);
        this.setSaleOrderF7(this.prmtSaleOrgUnit, this.prmtSaleOrderNumberTo);
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtMaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtMaterialNumTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        EntityViewInfo entryview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterInfo entryfilter = new FilterInfo();
        entryfilter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)String.valueOf(10040), CompareType.NOTEQUALS));
        view.setFilter(filter);
        entryview.setFilter(entryfilter);
        this.prmtMaterialNumFrom.setEntityViewInfo(view);
        this.prmtMaterialNumTo.setEntityViewInfo(view);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialNumFrom, this.prmtMaterialNumTo});
        this.f7Manager.registerBizCustomerF7(this.prmtCustomerNumFrom, null, null, null);
        this.f7Manager.registerBizCustomerF7(this.prmtCustomerNumTo, null, null, null);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtSaleOrgUnit, (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtSaleOrgUnit, (KDBizPromptBox)this.prmtTrackNumTo);
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType, String permissionItem) {
        OrgUnitFilterInfoProducer iProducer = (OrgUnitFilterInfoProducer)FilterInfoProducerFactory.getOrgUnitFilterInfoProducer((OrgType)orgType);
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
    }

    protected String getViewPermission() {
        return "mm_MTOBillTrace_Query";
    }

    private SaleOrgUnitInfo getSaleOrgUnit() {
        OrgUnitInfo saleOrgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        OrgUnitCollection orgUnitInfo = null;
        OrgUnitCollection orgUnitInfoSelected = new OrgUnitCollection();
        OrgUnitInfo[] orgs = null;
        Object mainOrg = this.prmtStorageOrgUnit.getData();
        try {
            Object[] objects;
            int i;
            IOrgUnitRelation orgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
            if (mainOrg != null && mainOrg instanceof OrgUnitInfo) {
                orgUnitInfo = orgUnitRelation.getToUnit(((OrgUnitInfo)mainOrg).getId().toString(), 4, 2);
                orgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Sale, "saleorder_view");
                for (i = 0; null != orgs && i < orgs.length; ++i) {
                    for (int j = 0; j < orgUnitInfo.size(); ++j) {
                        if (!orgUnitInfo.get(j).getId().toString().equals(orgs[i].getId().toString())) continue;
                        orgUnitInfoSelected.add(orgUnitInfo.get(j));
                    }
                }
            }
            if (mainOrg instanceof Object[] && (objects = (Object[])mainOrg).length > 0) {
                for (int k = 0; k < objects.length; ++k) {
                    OrgUnitInfo orgInfo = (OrgUnitInfo)objects[k];
                    if (orgInfo == null) {
                        return null;
                    }
                    orgUnitInfo = orgUnitRelation.getToUnit(orgInfo.getId().toString(), 4, 2);
                    orgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Sale, "saleorder_view");
                    for (int i2 = 0; null != orgs && i2 < orgs.length; ++i2) {
                        for (int j = 0; j < orgUnitInfo.size(); ++j) {
                            if (!orgUnitInfo.get(j).getId().toString().equals(orgs[i2].getId().toString())) continue;
                            orgUnitInfoSelected.add(orgUnitInfo.get(j));
                        }
                    }
                }
            }
            if (saleOrgUnitInfo != null && !saleOrgUnitInfo.isIsSaleOrgUnit()) {
                return (SaleOrgUnitInfo)orgUnitInfoSelected.get(0);
            }
            for (i = 0; i < orgUnitInfoSelected.size(); ++i) {
                if (!orgUnitInfoSelected.get(i).getId().toString().equals(saleOrgUnitInfo.getId().toString())) continue;
                return (SaleOrgUnitInfo)orgUnitInfoSelected.get(i);
            }
            if (!orgUnitInfoSelected.isEmpty()) {
                return (SaleOrgUnitInfo)orgUnitInfoSelected.get(0);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return null;
    }

    private OrgUnitInfo getPermittedOrgUnit(OrgUnitInfo orgUnitInfo, OrgType orgType, String permision) throws EASBizException, BOSException {
        OrgUnitInfo[] orgs = null;
        orgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), orgType, permision);
        if (orgs.length == 0) {
            return null;
        }
        for (int i = 0; i < orgs.length; ++i) {
            if (!orgUnitInfo.getId().toString().equals(orgs[i].getId().toString())) continue;
            return orgUnitInfo;
        }
        return orgs[0];
    }

    private void setSaleOrgUnitF7(final KDBizPromptBox storageOrgUnitBox, final KDBizPromptBox saleOrgUnitBox) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        saleOrgUnitBox.setSelectorCollection(selectors);
        saleOrgUnitBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                saleOrgUnitBox.setEntityViewInfo(MTOBillTraceFilterUI.this.getSaleOrgUnitF7EntityView(storageOrgUnitBox));
                saleOrgUnitBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
        saleOrgUnitBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                saleOrgUnitBox.setEntityViewInfo(MTOBillTraceFilterUI.this.getSaleOrgUnitF7EntityView(storageOrgUnitBox));
                saleOrgUnitBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    public EntityViewInfo getSaleOrgUnitF7EntityView(KDBizPromptBox storageOrgUnitBox) {
        Object[] objects;
        Object mainOrg = storageOrgUnitBox.getData();
        FilterInfo filterInfo = new FilterInfo();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        OrgUnitInfo[] orgs = null;
        try {
            orgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Sale, "saleorder_view");
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        if (mainOrg == null) {
            keys.add("null");
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", keys, CompareType.INCLUDE));
        } else if (mainOrg != null && mainOrg instanceof OrgUnitInfo) {
            try {
                IOrgUnitRelation orgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection saleOrgUnitInfo = orgUnitRelation.getToUnit(((OrgUnitInfo)mainOrg).getId().toString(), 4, 2);
                for (int i = 0; i < saleOrgUnitInfo.size(); ++i) {
                    for (int j = 0; j < orgs.length; ++j) {
                        if (!saleOrgUnitInfo.get(i).getId().toString().equals(orgs[j].getId().toString())) continue;
                        keys.add(orgs[j].getId().toString());
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        } else if (mainOrg instanceof Object[] && (objects = (Object[])mainOrg).length > 0) {
            for (int k = 0; k < objects.length; ++k) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)objects[k];
                try {
                    IOrgUnitRelation orgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
                    OrgUnitCollection saleOrgUnitInfo = orgUnitRelation.getToUnit(orgInfo.getId().toString(), 4, 2);
                    for (int i = 0; i < saleOrgUnitInfo.size(); ++i) {
                        for (int j = 0; j < orgs.length; ++j) {
                            if (!saleOrgUnitInfo.get(i).getId().toString().equals(orgs[j].getId().toString()) || keys.contains(orgs[j].getId().toString())) continue;
                            keys.add(orgs[j].getId().toString());
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    this.handUIException(e);
                    SysUtil.abort();
                }
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", keys, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public void setSaleOrderF7(final KDBizPromptBox saleOrgUnitBox, final KDBizPromptBox saleOrder) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        saleOrder.setSelectorCollection(selectors);
        saleOrder.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                saleOrder.setEntityViewInfo(MTOBillTraceFilterUI.this.getSaleOrderF7EntityView(saleOrgUnitBox));
                saleOrder.getQueryAgent().resetRuntimeEntityView();
            }
        });
        saleOrder.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                saleOrder.setEntityViewInfo(MTOBillTraceFilterUI.this.getSaleOrderF7EntityView(saleOrgUnitBox));
                saleOrder.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    public EntityViewInfo getSaleOrderF7EntityView(KDBizPromptBox saleOrgUnitBox) {
        Object[] objects;
        Object mainOrg = saleOrgUnitBox.getData();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (mainOrg == null) {
            keys.add("null");
        } else if (mainOrg != null && mainOrg instanceof OrgUnitInfo) {
            keys.add(((OrgUnitInfo)mainOrg).getId().toString());
        } else if (mainOrg instanceof Object[] && (objects = (Object[])mainOrg).length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)objects[i];
                keys.add(orgInfo.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", keys, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }
}

