/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.mm.report.MonthEnum;
import com.kingdee.eas.mm.report.client.AbstractPieceworkWagesReportFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PieceworkWagesReportFilterUI
extends AbstractPieceworkWagesReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PieceworkWagesReportFilterUI.class);
    private String storageOrgUnitId = null;
    protected boolean isLoadingData = false;
    private String yearRegex = "[1][9][0-9]{2}|[2-9][0-9]{3}";
    private String[] monthNumber = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private DataChangeListener adminOrgDataChanged;

    public PieceworkWagesReportFilterUI() throws Exception {
        this.initComponent();
        this.initFilterElements();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)this.getViewPermission());
    }

    public void afterMainOrgChanged(String ids) {
        if (!this.isLoadingData && (ids == null || "".equals(ids.trim()))) {
            this.prmtAdminOrgUnit.setValue(null);
            this.prmtClassGroup.setValue(null);
            this.prmtPerson.setValue(null);
            this.storageOrgUnitId = ids;
            return;
        }
        if (!this.isLoadingData && !ids.equals(this.storageOrgUnitId)) {
            this.prmtAdminOrgUnit.setValue(null);
            this.prmtClassGroup.setValue(null);
            this.prmtPerson.setValue(null);
        }
        this.storageOrgUnitId = ids;
        Set delegatedAdminOrgUnitIds = new HashSet();
        try {
            delegatedAdminOrgUnitIds = this.getDelegatedAdminOrgUnitIds(ids);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setAdminOrgUnitF7(delegatedAdminOrgUnitIds);
        this.setClassGroupF7(ids);
    }

    public void clear() {
        super.clear();
        this.rbtAdminOrgUnit.setSelected(false);
        this.rbtClassGroup.setSelected(false);
        this.rbtPerson.setSelected(true);
    }

    public boolean verify() {
        boolean isVerifyPass = super.verify();
        if (!isVerifyPass) {
            return isVerifyPass;
        }
        if (this.isYearInvalid()) {
            this.txtYear.requestFocus();
            MsgBox.showInfo((String)this.getResource("YEAR_INVALID"));
            return false;
        }
        return isVerifyPass;
    }

    public boolean isReport() {
        return true;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_PieceworkWagesReport_view";
    }

    private boolean isYearInvalid() {
        String year = this.txtYear.getStringValue();
        Pattern pattern = Pattern.compile(this.yearRegex);
        Matcher matcher = pattern.matcher(year);
        return !matcher.find();
    }

    private void initComponent() {
        this.cmbMonth.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.report.MonthEnum").toArray());
        if (this.adminOrgDataChanged == null) {
            this.adminOrgDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        PieceworkWagesReportFilterUI.this.adminOrgUnit_Changed(eventObj);
                    }
                    catch (Exception e) {
                        PieceworkWagesReportFilterUI.this.handUIException(e);
                    }
                }
            };
        }
        this.prmtAdminOrgUnit.addDataChangeListener(this.adminOrgDataChanged);
    }

    protected void adminOrgUnit_Changed(DataChangeEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        if (isDiffrent) {
            LinkedHashSet<String> adminOrgUnitIds = new LinkedHashSet<String>();
            if (e.getNewValue() != null) {
                Object o = e.getNewValue();
                if (o instanceof Object[]) {
                    Object[] adminOrgs = (Object[])o;
                    int n = adminOrgs.length;
                    for (int i = 0; i < n; ++i) {
                        AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)adminOrgs[i];
                        adminOrgUnitIds.add(adminOrg.getId().toString());
                    }
                    if (!this.isLoadingData) {
                        this.prmtPerson.setValue(null);
                    }
                } else if (o instanceof AdminOrgUnitInfo) {
                    AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)o;
                    adminOrgUnitIds.add(adminOrg.getId().toString());
                    if (!this.isLoadingData) {
                        this.prmtPerson.setValue(null);
                    }
                }
            } else if (this.storageOrgUnitId != null) {
                Set set = this.getDelegatedAdminOrgUnitIds(this.storageOrgUnitId);
            }
        }
    }

    private void initFilterElements() {
        Calendar calendar = Calendar.getInstance();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("STORAGEORGUNIT_CANNOT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        SingleFilterElement yearFilterElement = new SingleFilterElement("txtYear", (Component)this.txtYear);
        int year = calendar.get(1);
        yearFilterElement.setDefaultValue((Object)new Integer(year).toString());
        elements.add((FilterElement)yearFilterElement);
        SingleFilterElement monthFilterElement = new SingleFilterElement("cmbMonth", (Component)this.cmbMonth);
        int month = calendar.get(2);
        monthFilterElement.setDefaultValue((Object)MonthEnum.getEnum(this.monthNumber[month]));
        elements.add((FilterElement)monthFilterElement);
        elements.add((FilterElement)new SingleFilterElement("prmtAdminOrgUnit", (Component)this.prmtAdminOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("prmtClassGroup", (Component)this.prmtClassGroup));
        this.registerPersonF7();
        elements.add((FilterElement)new SingleFilterElement("prmtPerson", (Component)this.prmtPerson));
        elements.add((FilterElement)new SingleFilterElement("rbtAdminOrgUnit", (Component)this.rbtAdminOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("rbtClassGroup", (Component)this.rbtClassGroup));
        elements.add((FilterElement)new SingleFilterElement("rbtPerson", (Component)this.rbtPerson));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private Set getDelegatedAdminOrgUnitIds(String storageOrgUnitId) throws Exception {
        LinkedHashSet<String> adminOrgUnitIds = new LinkedHashSet<String>();
        OrgUnitCollection orgUnitInfo = null;
        orgUnitInfo = OrgUnitRelationFactory.getRemoteInstance().getToUnit(storageOrgUnitId, 4, 0);
        if (orgUnitInfo != null) {
            for (int i = 0; i < orgUnitInfo.size(); ++i) {
                adminOrgUnitIds.add(orgUnitInfo.get(i).getId().toString());
            }
        }
        return adminOrgUnitIds;
    }

    private void setAdminOrgUnitF7(Set adminOrgUnitIds) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminOrgUnitIds, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtAdminOrgUnit.setEntityViewInfo(view);
    }

    private void setClassGroupF7(String storageOrgUnitId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId));
        view.setFilter(filter);
        this.prmtClassGroup.setEntityViewInfo(view);
    }

    private void registerPersonF7() {
        this.prmtPerson.setEnabledMultiSelection(true);
        this.prmtPerson.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.prmtPerson.setDisplayFormat("$number$");
        this.prmtPerson.setEditFormat("$number$");
        this.prmtPerson.setCommitFormat("$number$;$idNum$");
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("DEFAULT_SHOW_ALL", "DEFAULT_SHOW_ALL");
        hash.put("IS_SINGLE_SELECT", new Boolean(false));
        hash.put("0", "2");
        PersonPromptBox selector = new PersonPromptBox((IUIObject)this, hash);
        this.prmtPerson.setSelector((KDPromptSelector)selector);
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.ReportResource", (String)key);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.isLoadingData = true;
        super.loadData(entityViewInfo);
        this.isLoadingData = false;
    }
}

