/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.report.client.AbstractReqirementDataUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class ReqirementDataUI
extends AbstractReqirementDataUI {
    private static final Logger logger = CoreUIObject.getLogger(ReqirementDataUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtReqQty.setHorizontalAlignment(4);
    }

    public void setData(IRowSet rowSet, RptParams filter) throws Exception {
        BigDecimal amountMeasuredByBaseUnit;
        String reqNumber = null;
        String reqType = null;
        BigDecimal mrpItem = new BigDecimal("0");
        mrpItem = new BigDecimal(rowSet.getObject("FMRPItem").toString());
        if (mrpItem.compareTo(new BigDecimal("120")) == 0 || mrpItem.compareTo(new BigDecimal("320")) == 0 || mrpItem.compareTo(new BigDecimal("330")) == 0 || mrpItem.compareTo(new BigDecimal("331")) == 0 || mrpItem.compareTo(new BigDecimal("390")) == 0 || mrpItem.compareTo(new BigDecimal("251")) == 0 || mrpItem.compareTo(new BigDecimal("400")) == 0 || mrpItem.compareTo(new BigDecimal("300")) == 0 || mrpItem.compareTo(new BigDecimal("310")) == 0) {
            reqNumber = rowSet.getString("FBillnumWithoutSeq");
            reqType = this.getResource("INDEPENDENT_REQ");
        } else {
            reqNumber = rowSet.getString("FBillnum");
            reqType = this.getResource("DEPENDENT_REQ");
        }
        this.txtReqType.setText(reqType);
        this.txtReqNumber.setText(reqNumber);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyy-MM-dd");
        this.dpReqDate.setValue((Object)dateFormat.parse(rowSet.getString("FBilldate")));
        this.txtReqSource.setText(rowSet.getString("FMRP"));
        int qtyPrecision = rowSet.getInt("FBaseQtyPrc");
        BigDecimal amount = amountMeasuredByBaseUnit = rowSet.getBigDecimal("FAmount");
        if ("productionUnit".equals(filter.getString("displayUnit"))) {
            qtyPrecision = rowSet.getInt("FProdQtyPrc");
            BigDecimal converseRate = rowSet.getBigDecimal("FConvertRate");
            int precision = rowSet.getInt("FProdQtyPrc");
            amount = amountMeasuredByBaseUnit.divide(converseRate, precision, 4);
        }
        this.txtReqQty.setPrecision(qtyPrecision);
        this.txtReqQty.setRemoveingZeroInDispaly(false);
        this.txtReqQty.setSupportedEmpty(true);
        this.txtReqQty.setValue((Object)amount.negate());
        this.txtProjectNumber.setText(rowSet.getString("Fproject"));
        this.txtTackNumber.setText(rowSet.getString("FTrackNumber"));
        this.getUIContext().put("rowSet", rowSet);
        this.actionSetAttachData_actionPerformed(null);
    }

    public void resetData() {
        this.txtReqType.setText(null);
        this.txtReqNumber.setText(null);
        this.dpReqDate.setValue(null);
        this.txtReqSource.setText(null);
        this.txtReqQty.setValue(null);
        this.txtProjectNumber.setText(null);
        this.txtTackNumber.setText(null);
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.PlannerResource", (String)key);
    }
}

