/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.util.render.CellIconRender;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.mm.report.LightInfoEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;

public class SingleLigtRender
implements IBasicRender {
    private CellIconRender render = new CellIconRender();
    private CellTextRender txtRender = new CellTextRender();
    protected static final int BUTTONSIZE = 19;
    protected static final Color BGCOLOR = new Color(7645403);
    protected IDataFormat format;
    private boolean txt_display;

    public SingleLigtRender(boolean txt_display) {
        this.txt_display = txt_display;
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object instanceof LightInfoEnum) {
            Icon icon;
            int type = new Integer(((LightInfoEnum)((Object)object)).getValue());
            if (type <= 0) {
                type = 1;
            }
            if ((icon = this.getIcon(type)) != null) {
                int iconW = icon.getIconWidth();
                int iconH = icon.getIconHeight();
                if (iconW <= 0) {
                    iconW = this.getIconWidth();
                }
                if (iconH <= 0) {
                    iconH = this.getIconHeight();
                }
                Rectangle rect = (Rectangle)clip;
                int x = (rect.width - iconW) / 2;
                Rectangle rIcon = new Rectangle(x, rect.y, iconW, rect.height);
                Rectangle rText = new Rectangle(rIcon.x + rIcon.width + 5, rIcon.y, rect.width - 19, rect.height);
                if (rIcon.width > 0) {
                    this.render.draw(graphics, (Shape)rIcon, (Object)icon, cellStyle);
                }
                if (this.txt_display) {
                    this.txtRender.draw(graphics, (Shape)rText, (Object)this.getText(type), cellStyle);
                }
            }
        }
    }

    public Icon getIcon(int type) {
        String iconName = null;
        switch (type) {
            case 1: {
                iconName = "imgLight_red";
                break;
            }
            case 2: {
                iconName = "imgLight_yellow";
                break;
            }
            case 3: {
                iconName = "imgLight_green";
                break;
            }
        }
        return EASResource.getIcon((String)iconName);
    }

    public String getText(int type) {
        String text = null;
        switch (type) {
            case 1: {
                text = EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"33_PlanerWorkPlatformReportTotal");
                break;
            }
            case 2: {
                text = EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"57_SingleLigtRender");
                break;
            }
            case 3: {
                text = EASResource.getString((String)"com.kingdee.eas.mm.report.REPORTAutoGenerateResource", (String)"58_SingleLigtRender");
                break;
            }
        }
        return text;
    }

    protected Color getIconBackGround() {
        return BGCOLOR;
    }

    protected int getIconWidth() {
        return 27;
    }

    protected int getIconHeight() {
        return 9;
    }
}

