/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.bill.STDCostDataSourceTypeEnum;
import java.util.HashSet;

public class STDCostDataFilterParam
implements NCMIFilterParam {
    private static final long serialVersionUID = 6988383343113512334L;
    private StorageOrgUnitInfo storageOrgUnitInfo = null;
    private STDCostEstimateSchemeInfo[] estimateSchemes = null;
    private CalculateTypeEnum calculateTypeEnum = null;
    private MaterialInfo materialInfoFrom = null;
    private MaterialInfo materialInfoTo = null;
    private STDCostDataSourceTypeEnum dataType = null;
    private Boolean isOnlyNoStdPrice = Boolean.FALSE;

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.storageOrgUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("materialInventory.orgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.estimateSchemes != null && this.estimateSchemes.length > 0) {
            HashSet<String> _estimateSchemes = new HashSet<String>();
            int length = this.estimateSchemes.length;
            for (int i = 0; i < length; ++i) {
                _estimateSchemes.add(this.estimateSchemes[i].getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("estimateScheme.id", _estimateSchemes, CompareType.INCLUDE));
        }
        if (!CalculateTypeEnum.NULL.equals((Object)this.calculateTypeEnum)) {
            filter.getFilterItems().add(new FilterItemInfo("materialCompanyInfo.calculateType", (Object)this.calculateTypeEnum.getValue(), CompareType.EQUALS));
        }
        if (this.materialInfoFrom != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)this.materialInfoFrom.getNumber(), CompareType.GREATER_EQUALS));
        }
        if (this.materialInfoTo != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)this.materialInfoTo.getNumber(), CompareType.LESS_EQUALS));
        }
        if (!STDCostDataSourceTypeEnum.NULL.equals((Object)this.dataType)) {
            filter.getFilterItems().add(new FilterItemInfo("dataType", (Object)this.dataType.getValue(), CompareType.EQUALS));
        }
        if (this.isOnlyNoStdPrice.booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("stdAmount", null, CompareType.EMPTY));
        }
        return filter;
    }

    public StorageOrgUnitInfo getStorageOrgUnitInfo() {
        return this.storageOrgUnitInfo;
    }

    public void setStorageOrgUnitInfo(StorageOrgUnitInfo storageOrgUnitInfo) {
        this.storageOrgUnitInfo = storageOrgUnitInfo;
    }

    public STDCostEstimateSchemeInfo[] getEstimateSchemes() {
        return this.estimateSchemes;
    }

    public void setEstimateSchemes(STDCostEstimateSchemeInfo[] estimateScheme) {
        this.estimateSchemes = estimateScheme;
    }

    public CalculateTypeEnum getCalculateTypeEnum() {
        return this.calculateTypeEnum;
    }

    public void setCalculateTypeEnum(CalculateTypeEnum calculateTypeEnum) {
        this.calculateTypeEnum = calculateTypeEnum;
    }

    public MaterialInfo getMaterialInfoFrom() {
        return this.materialInfoFrom;
    }

    public void setMaterialInfoFrom(MaterialInfo materialInfoFrom) {
        this.materialInfoFrom = materialInfoFrom;
    }

    public MaterialInfo getMaterialInfoTo() {
        return this.materialInfoTo;
    }

    public void setMaterialInfoTo(MaterialInfo materialInfoTo) {
        this.materialInfoTo = materialInfoTo;
    }

    public STDCostDataSourceTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(STDCostDataSourceTypeEnum dataType) {
        this.dataType = dataType;
    }

    public Boolean getIsOnlyNoStdPrice() {
        return this.isOnlyNoStdPrice;
    }

    public void setIsOnlyNoStdPrice(Boolean isOnlyNoStdPrice) {
        this.isOnlyNoStdPrice = isOnlyNoStdPrice;
    }
}

