/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.ncm.common.utils.client.ExcelFileFilter;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class ExportHelper {
    public static final String RES = "com.kingdee.eas.fm.common.client.FMCommonClientResource";

    public static void export(Component ui, BOSObjectType bosType, KDTable table, String methodName, String logItemName) throws Exception {
        ExportHelper.export(ui, bosType, table, false, methodName, logItemName);
    }

    public static void export(Component ui, BOSObjectType bosType, KDTable table, boolean flag, String methodName, String logItemName) throws Exception {
        String filePath = null;
        ExcelFileFilter excleFilter = new ExcelFileFilter();
        SimpleFileFilter txtFilter = new SimpleFileFilter("txt");
        SimpleFileFilter csvFilter = new SimpleFileFilter("csv");
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setFileFilter((FileFilter)txtFilter);
        fileChooser.setFileFilter((FileFilter)csvFilter);
        fileChooser.setFileFilter((FileFilter)excleFilter);
        String fileName = null;
        File fileDir = null;
        String totalFileName = null;
        if (fileChooser.showSaveDialog(ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            fileDir = new File(filePath.substring(0, filePath.lastIndexOf("\\")));
            totalFileName = fileName = fileChooser.getSelectedFile().getName();
            if (fileName.lastIndexOf(".") != -1) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            totalFileName = fileChooser.getFileFilter() == excleFilter ? fileName + ".xls" : (fileChooser.getFileFilter() == txtFilter ? fileName + ".txt" : (fileChooser.getFileFilter() == csvFilter ? fileName + ".csv" : fileName + ".xls"));
            filePath = fileChooser.getFileFilter() == excleFilter ? filePath + ".xls" : (fileChooser.getFileFilter() == txtFilter ? filePath + ".txt" : (fileChooser.getFileFilter() == csvFilter ? filePath + ".csv" : filePath + ".xls"));
        } else {
            return;
        }
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File[] files = null;
        int status = -1;
        if (fileDir != null && fileDir.isDirectory()) {
            files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().equals(totalFileName) || (status = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)RES, (String)"FileExisted"))) != 2) continue;
                return;
            }
        }
        KDSBook kdsBook = new KDSBook(fileName);
        String sheetName = fileName;
        KDSSheet kdsSheet = flag ? table.getIOManager().saveToKDSSheet(kdsBook, true, false, sheetName) : table.getIOManager().saveToKDSSheet(kdsBook, true, false, false, sheetName);
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            IObjectPK logPK = null;
            if (ExportHelper.isNeedLog(methodName, bosType, logItemName)) {
                logPK = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)bosType, null, (String)fileName, (String)logItemName);
            }
            if (totalFileName.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                export.exportToExcel(kdsBook, filePath);
            } else {
                export.setExporterParmeter(ExporterParameter.CHARACTER_ENCODING, (Object)"GBK");
                export.exportToCsv(new PrintableBook(kdsBook), filePath);
            }
            if (null != logPK) {
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"20_ExportHelper"));
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)RES, (String)"fileIsOpen"));
        }
    }

    protected static boolean isNeedLog(String methodName, BOSObjectType bosType, String logItemName) {
        boolean flag = !StringUtil.isEmpty((String)methodName) && !StringUtil.isEmpty((String)logItemName) && !EmptyUtil.isEmpty((Object)bosType);
        return flag;
    }

    public static void export(Component ui, KDTable table) throws Exception {
        ExportHelper.export(ui, null, table, false, null, null);
    }
}

