/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.bill.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.std.bill.STDCostDataSourceTypeEnum;
import com.kingdee.eas.ncm.std.bill.STDCostEstimateTypeFilterParam;
import com.kingdee.eas.ncm.std.bill.client.AbstractSTDCostEstimateTypeFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.List;

public class STDCostEstimateTypeFilterUI
extends AbstractSTDCostEstimateTypeFilterUI {
    private static final long serialVersionUID = 3998303648890219179L;
    private static final String STORAGE_ORG_UNIT_ID = "StorageOrgUnitId";
    private static final String MATERIAL_NUMBERS = "MaterialNumbers";
    private static final String CALCULATE_TYPE = "CalculateType";
    private static final String DATA_TYPE = "DataType";
    CompanyOrgUnitInfo currCompany = null;
    PeriodInfo currPeriod = null;

    public STDCostEstimateTypeFilterUI() throws Exception {
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void init() throws Exception {
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.currCompany.getId().toString());
        this.filterStorageOrgBox();
        this.storageOrgBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                boolean clear = false;
                if (!(eventObj.getNewValue() instanceof StorageOrgUnitInfo) || !(eventObj.getOldValue() instanceof StorageOrgUnitInfo)) {
                    clear = true;
                } else {
                    StorageOrgUnitInfo newOrg = (StorageOrgUnitInfo)eventObj.getNewValue();
                    StorageOrgUnitInfo oldOrg = (StorageOrgUnitInfo)eventObj.getOldValue();
                    if (!newOrg.getId().toString().equals(oldOrg.getId().toString())) {
                        clear = true;
                    }
                }
                if (clear) {
                    STDCostEstimateTypeFilterUI.this.materialBizPromptBox.setValue(null);
                    try {
                        STDCostEstimateTypeFilterUI.this.filterMaterialBox();
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Throwable)exc);
                    }
                }
            }
        });
        this.filterMaterialBox();
        this.materialBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (STDCostEstimateTypeFilterUI.this.storageOrgBizPromptBox.getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"26_STDCostDataFilterUI"));
                    SysUtil.abort();
                }
                try {
                    STDCostEstimateTypeFilterUI.this.filterMaterialBox();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
        });
    }

    public void clear() {
        super.clear();
        this.storageOrgBizPromptBox.setData(null);
        this.materialBizPromptBox.setData(null);
        this.calcuTypeComboBox.setSelectedIndex(0);
        this.typeComboBox.setSelectedIndex(0);
    }

    private void filterStorageOrgBox() throws Exception {
        BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)this.storageOrgBizPromptBox, (String)"isBizUnit", (Object)1, (String)this.currCompany.getId().toString(), (String)"id");
    }

    private void filterMaterialBox() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.storageOrgBizPromptBox.getValue() != null) {
            String storageOrgUnitId = ((StorageOrgUnitInfo)this.storageOrgBizPromptBox.getValue()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currCompany.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("MaterialInventory.status", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.materialBizPromptBox.setEntityViewInfo(view);
        FilterInfo filterPrmt = this.materialBizPromptBox.getEntityViewInfo().getFilter();
        this.materialBizPromptBox = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.materialBizPromptBox, (FilterInfo)filterPrmt);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new STDCostEstimateTypeFilterParam();
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof STDCostEstimateTypeFilterParam)) {
            return;
        }
        STDCostEstimateTypeFilterParam _filterParam = (STDCostEstimateTypeFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getStorageOrgUnitInfo(), STORAGE_ORG_UNIT_ID);
        super.putIdByKey(customerParams, (Object)_filterParam.getMaterialInfos(), MATERIAL_NUMBERS);
        customerParams.addCustomerParam(CALCULATE_TYPE, String.valueOf(_filterParam.getCalculateTypeEnum().getValue()));
        customerParams.addCustomerParam(DATA_TYPE, String.valueOf(_filterParam.getDataType().getValue()));
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof STDCostEstimateTypeFilterParam)) {
            return;
        }
        STDCostEstimateTypeFilterParam _filterParam = (STDCostEstimateTypeFilterParam)filterParam;
        if (this.storageOrgBizPromptBox.getData() instanceof StorageOrgUnitInfo) {
            _filterParam.setStorageOrgUnitInfo((StorageOrgUnitInfo)this.storageOrgBizPromptBox.getData());
        }
        if (this.calcuTypeComboBox.getSelectedItem() instanceof CalculateTypeEnum) {
            _filterParam.setCalculateTypeEnum((CalculateTypeEnum)this.calcuTypeComboBox.getSelectedItem());
        }
        MaterialInfo[] materials = null;
        Object materialsObject = this.materialBizPromptBox.getData();
        if (materialsObject instanceof MaterialInfo) {
            materials = new MaterialInfo[]{(MaterialInfo)materialsObject};
        } else if (materialsObject instanceof Object[]) {
            materials = new MaterialInfo[((Object[])materialsObject).length];
            System.arraycopy(materialsObject, 0, materials, 0, ((Object[])materialsObject).length);
        }
        _filterParam.setMaterialInfos(materials);
        if (this.typeComboBox.getSelectedItem() instanceof STDCostDataSourceTypeEnum) {
            _filterParam.setDataType((STDCostDataSourceTypeEnum)((Object)this.typeComboBox.getSelectedItem()));
        }
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof STDCostEstimateTypeFilterParam)) {
            return;
        }
        STDCostEstimateTypeFilterParam _filterParam = (STDCostEstimateTypeFilterParam)filterParam;
        try {
            String storageOrgUnitId = customerParams.getCustomerParam(STORAGE_ORG_UNIT_ID);
            if (!StringUtils.isEmpty((String)storageOrgUnitId)) {
                StorageOrgUnitInfo storageOrgUnitInfo = new StorageOrgUnitInfo();
                storageOrgUnitInfo.setId(BOSUuid.read((String)storageOrgUnitId));
                _filterParam.setStorageOrgUnitInfo(storageOrgUnitInfo);
            } else {
                _filterParam.setStorageOrgUnitInfo(null);
            }
            String calcuTypeString = customerParams.getCustomerParam(CALCULATE_TYPE);
            if (!StringUtils.isEmpty((String)calcuTypeString)) {
                _filterParam.setCalculateTypeEnum(CalculateTypeEnum.getEnum((int)Integer.valueOf(calcuTypeString)));
            } else {
                _filterParam.setCalculateTypeEnum(null);
            }
            List materialIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(MATERIAL_NUMBERS)));
            if (materialIds != null) {
                _filterParam.setMaterialInfos(new MaterialInfo[materialIds.size()]);
                String id = null;
                int in = materialIds.size();
                for (int i = 0; i < in; ++i) {
                    id = (String)materialIds.get(i);
                    if (StringUtils.isEmpty((String)id)) continue;
                    _filterParam.getMaterialInfos()[i] = new MaterialInfo();
                    _filterParam.getMaterialInfos()[i].setId(BOSUuid.read((String)id));
                }
            } else {
                _filterParam.setMaterialInfos(null);
            }
            String dataType = customerParams.getCustomerParam(DATA_TYPE);
            if (!StringUtils.isEmpty((String)dataType)) {
                _filterParam.setDataType(STDCostDataSourceTypeEnum.getEnum(Integer.valueOf(dataType)));
            } else {
                _filterParam.setDataType(null);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof STDCostEstimateTypeFilterParam) {
            STDCostEstimateTypeFilterParam _filterParam = (STDCostEstimateTypeFilterParam)filterParam;
            if (_filterParam.getStorageOrgUnitInfo() != null) {
                this.storageOrgBizPromptBox.setValue((Object)_filterParam.getStorageOrgUnitInfo());
            } else {
                this.storageOrgBizPromptBox.setValue(null);
            }
            if (_filterParam.getCalculateTypeEnum() != null) {
                this.calcuTypeComboBox.setSelectedItem((Object)_filterParam.getCalculateTypeEnum());
            } else {
                this.calcuTypeComboBox.setSelectedItem(null);
            }
            if (_filterParam.getMaterialInfos() != null) {
                this.materialBizPromptBox.setValue((Object)_filterParam.getMaterialInfos());
            } else {
                this.materialBizPromptBox.setValue(null);
            }
            this.typeComboBox.setSelectedItem((Object)_filterParam.getDataType());
        }
    }

    public boolean verify() {
        if (UIRuleUtil.isNull((Object)this.storageOrgBizPromptBox.getValue())) {
            this.storageOrgBizPromptBox.requestFocus();
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.bill.BILLAutoGenerateResource", (String)"27_STDCostDataFilterUI"));
            SysUtil.abort();
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }
}

