/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemCollection;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeCollection;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeFactory;
import com.kingdee.eas.ncm.std.basedata.STDCostEstimateSchemeInfo;
import com.kingdee.eas.ncm.std.report.client.AbstractSTDCostDiffReportFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.ParseException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class STDCostDiffReportFilterUI
extends AbstractSTDCostDiffReportFilterUI {
    private static final long serialVersionUID = -1927594495767843874L;
    protected CompanyOrgUnitInfo company = null;
    private static final String _prmtCostCenter = "prmtCostCenter";
    protected boolean isNormal = true;
    private static final String _prmtScheme = "prmtScheme";
    private static final String _prmtCostObject = "prmtCostObject";
    private static final String _prmtCostItem = "prmtCostItem";
    private static final String _cbDivMatBatch = "cbDivMatBatch";
    private PeriodInfo currentPeriod;
    private CustomerParams cp = null;

    public STDCostDiffReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.company = this.getCompanyOrgInfoWithDefault();
        this.init();
    }

    public void onLoad() throws Exception {
        ISystemStatusCtrol sysctrol;
        super.onLoad();
        if (this.isNormal && !(sysctrol = SystemStatusCtrolFactory.getRemoteInstance()).isStart(1001, this.company.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    protected void init() throws Exception {
        this.prmtCompany.setValue((Object)this.company);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.company.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenter, (String)this.company.getId().toString());
        this.filterSchemeNumberBox();
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObject, (String)this.company.getId().toString());
        FilterInfo shareCostObject = new FilterInfo();
        shareCostObject.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.NOTEQUALS));
        shareCostObject.mergeFilter(this.prmtCostObject.getEntityViewInfo().getFilter(), "AND");
        this.prmtCostObject.getEntityViewInfo().setFilter(shareCostObject);
        FilterInfo costItemFilter = CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
        EntityViewInfo costItemView = null;
        costItemView = this.prmtCostItem.getEntityViewInfo() != null ? this.prmtCostItem.getEntityViewInfo() : new EntityViewInfo();
        costItemView.setFilter(costItemFilter);
        this.prmtCostItem.setEntityViewInfo(costItemView);
    }

    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleBizPromptFilterElement("companyOrg", this.prmtCompany));
        SpinnerFilterElement element = new SpinnerFilterElement("year", (Component)this.yearSpinner);
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("month", (Component)this.monthSpinner);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costCenters", (Component)this.prmtCostCenter));
        elements.add((FilterElement)new SingleBizPromptFilterElement("scheme", this.prmtScheme));
        elements.add((FilterElement)new SingleFilterElement("costObjects", (Component)this.prmtCostObject));
        elements.add((FilterElement)new SingleFilterElement("costItems", (Component)this.prmtCostItem));
        elements.add((FilterElement)new SingleFilterElement("divMatBatch", (Component)this.cbDivMatBatch));
        return elements;
    }

    protected void filterSchemeNumberBox() throws Exception {
        EntityViewInfo view = null;
        view = this.prmtScheme.getEntityViewInfo() == null ? new EntityViewInfo() : this.prmtScheme.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtScheme.setEntityViewInfo(view);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenter);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObject, true);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prmtScheme, "com.kingdee.eas.ncm.std.basedata.app.STDCostEstimateSchemeQuery", "company.id");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenter.setValue(null);
                this.prmtScheme.setValue(null);
                this.cbDivMatBatch.setSelected(false);
                this.prmtCostObject.setValue(null);
                this.prmtCostItem.setValue(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected String getReportViewPermissionItem() {
        return "STDCostDetailReport";
    }

    protected String getReportPrintPermissionItem() {
        return "STDCostDetailReportPrint";
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadCostCenter1(params);
            this.loadScheme(params);
            this.loadCostObject(params);
            this.loadCostItem1(params);
            this.loadMatBatch(params);
        }
    }

    private void loadCostCenter1(CustomerParams params) {
        String costCenter = "";
        if (params.getCustomerParam(_prmtCostCenter) != null) {
            costCenter = params.getCustomerParam(_prmtCostCenter);
        }
        if (StringUtils.isEmpty((String)costCenter)) {
            this.prmtCostCenter.setData(null);
            return;
        }
        String[] costCenterNumbers = costCenter.split(";");
        HashSet<String> costCenterNumbersSet = new HashSet<String>();
        for (int i = 0; i < costCenterNumbers.length; ++i) {
            costCenterNumbersSet.add(costCenterNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", costCenterNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        CostCenterOrgUnitCollection costCenterOrgUnitCol = null;
        try {
            costCenterOrgUnitCol = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterOrgUnitCol != null && costCenterOrgUnitCol.size() > 0) {
                int size = costCenterOrgUnitCol.size();
                CostCenterOrgUnitInfo[] costCenters = new CostCenterOrgUnitInfo[size];
                for (int i = 0; i < size; ++i) {
                    costCenters[i] = costCenterOrgUnitCol.get(i);
                }
                this.prmtCostCenter.setData((Object)costCenters);
            }
        }
        catch (BOSException e) {
            this.prmtCostCenter.setData(null);
        }
    }

    private void loadScheme(CustomerParams params) {
        String scheme = "";
        if (params.getCustomerParam(_prmtScheme) != null) {
            scheme = params.getCustomerParam(_prmtScheme);
        }
        if (StringUtils.isEmpty((String)scheme)) {
            this.prmtScheme.setData(null);
            return;
        }
        String[] schemeNumbers = scheme.split(";");
        HashSet<String> schemeNumbersSet = new HashSet<String>();
        for (int i = 0; i < schemeNumbers.length; ++i) {
            schemeNumbersSet.add(schemeNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", schemeNumbersSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        STDCostEstimateSchemeCollection schemeCol = null;
        try {
            schemeCol = STDCostEstimateSchemeFactory.getRemoteInstance().getSTDCostEstimateSchemeCollection(view);
            if (schemeCol != null && schemeCol.size() > 0) {
                int size = schemeCol.size();
                STDCostEstimateSchemeInfo[] schemes = new STDCostEstimateSchemeInfo[size];
                for (int i = 0; i < size; ++i) {
                    schemes[i] = schemeCol.get(i);
                }
                this.prmtScheme.setData((Object)schemes);
            }
        }
        catch (BOSException e) {
            this.prmtScheme.setData(null);
        }
    }

    private void loadCostObject(CustomerParams params) {
        String costObject = "";
        if (params.getCustomerParam(_prmtCostObject) != null) {
            costObject = params.getCustomerParam(_prmtCostObject);
        }
        if (StringUtils.isEmpty((String)costObject)) {
            this.prmtCostObject.setData(null);
            return;
        }
        String[] coNumbers = costObject.split(";");
        HashSet<String> coNumbersSet = new HashSet<String>();
        for (int i = 0; i < coNumbers.length; ++i) {
            coNumbersSet.add(coNumbers[i].trim());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", coNumbersSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        CostObjectCollection costObjectCol = null;
        try {
            costObjectCol = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
            if (costObjectCol != null && costObjectCol.size() > 0) {
                int size = costObjectCol.size();
                CostObjectInfo[] costObjects = new CostObjectInfo[size];
                for (int i = 0; i < size; ++i) {
                    costObjects[i] = costObjectCol.get(i);
                }
                this.prmtCostObject.setData((Object)costObjects);
            }
        }
        catch (BOSException e) {
            this.prmtCostObject.setData(null);
        }
    }

    private void loadCostItem1(CustomerParams params) {
        String costItem = "";
        if (params.getCustomerParam(_prmtCostItem) != null) {
            costItem = params.getCustomerParam(_prmtCostItem);
        }
        if (StringUtils.isEmpty((String)costItem)) {
            this.prmtCostItem.setData(null);
            return;
        }
        String[] costItemNumbers = costItem.split(";");
        HashSet<String> costItemNumbersSet = new HashSet<String>();
        for (int i = 0; i < costItemNumbers.length; ++i) {
            costItemNumbersSet.add(costItemNumbers[i].trim());
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", costItemNumbersSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo costItemFilterInfo = CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
            costItemFilterInfo.mergeFilter(filter, "and");
            view.setFilter(costItemFilterInfo);
            CostItemCollection costItemCol = CostItemFactory.getRemoteInstance().getCostItemCollection(view);
            if (costItemCol != null && costItemCol.size() > 0) {
                int size = costItemCol.size();
                CostItemInfo[] costItems = new CostItemInfo[size];
                for (int i = 0; i < size; ++i) {
                    costItems[i] = costItemCol.get(i);
                }
                this.prmtCostItem.setData((Object)costItems);
            }
        }
        catch (Exception e) {
            this.prmtCostItem.setData(null);
        }
    }

    public void loadMatBatch(CustomerParams params) {
        String matBatch = params.getCustomerParam(_cbDivMatBatch);
        this.cbDivMatBatch.setSelected(matBatch != null && matBatch.equalsIgnoreCase("true"));
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        OrgUnitInfo currentBizOrg = object == null ? this.getDefaultMainBizOrg() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    public boolean verify() {
        boolean ok = super.verify();
        if (this.prmtScheme.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.std.report.REPORTAutoGenerateResource", (String)"21_STDCostDiffReportFilterUI"));
            return false;
        }
        return ok;
    }

    protected void setDefaultValue() {
        this.company = this.getCompanyOrgInfoWithDefault();
        this.prmtCompany.setValue((Object)this.company);
        this.monthSpinner.setValue((Object)this.currentPeriod.getPeriodNumber());
        this.yearSpinner.setValue((Object)this.currentPeriod.getPeriodYear());
        this.cbDivMatBatch.setSelected(false);
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;
        private final Logger logger;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.logger = CoreUIObject.getLogger(SingleBizPromptFilterElement.class);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    this.logger.error((Object)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

