/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.openapi;

import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.scm.framework.openapi.APIId;
import com.kingdee.eas.scm.framework.openapi.LoggerHelper;
import com.kingdee.eas.scm.framework.openapi.Request;
import com.kingdee.eas.scm.framework.openapi.exception.ExceptionParser;
import com.kingdee.eas.scm.framework.openapi.exception.InvokeHttpException;
import com.kingdee.eas.scm.framework.openapi.exception.InvokeIOException;
import com.kingdee.eas.scm.framework.openapi.exception.PurCloudException;
import com.kingdee.eas.scm.framework.openapi.policy.ClientPolicy;
import com.kingdee.eas.scm.framework.openapi.policy.RequestPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;

public class PurCloudClient {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.openapi.PurCloudClient");
    private static final String ID_ENTERPRISE = "enterpriseid";
    private static final String ID_ORGUNIT = "orgunitid";
    private static final String ID_USER = "userid";
    private static final String TARGETURLENUM = "targetUrlEnum";
    private ClientPolicy policy;
    private HttpClient httpClient;

    public PurCloudClient(ClientPolicy policy) {
        this.init(policy);
    }

    private void init(ClientPolicy policy) {
        this.policy = policy;
        this.httpClient = new HttpClient();
        this.httpClient.getHostConfiguration().setHost(policy.getServerHost(), policy.getHttpPort());
        if (policy.isProxy()) {
            this.httpClient.getHostConfiguration().setProxy(policy.getProxyHost(), policy.getProxyPort());
        }
        HttpConnectionManagerParams managerParams = this.httpClient.getHttpConnectionManager().getParams();
        managerParams.setConnectionTimeout(policy.getTimeout());
        managerParams.setSoTimeout(policy.getTimeout());
    }

    public APIId getAPI(String namespace, String api, int version) {
        return new APIId(namespace, api, version);
    }

    public String send(Request request) throws PurCloudException {
        return this.innerSend(request);
    }

    private String innerSend(Request request) throws PurCloudException {
        String value;
        block11: {
            PostMethod method = this.getMethod(request, this.policy);
            this.setSystemParams(method, request);
            if (request.getParams() != null) {
                for (Map.Entry<String, Object> entry : request.getParams().entrySet()) {
                    method.setParameter(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
                }
            }
            value = "";
            try {
                logger.info((Object)("\u5f00\u59cb\u8c03\u7528http\u63a5\u53e3\uff1a" + request.getApiId().toString()));
                int status = this.httpClient.executeMethod((HttpMethod)method);
                logger.info((Object)("\u8c03\u7528http\u63a5\u53e3\u7ed3\u675f\uff1a" + request.getApiId().toString() + "\u72b6\u6001\uff1a" + status));
                if (status != 200) {
                    throw new RuntimeException("invoke api failed, urlPath:" + request.getApiId().toString() + " status:" + status + " response:" + method.getResponseBodyAsString());
                }
                Response res = this.parseResult(method);
                if (res.isSuccess) {
                    value = res.data;
                    break block11;
                }
                throw ExceptionParser.buildException(res.data);
            }
            catch (HttpException e) {
                LoggerHelper.getClientLogger().fine(e.getMessage());
                throw new InvokeHttpException(e.getMessage());
            }
            catch (IOException e) {
                LoggerHelper.getClientLogger().fine(e.getMessage());
                throw new InvokeIOException(e.getMessage());
            }
            catch (JSONException e) {
                throw new PurCloudException(e.getMessage());
            }
            finally {
                method.releaseConnection();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() {
        HttpConnectionManagerParams managerParams = this.httpClient.getHttpConnectionManager().getParams();
        managerParams.setConnectionTimeout(this.policy.getTimeout());
        managerParams.setSoTimeout(this.policy.getTimeout());
        GetMethod method = new GetMethod("/purchase");
        try {
            int status = this.httpClient.executeMethod((HttpMethod)method);
            if (status == 200) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (HttpException e) {
            LoggerHelper.getClientLogger().fine(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LoggerHelper.getClientLogger().fine(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    public String getAutoLoginWebContent(Request request, TargetUrlEnum targetUrl) {
        StringBuilder html = new StringBuilder();
        html.append("<html>").append("<script>").append("function submitForm(){document.getElementById('formId').submit();}").append("</script>").append("<body onload='submitForm();'>").append("<form id='formId' method='post' action='").append(this.getActionUrl(request, this.policy)).append("'>").append("<input type='hidden' name='").append(ID_ENTERPRISE).append("' value='").append(this.policy.getEnterpriseId()).append("'/>").append("<input type='hidden' name='").append(ID_ORGUNIT).append("' value='").append(request.getOrgUnitId()).append("'/>").append("<input type='hidden' name='").append(ID_USER).append("' value='").append(request.getUserId()).append("'/>").append("<input type='hidden' name='").append(TARGETURLENUM).append("' value='").append(targetUrl.toString()).append("'/>");
        if (request.getParams() != null) {
            for (Map.Entry<String, Object> entry : request.getParams().entrySet()) {
                html.append("<input type='hidden' name='").append(entry.getKey()).append("' value='").append(this.urlEncode(entry.getValue().toString())).append("'/>");
            }
        }
        html.append("</form>").append("</body>").append("</html>");
        return html.toString();
    }

    private String getActionUrl(Request request, RequestPolicy policy) {
        StringBuilder url = new StringBuilder();
        url.append(this.httpClient.getHostConfiguration().getHostURL());
        url.append(this.getUrlPath(request, policy));
        return url.toString();
    }

    public String getAutoLoginUrl(Request request, TargetUrlEnum targetUrl) throws PurCloudException {
        PostMethod method = this.getMethod(request, this.policy);
        this.setSystemParams(method, request);
        if (request.getParams() != null) {
            for (Map.Entry<String, Object> entry : request.getParams().entrySet()) {
                method.setParameter(entry.getKey(), entry.getValue() == null ? "" : this.urlEncode(entry.getValue().toString()));
            }
        }
        method.setParameter(TARGETURLENUM, targetUrl.toString());
        String value = "";
        try {
            Header[] headerArray;
            int status = this.httpClient.executeMethod((HttpMethod)method);
            if (status != 302) {
                throw new RuntimeException("invoke api failed, urlPath:" + request.getApiId().toString() + " status:" + status + " response:" + method.getResponseBodyAsString());
            }
            for (Header header : headerArray = method.getResponseHeaders()) {
                if (!header.getName().equalsIgnoreCase("Location")) continue;
                String string = header.getValue();
                return string;
            }
        }
        catch (HttpException e) {
            LoggerHelper.getClientLogger().fine(e.getMessage());
            throw new InvokeHttpException(e.getMessage());
        }
        catch (IOException e) {
            LoggerHelper.getClientLogger().fine(e.getMessage());
            throw new InvokeIOException(e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return value;
    }

    private String urlEncode(String s) {
        String encodeStr = null;
        try {
            encodeStr = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
        return encodeStr;
    }

    private String parserResponse(PostMethod method) throws IOException {
        StringBuffer contentBuffer = new StringBuffer();
        InputStream in = method.getResponseBodyAsStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, method.getResponseCharSet()));
        String inputLine = null;
        while ((inputLine = reader.readLine()) != null) {
            contentBuffer.append(inputLine);
            contentBuffer.append("/n");
        }
        contentBuffer.delete(contentBuffer.length() - 2, contentBuffer.length());
        in.close();
        return contentBuffer.toString();
    }

    private Response parseResult(PostMethod method) throws IOException, JSONException {
        String response = this.parserResponse(method);
        JSONObject json = new JSONObject(response);
        Response res = new Response();
        int flag = json.optInt("isSuccess");
        res.isSuccess = flag == 1;
        res.data = json.optString("data");
        return res;
    }

    private PostMethod getMethod(Request request, RequestPolicy policy) {
        PostMethod method = new PostMethod(this.getUrlPath(request, policy));
        method.setRequestHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        return method;
    }

    private PostMethod setSystemParams(PostMethod method, Request request) {
        method.setParameter(ID_ENTERPRISE, this.policy.getEnterpriseId());
        if (request.getUserId() != null) {
            method.setParameter(ID_USER, request.getUserId());
        }
        if (request.getOrgUnitId() != null) {
            method.setParameter(ID_ORGUNIT, request.getOrgUnitId());
        }
        return method;
    }

    private String getUrlPath(Request request, RequestPolicy policy) {
        StringBuilder path = new StringBuilder();
        path.append("/purchase/openapi/");
        path.append(policy.getRequestProtocol().toString());
        path.append("/");
        path.append(this.policy.getDefaultVersion());
        path.append("/");
        path.append(request.getApiId().getNamespace());
        path.append("/");
        path.append(request.getApiId().getName());
        return path.toString();
    }

    private class Response {
        boolean isSuccess;
        String data;

        private Response() {
        }
    }

    public static enum TargetUrlEnum {
        POST_BUYOFFER(0, "\u53d1\u5e03\u8be2\u4ef7"),
        BUYOFFER_MANAGEMENT(1, "\u8be2\u4ef7\u7ba1\u7406"),
        BUY_OFFER_DETAIL(2, "\u67e5\u770b\u8be2\u4ef7\u8be6\u60c5"),
        RECEIVE_QUOTATION_LIST(3, "\u67e5\u770b\u62a5\u4ef7\u5217\u8868"),
        SUPPLIER_DETAIL(4, "\u4f9b\u5e94\u5546\u7ba1\u7406"),
        POST_ORDER(5, "\u53d1\u5e03\u8ba2\u5355"),
        TRADE_PAYMENT(6, "\u4ed8\u6b3e"),
        MERGE_TRADE_PAYMENT(7, "\u5408\u5e76\u4ed8\u6b3e"),
        CONFIRM_RECEIVE_GOODS(8, "\u786e\u8ba4\u6536\u8d27"),
        ORDER_LIST(9, "\u8ba2\u5355\u7ba1\u7406"),
        ORDER_DETAIL(10, "\u8ba2\u5355\u8be6\u60c5");

        private int val;
        private String alias;

        private TargetUrlEnum(int value, String alias) {
            this.val = value;
            this.alias = alias;
        }

        public int getValue() {
            return this.val;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

