/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.eas.scm.sm.pur.b2b.IPurCloudService;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudConfigInfo;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudServiceFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractPurCloudRegisterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PurCloudRegisterUI
extends AbstractPurCloudRegisterUI {
    private static final long serialVersionUID = 1L;
    private static final String Default_Host = "cg100.kingdee.com";
    private static final int Default_Port = 8086;
    private PurCloudConfigInfo config;

    public PurCloudRegisterUI() throws Exception {
        this.chkIsProxy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PurCloudRegisterUI.this.proxyStateChange();
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String configContent = this.getInterface().getPurCloudConfigInfo();
        this.config = new PurCloudConfigInfo(configContent);
        this.fillData();
        this.txtProxyHost.setEnabled(this.chkIsProxy.isSelected());
        this.txtProxyPort.setEnabled(this.chkIsProxy.isSelected());
    }

    private void fillData() {
        this.txtEnterprise.setText(this.config.getEnterpriseid());
        if (this.config.getHost() == null || this.config.getHost().length() == 0) {
            this.config.setHost(Default_Host);
        }
        this.txtServerHost.setText(this.config.getHost());
        if (this.config.getPort() == 0) {
            this.config.setPort(8086);
        }
        this.txtSecretKey.setText(this.config.getSecretkey());
        this.txtServerPort.setText(String.valueOf(this.config.getPort()));
        this.chkIsProxy.setSelected(this.config.isProxy());
        this.txtProxyHost.setText(this.config.getProxyHost());
        if (this.config.getProxyPort() != 0) {
            this.txtProxyPort.setText(String.valueOf(this.config.getProxyPort()));
        }
        this.txtDC.setText(this.config.getDcname());
        this.txtUserName.setText(this.config.getUsername());
    }

    private void proxyStateChange() {
        this.txtProxyHost.setEnabled(this.chkIsProxy.isSelected());
        this.txtProxyPort.setEnabled(this.chkIsProxy.isSelected());
    }

    @Override
    public void storeFields() {
        this.config.setEnterpriseid(this.txtEnterprise.getText());
        this.config.setHost(this.txtServerHost.getText());
        if (this.txtServerPort.getText() != null && this.txtServerPort.getText().length() > 0) {
            this.config.setPort(Integer.valueOf(this.txtServerPort.getText()));
        } else {
            this.config.setPort(0);
        }
        this.config.setSecretkey(this.txtSecretKey.getText());
        this.config.setProxy(this.chkIsProxy.isSelected());
        if (this.chkIsProxy.isSelected()) {
            this.config.setProxyHost(this.txtProxyHost.getText());
            if (this.txtProxyPort.getText() != null && this.txtProxyPort.getText().length() > 0) {
                this.config.setProxyPort(Integer.valueOf(this.txtProxyPort.getText()));
            } else {
                this.config.setProxyPort(0);
            }
        }
        this.config.setDcname(this.txtDC.getText());
        this.config.setUsername(this.txtUserName.getText());
        this.config.setSolution("eas");
    }

    protected IPurCloudService getInterface() throws Exception {
        return PurCloudServiceFactory.getRemoteInstance();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.beforeCheck();
        this.storeFields();
        boolean tested = this.getInterface().savePurCloudConfigInfo(this.config.toString());
        if (tested) {
            MsgBox.showInfo((String)"\u4fdd\u5b58\u5e76\u8fde\u63a5\u91c7\u8d2d100\u670d\u52a1\u5668\u6210\u529f\uff01");
        } else {
            MsgBox.showError((String)"\u5df2\u4fdd\u5b58\uff0c\u4f46\u662f\u8fde\u63a5\u91c7\u8d2d100\u670d\u52a1\u5668\u5931\u8d25\u3002");
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionOpenRegistWeb_actionPerformed(ActionEvent e) throws Exception {
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + this.getUrl());
    }

    private String getUrl() {
        String host = Default_Host;
        int port = 8086;
        if (this.txtServerHost.getText() != null) {
            host = this.txtServerHost.getText().trim();
        }
        if (this.txtServerPort.getText() == null) {
            port = Integer.valueOf(this.txtServerPort.getText());
        }
        return "http://" + host + ":" + port + "/purchase";
    }

    private void beforeCheck() {
        if (this.txtServerHost.getText() == null || this.txtServerHost.getText().length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u670d\u52a1\u5668\u5730\u5740\uff01");
            SysUtil.abort();
        }
        if (this.txtServerPort.getText() == null || this.txtServerPort.getText().length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u670d\u52a1\u5668\u7aef\u53e3\uff01");
            SysUtil.abort();
        }
        if (this.txtSecretKey.getText() == null || this.txtSecretKey.getText().length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u79d8\u94a5\uff01");
            SysUtil.abort();
        }
        if (this.chkIsProxy.isSelected()) {
            if (this.txtProxyHost.getText() == null || this.txtProxyHost.getText().length() == 0) {
                MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u4ee3\u7406\u670d\u52a1\u5668\u5730\u5740\uff01");
                SysUtil.abort();
            }
            if (this.txtProxyPort.getText() == null || this.txtProxyPort.getText().length() == 0) {
                MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u4ee3\u7406\u670d\u52a1\u5668\u7aef\u53e3\uff01");
                SysUtil.abort();
            }
        }
        if (this.txtDC.getText() == null || this.txtDC.getText().length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u6570\u636e\u4e2d\u5fc3\uff01");
            SysUtil.abort();
        }
        if (this.txtUserName.getText() == null || this.txtUserName.getText().length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u7528\u6237\u540d\uff01");
            SysUtil.abort();
        }
    }

    @Override
    public void actionTestConntion_actionPerformed(ActionEvent e) throws Exception {
        this.beforeCheck();
        this.storeFields();
        boolean success = PurCloudServiceFactory.getRemoteInstance().testConnetion(this.config.toString());
        if (success) {
            MsgBox.showInfo((String)"\u8fde\u63a5\u91c7\u8d2d100\u670d\u52a1\u5668\u6210\u529f\uff01");
        } else {
            MsgBox.showError((String)"\u8fde\u63a5\u91c7\u8d2d100\u670d\u52a1\u5668\u5931\u8d25\uff01");
        }
    }
}

