/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.sm.pur.b2b.IPurCloudService;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudServiceFactory;
import com.kingdee.eas.scm.sm.pur.b2b.UserSearchEnum;
import com.kingdee.eas.scm.sm.pur.b2b.UserUploadFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractPurchasePersonUploadListUI;
import com.kingdee.eas.scm.sm.pur.b2b.model.KeyValue;
import com.kingdee.eas.scm.sm.pur.b2b.model.ObjectCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PurchasePersonUploadListUI
extends AbstractPurchasePersonUploadListUI {
    private static final long serialVersionUID = 1L;
    private static final String OPENAPINAME = "user.postUser";
    private static final String CL_USERNAME = "user.name";
    private static final String CL_PERSONNAME = "person.name";
    private static final String CL_PERSONNUMBER = "person.number";
    private String tempTableName = null;

    public PurchasePersonUploadListUI() throws Exception {
        this.selectedTable.checkParsed();
        this.selectedTable.setEnabled(false);
        this.prmtComOrg.setEnabledMultiSelection(false);
        this.prmtComOrg.setCommitFormat("#number");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchasePersonUploadListUI.this.onClickForBtnOK();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchasePersonUploadListUI.this.onClickForBtnCancel();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchasePersonUploadListUI.this.onClickForBtnRemove();
            }
        });
        this.btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchasePersonUploadListUI.this.onClickForBtnRemoveAll();
            }
        });
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PurchasePersonUploadListUI.this.doQuerying();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)PurchasePersonUploadListUI.this), (Throwable)ex);
                }
            }
        });
        this.prmtComOrg.setData((Object)SysContext.getSysContext().getCurrentFIUnit());
    }

    private void doQuerying() throws EASBizException, BOSException {
        String field = this.txtFieldValue.getText();
        if (field == null || field.trim().length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u8981\u6dfb\u52a0\u7684\u7528\u6237\uff01");
            SysUtil.abort();
        }
        RptParams param = new RptParams();
        if (this.comboField.getSelectedItem().equals((Object)UserSearchEnum.USERNAME)) {
            param.setString("key", "username");
        } else {
            param.setString("key", "personname");
        }
        param.setString("value", field);
        param.setString("tempTable", this.tempTableName);
        RptParams rpt = UserUploadFacadeFactory.getRemoteInstance().createTempTable(param);
        this.tempTableName = rpt.getString("tempTable");
        param.setString("tempTable", this.tempTableName);
        rpt = UserUploadFacadeFactory.getRemoteInstance().query(param);
        RptRowSet rs = (RptRowSet)rpt.getObject("rowSet");
        IRow row = null;
        while (rs.next()) {
            String username = rs.getString("FUserName");
            row = this.selectedTable.addRow();
            row.getCell(CL_USERNAME).setValue((Object)rs.getString("FUserName"));
            row.getCell(CL_PERSONNAME).setValue((Object)rs.getString("FPersonName"));
            row.getCell(CL_PERSONNUMBER).setValue((Object)rs.getString("FPersonNumber"));
        }
    }

    private void onClickForBtnOK() {
        int size = this.selectedTable.getRowCount();
        if (size == 0) {
            MsgBox.showInfo((String)"\u8bf7\u6dfb\u52a0\u8981\u4e0a\u4f20\u7684\u7528\u6237");
            SysUtil.abort();
        }
        if (this.prmtComOrg.getData() == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u7528\u6237\u8981\u4e0a\u4f20\u5230\u7684\u8d22\u52a1\u7ec4\u7ec7");
            SysUtil.abort();
        }
        ArrayList<String> usernames = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String username = (String)this.selectedTable.getCell(i, CL_USERNAME).getValue();
            String personName = (String)this.selectedTable.getCell(i, CL_PERSONNAME).getValue();
            usernames.add(username);
        }
        try {
            this.uploadUser(usernames);
            MsgBox.showInfo((String)"\u7528\u6237\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void onClickForBtnCancel() {
        this.disposeUIWindow();
    }

    private void onClickForBtnRemove() {
        ArrayList blocks = this.selectedTable.getSelectManager().getBlocks();
        int n = blocks.size();
        for (int i = 0; i < n; ++i) {
            KDTSelectBlock sb = (KDTSelectBlock)blocks.get(i);
            this.selectedTable.removeRow(sb.getTop());
        }
    }

    private void onClickForBtnRemoveAll() {
        this.selectedTable.removeRows();
    }

    private String uploadUser(List<String> usernames) throws Exception {
        JSONArray jsonArray = this.getPurchaseJsonArray(usernames);
        IPurCloudService cloudService = PurCloudServiceFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        String companyId = companyInfo.getId().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("users", jsonArray.toString());
        return cloudService.invokeApi(companyId, OPENAPINAME, params);
    }

    private JSONArray getPurchaseJsonArray(List<String> selectId) throws Exception {
        ObjectCollection<KeyValue> collection = new ObjectCollection<KeyValue>();
        KeyValue item = null;
        String companyId = this.getCompanyOrgId();
        String userNumber = null;
        int size = selectId.size();
        for (int i = 0; i < size; ++i) {
            userNumber = selectId.get(i);
            item = new KeyValue(userNumber, companyId);
            collection.addItem(item);
        }
        return collection.toJSONArray();
    }

    private String getCompanyOrgId() {
        Object obj = this.prmtComOrg.getData();
        if (obj == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u7528\u6237\u8981\u4e0a\u4f20\u5230\u7684\u8d22\u52a1\u7ec4\u7ec7");
            SysUtil.abort();
        }
        OrgUnitInfo info = (OrgUnitInfo)obj;
        return info.getId().toString();
    }
}

