/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractQuotationConditionUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class QuotationConditionUI
extends AbstractQuotationConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(QuotationConditionUI.class);
    private static final long serialVersionUID = 1L;
    private DataChangeListener compChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            QuotationConditionUI.this.changeCompanyOrg(eventObj);
        }
    };
    private DataChangeListener purchaseChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            QuotationConditionUI.this.changePurchaseOrg(eventObj);
        }
    };
    private DataChangeListener purPersonGroupListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            QuotationConditionUI.this.changePurPersonGroup(eventObj);
        }
    };
    private DataChangeListener purPersonListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            QuotationConditionUI.this.changePurPerson(eventObj);
        }
    };
    private F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.initF7Controler();
    }

    private void initF7Controler() {
        this.prmtCompanyOrgUnit.setCommitFormat("$number");
        this.prmtPurOrgUnit.setCommitFormat("$number");
        this.prmtMaterialStart.setCommitFormat("$number");
        this.prmtMaterialEnd.setCommitFormat("$number");
        this.prmtPurReqStart.setCommitFormat("$number");
        this.prmtPurReqEnd.setCommitFormat("$number");
        this.prmtPersonGroup.setCommitFormat("$number");
        this.prmtPurPerson.setQueryInfo("com.kingdee.eas.basedata.scm.sm.pur.app.F7PurPersonQuery");
        this.prmtPurPerson.setEditFormat("$person.number$");
        this.prmtPurPerson.setDisplayFormat("$person.number$");
        this.prmtPurPerson.setCommitFormat("$person.number$");
        this.prmtCompanyOrgUnit.setEnabledMultiSelection(true);
        this.prmtPurOrgUnit.setEnabledMultiSelection(true);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterialStart, null, null, null, false);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterialEnd, null, null, null, false);
        GeneralKDPromptSelectorAdaptor selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtMaterialStart, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery", "materialGroup.id", "StorageOrgUnit.id", "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryNoGroupQuery");
        selectorLisenter.setIsMultiSelect(false);
        this.prmtMaterialStart.setSelector((KDPromptSelector)selectorLisenter);
        this.prmtMaterialStart.addSelectorListener((SelectorListener)selectorLisenter);
        this.prmtMaterialEnd.setSelector((KDPromptSelector)selectorLisenter);
        this.prmtMaterialEnd.addSelectorListener((SelectorListener)selectorLisenter);
    }

    private void addListener() {
        this.prmtCompanyOrgUnit.addDataChangeListener(this.compChangeListener);
        this.prmtPurOrgUnit.addDataChangeListener(this.purchaseChangeListener);
        this.prmtPersonGroup.addDataChangeListener(this.purPersonGroupListener);
        this.prmtPurPerson.addDataChangeListener(this.purPersonListener);
    }

    private void removeListener() {
        if (this.compChangeListener != null) {
            this.prmtCompanyOrgUnit.removeDataChangeListener(this.compChangeListener);
        }
        if (this.purchaseChangeListener != null) {
            this.prmtPurOrgUnit.removeDataChangeListener(this.purchaseChangeListener);
        }
        if (this.purPersonGroupListener != null) {
            this.prmtPersonGroup.removeDataChangeListener(this.purPersonGroupListener);
        }
        if (this.purPersonListener != null) {
            this.prmtPurPerson.removeDataChangeListener(this.purPersonListener);
        }
    }

    private void changeCompanyOrg(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        Object obj = eventObj.getNewValue();
        Object[] objs = null;
        if (obj != null) {
            objs = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
        }
        ArrayList<OrgUnitInfo> compInfos = new ArrayList<OrgUnitInfo>();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                OrgUnitInfo info = (OrgUnitInfo)objs[i];
                if (info == null) continue;
                compInfos.add(info);
            }
        }
        this.filterPurReqestByCompanyOrg(compInfos);
    }

    private void changePurchaseOrg(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        this.prmtPersonGroup.setData(null);
        this.prmtPurPerson.setData(null);
        Object obj = this.prmtPurOrgUnit.getData();
        if (obj == null) {
            this.filterByFiledName2(this.prmtPersonGroup, "purOrg.id", null);
            this.filterByFiledName2(this.prmtPurPerson, "purOrg.id", null);
            return;
        }
        Object[] objs = null;
        if (obj != null) {
            objs = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
        }
        ArrayList<OrgUnitInfo> purOrgInfos = new ArrayList<OrgUnitInfo>();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                OrgUnitInfo info = (OrgUnitInfo)objs[i];
                if (info == null) continue;
                purOrgInfos.add(info);
            }
            this.filterPurGroupByPurOrg(purOrgInfos);
            this.filterPurPesonByPurOrg(purOrgInfos);
        }
    }

    private void changePurPersonGroup(DataChangeEvent eventObj) {
        this.prmtPurPerson.setData(null);
        Object obj = this.prmtPersonGroup.getData();
        if (obj == null) {
            this.prmtPurPerson.getQueryAgent().resetRuntimeEntityView();
            this.filterByFiledName2(this.prmtPurPerson, "purGroup.id", null);
            return;
        }
        PurchaseGroupInfo groupInfo = (PurchaseGroupInfo)obj;
        this.filterByFiledName2(this.prmtPurPerson, "purGroup.id", groupInfo.getId().toString());
    }

    private void changePurPerson(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        Object oldValue = eventObj.getOldValue();
        if (newValue == null || newValue != null && oldValue != null && newValue.equals(oldValue)) {
            return;
        }
        PurchasePersonInfo purPersonInfo = (PurchasePersonInfo)newValue;
        SelectorItemCollection select = new SelectorItemCollection();
        select.add(new SelectorItemInfo("person.number"));
        select.add(new SelectorItemInfo("id"));
        select.add(new SelectorItemInfo("person.name"));
        try {
            purPersonInfo = PurchasePersonFactory.getRemoteInstance().getPurchasePersonInfo((IObjectPK)new ObjectUuidPK(purPersonInfo.getId().toString()), select);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.prmtPurPerson.setValue((Object)purPersonInfo);
    }

    private void filterPurPesonByPurOrg(List<OrgUnitInfo> purOrgInfos) {
        String[] purOrgIds = this.getSelectPurOrgIds(purOrgInfos);
        if (purOrgIds == null) {
            return;
        }
        this.filterByFiledName(this.prmtPurPerson, "purOrg.id", purOrgIds);
    }

    private String[] getSelectPurOrgIds(List<OrgUnitInfo> purOrgInfos) {
        if (purOrgInfos == null || purOrgInfos.isEmpty()) {
            return null;
        }
        String[] purOrgIds = new String[purOrgInfos.size()];
        for (int i = 0; i < purOrgInfos.size(); ++i) {
            purOrgIds[i] = new String();
            purOrgIds[i] = purOrgInfos.get(i).getId().toString();
        }
        return purOrgIds;
    }

    private void filterPurGroupByPurOrg(List<OrgUnitInfo> purOrgInfos) {
        String[] purOrgIds = this.getSelectPurOrgIds(purOrgInfos);
        if (purOrgIds == null) {
            return;
        }
        this.filterByFiledName(this.prmtPersonGroup, "purOrg.id", purOrgIds);
    }

    private void filterPurReqestByCompanyOrg(List<OrgUnitInfo> compInfos) {
        if (compInfos == null || compInfos.isEmpty()) {
            return;
        }
        String[] compIds = new String[compInfos.size()];
        for (int i = 0; i < compInfos.size(); ++i) {
            compIds[i] = new String();
            compIds[i] = compInfos.get(i).getId().toString();
        }
        this.filterByFiledName(this.prmtPurReqStart, "companyOrgUnit.id", compIds);
        this.filterByFiledName(this.prmtPurReqEnd, "companyOrgUnit.id", compIds);
    }

    public void clear() {
        super.clear();
        this.prmtCompanyOrgUnit.setData((Object)SysContext.getSysContext().getCurrentFIUnit());
        Calendar calendar = Calendar.getInstance();
        Date dateEnd = new Date();
        dateEnd.setTime(calendar.getTimeInMillis());
        Date dateStart = new Date();
        calendar.add(2, -1);
        dateStart.setTime(calendar.getTimeInMillis());
        this.pkBizDateStart.setValue((Object)dateStart);
        this.pkBizDateEnd.setValue((Object)dateEnd);
        this.prmtPurOrgUnit.setData(null);
        this.prmtMaterialStart.setData(null);
        this.prmtMaterialEnd.setData(null);
        this.prmtPurReqStart.setData(null);
        this.prmtPurReqEnd.setData(null);
        this.txtSupplier.setText(null);
        this.prmtPurPerson.setData(null);
    }

    public void onInit(RptParams initParams) throws Exception {
        this.prmtCompanyOrgUnit.setData((Object)SysContext.getSysContext().getCurrentFIUnit());
        Calendar calendar = Calendar.getInstance();
        Date dateEnd = new Date();
        dateEnd.setTime(calendar.getTimeInMillis());
        Date dateStart = new Date();
        calendar.add(2, -1);
        dateStart.setTime(calendar.getTimeInMillis());
        this.pkBizDateStart.setValue((Object)dateStart);
        this.pkBizDateEnd.setValue((Object)dateEnd);
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        params.setObject("prmtCompanyOrgUnit", this.prmtCompanyOrgUnit.getData());
        params.setObject("pkBizDateStart", this.pkBizDateStart.getValue());
        params.setObject("pkBizDateEnd", this.pkBizDateEnd.getValue());
        params.setObject("prmtPurOrgUnit", this.prmtPurOrgUnit.getData());
        params.setObject("prmtMaterialStart", this.prmtMaterialStart.getData());
        params.setObject("prmtMaterialEnd", this.prmtMaterialEnd.getData());
        params.setObject("prmtPurReqStart", this.prmtPurReqStart.getData());
        params.setObject("prmtPurReqEnd", this.prmtPurReqEnd.getData());
        params.setObject("prmtPurPerson", this.prmtPurPerson.getData());
        params.setString("txtSupplier", this.txtSupplier.getText());
        params.setObject("prmtPersonGroup", this.prmtPersonGroup.getData());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtCompanyOrgUnit.setData(params.getObject("prmtCompanyOrgUnit"));
        if (params.getObject("pkBizDateStart") != null) {
            this.pkBizDateStart.setValue(params.getObject("pkBizDateStart"));
        }
        if (params.getObject("pkBizDateEnd") != null) {
            this.pkBizDateEnd.setValue(params.getObject("pkBizDateEnd"));
        }
        this.prmtPurOrgUnit.setData(params.getObject("prmtPurOrgUnit"));
        this.prmtMaterialStart.setData(params.getObject("prmtMaterialStart"));
        this.prmtMaterialEnd.setData(params.getObject("prmtMaterialEnd"));
        this.prmtPurReqStart.setData(params.getObject("prmtPurReqStart"));
        this.prmtPurReqEnd.setData(params.getObject("prmtPurReqEnd"));
        this.prmtPurPerson.setData(params.getObject("prmtPurPerson"));
        this.txtSupplier.setText(params.getString("txtSupplier"));
        this.prmtPersonGroup.setData(params.getObject("prmtPersonGroup"));
    }

    public boolean verify() {
        if (this.prmtCompanyOrgUnit.getData() == null) {
            MsgBox.showInfo((String)"\u8d22\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        Date dateStart = (Date)this.pkBizDateStart.getValue();
        Date dateEnd = (Date)this.pkBizDateEnd.getValue();
        if (dateStart == null || dateEnd == null) {
            MsgBox.showWarning((String)"\u65e5\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (dateStart.compareTo(dateEnd) > 0) {
            MsgBox.showWarning((String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u53ef\u5927\u4e8e\u7ec8\u6b62\u65f6\u95f4");
            return false;
        }
        return true;
    }

    private void filterByFiledName(KDBizPromptBox box, String filedName, String[] values) {
        if (values == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String maskString = null;
        for (int i = 0; i < values.length; ++i) {
            FilterItemInfo itemInfo = new FilterItemInfo(filedName, (Object)values[i], CompareType.EQUALS);
            filterInfo.getFilterItems().add(itemInfo);
            maskString = i == 0 ? "#0" : maskString + " or #" + i;
        }
        filterInfo.setMaskString(maskString);
        viewInfo.setFilter(filterInfo);
        box.setEntityViewInfo(viewInfo);
    }

    private void filterByFiledName2(KDBizPromptBox box, String filedName, String value) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (value != null) {
            FilterItemInfo itemInfo = new FilterItemInfo(filedName, (Object)value, CompareType.EQUALS);
            filterInfo.getFilterItems().add(itemInfo);
        }
        viewInfo.setFilter(filterInfo);
        box.setEntityViewInfo(viewInfo);
    }
}

