/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.b2b.QuotationDetailFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractQuotationDetailListUI;
import com.kingdee.eas.scm.sm.pur.b2b.client.QuotationConditionUI;
import com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurRequestEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class QuotationDetailListUI
extends AbstractQuotationDetailListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(QuotationDetailListUI.class);
    private KDTMouseListener tblClickListener;

    public QuotationDetailListUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getMergeManager().setDataMode(3);
        this.tbl.getGroupManager().setGroup(true);
        this.tbl.getColumn("purReqNumber").setMergeable(true);
        this.tbl.getColumn("purReqNumber").setGroup(true);
        this.tbl.getColumn("seq").setMergeable(true);
        this.tbl.getColumn("seq").setGroup(true);
        this.tbl.getColumn("comOrgName").setMergeable(true);
        this.tbl.getColumn("comOrgName").setGroup(true);
        this.tbl.getColumn("purOrgName").setMergeable(true);
        this.tbl.getColumn("purOrgName").setGroup(true);
        this.tbl.getDataRequestManager().setPageRowCount(500);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.tbl.getColumn("buyOfferTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tbl.getColumn("quotationTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.enableExportExcel(this.tbl);
        this.tbl.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initToolButton();
        this.addListener();
        this.initTable();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void initTable() {
        String timeFormat = SCMClientUtils.strTimeFormat;
        this.tbl.getColumn("buyOfferTime").getStyleAttributes().setNumberFormat(timeFormat);
        this.tbl.getColumn("quotationTime").getStyleAttributes().setNumberFormat(timeFormat);
    }

    private void initToolButton() {
        this.btnViewPurReq.setVisible(false);
        this.btnViewPurOrder.setVisible(false);
    }

    public void addListener() {
        this.tbl.addKDTMouseListener(this.tblClickListener);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return QuotationDetailFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new QuotationConditionUI();
    }

    protected void query() {
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.removeRows();
        this.initUserConfig();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            RptParams para = new RptParams();
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            if (from == 0) {
                para.setString("tempTable", this.getTempTable());
                para.putAll(this.params.toMap());
                rpt = QuotationDetailFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                this.tbl.setRowCount(rpt.getInt("RowCount"));
                logger.info((Object)("\u5b58\u8d27\u6536\u53d1\u5b58\u62a5\u8868--\u672c\u6b21\u67e5\u8be2\u4f7f\u7528\u7684\u4e34\u65f6\u8868\u540d\u4e3a: " + rpt.getString("tempTable")));
            }
            para.setString("tempTable", this.getTempTable());
            rpt = QuotationDetailFacadeFactory.getRemoteInstance().query(para);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowSet");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
        }
        catch (Exception ee) {
            this.handleException(ee);
        }
    }

    @Override
    public void actionViewPurReq_actionPerformed(ActionEvent e) throws Exception {
        String reqId = this.getPurReqIdBySelected();
        if (reqId == null) {
            return;
        }
        try {
            HashMap<String, String> uiContext = new HashMap<String, String>();
            uiContext.put("ID", reqId);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PurRequestEditUI.class.getName(), uiContext, null, "FINDVIEW");
            window.show();
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    @Override
    public void actionViewPurOrder_actionPerformed(ActionEvent e) throws Exception {
        String reqId = this.getPurReqIdBySelected();
        if (reqId == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo itemInfo = new FilterItemInfo("sourceBillId", (Object)reqId, CompareType.EQUALS);
        filterInfo.getFilterItems().add(itemInfo);
        viewInfo.setFilter(filterInfo);
        PurOrderEntryCollection purOrderEntrys = PurOrderEntryFactory.getRemoteInstance().getPurOrderEntryCollection(viewInfo);
        if (purOrderEntrys.isEmpty()) {
            MsgBox.showWarning((String)"\u8be5\u7533\u8bf7\u5355\u8fd8\u672a\u4e0b\u63a8\u8ba2\u5355\uff0c\u65e0\u6cd5\u8054\u67e5\u8ba2\u5355");
            SysUtil.abort();
        }
        String purOrdeId = purOrderEntrys.get(0).getParent().getId().toString();
        try {
            HashMap<String, String> uiContext = new HashMap<String, String>();
            uiContext.put("ID", purOrdeId);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PurOrderEditUI.class.getName(), uiContext, null, "FINDVIEW");
            window.show();
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }

    private String getPurReqIdBySelected() {
        IRow row;
        String reqId;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbl);
        int selectIndex = -1;
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        if (selectIndex == -1) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u884c");
            SysUtil.abort();
        }
        if ((reqId = (String)(row = this.tbl.getRow(selectIndex)).getCell("reqId").getValue()) == null) {
            MsgBox.showWarning((String)"\u9009\u62e9\u7684\u5217\u6ca1\u6709\u91c7\u8d2d\u7533\u8bf7\u5355");
            SysUtil.abort();
        }
        return reqId;
    }
}

