/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.client.SupplierEditUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.sm.pur.b2b.IPurCloudService;
import com.kingdee.eas.scm.sm.pur.b2b.ISupplier4AliFacade;
import com.kingdee.eas.scm.sm.pur.b2b.PurCloudServiceFactory;
import com.kingdee.eas.scm.sm.pur.b2b.Supplier4AliFacadeFactory;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractSupplierAddNewUI;
import com.kingdee.eas.scm.sm.pur.b2b.model.SupplierMapTypeEnum;
import com.kingdee.eas.scm.sm.pur.b2b.util.JSONUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SupplierAddNewUI
extends AbstractSupplierAddNewUI {
    private static final long serialVersionUID = 1L;
    protected String companyOrgUnitId = null;
    protected List<String> purchaseOrgUnitIdList = null;
    protected String supplierMemberId = null;
    protected com.kingdee.eas.scm.sm.pur.b2b.model.SupplierInfo netSupplierInfo = null;
    private CtrlUnitInfo curCtrlUnitInfo = null;
    private static final String OPENAPINAME = "supplier.getSupplier";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadCtx();
        this.loadSupplierInfo();
        this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        this.initSupplierF7(this.kdptSupplier);
        this.kdptSupplier.setEnabled(false);
    }

    protected void loadCtx() {
        this.companyOrgUnitId = (String)this.getUIContext().get("companyOrgUnitId");
        this.supplierMemberId = (String)this.getUIContext().get("supplierMemberId");
        this.purchaseOrgUnitIdList = (ArrayList)this.getUIContext().get("purchaseOrgUnitIdList");
    }

    private com.kingdee.eas.scm.sm.pur.b2b.model.SupplierInfo getSupplier(String supplierMemberId) throws Exception {
        IPurCloudService cloudService = PurCloudServiceFactory.getRemoteInstance();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("memberId", supplierMemberId);
        String result = cloudService.invokeApi(this.companyOrgUnitId, OPENAPINAME, params);
        JSONObject json = new JSONObject(result);
        return JSONUtil.json2SupplierInfo(json.getJSONObject("supplier"));
    }

    private void loadSupplierInfo() throws Exception {
        this.netSupplierInfo = this.getSupplier(this.supplierMemberId);
        if (this.netSupplierInfo == null) {
            MsgBox.showInfo((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u7f51\u7edc\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
            SysUtil.abort();
        }
        if (this.netSupplierInfo != null && this.netSupplierInfo.getCompanyInfo() != null) {
            this.lblSupplierValue.setText(this.netSupplierInfo.getCompanyInfo().getName());
            this.lblDateEstablishValue.setText(this.netSupplierInfo.getCompanyInfo().getDateOfEstablishment());
            this.lblRegisterCapitalValue.setText(this.netSupplierInfo.getCompanyInfo().getRegisteredCapital());
            this.lblTermValue.setText(this.netSupplierInfo.getCompanyInfo().getBusinessTerm());
            this.lblBankValue.setText(this.netSupplierInfo.getCompanyInfo().getBank());
            this.lblregistrValue.setText(this.netSupplierInfo.getCompanyInfo().getRegistrationId());
            this.lblScopeValue.setText(this.netSupplierInfo.getCompanyInfo().getBusinessScope());
            this.lblTypeValue.setText(this.netSupplierInfo.getCompanyInfo().getEnterpriseType());
            this.lblPrincipalValue.setText(this.netSupplierInfo.getCompanyInfo().getPrincipal());
            this.lblAdressValue.setText(this.netSupplierInfo.getCompanyInfo().getCompanyAddress());
            StringBuilder summary = new StringBuilder();
            summary.append(this.lblDateEstablish.getText()).append("").append(this.netSupplierInfo.getCompanyInfo().getDateOfEstablishment()).append("\n");
            summary.append(this.lblTerm.getText()).append("").append(this.netSupplierInfo.getCompanyInfo().getBusinessTerm()).append("\n");
            summary.append(this.lblScope.getText()).append("").append(this.netSupplierInfo.getCompanyInfo().getBusinessScope()).append("\n");
            summary.append(this.lblBank.getText()).append("").append(this.netSupplierInfo.getCompanyInfo().getBank()).append("\n");
            summary.append(this.netSupplierInfo.getCompanyInfo().getCompanySummary()).append("\n");
            this.lblSummaryValue.setText(summary.toString());
            this.kdptSupplier.setText(this.netSupplierInfo.getCompanyInfo().getName());
        }
        if (this.netSupplierInfo != null && this.netSupplierInfo.getContactInfo() != null) {
            this.lblContactorValue.setText(this.netSupplierInfo.getContactInfo().getName());
            this.lblPhoneValue.setText(this.netSupplierInfo.getContactInfo().getPhone());
            this.lblMobileValue.setText(this.netSupplierInfo.getContactInfo().getMobile());
            this.lblFaxValue.setText(this.netSupplierInfo.getContactInfo().getFax());
        }
    }

    @Override
    public void rdAddNew_actionPerformed(ActionEvent e) {
        this.kdptSupplier.setEnabled(false);
    }

    @Override
    public void rdMapping_actionPerformed(ActionEvent e) {
        this.kdptSupplier.setEnabled(true);
    }

    private void initSupplierF7(KDBizPromptBox supplierPromptBox) throws EASBizException, BOSException {
        supplierPromptBox.setEditable(true);
        supplierPromptBox.setDisplayFormat("$name$");
        supplierPromptBox.setEditFormat("$number$");
        supplierPromptBox.setCommitFormat("$number$;$name$");
        supplierPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierPurchasingQueryWithDefaultStandard");
        GeneralKDPromptSelectorAdaptor selectorLisenterSupplier = new GeneralKDPromptSelectorAdaptor((KDPromptBox)supplierPromptBox, "com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.cssp.app.F7SupplierPurchasingQuery", "browseGroup.id", "purChaseOrgUnit.id");
        supplierPromptBox.setSelector((KDPromptSelector)selectorLisenterSupplier);
        supplierPromptBox.addSelectorListener((SelectorListener)selectorLisenterSupplier);
    }

    private void setSupplierF7(KDBizPromptBox prmtSupplier) {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            prmtSupplier.setEntityViewInfo(viewInfo);
            prmtSupplier.getQueryAgent().resetRuntimeEntityView();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private IObjectValue createSupplierBaseData() {
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setName(this.netSupplierInfo.getCompanyInfo().getName());
        supplierInfo.setNumber(this.netSupplierInfo.getCompanyInfo().getName());
        supplierInfo.setTaxRate(new BigDecimal("0.00"));
        supplierInfo.setIsInternalCompany(false);
        supplierInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        supplierInfo.setCreateTime(TimeStampUtility.getTime());
        supplierInfo.setCU(this.curCtrlUnitInfo);
        supplierInfo.setVersion(1);
        supplierInfo.setUsedStatus(UsedStatusEnum.UNAPPROVE);
        return supplierInfo;
    }

    private IObjectValue createSupplierLinkInfo() {
        SupplierLinkManInfo linkInfo = new SupplierLinkManInfo();
        if (this.netSupplierInfo != null && this.netSupplierInfo.getContactInfo() != null) {
            linkInfo.setContactPerson(this.netSupplierInfo.getContactInfo().getName());
            linkInfo.setPhone(this.netSupplierInfo.getContactInfo().getPhone());
            linkInfo.setMobile(this.netSupplierInfo.getContactInfo().getMobile());
            linkInfo.setFax(this.netSupplierInfo.getContactInfo().getFax());
            linkInfo.setAddress(this.netSupplierInfo.getContactInfo().getContactAddress());
        }
        return linkInfo;
    }

    @Override
    public void btnOk_actionPerformed(ActionEvent e) {
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("companyOrgUnitId", this.companyOrgUnitId);
            paramMap.put("purchaseOrgUnitIdList", this.purchaseOrgUnitIdList);
            paramMap.put("supplierMemberId", this.supplierMemberId);
            paramMap.put("contactorInfo", this.createSupplierLinkInfo());
            ISupplier4AliFacade ifacade = Supplier4AliFacadeFactory.getRemoteInstance();
            SupplierInfo supplierInfo = null;
            if (this.rdMapping.isSelected()) {
                supplierInfo = (SupplierInfo)this.kdptSupplier.getValue();
                SupplierMapTypeEnum mapTpye = ifacade.handleMapping(supplierInfo, paramMap);
                if (SupplierMapTypeEnum.SUPPLIER_SUCCESS.equals((Object)mapTpye)) {
                    MsgBox.showInfo((String)"\u5173\u8054EAS\u4f9b\u5e94\u5546\u6210\u529f");
                } else {
                    MsgBox.showInfo((String)"\u4f9b\u5e94\u5546\u5df2\u5173\u8054EAS\u4f9b\u5e94\u5546,\u65e0\u987b\u518d\u5173\u8054");
                }
            }
            if (this.rdAddNew.isSelected()) {
                supplierInfo = (SupplierInfo)this.createSupplierBaseData();
                IObjectPK pk = ifacade.addNewSupplier(supplierInfo, paramMap);
                if (pk == null) {
                    MsgBox.showInfo((String)"\u65b0\u589eEAS\u4f9b\u5e94\u5546\u5931\u8d25");
                    return;
                }
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)pk.toString());
                String editUI = SupplierEditUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(editUI, (Map)uiContext, null, OprtState.EDIT);
                uiWindow.show();
            }
        }
        catch (Exception exp) {
            this.handleException(exp);
        }
    }

    @Override
    public void btnClose_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

