/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.openapi.PurCloudClient;
import com.kingdee.eas.scm.sm.pur.b2b.PurB2BException;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractWebContainerUI;
import com.kingdee.eas.scm.sm.pur.b2b.client.IStatusChangeListener;
import com.kingdee.eas.scm.sm.pur.b2b.client.PurCloudBrowser;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.jdesktop.jdic.browser.WebBrowserEvent;

public class WebContainerUI
extends AbstractWebContainerUI
implements IStatusChangeListener {
    private static final long serialVersionUID = -6828728187417817707L;
    public static final String UICTX_TARGETURL = "TargetUrl";
    public static final String UICTX_COMPANY = "CompanyId";
    public static final String UICTX_PARAMS = "Params";
    private PurCloudBrowser browser;
    private PurCloudClient.TargetUrlEnum targetUrl;
    private String companyId;
    private Map<String, Object> params;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setShowMessagePolicy(2);
        this.setIsShowTextOnly(true);
        if (this.getUIContext().get(UICTX_TARGETURL) == null) {
            throw new EASBizException(PurB2BException.TARGETURLENUMISNULL);
        }
        this.targetUrl = (PurCloudClient.TargetUrlEnum)((Object)this.getUIContext().get(UICTX_TARGETURL));
        if (this.getUIContext().get(UICTX_COMPANY) == null) {
            throw new EASBizException(PurB2BException.COMPANYIDISNULL);
        }
        this.companyId = (String)this.getUIContext().get(UICTX_COMPANY);
        this.params = (Map)this.getUIContext().get(UICTX_PARAMS);
        this.setUITitle(this.targetUrl.getAlias());
        this.browser = new PurCloudBrowser(this.targetUrl, this.companyId, this.params);
        this.kDPanel.setLayout((LayoutManager)new GridLayout(1, 1));
        this.kDPanel.add((Component)this.browser);
        this.browser.open();
    }

    public void onShow() {
        if (this.statusBar != null && this.statusBar.isVisible()) {
            this.browser.addStatusListener(this);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.browser.refresh();
    }

    @Override
    public void actionBack_actionPerformed(ActionEvent e) throws Exception {
        this.browser.back();
    }

    @Override
    public void actionForward_actionPerformed(ActionEvent e) throws Exception {
        this.browser.forward();
    }

    @Override
    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        this.browser.stop();
    }

    @Override
    public void downloadCompleted(WebBrowserEvent event) {
        this.btnBack.setEnabled(this.browser.isBackEnabled());
        this.btnForward.setEnabled(this.browser.isForwardEnabled());
    }

    @Override
    public void statusChanged(WebBrowserEvent event) {
        if (event.getData() != null && this.statusBar != null) {
            this.setMessageText(event.getData());
            this.showMessage();
        }
    }
}

