/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.b2b.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.sm.pur.b2b.BuyOfferOrderEnum;
import com.kingdee.eas.scm.sm.pur.b2b.client.AbstractWebPurOrderConditionUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class WebPurOrderConditionUI
extends AbstractWebPurOrderConditionUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(WebPurOrderConditionUI.class);
    private static final String C_compOrg = "compOrg";
    private static final String C_purOrg = "purOrg";
    private static final String C_matNumFrom = "matNumFrom";
    private static final String C_matNumTo = "matNumTo";
    private static final String C_buyGmtDateFrom = "easOrderBizDateFrom";
    private static final String C_buyGmtDateTo = "easOrderBizDateTo";
    private static final String C_WebOrderStatus = "webOrderStatus";
    private static final String C_supplierName = "supplierName";
    private static final String C_esaOrderNum = "esaOrderNum";
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private SCMRptMultiOrgsF7 f7CompanyOrgUnit = new SCMRptMultiOrgsF7(this.prmtComOrg, OrgType.Company, EASResource.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"CompanyOrgUnitMutilF7"));
    private F7ContextManager f7Manager = null;
    private DataChangeListener comOrgListener = null;
    private DataChangeListener purOrgListener = null;

    public WebPurOrderConditionUI() throws Exception {
        this.f7CompanyOrgUnit.setPermItemName(this.getViewPermission());
        this.f7CompanyOrgUnit.setUseCache(true);
        this.f7CompanyOrgUnit.setNeedWait4UIOpen(false);
        this.prmtPurOrg.setEnabledMultiSelection(true);
        this.prmtMatNumberFrom.setEnabledMultiSelection(false);
        this.prmtMatNumberTo.setEnabledMultiSelection(false);
        this.prmtMatNumberFrom.setEnabledMultiSelection(false);
        this.prmtMatNumberTo.setEnabledMultiSelection(false);
        this.comOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                WebPurOrderConditionUI.this.compOrgChange(eventObj);
            }
        };
        this.purOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                WebPurOrderConditionUI.this.purOrgChange(eventObj);
            }
        };
        this.prmtComOrg.addDataChangeListener(this.comOrgListener);
        this.prmtPurOrg.addDataChangeListener(this.purOrgListener);
        this.prmtPurOrg.setCommitFormat("#number");
        this.prmtMatNumberFrom.setCommitFormat("#number");
        this.prmtMatNumberTo.setCommitFormat("#number");
        this.prmtEasOrder.setCommitFormat("#number");
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
        this.f7Manager.registerBizMaterialF7(this.prmtMatNumberFrom, null, null, null, false);
        this.f7Manager.registerBizMaterialF7(this.prmtMatNumberTo, null, null, null, false);
        GeneralKDPromptSelectorAdaptor selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtMatNumberFrom, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery", "materialGroup.id", "StorageOrgUnit.id", "com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryNoGroupQuery");
        selectorLisenter.setIsMultiSelect(false);
        this.prmtMatNumberFrom.setSelector((KDPromptSelector)selectorLisenter);
        this.prmtMatNumberFrom.addSelectorListener((SelectorListener)selectorLisenter);
        this.prmtMatNumberTo.setSelector((KDPromptSelector)selectorLisenter);
        this.prmtMatNumberTo.addSelectorListener((SelectorListener)selectorLisenter);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    private void compOrgChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        Object obj = eventObj.getNewValue();
        Object[] objs = null;
        if (obj != null) {
            objs = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
        }
        ArrayList<OrgUnitInfo> compInfos = new ArrayList<OrgUnitInfo>();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                OrgUnitInfo info = (OrgUnitInfo)objs[i];
                if (info == null) continue;
                compInfos.add(info);
            }
        }
        this.filterPurOrgByCompOrg(compInfos);
        this.filterPurOrderByComOrg(compInfos);
        this.prmtPurOrg.setValue(null);
    }

    private void purOrgChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getOldValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        this.prmtEasOrder.setValue(null);
        Object obj = this.prmtPurOrg.getData();
        Object[] objs = null;
        if (obj != null) {
            objs = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
        }
        ArrayList<OrgUnitInfo> purOrgInfos = new ArrayList<OrgUnitInfo>();
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                OrgUnitInfo info = (OrgUnitInfo)objs[i];
                if (info == null) continue;
                purOrgInfos.add(info);
            }
        }
        this.filterPurOrderByPurOrg(purOrgInfos);
    }

    public void onInit(RptParams initParams) throws Exception {
        this.init();
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        params.setObject(C_compOrg, this.prmtComOrg.getValue());
        params.setObject(C_purOrg, this.prmtPurOrg.getData());
        params.setObject(C_matNumFrom, this.prmtMatNumberFrom.getData());
        params.setObject(C_matNumTo, this.prmtMatNumberTo.getData());
        params.setObject(C_buyGmtDateFrom, this.pkGmtDateFrom.getValue());
        params.setObject(C_buyGmtDateTo, this.pkGmtDateTo.getValue());
        params.setObject(C_WebOrderStatus, this.combWebOrder.getSelectedItem());
        params.setString(C_supplierName, this.txtSupplier.getText());
        params.setObject(C_esaOrderNum, this.prmtEasOrder.getValue());
        return params;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtComOrg.setValue(params.getObject(C_compOrg));
        this.prmtPurOrg.setValue(params.getObject(C_purOrg));
        this.prmtMatNumberFrom.setValue(params.getObject(C_matNumFrom));
        this.prmtMatNumberTo.setValue(params.getObject(C_matNumTo));
        this.pkGmtDateFrom.setValue(params.getObject(C_buyGmtDateFrom));
        this.pkGmtDateTo.setValue(params.getObject(C_buyGmtDateTo));
        this.combWebOrder.setSelectedItem(params.getObject(C_WebOrderStatus));
        this.txtSupplier.setText(params.getString(C_supplierName));
        this.prmtEasOrder.setValue(params.getObject(C_esaOrderNum));
    }

    public void clear() {
        super.clear();
        this.init();
    }

    public boolean verify() {
        Date dateStart = (Date)this.pkGmtDateFrom.getValue();
        Date dateEnd = (Date)this.pkGmtDateTo.getValue();
        if (dateStart == null || dateEnd == null) {
            MsgBox.showWarning((String)"\u8be2\u4ef7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (dateStart.compareTo(dateEnd) > 0) {
            MsgBox.showWarning((String)"\u8be2\u4ef7\u65e5\u671f\u8d77\u59cb\u65e5\u671f\u4e0d\u53ef\u5927\u4e8e\u7ec8\u6b62\u65e5\u671f");
            return false;
        }
        return true;
    }

    private void init() {
        Calendar calendar = Calendar.getInstance();
        Date dateEnd = new Date();
        dateEnd.setTime(calendar.getTimeInMillis());
        Date dateStart = new Date();
        calendar.add(2, -1);
        dateStart.setTime(calendar.getTimeInMillis());
        this.pkGmtDateFrom.setValue((Object)dateStart);
        this.pkGmtDateTo.setValue((Object)dateEnd);
        this.prmtComOrg.setValue(null);
        this.prmtPurOrg.setValue(null);
        this.prmtMatNumberFrom.setValue(null);
        this.prmtMatNumberTo.setValue(null);
        this.txtSupplier.setText(null);
        this.prmtEasOrder.setValue(null);
        this.combWebOrder.setSelectedItem((Object)BuyOfferOrderEnum.NONE);
        this.combWebOrder.setSelectedItem((Object)BuyOfferOrderEnum.NONE);
    }

    protected String getViewPermission() {
        String viewPermission = "webPurOrderRpt_view";
        return viewPermission;
    }

    private void filterPurOrgByCompOrg(List<OrgUnitInfo> compInfos) {
        ArrayList<String> purIds = new ArrayList<String>();
        try {
            for (int i = 0; i < compInfos.size(); ++i) {
                OrgUnitCollection orgs = OrgRelationUtils.getOrgsByRelation((OrgType)OrgType.Company, (OrgType)OrgType.Purchase, (BOSUuid)compInfos.get(i).getId());
                for (int j = 0; j < orgs.size(); ++j) {
                    purIds.add(orgs.get(j).getId().toString());
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.filterByFiledName(this.prmtPurOrg, "id", purIds.toArray(new String[0]));
    }

    private void filterPurOrderByComOrg(List<OrgUnitInfo> compInfos) {
        if (compInfos == null || compInfos.isEmpty()) {
            return;
        }
        String[] compIds = new String[compInfos.size()];
        for (int i = 0; i < compInfos.size(); ++i) {
            compIds[i] = new String();
            compIds[i] = compInfos.get(i).getId().toString();
        }
        this.filterByFiledName(this.prmtEasOrder, "companyOrgUnit.id", compIds);
    }

    private void filterPurOrderByPurOrg(List<OrgUnitInfo> purOrgInfos) {
        if (purOrgInfos == null || purOrgInfos.isEmpty()) {
            return;
        }
        String[] compIds = new String[purOrgInfos.size()];
        for (int i = 0; i < purOrgInfos.size(); ++i) {
            compIds[i] = new String();
            compIds[i] = purOrgInfos.get(i).getId().toString();
        }
        this.filterByFiledName(this.prmtEasOrder, "purchaseOrgUnit.id", compIds);
    }

    private void filterByFiledName(KDBizPromptBox box, String filedName, String[] values) {
        if (values == null) {
            return;
        }
        HashSet<String> valueSet = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            valueSet.add(values[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String maskString = null;
        for (int i = 0; i < values.length; ++i) {
            FilterItemInfo itemInfo = new FilterItemInfo(filedName, valueSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(itemInfo);
            maskString = i == 0 ? "#0" : maskString + " or #" + i;
        }
        filterInfo.setMaskString(maskString);
        viewInfo.setFilter(filterInfo);
        box.setEntityViewInfo(viewInfo);
    }
}

