/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.channel.NetOrderCollectionManagerFacadeFactory;
import com.kingdee.eas.scm.sd.channel.client.AbstractInventoryDetailListUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class InventoryDetailListUI
extends AbstractInventoryDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(InventoryDetailListUI.class);
    ItemChangeEnvent itemChangeEnvent = null;
    List materialIdList = new ArrayList();

    public InventoryDetailListUI() throws Exception {
        this.itemChangeEnvent = new ItemChangeEnvent();
        this.kDCheckWareHs.addItemListener((ItemListener)this.itemChangeEnvent);
        this.kDCheckLocation.addItemListener((ItemListener)this.itemChangeEnvent);
        this.kDCheckLot.addItemListener((ItemListener)this.itemChangeEnvent);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tbInvenDetail.checkParsed();
        this.tbInvenDetail.getStyleAttributes().setLocked(true);
        Set materialIdSet = (Set)this.getUIContext().get("materialIdSet");
        Iterator it = materialIdSet.iterator();
        while (it.hasNext()) {
            this.materialIdList.add(it.next().toString());
        }
        this.queryInventory();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected void queryInventory() throws BOSException, SQLException {
        IRowSet rs = NetOrderCollectionManagerFacadeFactory.getRemoteInstance().getInventoryDetail(this.materialIdList, this.getQueryType());
        this.fullTbInvenInfo(rs);
    }

    private String getQueryType() {
        String queryType = null;
        if (this.kDCheckWareHs.isSelected()) {
            queryType = queryType + "a";
        }
        if (this.kDCheckLocation.isSelected()) {
            queryType = queryType + "b";
        }
        if (this.kDCheckLot.isSelected()) {
            queryType = queryType + "c";
        }
        return queryType;
    }

    private void fullTbInvenInfo(IRowSet rs) throws SQLException {
        IRow iRow = null;
        int qtyPrecision = -1;
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                if (qtyPrecision < 0) {
                    String unitId = rs.getString("unitId");
                    String materialId = rs.getString("materialId");
                    try {
                        MultiMeasureUnitInfo multiMeasureUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialId, unitId);
                        qtyPrecision = multiMeasureUnitInfo.getQtyPrecision();
                    }
                    catch (Exception e) {
                        qtyPrecision = 0;
                    }
                }
                iRow = this.tbInvenDetail.addRow();
                for (int j = 0; j < this.tbInvenDetail.getColumnCount(); ++j) {
                    iRow.getCell(j).setValue((Object)rs.getString(this.tbInvenDetail.getColumnKey(j)));
                }
                iRow.getCell("qty").setValue((Object)new BigDecimal(iRow.getCell("qty").getValue().toString()));
            }
            SCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.tbInvenDetail, (String[])new String[]{"qty"});
        }
    }

    private void kDCheckInv_StateChanged(ItemEvent arg0) {
        this.kDCheckWareHs.setSelected(true);
        this.kDCheckWareHs.setEnabled(true);
        this.kDCheckLocation.setSelected(true);
        this.kDCheckLocation.setEnabled(true);
        this.kDCheckLot.setSelected(true);
        this.kDCheckLot.setEnabled(true);
        this.kDCheckWareHs.addItemListener((ItemListener)this.itemChangeEnvent);
        this.kDCheckLocation.addItemListener((ItemListener)this.itemChangeEnvent);
        this.kDCheckLot.addItemListener((ItemListener)this.itemChangeEnvent);
    }

    private void kDCheckWareHs_StateChanged(ItemEvent arg0) {
        if (this.kDCheckWareHs.isSelected()) {
            this.kDCheckLocation.setEnabled(true);
        } else {
            this.kDCheckLocation.setSelected(false);
            this.kDCheckLocation.setEnabled(false);
        }
    }

    protected void checkBoxChangeToQueryInv() {
        try {
            this.queryInventory();
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    private class ItemChangeEnvent
    implements ItemListener {
        private ItemChangeEnvent() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            Object source = arg0.getSource();
            try {
                if (source.equals(InventoryDetailListUI.this.kDCheckWareHs)) {
                    InventoryDetailListUI.this.kDCheckWareHs_StateChanged(arg0);
                }
            }
            catch (Exception ex) {
                InventoryDetailListUI.this.handUIException(ex);
            }
            InventoryDetailListUI.this.tbInvenDetail.refresh();
            InventoryDetailListUI.this.checkBoxChangeToQueryInv();
        }
    }
}

