/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.AbstractNetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillStatusEnum;
import com.kingdee.eas.scm.sd.channel.NetOrderCollectionManagerFacadeFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderManagerException;
import com.kingdee.eas.scm.sd.channel.client.AbstractNetOrderCollectionManagerMainUI;
import com.kingdee.eas.scm.sd.channel.client.InventoryDetailListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NetOrderCollectionManagerMainUI
extends AbstractNetOrderCollectionManagerMainUI {
    private static final long serialVersionUID = 4150978218020744434L;
    private BigDecimal ZERO = new BigDecimal("0.00");
    Map materialCollection = new HashMap();
    KDBizPromptBox kDTCollectionManager_storage_PromptBox = new KDBizPromptBox();
    StorageOrgUnitInfo oldStorageOrg = null;
    KDBizPromptBox tbManagerInfo_warehouse_PromptBox = new KDBizPromptBox();
    private Set ids = null;
    private NetOrderBillCollection netOrderBillCollection = null;
    String currentMaterialId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.ids = (Set)this.getUIContext().get("ids");
        if (this.ids == null || this.ids.size() < 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"9_NetOrderCollectionManagerMainUI"));
            SysUtil.abort();
        }
        this.kDTCollectionManager.checkParsed();
        this.kDTMaterialCollection.checkParsed();
        this.netOrderBillCollection = this.getNetOrderCollection(this.ids);
        this.materialCollection();
        this.initUI();
    }

    protected boolean checkBeforeWindowClosing() {
        ArrayList idList = new ArrayList();
        Iterator it = this.ids.iterator();
        while (it.hasNext()) {
            idList.add(it.next());
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
        mutexServiceControl.batchReleaseObjIDForUpdate(idList);
        return true;
    }

    private void initUI() {
        this.kDTMaterialCollection.getSelectManager().setSelectMode(2);
        this.kDTCollectionManager_storage_PromptBox.setQueryInfo("com.kingdee.eas.scm.im.inv.app.F7StorageOrgUnitQuery");
        this.kDTCollectionManager_storage_PromptBox.setVisible(true);
        this.kDTCollectionManager_storage_PromptBox.setEditable(true);
        this.kDTCollectionManager_storage_PromptBox.setDisplayFormat("$name$");
        this.kDTCollectionManager_storage_PromptBox.setEditFormat("$number$");
        this.kDTCollectionManager_storage_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kDTCollectionManager_storage_CellEditor = new KDTDefaultCellEditor((IKDEditor)this.kDTCollectionManager_storage_PromptBox);
        this.kDTCollectionManager.getColumn("storageOrgUnit.name").setEditor((ICellEditor)kDTCollectionManager_storage_CellEditor);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.kDTCollectionManager_storage_PromptBox, (OrgType)OrgType.Storage, (String)"inventory");
        this.kDTCollectionManager_storage_PromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                int rowNum;
                IRow row;
                AbstractNetOrderBillEntryInfo entry = null;
                int size = NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().size();
                if (size == 1 && NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().get().getTop() == NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().get().getBottom() && (row = NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getRow(rowNum = NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().get().getTop())).getCell("storageOrgUnit.name") != null) {
                    entry = (NetOrderBillEntryInfo)row.getCell("entryId").getUserObject();
                    NetOrderCollectionManagerMainUI.this.oldStorageOrg = entry.getStorageOrgUnit();
                }
                if (NetOrderCollectionManagerMainUI.this.kDTCollectionManager_storage_PromptBox.getData() == null || !(NetOrderCollectionManagerMainUI.this.kDTCollectionManager_storage_PromptBox.getData() instanceof StorageOrgUnitInfo) || NetOrderCollectionManagerMainUI.this.kDTCollectionManager_storage_PromptBox.getData().equals(NetOrderCollectionManagerMainUI.this.oldStorageOrg)) {
                    return;
                }
                if (entry != null) {
                    entry.setStorageOrgUnit((StorageOrgUnitInfo)NetOrderCollectionManagerMainUI.this.kDTCollectionManager_storage_PromptBox.getData());
                }
                NetOrderCollectionManagerMainUI.this.tbManagerInfo_warehouse_PromptBox.setData(null);
                size = NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().size();
                if (size == 1 && NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().get().getTop() == NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().get().getBottom() && (row = NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getRow(rowNum = NetOrderCollectionManagerMainUI.this.kDTCollectionManager.getSelectManager().get().getTop())).getCell("warehouse") != null) {
                    row.getCell("warehouse").setValue(null);
                    entry = (NetOrderBillEntryInfo)row.getCell("entryId").getUserObject();
                    entry.setWarehouse(null);
                }
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)NetOrderCollectionManagerMainUI.this.kDTCollectionManager_storage_PromptBox.getData();
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("whState", (Object)new Integer(1), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
                ev.setFilter(filterInfo);
                NetOrderCollectionManagerMainUI.this.tbManagerInfo_warehouse_PromptBox.setEntityViewInfo(ev);
            }
        });
        KDDatePicker askArriveDate_DatePicker = new KDDatePicker();
        this.kDTCollectionManager.getColumn("entries.askArriveDate").setEditor((ICellEditor)new KDTDefaultCellEditor(askArriveDate_DatePicker));
        this.kDTCollectionManager.getColumn("entries.askArriveDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        KDDatePicker sendDate_DatePicker = new KDDatePicker();
        this.kDTCollectionManager.getColumn("sendDate").setEditor((ICellEditor)new KDTDefaultCellEditor(sendDate_DatePicker));
        this.kDTCollectionManager.getColumn("sendDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.kDTCollectionManager.getColumn("bizDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.kDTMaterialCollection.getStyleAttributes().setLocked(true);
        this.kDTCollectionManager.getStyleAttributes().setLocked(true);
        this.kDTCollectionManager.getColumn("warehouse").getStyleAttributes().setLocked(false);
        this.kDTCollectionManager.getColumn("entries.approveQty").getStyleAttributes().setLocked(false);
        this.kDTCollectionManager.getColumn("entries.askArriveDate").getStyleAttributes().setLocked(false);
        this.kDTCollectionManager.getColumn("sendDate").getStyleAttributes().setLocked(false);
        this.kDTCollectionManager.getColumn("storageOrgUnit.name").getStyleAttributes().setLocked(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnStorageDetail.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
    }

    private void materialCollection() throws BOSException, EASBizException {
        if (this.netOrderBillCollection == null || this.netOrderBillCollection.size() < 1) {
            return;
        }
        String inventoryID = null;
        int size = 0;
        HashSet<String> set = new HashSet<String>();
        HashSet<String> materialIdsSet = new HashSet<String>();
        HashSet<String> unitIdSet = new HashSet<String>();
        HashSet<MeasureUnitInfo> inventoryUnitIdSet = new HashSet<MeasureUnitInfo>();
        for (int i = 0; i < this.netOrderBillCollection.size(); ++i) {
            NetOrderBillInfo bill = this.netOrderBillCollection.get(i);
            NetOrderBillEntryCollection entrys = bill.getEntries();
            if (entrys == null || entrys.size() < 1) continue;
            size += entrys.size();
            for (int j = 0; j < entrys.size(); ++j) {
                NetOrderBillEntryInfo entry = entrys.get(j);
                set.add(entry.getMaterial().getId().toString());
                materialIdsSet.add(entry.getMaterial().getId().toString());
                unitIdSet.add(entry.getUnit().getId().toString());
                inventoryID = entry.getStorageOrgUnit() == null ? "" : entry.getStorageOrgUnit().getId().toString();
            }
        }
        HashMap<String, MaterialInventoryInfo> map = new HashMap<String, MaterialInventoryInfo>(0);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        view.getSelector().add(new SelectorItemInfo("unit.number"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        view.getSelector().add(new SelectorItemInfo("unit.qtyPrecision"));
        view.getSelector().add(new SelectorItemInfo("unit.coefficient"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)inventoryID));
        view.setFilter(filter);
        MaterialInventoryCollection collection = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            MaterialInventoryInfo info = collection.get(i);
            map.put(info.getMaterial().getId().toString(), info);
            inventoryUnitIdSet.add(info.getUnit());
        }
        Map mulUnitMap = SCMUtils.getMultiMeasureUnitMap(materialIdsSet, unitIdSet);
        Map mulInventoryUnitMap = SCMUtils.getMultiMeasureUnitMap(materialIdsSet, inventoryUnitIdSet);
        for (int i = 0; i < this.netOrderBillCollection.size(); ++i) {
            NetOrderBillInfo bill = this.netOrderBillCollection.get(i);
            NetOrderBillEntryCollection entrys = bill.getEntries();
            if (entrys == null || entrys.size() < 1) continue;
            for (int j = 0; j < entrys.size(); ++j) {
                NetOrderBillEntryInfo entry = entrys.get(j);
                if (NetOrderBillStatusEnum.TREATED.equals((Object)entry.getEntryStatus())) continue;
                String materialId = entry.getMaterial().getId().toString();
                MaterialCollectionInfo materialCollectionInfo = (MaterialCollectionInfo)this.materialCollection.get(materialId);
                MaterialInventoryInfo inventoryInfo = (MaterialInventoryInfo)map.get(entry.getMaterial().getId().toString());
                if (materialCollectionInfo == null) {
                    materialCollectionInfo = new MaterialCollectionInfo();
                    materialCollectionInfo.setMaterialId(entry.getMaterial().getId());
                    materialCollectionInfo.setMaterialNumber(entry.getMaterial().getNumber());
                    materialCollectionInfo.setMaterialName(entry.getMaterial().getName());
                    materialCollectionInfo.setMaterialModel(entry.getMaterial().getModel());
                    materialCollectionInfo.setBasicUnit(entry.getMaterial().getBaseUnit());
                    materialCollectionInfo.setStorageUnit(inventoryInfo == null ? null : inventoryInfo.getUnit());
                    materialCollectionInfo.setMaterialInfo(entry.getMaterial());
                    materialCollectionInfo.setUnit(inventoryInfo == null ? null : inventoryInfo.getUnit());
                    this.materialCollection.put(materialId, materialCollectionInfo);
                }
                materialCollectionInfo.setApproveQty(materialCollectionInfo.getApproveQty().add(entry.getApproveQty() == null ? new BigDecimal("0") : entry.getApproveQty()));
                BigDecimal newQty = SCMUtils.getExchangeQtyForClient((MultiMeasureUnitInfo)((MultiMeasureUnitInfo)mulUnitMap.get(materialId)), (MultiMeasureUnitInfo)((MultiMeasureUnitInfo)mulInventoryUnitMap.get(materialId)), (BigDecimal)entry.getApproveQty());
                materialCollectionInfo.setApproveQtyBasic(materialCollectionInfo.getApproveQtyBasic().add(newQty == null ? this.ZERO : newQty));
                materialCollectionInfo.setQtyBasic(materialCollectionInfo.getQtyBasic().add(entry.getBaseQty()));
            }
        }
        ArrayList materialIds = new ArrayList();
        Set materialIdSet = this.materialCollection.keySet();
        Iterator iterator = materialIdSet.iterator();
        while (iterator.hasNext()) {
            materialIds.add(iterator.next());
        }
        Map inventoryQtyBase = null;
        inventoryQtyBase = NetOrderCollectionManagerFacadeFactory.getRemoteInstance().getInventoryQtyBase(materialIds);
        if (inventoryQtyBase != null) {
            Set keySet = this.materialCollection.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                MaterialCollectionInfo info = (MaterialCollectionInfo)this.materialCollection.get(it.next());
                String key = inventoryID + info.getMaterialId();
                BigDecimal invqtyBase = (BigDecimal)inventoryQtyBase.get(key);
                if (invqtyBase == null) {
                    invqtyBase = this.ZERO;
                }
                info.setStorageQtyBasic(invqtyBase);
                info.setDifferenceQtyBasic(invqtyBase.subtract(info.getQtyBasic()));
                if (info.getStorageUnit() != null) {
                    info.setQty(SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)info.getStorageUnit(), (MeasureUnitInfo)info.getBasicUnit(), (MaterialInfo)info.getMaterialInfo(), (BigDecimal)info.getQtyBasic()));
                    info.setStorageQty(SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)info.getStorageUnit(), (MeasureUnitInfo)info.getBasicUnit(), (MaterialInfo)info.getMaterialInfo(), (BigDecimal)info.getStorageQtyBasic()));
                    if (info.getStorageQty() != null) {
                        info.setDifferenceQty(info.getStorageQty().subtract(info.getQty()));
                    }
                } else {
                    info.setQty(this.ZERO);
                    info.setStorageQty(this.ZERO);
                    info.setDifferenceQty(this.ZERO);
                }
                info.setApproveQty(info.getApproveQtyBasic());
            }
        }
        this.fillKDTMaterialCollection();
    }

    private void fillKDTMaterialCollection() throws EASBizException, BOSException {
        this.kDTMaterialCollection.removeRows();
        Collection materialColl = this.materialCollection.values();
        Iterator it = materialColl.iterator();
        MaterialInfo[] materialInfos = new MaterialInfo[materialColl.size()];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[materialColl.size()];
        MeasureUnitInfo[] storageUnitInfos = new MeasureUnitInfo[materialColl.size()];
        int[] rowIndexs = new int[materialColl.size()];
        int i = 0;
        while (it.hasNext()) {
            MaterialCollectionInfo materialCollectionInfo = (MaterialCollectionInfo)it.next();
            IRow row = this.kDTMaterialCollection.addRow();
            materialInfos[i] = materialCollectionInfo.getMaterialInfo();
            measureUnitInfos[i] = materialCollectionInfo.getBasicUnit();
            storageUnitInfos[i] = materialCollectionInfo.getStorageUnit();
            rowIndexs[i] = i;
            ++i;
            row.getCell("materialId").setValue((Object)materialCollectionInfo.getMaterialId());
            row.getCell("materialNumber").setValue((Object)materialCollectionInfo.getMaterialNumber());
            row.getCell("materialName").setValue((Object)materialCollectionInfo.getMaterialName());
            row.getCell("materialModel").setValue((Object)materialCollectionInfo.getMaterialModel());
            row.getCell("qty").setValue((Object)materialCollectionInfo.getQty());
            row.getCell("storageQty").setValue((Object)materialCollectionInfo.getStorageQty());
            row.getCell("differenceQty").setValue((Object)materialCollectionInfo.getDifferenceQty());
            row.getCell("approveQty").setValue((Object)materialCollectionInfo.getApproveQty());
            row.getCell("qtyBasic").setValue((Object)materialCollectionInfo.getQtyBasic());
            row.getCell("storageQtyBasic").setValue((Object)materialCollectionInfo.getStorageQtyBasic());
            row.getCell("differenceQtyBasic").setValue((Object)materialCollectionInfo.getDifferenceQtyBasic());
            row.getCell("basicUnit").setValue((Object)materialCollectionInfo.getBasicUnit());
            row.getCell("storageUnit").setValue((Object)materialCollectionInfo.getStorageUnit());
        }
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])measureUnitInfos, (KDTable)this.kDTMaterialCollection, (String[])new String[]{"qtyBasic", "storageQtyBasic", "differenceQtyBasic"}, (int[])rowIndexs);
        SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])materialInfos, (MeasureUnitInfo[])storageUnitInfos, (KDTable)this.kDTMaterialCollection, (String[])new String[]{"qty", "storageQty", "differenceQty", "approveQty"}, (int[])rowIndexs);
    }

    private NetOrderBillCollection getNetOrderCollection(Set idSet) throws BOSException {
        this.netOrderBillCollection = new NetOrderBillCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo info = new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE);
        filter.getFilterItems().add(info);
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("*");
        coll.add("channel.*");
        coll.add("saleOrgUnit.*");
        coll.add("entries.*");
        coll.add("entries.material.*");
        coll.add("entries.material.baseUnit.*");
        coll.add("entries.unit.*");
        coll.add("entries.storageOrgUnit.*");
        coll.add("entries.warehouse.*");
        coll.add("entries.weightUnit.*");
        view.setSelector(coll);
        this.netOrderBillCollection = NetOrderBillFactory.getRemoteInstance().getNetOrderBillCollection(view);
        return this.netOrderBillCollection;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kDTCollectionManager_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.kDTCollectionManager.getRow(rowIndex);
        String billId = row.getCell("billId").getValue().toString();
        String entryId = row.getCell("entryId").getValue().toString();
        String materialId = row.getCell("material.id").getValue().toString();
        BigDecimal qty = (BigDecimal)row.getCell("entries.qty").getValue();
        BigDecimal approveQty = (BigDecimal)row.getCell("entries.approveQty").getValue();
        BigDecimal price = (BigDecimal)row.getCell("entries.price").getValue();
        BigDecimal amount = (BigDecimal)row.getCell("entries.amount").getValue();
        if (approveQty != null && price != null) {
            int currencyPrecision = 2;
            if (amount != null) {
                currencyPrecision = amount.scale();
            }
            row.getCell("entries.approveAmount").setValue((Object)approveQty.multiply(price).setScale(currencyPrecision, 4));
        }
        BigDecimal weight = (BigDecimal)row.getCell("entries.weight").getValue();
        if (qty != null && qty.compareTo(SCMClientUtils.ZERO) > 0 && weight != null && weight.compareTo(SCMClientUtils.ZERO) > 0) {
            row.getCell("entries.approveWeight").setValue((Object)weight.multiply(approveQty == null ? new BigDecimal("0") : approveQty).divide(qty, weight.scale(), 4));
        }
        BigDecimal oldQty = new BigDecimal("0");
        BigDecimal newQty = new BigDecimal("0");
        MaterialCollectionInfo materialCollectionInfo = (MaterialCollectionInfo)this.materialCollection.get(materialId);
        for (int i = 0; i < this.netOrderBillCollection.size(); ++i) {
            NetOrderBillInfo bill = this.netOrderBillCollection.get(i);
            if (!bill.getId().toString().equals(billId)) continue;
            NetOrderBillEntryCollection entrys = bill.getEntries();
            for (int j = 0; j < entrys.size(); ++j) {
                NetOrderBillEntryInfo entry = entrys.get(j);
                if (!entry.getId().toString().equals(entryId)) continue;
                oldQty = SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)materialCollectionInfo.getStorageUnit(), (MeasureUnitInfo)entry.getUnit(), (MaterialInfo)entry.getMaterial(), (BigDecimal)entry.getApproveQty());
                newQty = SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)materialCollectionInfo.getStorageUnit(), (MeasureUnitInfo)entry.getUnit(), (MaterialInfo)entry.getMaterial(), (BigDecimal)approveQty);
                entry.setApproveQty(approveQty);
            }
        }
        materialCollectionInfo.setApproveQty(newQty == null ? new BigDecimal("0") : newQty);
        int rowCount = this.kDTMaterialCollection.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kDTMaterialCollection.getRow(i);
            String tempMaterialId = row.getCell("materialId").getValue().toString();
            if (!tempMaterialId.equalsIgnoreCase(materialId)) continue;
            row.getCell("approveQty").setValue((Object)materialCollectionInfo.getApproveQty());
            break;
        }
    }

    @Override
    protected void kDTMaterialCollection_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.kDTMaterialCollection.getRow(rowIndex);
        this.currentMaterialId = row.getCell("materialId").getValue().toString();
        this.fillCollectionManagerTable(this.currentMaterialId);
    }

    @Override
    protected void kDTCollectionManager_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.kDTCollectionManager.getRow(rowIndex);
        ICell cell = row.getCell("storageOrgUnit.name");
        if (cell != null && cell.getValue() != null && cell.getValue() instanceof StorageOrgUnitInfo) {
            this.oldStorageOrg = (StorageOrgUnitInfo)cell.getValue();
        }
    }

    private void fillCollectionManagerTable(String materialId) throws NetOrderManagerException, EASBizException, BOSException {
        if (materialId == null || materialId.trim().length() == 0) {
            return;
        }
        if (this.netOrderBillCollection == null || this.netOrderBillCollection.size() < 1) {
            return;
        }
        MaterialCollectionInfo materialCollectionInfo = (MaterialCollectionInfo)this.materialCollection.get(materialId);
        this.kDTCollectionManager.removeRows();
        BigDecimal storageQty = new BigDecimal("0");
        BigDecimal baseUnitQty = null;
        for (int i = 0; i < this.netOrderBillCollection.size(); ++i) {
            NetOrderBillInfo bill = this.netOrderBillCollection.get(i);
            NetOrderBillEntryCollection entrys = bill.getEntries();
            if (entrys == null || entrys.size() < 1) continue;
            if (this.kDTCollectionManager.getColumn("storageOrgUnit.name").getEditor() != null && this.kDTCollectionManager.getColumn("storageOrgUnit.name").getEditor().getComponent() instanceof KDBizPromptBox) {
                KDBizPromptBox storageF7 = (KDBizPromptBox)this.kDTCollectionManager.getColumn("storageOrgUnit.name").getEditor().getComponent();
                SCMGroupClientUtils.setBizOrgF7ByType((KDBizPromptBox)storageF7, (OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (boolean)true);
                if (bill.getSaleOrgUnit() != null) {
                    storageF7.setCurrentMainBizOrgUnit((OrgUnitInfo)bill.getSaleOrgUnit(), OrgType.Sale);
                }
            }
            MaterialInfo[] materialInfos = new MaterialInfo[entrys.size()];
            MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[entrys.size()];
            MeasureUnitInfo[] weightUnits = new MeasureUnitInfo[entrys.size()];
            int[] rowIndexs = new int[entrys.size()];
            int si = 0;
            for (int j = 0; j < entrys.size(); ++j) {
                NetOrderBillEntryInfo entry = entrys.get(j);
                if (NetOrderBillStatusEnum.TREATED.equals((Object)entry.getEntryStatus())) {
                    rowIndexs[j] = -1;
                    continue;
                }
                String tempMaterialId = entry.getMaterial().getId().toString();
                if (!materialId.equals(tempMaterialId)) {
                    rowIndexs[j] = -1;
                    continue;
                }
                materialInfos[j] = entry.getMaterial();
                measureUnitInfos[j] = entry.getUnit();
                weightUnits[j] = entry.getWeightUnit();
                rowIndexs[j] = si;
                si = 1;
                IRow row = this.kDTCollectionManager.addRow();
                row.getCell("billId").setValue((Object)bill.getId());
                row.getCell("entryId").setValue((Object)entry.getId());
                row.getCell("entryId").setUserObject((Object)entry);
                row.getCell("channel.id").setValue((Object)bill.getChannel().getId());
                row.getCell("channel.name").setValue((Object)bill.getChannel().getName());
                row.getCell("number").setValue((Object)bill.getNumber());
                row.getCell("entries.askArriveDate").setValue((Object)entry.getAskArriveDate());
                row.getCell("entries.entryStatus").setValue((Object)entry.getEntryStatus());
                row.getCell("entries.qty").setValue((Object)entry.getQty());
                if (4 == entry.getEntryStatus().getValue()) {
                    row.getCell("entries.approveQty").setValue((Object)entry.getQty());
                } else {
                    row.getCell("entries.approveQty").setValue((Object)entry.getApproveQty());
                }
                baseUnitQty = SCMClientUtils.getBaseUnitQtyFromData((MeasureUnitInfo)materialCollectionInfo.getStorageUnit(), (MeasureUnitInfo)entry.getUnit(), (MaterialInfo)entry.getMaterial(), (BigDecimal)((BigDecimal)row.getCell("entries.approveQty").getValue()));
                if (baseUnitQty != null) {
                    storageQty = storageQty.add(baseUnitQty);
                }
                row.getCell("storageOrgUnit.number").setValue((Object)entry.getStorageOrgUnit().getNumber());
                row.getCell("storageOrgUnit.name").setValue((Object)entry.getStorageOrgUnit());
                row.getCell("warehouse").setValue((Object)entry.getWarehouse());
                row.getCell("material.id").setValue((Object)entry.getMaterial().getId());
                row.getCell("material.number").setValue((Object)entry.getMaterial().getNumber());
                row.getCell("material.name").setValue((Object)entry.getMaterial().getName());
                row.getCell("material.model").setValue((Object)entry.getMaterial().getModel());
                row.getCell("unit.name").setValue((Object)entry.getUnit().getName());
                row.getCell("entries.price").setValue((Object)entry.getPrice());
                row.getCell("entries.amount").setValue((Object)entry.getAmount());
                row.getCell("bizDate").setValue((Object)bill.getBizDate());
                row.getCell("entries.address").setValue((Object)entry.getAddress());
                row.getCell("entries.weightUnit").setValue((Object)entry.getWeightUnit());
                row.getCell("entries.weight").setValue((Object)entry.getWeight());
                BigDecimal weight = entry.getWeight() == null ? new BigDecimal("0") : entry.getWeight();
                BigDecimal qty = entry.getQty();
                int weightUnitPrecision = entry.getWeightUnitPrecision() == 0 ? 8 : entry.getWeightUnitPrecision();
                BigDecimal approveQty = row.getCell("entries.approveQty").getValue() == null ? new BigDecimal("0") : (BigDecimal)row.getCell("entries.approveQty").getValue();
                BigDecimal approveWeight = approveQty.multiply(weight.divide(qty, weightUnitPrecision, 4));
                row.getCell("entries.approveWeight").setValue((Object)approveWeight);
                row.getCell("entries.approvePrice").setValue((Object)entry.getPrice());
                row.getCell("saleOrgUnit.id").setValue((Object)bill.getSaleOrgUnit().getId());
                row.getCell("saleOrgUnit.name").setValue((Object)bill.getSaleOrgUnit().getName());
                row.getCell("sendDate").setValue(null);
                BigDecimal amount = entry.getAmount().setScale(bill.getCurrencyPrecision(), 4);
                row.getCell("entries.amount").setValue((Object)amount);
                BigDecimal approveAmount = approveQty.multiply(entry.getPrice()).setScale(bill.getCurrencyPrecision(), 4);
                row.getCell("entries.approveAmount").setValue((Object)approveAmount.setScale(bill.getCurrencyPrecision(), 4));
                if (entry.getStorageOrgUnit() == null) continue;
                row.getCell("sendDate").setValue(row.getCell("entries.askArriveDate").getValue());
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)entry.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                ev.setFilter(filterInfo);
                row.getCell("warehouse").getEditor();
                this.tbManagerInfo_warehouse_PromptBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7AllWarehouseQuery");
                this.tbManagerInfo_warehouse_PromptBox.setVisible(true);
                this.tbManagerInfo_warehouse_PromptBox.setEditable(true);
                this.tbManagerInfo_warehouse_PromptBox.setDisplayFormat("$name$");
                this.tbManagerInfo_warehouse_PromptBox.setEditFormat("$number$");
                this.tbManagerInfo_warehouse_PromptBox.setCommitFormat("$number$");
                this.tbManagerInfo_warehouse_PromptBox.setEntityViewInfo(ev);
                KDTDefaultCellEditor tbManagerInfo_warehouse_CellEditor = new KDTDefaultCellEditor((IKDEditor)this.tbManagerInfo_warehouse_PromptBox);
                row.getCell("warehouse").setEditor((ICellEditor)tbManagerInfo_warehouse_CellEditor);
                SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{"entries.price", "entries.approvePrice"}, (int)entry.getPricePrecision(), (boolean)false, (boolean)false);
                SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{"entries.qty", "entries.approveQty"}, (int)entry.getUnitPrecision(), (boolean)false, (boolean)false);
                if (entry.getWeightUnit() != null) {
                    SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{"entries.weight", "entries.approveWeight"}, (int)entry.getWeightUnit().getQtyPrecision(), (boolean)false, (boolean)false);
                    continue;
                }
                SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{"entries.weight", "entries.approveWeight"}, (int)2, (boolean)false, (boolean)false);
            }
        }
        this.updateApproveQty_kDTMaterialCollection(materialId, storageQty);
    }

    private void updateApproveQty_kDTMaterialCollection(String materialId, BigDecimal approveQty) {
        int rowCount = this.kDTMaterialCollection.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.kDTMaterialCollection.getRow(i);
            String tempMaterialId = row.getCell("materialId").getValue().toString();
            if (!tempMaterialId.equalsIgnoreCase(materialId)) continue;
            row.getCell("approveQty").setValue((Object)approveQty);
            break;
        }
    }

    @Override
    protected void kDTMaterialCollection_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.kDTCollectionManager.getEditManager().editingStopped();
        NetOrderBillEntryCollection entryCollection = new NetOrderBillEntryCollection();
        int rowCount = this.kDTCollectionManager.getRowCount();
        StringBuffer entryIds = new StringBuffer();
        for (int i2 = 0; i2 < rowCount; ++i2) {
            IRow row = this.kDTCollectionManager.getRow(i2);
            String entryId = row.getCell("entryId").getValue().toString();
            if (i2 == 0) {
                entryIds.append(entryId);
                continue;
            }
            entryIds.append(",").append(entryId);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)entryIds.toString(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        NetOrderBillEntryCollection collection = NetOrderBillEntryFactory.getRemoteInstance().getNetOrderBillEntryCollection(view);
        ArrayList<BOSUuid> dealedEntryIdList = new ArrayList<BOSUuid>();
        if (collection != null) {
            for (i = 0; i < collection.size(); ++i) {
                int statusValue = collection.get(i).getEntryStatus().getValue();
                if (statusValue <= 4 || statusValue == 8) continue;
                dealedEntryIdList.add(collection.get(i).getId());
            }
        }
        for (i = 0; i < rowCount; ++i) {
            int result;
            IRow row = this.kDTCollectionManager.getRow(i);
            NetOrderBillEntryInfo entry = (NetOrderBillEntryInfo)row.getCell("entryId").getUserObject();
            if (dealedEntryIdList.contains(entry.getId())) continue;
            String billNumber = row.getCell("number").getValue().toString();
            Object storageOrg = row.getCell("storageOrgUnit.name").getValue();
            Object wareHouse = row.getCell("warehouse").getValue();
            Object askArriveDate = row.getCell("entries.askArriveDate").getValue();
            BigDecimal qty = (BigDecimal)row.getCell("entries.qty").getValue();
            BigDecimal approveQty = (BigDecimal)row.getCell("entries.approveQty").getValue();
            BigDecimal approveAmount = (BigDecimal)row.getCell("entries.approveAmount").getValue();
            if (approveQty.compareTo(qty) > 0 && 2 == (result = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"10_NetOrderCollectionManagerMainUI"), billNumber)))) {
                return;
            }
            entry.setApproveQty(approveQty);
            entry.setApproveAmount(approveAmount);
            if (storageOrg != null && storageOrg instanceof StorageOrgUnitInfo) {
                entry.setStorageOrgUnit((StorageOrgUnitInfo)storageOrg);
            }
            if (wareHouse != null && wareHouse instanceof WarehouseInfo) {
                entry.setWarehouse((WarehouseInfo)wareHouse);
            } else {
                entry.setWarehouse(null);
            }
            if (askArriveDate != null && askArriveDate instanceof Date) {
                entry.setAskArriveDate((Date)askArriveDate);
            }
            entry.setEntryStatus(NetOrderBillStatusEnum.DEALING);
            if (entry.getStorageOrgUnit() == null) {
                MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"13_NetOrderCollectionManagerMainUI"), new Integer(i + 1).toString()));
                return;
            }
            if (entry.getAskArriveDate() == null) {
                MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"14_NetOrderCollectionManagerMainUI"), new Integer(i + 1).toString()));
                return;
            }
            entryCollection.add(entry);
        }
        NetOrderCollectionManagerFacadeFactory.getRemoteInstance().assignInventory(entryCollection);
        this.fillCollectionManagerTable(this.currentMaterialId);
    }

    @Override
    public void actionStorageDetail_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        HashSet<String> materialIdSet = new HashSet<String>();
        materialIdSet.add(this.currentMaterialId);
        if (this.currentMaterialId == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"9_NetOrderCollectionManagerMainUI"));
            return;
        }
        uiContext.put((Object)"materialIdSet", materialIdSet);
        String mode = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(InventoryDetailListUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    class MaterialCollectionInfo {
        private BOSUuid materialId = null;
        private String materialNumber = "";
        private String materialName = "";
        private String materialModel = "";
        private BigDecimal qty = new BigDecimal(0);
        private BigDecimal storageQty = new BigDecimal(0);
        private BigDecimal differenceQty = new BigDecimal(0);
        private BigDecimal approveQty = new BigDecimal(0);
        private BigDecimal approveQtyBasic = new BigDecimal(0);
        private BigDecimal qtyBasic = new BigDecimal(0);
        private BigDecimal storageQtyBasic = new BigDecimal(0);
        private BigDecimal differenceQtyBasic = new BigDecimal(0);
        private MeasureUnitInfo basicUnit = null;
        private MeasureUnitInfo storageUnit = null;
        private MaterialInfo materialInfo = null;
        private MeasureUnitInfo unit = null;

        MaterialCollectionInfo() {
        }

        public BigDecimal getApproveQtyBasic() {
            return this.approveQtyBasic;
        }

        public void setApproveQtyBasic(BigDecimal approveQtyBasic) {
            this.approveQtyBasic = approveQtyBasic;
        }

        public MaterialInfo getMaterialInfo() {
            return this.materialInfo;
        }

        public void setMaterialInfo(MaterialInfo materialInfo) {
            this.materialInfo = materialInfo;
        }

        public MeasureUnitInfo getUnit() {
            return this.unit;
        }

        public void setUnit(MeasureUnitInfo unit) {
            this.unit = unit;
        }

        public BigDecimal getApproveQty() {
            return this.approveQty;
        }

        public void setApproveQty(BigDecimal approveQty) {
            this.approveQty = approveQty;
        }

        public MeasureUnitInfo getBasicUnit() {
            return this.basicUnit;
        }

        public void setBasicUnit(MeasureUnitInfo basicUnit) {
            this.basicUnit = basicUnit;
        }

        public BigDecimal getDifferenceQty() {
            return this.differenceQty;
        }

        public void setDifferenceQty(BigDecimal differenceQty) {
            this.differenceQty = differenceQty;
        }

        public BigDecimal getDifferenceQtyBasic() {
            return this.differenceQtyBasic;
        }

        public void setDifferenceQtyBasic(BigDecimal differenceQtyBasic) {
            this.differenceQtyBasic = differenceQtyBasic;
        }

        public String getMaterialModel() {
            return this.materialModel;
        }

        public void setMaterialModel(String materialModel) {
            this.materialModel = materialModel;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public void setMaterialName(String materialName) {
            this.materialName = materialName;
        }

        public String getMaterialNumber() {
            return this.materialNumber;
        }

        public void setMaterialNumber(String materialNumber) {
            this.materialNumber = materialNumber;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getQtyBasic() {
            return this.qtyBasic;
        }

        public void setQtyBasic(BigDecimal qtyBasic) {
            this.qtyBasic = qtyBasic;
        }

        public BigDecimal getStorageQty() {
            return this.storageQty;
        }

        public void setStorageQty(BigDecimal storageQty) {
            this.storageQty = storageQty;
        }

        public BigDecimal getStorageQtyBasic() {
            return this.storageQtyBasic;
        }

        public void setStorageQtyBasic(BigDecimal storageQtyBasic) {
            this.storageQtyBasic = storageQtyBasic;
        }

        public MeasureUnitInfo getStorageUnit() {
            return this.storageUnit;
        }

        public void setStorageUnit(MeasureUnitInfo storageUnit) {
            this.storageUnit = storageUnit;
        }

        public BOSUuid getMaterialId() {
            return this.materialId;
        }

        public void setMaterialId(BOSUuid materialId) {
            this.materialId = materialId;
        }
    }
}

