/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.NetOrderBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderCollectionManagerFacadeFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderManagerException;
import com.kingdee.eas.scm.sd.channel.client.AbstractNetOrderListUI;
import com.kingdee.eas.scm.sd.channel.client.ChannelCommonQueryProcessor;
import com.kingdee.eas.scm.sd.channel.client.NetOrderBatchModifyUI;
import com.kingdee.eas.scm.sd.channel.client.NetOrderCollectionManagerConditionPanelUI;
import com.kingdee.eas.scm.sd.channel.client.NetOrderCollectionManagerMainUI;
import com.kingdee.eas.scm.sd.channel.util.NetOrderHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;

public class NetOrderListUI
extends AbstractNetOrderListUI {
    private static final long serialVersionUID = -8541707357892523715L;
    CommonQueryDialog commonQueryDialog = null;
    NetOrderCollectionManagerConditionPanelUI filterUI = null;
    ISCMBillBase iBiz = null;
    OrgUnitCollection authorizedMainOrgs = null;
    Set listSaleOrg = null;
    private static String[] NUMBERTAB = new String[]{"exchangeRate", "entries.qty", "entries.price", "entries.amount", "entries.weight", "entries.approveQty", "entries.approvePrice", "entries.approveAmount"};

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])NUMBERTAB, (String)"%{0.##########}f");
        this.setQtyColumnsAlign();
        this.initUI();
        this.initData();
    }

    protected String[] getQtyColumns() throws Exception {
        return NUMBERTAB;
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.initUI();
        this.initData();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (!this.isDoRequestData() || this.mainQuery == null) {
            return;
        }
        if (this.isHasQyeryPK() && this.tblMain.getDataRequestManager().getDataRequestMode() == 1) {
            this.tblMain_doRequestRowSetForHasQueryPK(e);
        } else {
            this.tblMain_doRequestRowSetForNoQueryPK(e);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDContainer3.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 986, 279));
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (OrgType.Sale.equals((Object)orgType)) {
            return "saleOrgUnit.id";
        }
        if (OrgType.Storage.equals((Object)orgType)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    private void initUI() {
        KDCheckBox tblMain_IsSelect_kdCheckBox = new KDCheckBox();
        KDTDefaultCellEditor tblMain_IsSelect_CellEditor = new KDTDefaultCellEditor((JCheckBox)tblMain_IsSelect_kdCheckBox);
        this.tblMain.getColumn("isSelect").setEditor((ICellEditor)tblMain_IsSelect_CellEditor);
        this.tblMain.checkParsed();
        KDBizPromptBox tblMain_storage_PromptBox = new KDBizPromptBox();
        tblMain_storage_PromptBox.setQueryInfo("com.kingdee.eas.scm.im.inv.app.F7StorageOrgUnitQuery");
        tblMain_storage_PromptBox.setVisible(true);
        tblMain_storage_PromptBox.setEditable(true);
        tblMain_storage_PromptBox.setDisplayFormat("$number$");
        tblMain_storage_PromptBox.setEditFormat("$number$");
        tblMain_storage_PromptBox.setCommitFormat("$number$");
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)tblMain_storage_PromptBox, (OrgType)OrgType.Storage, (String)"inventory");
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("askArriveDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("entries.askArriveDate").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("modificationTime").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.actionUnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnUnAudit.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.btnSubmit.setVisible(false);
        this.btnSubmit.setEnabled(false);
        this.btnCreateToSaleOrder.setVisible(true);
        this.btnCreateToSaleOrder.setEnabled(true);
        this.btnTraceDown.setVisible(false);
        this.btnTraceDown.setEnabled(false);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnFightBack.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
    }

    private void initData() {
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            this.tblMain.getCell(i, "isSelect").setValue((Object)Boolean.FALSE);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() == this.tblMain.getColumnIndex("isSelect")) {
            int colNum;
            int rowNum = e.getRowIndex();
            if (this.tblMain.getCell(rowNum, colNum = e.getColIndex()) == null) {
                return;
            }
            Boolean select = (Boolean)this.tblMain.getCell(rowNum, colNum).getValue();
            String currentID = null;
            String nextID = null;
            int selectStatrRow = -1;
            int selectEndRow = -1;
            if (select.booleanValue()) {
                this.tblMain.getCell(rowNum, "isSelect").setValue((Object)Boolean.FALSE);
                this.tblMain.getCell(rowNum, "entries.approveQty").setValue(this.tblMain.getCell(rowNum, "entries.qty").getValue());
                this.tblMain.getCell(rowNum, "entries.approveAmount").setValue(this.tblMain.getCell(rowNum, "entries.amount").getValue());
            } else {
                this.tblMain.getCell(rowNum, "isSelect").setValue((Object)Boolean.TRUE);
                currentID = this.tblMain.getCell(rowNum, "id").getValue().toString();
                for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                    nextID = this.tblMain.getCell(i, "id").getValue().toString();
                    if (!currentID.equals(nextID)) continue;
                    if (selectStatrRow == -1) {
                        selectStatrRow = i;
                        selectEndRow = i;
                        continue;
                    }
                    selectEndRow = i;
                }
                this.tblMain.getSelectManager().select(selectStatrRow, 0, selectEndRow, this.tblMain.getColumnCount() - 1);
            }
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelect = false;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            isSelect = this.checkIsSelected(this.tblMain, i);
            if (!isSelect) continue;
            BizEnumValueDTO entryStatus = null;
            if (this.tblMain.getCell(i, "entries.entryStatus") != null && this.tblMain.getCell(i, "entries.entryStatus").getValue() instanceof BizEnumValueDTO) {
                entryStatus = (BizEnumValueDTO)this.tblMain.getCell(i, "entries.entryStatus").getValue();
            }
            if (entryStatus != null && entryStatus.getInt() != 4 && entryStatus.getInt() != -1 && entryStatus.getInt() != 0 && entryStatus.getInt() != 1 && entryStatus.getInt() != 2 && entryStatus.getInt() != 6 && entryStatus.getInt() != 7 && entryStatus.getInt() != 12) continue;
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"1_NetOrderListUI"), new Integer(i + 1).toString()));
            SysUtil.abort();
        }
        super.actionTraceDown_actionPerformed(e);
    }

    @Override
    public void actionBatchModify_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanCollectionManager();
        Set ids = this.getCollectionManagerNetOrderEntryIDlist();
        if (ids == null || ids.size() < 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"27_NetOrderListUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ids", (Object)ids);
        String mode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(NetOrderBatchModifyUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionCollecttionManage_actionPerformed(ActionEvent e) throws Exception {
        Set ids = NetOrderHelper.getAvailableNetOrderIdSet(this.tblMain, "batchTreatment");
        if (ids == null || ids.size() < 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"28_NetOrderListUI"));
            SysUtil.abort();
        }
        ArrayList idList = new ArrayList();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            idList.add(it.next());
        }
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
        Map mutexResult = mutexServiceControl.batchRequestObjIDForUpdate(idList);
        it = idList.iterator();
        while (it.hasNext()) {
            Object result = mutexResult.get(it.next());
            if (result == null || ((Boolean)result).booleanValue()) continue;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"29_NetOrderListUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ids", (Object)ids);
        String mode = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(NetOrderCollectionManagerMainUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    private Set getCollectionManagerNetOrderEntryIDlist() {
        this.checkSelected();
        HashSet<String> ids = new HashSet<String>();
        if (this.tblMain.getSelectManager().get().getMode() == 8) {
            int allRowCount = this.tblMain.getRowCount();
            for (int i = 0; i < allRowCount; ++i) {
                IRow row = this.tblMain.getRow(i);
                BizEnumValueDTO entryStatus = null;
                if (row.getCell("entries.entryStatus") != null && row.getCell("entries.entryStatus").getValue() instanceof BizEnumValueDTO) {
                    entryStatus = (BizEnumValueDTO)row.getCell("entries.entryStatus").getValue();
                }
                if (entryStatus == null || entryStatus.getInt() != 4 && entryStatus.getInt() != 8 || row.getCell("entries.id") == null || !(row.getCell("entries.id").getValue() instanceof String)) continue;
                ids.add(row.getCell("entries.id").getValue().toString());
            }
            return ids;
        }
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            IRow row = this.tblMain.getRow(rowNum);
            BizEnumValueDTO entryStatus = null;
            if (row.getCell("entries.entryStatus") != null && row.getCell("entries.entryStatus").getValue() instanceof BizEnumValueDTO) {
                entryStatus = (BizEnumValueDTO)row.getCell("entries.entryStatus").getValue();
            }
            if (entryStatus == null || entryStatus.getInt() != 4 && entryStatus.getInt() != 8) {
                return ids;
            }
            if (row.getCell("entries.id") != null && row.getCell("entries.id").getValue() instanceof String) {
                ids.add(row.getCell("entries.id").getValue().toString());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    IRow row = this.tblMain.getRow(j);
                    BizEnumValueDTO entryStatus = null;
                    if (row.getCell("entries.entryStatus") != null && row.getCell("entries.entryStatus").getValue() instanceof BizEnumValueDTO) {
                        entryStatus = (BizEnumValueDTO)row.getCell("entries.entryStatus").getValue();
                    }
                    if (entryStatus == null || entryStatus.getInt() != 4 && entryStatus.getInt() != 8 || row.getCell("entries.id") == null || !(row.getCell("entries.id").getValue() instanceof String)) continue;
                    ids.add(row.getCell("entries.id").getValue().toString());
                }
            }
        }
        return ids;
    }

    private void checkCanCollectionManager() {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            boolean isSelect = false;
            if (row.getCell("isSelect") != null && row.getCell("isSelect").getValue() instanceof Boolean) {
                isSelect = (Boolean)row.getCell("isSelect").getValue();
            }
            if (!isSelect) continue;
            row.getCell("entries.entryStatus").getValue();
        }
    }

    @Override
    public void createToSaleOrder_actionPerformed(ActionEvent e) throws Exception {
        this.checkCondition();
        this.createToSaleOrder();
        this.refreshList();
    }

    private void createToSaleOrder() throws EASBizException, BOSException {
        int rowCount = this.tblMain.getRowCount();
        NetOrderBillEntryInfo netOrderBillEntry = null;
        NetOrderBillEntryCollection netOrderBillEntryColl = new NetOrderBillEntryCollection();
        NetOrderBillEntryCollection splitNetOrderBillEntryColl = new NetOrderBillEntryCollection();
        for (int j = 0; j < rowCount; ++j) {
            boolean isSelected = this.checkIsSelected(this.tblMain, j);
            if (!isSelected) continue;
            String saleOrgId = null;
            saleOrgId = this.tblMain.getCell(j, "saleOrgUnit.id").getValue().toString();
            netOrderBillEntry = new NetOrderBillEntryInfo();
            netOrderBillEntry = this.createEntryInfo(j, netOrderBillEntry);
            netOrderBillEntryColl.add(netOrderBillEntry);
            SCMClientUtils.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(saleOrgId), (String)"saleorder_addnew");
        }
        if (netOrderBillEntryColl != null) {
            try {
                int botpBills = NetOrderCollectionManagerFacadeFactory.getRemoteInstance().dealNetOrderBill(netOrderBillEntryColl, SysContext.getSysContext().getCurrentCtrlUnit(), splitNetOrderBillEntryColl);
                if (botpBills > 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"17_NetOrderCollectionManagerUI"));
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"30_NetOrderListUI"));
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"18_NetOrderCollectionManagerUI"));
                SysUtil.abort();
            }
            catch (BOTPException e) {
                Logger.error((Throwable)e);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"19_NetOrderCollectionManagerUI"));
                SysUtil.abort();
            }
            catch (NetOrderManagerException e) {
                Logger.error((Throwable)((Object)e));
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
            catch (BTPException e) {
                Logger.error((Throwable)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
            catch (PriceParamException e) {
                Logger.error((Throwable)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
        }
    }

    private boolean checkIsSelected(KDTable tblMain, int index) {
        boolean isSelected = false;
        if (tblMain.getSelectManager().get() != null && tblMain.getSelectManager().get().getMode() == 8) {
            isSelected = true;
            return isSelected;
        }
        KDTSelectBlock selectBlock = null;
        int size = tblMain.getSelectManager().size();
        if (size == 1 && tblMain.getSelectManager().get().getTop() == tblMain.getSelectManager().get().getBottom()) {
            int rowNum = tblMain.getSelectManager().get().getTop();
            if (rowNum == index) {
                isSelected = true;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = tblMain.getSelectManager().get(i);
                if (index < selectBlock.getTop() || index > selectBlock.getBottom()) continue;
                isSelected = true;
            }
        }
        return isSelected;
    }

    private NetOrderBillEntryInfo createEntryInfo(int rowNum, NetOrderBillEntryInfo netOrderBillEntry) {
        netOrderBillEntry.setId(BOSUuid.read((String)this.tblMain.getCell(rowNum, "entries.id").getValue().toString()));
        netOrderBillEntry.setAddress(this.tblMain.getCell(rowNum, "id").getValue().toString());
        netOrderBillEntry.setAskArriveDate((Date)this.tblMain.getCell(rowNum, "entries.askArriveDate").getValue());
        if (this.tblMain.getCell(rowNum, "entries.approveQty").getValue() != null) {
            netOrderBillEntry.setApproveQty(new BigDecimal(this.tblMain.getCell(rowNum, "entries.approveQty").getValue().toString()));
        } else {
            netOrderBillEntry.setApproveQty(SysConstant.BIGZERO);
        }
        if (this.tblMain.getCell(rowNum, "warehouse.id") != null && this.tblMain.getCell(rowNum, "warehouse.id").getValue() != null) {
            WarehouseInfo wareHouse = new WarehouseInfo();
            wareHouse.setId(BOSUuid.read((String)this.tblMain.getCell(rowNum, "warehouse.id").getValue().toString()));
            netOrderBillEntry.setWarehouse(wareHouse);
        }
        if (this.tblMain.getCell(rowNum, "storageOrgUnit.id") != null && this.tblMain.getCell(rowNum, "storageOrgUnit.id").getValue() != null) {
            StorageOrgUnitInfo storageOrg = new StorageOrgUnitInfo();
            storageOrg.setId(BOSUuid.read((String)this.tblMain.getCell(rowNum, "storageOrgUnit.id").getValue().toString()));
            netOrderBillEntry.setStorageOrgUnit(storageOrg);
        }
        return netOrderBillEntry;
    }

    private void checkCondition() throws BOSException, EASBizException {
        this.checkSelected();
        if (this.tblMain.getRowCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"22_NetOrderCollectionManagerUI"));
            SysUtil.abort();
        }
        StringBuffer warningMessger = new StringBuffer();
        BigDecimal approveQty = new BigDecimal("0.0");
        BigDecimal qty = new BigDecimal("0.0");
        warningMessger.append(EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"23_NetOrderCollectionManagerUI"));
        boolean hasSelect = false;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            boolean isSelect = false;
            isSelect = this.checkIsSelected(this.tblMain, i);
            if (!isSelect) continue;
            BizEnumValueDTO entryStatus = null;
            if (this.tblMain.getCell(i, "entries.entryStatus") != null && this.tblMain.getCell(i, "entries.entryStatus").getValue() instanceof BizEnumValueDTO) {
                entryStatus = (BizEnumValueDTO)this.tblMain.getCell(i, "entries.entryStatus").getValue();
            }
            if (entryStatus == null || entryStatus.getInt() != 8) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"31_NetOrderListUI"), new Integer(i + 1).toString()));
                SysUtil.abort();
            }
            hasSelect = true;
            approveQty = (BigDecimal)this.tblMain.getCell(i, "entries.approveQty").getValue();
            qty = (BigDecimal)this.tblMain.getCell(i, "entries.qty").getValue();
            if (approveQty != null && approveQty.compareTo(qty) == 1) {
                warningMessger.append(i + 1 + ",");
            }
            if (this.tblMain.getCell(i, "storageOrgUnit.number").getValue() != null) continue;
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"25_NetOrderCollectionManagerUI"), new Integer(i + 1).toString()));
            SysUtil.abort();
        }
        if (!hasSelect) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"32_NetOrderListUI"));
            SysUtil.abort();
        }
    }

    protected boolean hasCodingRule(IObjectValue caller, String orgId) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(caller, orgId)) {
                return true;
            }
            String companyId = this.getNextCompanyId();
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(caller, companyId);
        }
        catch (Exception err) {
            return false;
        }
    }

    protected String getNextCompanyId() throws Exception {
        CompanyOrgUnitInfo comInfo = null;
        OrgUnitInfo rootCU = NewOrgUnitHelper.getRootCU();
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        if (rootCU.isIsCompanyOrgUnit()) {
            comInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootCU.getId()));
        }
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setHiddenTableCols(new String[]{"isFightBack", "fightBackReason"});
        this.commonQueryDialog.setProcessor((IProcessor)new ChannelCommonQueryProcessor());
        this.commonQueryDialog.setWidth(490);
        return this.commonQueryDialog;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    @Override
    public void actionFightBack_actionPerformed(ActionEvent e) throws Exception {
        Object reasonCodeInfo;
        Set netorderIDSet = NetOrderHelper.getAvailableNetOrderIdSet(this.tblMain, "fightback");
        if (netorderIDSet.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"16_NetOrderListUI"));
            SysUtil.abort();
        }
        if ((reasonCodeInfo = NetOrderHelper.showReasonWindow(netorderIDSet, (ListUI)this)) == null) {
            SysUtil.abort();
        }
        NetOrderHelper.doFightBack(netorderIDSet, reasonCodeInfo, (ListUI)this);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return NetOrderBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new NetOrderCollectionManagerConditionPanelUI();
        }
        return this.filterUI;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new NetOrderCollectionManagerConditionPanelUI();
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private FilterInfo getPremissionFilterByMainOrg() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.listSaleOrg == null && this.iBiz == null) {
            try {
                this.listSaleOrg = new LinkedHashSet();
                this.iBiz = NetOrderBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                this.authorizedMainOrgs = this.iBiz.getAuthOrgsByType(this.getMainBizOrgType(), this.mainQueryPK);
                for (int i = 0; i < this.authorizedMainOrgs.size(); ++i) {
                    this.listSaleOrg.add(this.authorizedMainOrgs.get(i).getId().toString());
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
        }
        if (this.listSaleOrg == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.sd.channel.client.CHANNELCLIENTAutoGenerateResource", (String)"0_ChannelInwarehsBillListUI"));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)this.listSaleOrg, CompareType.INCLUDE));
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo defaultFilterInfo = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = this.getPremissionFilterByMainOrg();
        FilterInfo aFilterInfo = new FilterInfo();
        aFilterInfo.getFilterItems().add(new FilterItemInfo("entries.entryStatus", (Object)new Integer(4)));
        aFilterInfo.getFilterItems().add(new FilterItemInfo("entries.entryStatus", (Object)new Integer(8)));
        aFilterInfo.setMaskString("#0 OR #1");
        if (defaultFilterInfo != null) {
            try {
                defaultFilterInfo.mergeFilter(filterInfo, "and");
                defaultFilterInfo.mergeFilter(aFilterInfo, "and");
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        } else {
            defaultFilterInfo = filterInfo;
            try {
                defaultFilterInfo.mergeFilter(aFilterInfo, "and");
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
        return defaultFilterInfo;
    }

    public String[] getMergeColumnKeys() {
        String[] mergeColumnKeys = new String[]{"id", "isSelect", "number", "saleOrgUnit.number", "saleOrgUnit.name", "companyOrgUnit.name", "channel.name", "customer.name", "bizDate", "askArriveDate", "billStatus", "currency.name", "exchangeRate", "remark", "createTime", "modificationTime", "auditTime", "creator.name", "modifier.name", "fightBackReason", "aduitor.name"};
        return mergeColumnKeys;
    }

    @Override
    public void ationSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "isSelect").setValue((Object)Boolean.TRUE);
            this.tblMain.getSelectManager().select(0, 0, this.tblMain.getRowCount() - 1, this.tblMain.getColumnCount() - 1);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "isSelect").setValue((Object)Boolean.FALSE);
            this.tblMain.getSelectManager().select(0, 0, 0, this.tblMain.getColumnCount() - 1);
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

