/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.basedata.scm.sd.channel.client.ChannelClientUtil;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sd.channel.report.ChannelTotalGropEnum;
import com.kingdee.eas.scm.sd.channel.report.client.AbstractChannelInWarehouseTotalConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class ChannelInWarehouseTotalConditionUI
extends AbstractChannelInWarehouseTotalConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(ChannelInWarehouseTotalConditionUI.class);
    private static SCMRptMultiOrgsF7 SaleMultiOrgsF7;
    private static final String ResClassName = "com.kingdee.eas.scm.sd.channel.report.ChannelRPTResource";
    private static final String SDResClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";

    public ChannelInWarehouseTotalConditionUI() throws Exception {
        this.datePickerStart.setRequired(true);
        this.datePickerEnd.setRequired(true);
        this.isReport = true;
        String tempResClassName = SDResClassName;
        String OrgUnitMutilF7 = EASResource.getString((String)tempResClassName, (String)"saleOrgUnitMutilF7");
        SaleMultiOrgsF7 = new SCMRptMultiOrgsF7(this.prmtCompany, OrgType.Sale, OrgUnitMutilF7);
        SaleMultiOrgsF7.setPermItemName(this.getViewPermission());
        SaleMultiOrgsF7.setUseCache(true);
        SaleMultiOrgsF7.setNeedWait4UIOpen(false);
        this.setBizMaterialF7(this.prmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.datePickerStart);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.datePickerEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullOrgUnit", SaleMultiOrgsF7, this.prmtCompany);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)ResClassName, (String)"SaleOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        element = new SingleFilterElement("ChannelFrom", (Component)this.prmtChannelFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("ChannelTo", (Component)this.prmtChannelTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialFrom", (Component)this.prmtMaterialFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("kdcTotalGroupBy", (Component)this.comGroupBy);
        element.setDefaultValue((Object)ChannelTotalGropEnum.channelPlusMaterial);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtCompany, this.prmtChannelFrom, this.prmtChannelTo, this.prmtMaterialFrom, this.prmtMaterialTo});
        this.setIsSupportMultiOrgs(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        SCMQueryFormat.formatStartTime((KDDatePicker)this.datePickerStart);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.datePickerEnd);
        this.prmtChannelFrom.setValue(null);
        this.prmtChannelTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
    }

    public boolean verify() {
        Object[] purchaseOrg;
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.datePickerStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.datePickerEnd.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SDResClassName, (String)"STARTDATE_NOT_NULL"));
            this.datePickerStart.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SDResClassName, (String)"END_DATE_NULL"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SDResClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SDResClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (this.prmtCompany.getValue() == null || ((Object[])this.prmtCompany.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SDResClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtCompany.getValue()).length == 1 && ((purchaseOrg = (Object[])this.prmtCompany.getValue())[0] == null || purchaseOrg[0].toString().length() == 0)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SDResClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        return true;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected String getViewPermission() {
        String viewPermission = "channelInWarehouseTotal_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    public static boolean checkSameCurrency(Object[] infos) {
        Object currCom = null;
        Object firstCur = null;
        Object firstOrg = null;
        return true;
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
        StringBuffer orgIDs = new StringBuffer();
        Object[] org = (Object[])SaleMultiOrgsF7.getFullData();
        int n = org.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                orgIDs.append(",");
            }
            String fid = ((FullOrgUnitInfo)org[i]).get("id").toString();
            orgIDs.append(fid);
        }
        if (orgIDs == null) {
            ids = "''";
        }
        ChannelClientUtil.getChannelAndTerminalF7ForReport((KDBizPromptBox)this.prmtChannelFrom);
        ChannelClientUtil.getChannelAndTerminalF7ForReport((KDBizPromptBox)this.prmtChannelTo);
        this.prmtChannelFrom.setDisplayFormat("$number$");
        this.prmtChannelTo.setDisplayFormat("$number$");
        EntityViewInfo channelViewInfo = new EntityViewInfo();
        FilterInfo channelFilterInfo = new FilterInfo();
        channelFilterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)orgIDs.toString(), CompareType.INCLUDE));
        channelFilterInfo.getFilterItems().add(new FilterItemInfo("terminalSaleOrgUnit.id", (Object)orgIDs.toString(), CompareType.INCLUDE));
        channelFilterInfo.setMaskString("#0 or #1");
        channelViewInfo.setFilter(channelFilterInfo);
        this.prmtChannelFrom.setEntityViewInfo(channelViewInfo);
        this.prmtChannelTo.setEntityViewInfo(channelViewInfo);
    }
}

