/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.customize.storeage.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.inv.ws.ImportException;
import com.kingdee.eas.scm.im.inv.ws.util.CommonInfoUtil;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSUtil {
    public static ICoreBase getRemoteInstance(String bosType) {
        ICoreBase iCoreBase = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo eo = loader.getEntity(new BOSObjectType(bosType));
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getRemoteInstance", new Class[0]);
            iCoreBase = (ICoreBase)mtd.invoke(cls, (Object[])new Class[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return iCoreBase;
    }

    public static ICoreBase getLocalInstance(String bosType, Context ctx) {
        ICoreBase iCoreBase = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(new BOSObjectType(bosType));
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return iCoreBase;
    }

    public static ICoreBase getLocalInstance(Context ctx, EntityObjectInfo eo) {
        ICoreBase iCoreBase = null;
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return iCoreBase;
    }

    public static CoreBaseInfo getLinkPropCoreBaseInfo(Context ctx, CoreBaseInfo info, String linkProperty, String number, String cuId) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(info.getBOSType());
        LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)eo.getPropertyByName(linkProperty);
        EntityObjectInfo superEntityObjectInfo = null;
        ICoreBase iLinkCoreBase = null;
        CoreBaseInfo linkInfo = null;
        if (linkPropertyInfo != null && number != null) {
            superEntityObjectInfo = linkPropertyInfo.getRelationship().getSupplierObject();
            iLinkCoreBase = WSUtil.getLocalInstance(ctx, superEntityObjectInfo);
            linkInfo = cuId != null && cuId.trim().length() > 0 ? WSUtil.getCoreBaseInfo(iLinkCoreBase, number, cuId) : WSUtil.getCoreBaseInfo(iLinkCoreBase, number);
        }
        return linkInfo;
    }

    public static CoreBaseInfo getLinkPropCoreBaseInfo(Context ctx, CoreBaseInfo info, String linkProperty, String number) throws BOSException {
        return WSUtil.getLinkPropCoreBaseInfo(ctx, info, linkProperty, number, null);
    }

    public static CoreBaseInfo getCoreBaseInfo(Context ctx, String bosType, BOSUuid uuid) throws BOSException, EASBizException {
        ICoreBase iDataBase = null;
        iDataBase = ctx == null ? WSUtil.getRemoteInstance(bosType) : WSUtil.getLocalInstance(bosType, ctx);
        return iDataBase.getValue((IObjectPK)new ObjectUuidPK(uuid));
    }

    public static CoreBaseInfo getCoreBaseInfo(Context ctx, String bosType, String number) throws BOSException, EASBizException {
        ICoreBase iDataBase = null;
        iDataBase = ctx == null ? WSUtil.getRemoteInstance(bosType) : WSUtil.getLocalInstance(bosType, ctx);
        return WSUtil.getCoreBaseInfo(iDataBase, number);
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, String number) throws BOSException {
        String[] fields = new String[]{"number"};
        String[] values = new String[]{number};
        EntityViewInfo view = WSUtil.getEntityViewInfo(fields, values, false);
        return WSUtil.getCoreBaseInfo(iDataBase, view);
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, String number, String cuId) throws BOSException {
        if (cuId == null || cuId.trim().length() == 0) {
            return WSUtil.getCoreBaseInfo(iDataBase, number);
        }
        String[] fields = new String[]{"number", "CU"};
        String[] values = new String[]{number, cuId};
        EntityViewInfo view = WSUtil.getEntityViewInfo(fields, values, false);
        return WSUtil.getCoreBaseInfo(iDataBase, view);
    }

    public static EntityViewInfo getEntityViewInfo(String[] fields, String[] fieldsValue, boolean isAllField) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        if (fields != null && fieldsValue != null && fields.length >= fieldsValue.length) {
            if (isAllField) {
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("entry.*"));
            } else {
                for (int i = 0; i < fields.length; ++i) {
                    sic.add(new SelectorItemInfo(fields[i]));
                }
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            for (int j = 0; j < fields.length && j < fieldsValue.length; ++j) {
                fic.add(new FilterItemInfo(fields[j], (Object)fieldsValue[j].trim(), CompareType.EQUALS));
            }
            view.setFilter(filter);
        } else {
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("entry.*"));
        }
        return view;
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, EntityViewInfo view) throws BOSException {
        CoreBaseCollection coreBaseCollection;
        CoreBaseInfo coreBaseInfo = null;
        if (iDataBase != null && (coreBaseCollection = iDataBase.getCollection(view)) != null) {
            coreBaseInfo = coreBaseCollection.get(0);
        }
        return coreBaseInfo;
    }

    public static MaterialInfo getMaterialInfo(Context ctx, String pid) throws BOSException, EASBizException {
        MaterialInfo maiterInfo = null;
        if (pid != null) {
            IMaterial iMaterial = ctx != null ? MaterialFactory.getLocalInstance((Context)ctx) : MaterialFactory.getRemoteInstance();
            maiterInfo = (MaterialInfo)iMaterial.getValue((IObjectPK)new ObjectUuidPK(pid));
        }
        return maiterInfo;
    }

    public static CoreBaseCollection getCoreBaseCollection(ICoreBase iDataBase, EntityViewInfo view) throws BOSException {
        if (iDataBase != null) {
            return iDataBase.getCollection(view);
        }
        return null;
    }

    public static String convertDateToStr(Date date, String parttern) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(parttern);
            return dateFormat.format(date);
        }
        return null;
    }

    public static HashMap getBillHeadPropMap(Document doc, String[] headExtendProps) {
        if (doc == null) {
            return null;
        }
        NodeList childs = doc.getElementsByTagName("billHead");
        HashMap<String, String> billHeadMap = new HashMap<String, String>();
        if (headExtendProps == null || headExtendProps.length == 0) {
            return billHeadMap;
        }
        String value = null;
        if (childs != null && childs.getLength() > 0) {
            for (int i = 0; i < childs.getLength(); ++i) {
                Node subChild = childs.item(i);
                if (subChild.getNodeType() != 1) continue;
                Element subElement = (Element)subChild;
                for (int j = 0; j < headExtendProps.length; ++j) {
                    Node contentNode;
                    NodeList subChilds = subElement.getElementsByTagName(headExtendProps[j]);
                    if (subChilds == null || subChilds.getLength() <= 0 || (contentNode = subChilds.item(0).getFirstChild()) == null) continue;
                    value = contentNode.getNodeValue();
                    String string = value = value == null ? null : value.trim();
                    if (value == null) continue;
                    billHeadMap.put(headExtendProps[j], value);
                }
                break;
            }
        }
        return billHeadMap;
    }

    public static ArrayList getBillEntries(Document doc, String[] entryExtendProps) throws TransformerException {
        if (doc == null) {
            return null;
        }
        NodeList subChilds = XMLUtil.getNodeListFromXpath((Node)doc, (String)"//billEntries/entry");
        ArrayList entries = new ArrayList();
        HashMap<String, String> entryMap = null;
        String value = null;
        if (entryExtendProps == null || entryExtendProps.length == 0) {
            return entries;
        }
        for (int i = 0; subChilds != null && i < subChilds.getLength(); ++i) {
            if (subChilds.item(i).getNodeType() != 1) continue;
            entryMap = new HashMap<String, String>();
            Element entryElement = (Element)subChilds.item(i);
            if (entryElement != null) {
                for (int m = 0; m < entryExtendProps.length; ++m) {
                    Node textNode;
                    Node subChild;
                    NodeList entryChildList = entryElement.getElementsByTagName(entryExtendProps[m]);
                    if (entryChildList == null || entryChildList.getLength() <= 0 || (subChild = entryChildList.item(0)) == null || subChild.getNodeType() != 1 || (textNode = XMLUtil.getChildTextNode((Node)subChild)) == null) continue;
                    value = textNode.getNodeValue();
                    String string = value = value == null ? null : value.trim();
                    if (value == null) continue;
                    entryMap.put(subChild.getNodeName(), value);
                }
            }
            entries.add(entryMap);
        }
        return entries;
    }

    public static void setStrProperties(CoreBaseInfo info, HashMap billHeadMap, String[] strProperties) {
        for (int i = 0; i < strProperties.length; ++i) {
            info.setString(strProperties[i], (String)billHeadMap.get(strProperties[i]));
        }
    }

    public static void setIntProperties(CoreBaseInfo info, HashMap billHeadMap, String[] intProperties) throws ImportException {
        String propertyName = null;
        try {
            int value = 0;
            for (int i = 0; i < intProperties.length; ++i) {
                propertyName = intProperties[i];
                value = billHeadMap.get(propertyName) != null ? Integer.parseInt((String)billHeadMap.get(propertyName)) : 0;
                info.setInt(propertyName, value);
            }
        }
        catch (Exception e) {
            NumericExceptionSubItem numberExc = new NumericExceptionSubItem(propertyName, e.getMessage());
            throw new ImportException(numberExc);
        }
    }

    public static void setLinkProperties(Context ctx, CoreBaseInfo info, HashMap billHeadMap, String cuNumber, String[] linkProperties, String[] isNoCuFilterProperties) throws ImportException {
        String propertyName = null;
        CoreBaseInfo linkBaseInfo = null;
        try {
            for (int i = 0; i < linkProperties.length; ++i) {
                propertyName = linkProperties[i];
                linkBaseInfo = WSUtil.isNoCuFilterProperties(propertyName, isNoCuFilterProperties) ? CommonInfoUtil.getLinkPropCoreBaseInfo((Context)ctx, (CoreBaseInfo)info, (String)propertyName, (String)((String)billHeadMap.get(propertyName)), null) : CommonInfoUtil.getLinkPropCoreBaseInfo((Context)ctx, (CoreBaseInfo)info, (String)propertyName, (String)((String)billHeadMap.get(propertyName)), (String)cuNumber);
                info.put(propertyName, (Object)linkBaseInfo);
            }
        }
        catch (Exception e) {
            NumericExceptionSubItem numberExc = new NumericExceptionSubItem(propertyName, e.getMessage());
            throw new ImportException(numberExc);
        }
    }

    public static void setDeciamlProperties(CoreBaseInfo info, HashMap billHeadMap, String[] decimalProperties) throws ImportException {
        String propertyName = null;
        try {
            BigDecimal value = null;
            for (int i = 0; i < decimalProperties.length; ++i) {
                propertyName = decimalProperties[i];
                value = billHeadMap.get(propertyName) != null ? new BigDecimal((String)billHeadMap.get(propertyName)) : new BigDecimal("0");
                info.setBigDecimal(propertyName, value);
            }
        }
        catch (Exception e) {
            NumericExceptionSubItem numberExc = new NumericExceptionSubItem(propertyName, e.getMessage());
            throw new ImportException(numberExc);
        }
    }

    public void setBooleanProperties(CoreBaseInfo info, HashMap billHeadMap, String[] booleanProperties) throws ImportException {
        String propertyName = null;
        try {
            boolean boolValue = false;
            String propValue = null;
            for (int i = 0; i < booleanProperties.length; ++i) {
                propertyName = booleanProperties[i];
                propValue = (String)billHeadMap.get(propertyName);
                boolValue = propValue != null && (propValue.equals("1") || propValue.equals("true"));
                info.setBoolean(propertyName, boolValue);
            }
        }
        catch (Exception e) {
            NumericExceptionSubItem numberExc = new NumericExceptionSubItem(propertyName, e.getMessage());
            throw new ImportException(numberExc);
        }
    }

    public static void seTimeStampProperties(CoreBaseInfo info, HashMap billHeadMap, String[] stampProperties) throws EASBizException {
        String propertyName = null;
        Timestamp timeStamp = null;
        try {
            for (int i = 0; i < stampProperties.length; ++i) {
                propertyName = stampProperties[i];
                timeStamp = CommonInfoUtil.getTimeStampFromStr((String)((String)billHeadMap.get(propertyName)));
                info.setTimestamp(propertyName, timeStamp);
            }
        }
        catch (Exception e) {
            NumericExceptionSubItem numberExc = new NumericExceptionSubItem(propertyName, e.getMessage());
            throw new ImportException(numberExc);
        }
    }

    public void setDateProperties(CoreBaseInfo info, HashMap billHeadMap, String[] dateProperties) throws ImportException {
        String propertyName = null;
        Date date = null;
        try {
            for (int i = 0; i < dateProperties.length; ++i) {
                propertyName = dateProperties[i];
                date = CommonInfoUtil.convertStrToDate((String)((String)billHeadMap.get(propertyName)), (String)"yyyy-MM-dd");
                info.setDate(propertyName, date);
            }
        }
        catch (Exception e) {
            NumericExceptionSubItem numberExc = new NumericExceptionSubItem(propertyName, e.getMessage());
            throw new ImportException(numberExc);
        }
    }

    private static boolean isNoCuFilterProperties(String propertyName, String[] isNoCuFilterProperties) {
        if (isNoCuFilterProperties == null) {
            return false;
        }
        for (int i = 0; i < isNoCuFilterProperties.length; ++i) {
            if (!isNoCuFilterProperties[i].equals(propertyName)) continue;
            return true;
        }
        return false;
    }
}

