/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractSelectQueryFieldUI;
import com.kingdee.eas.scm.framework.util.FindTreeNodeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BalanceFieldSelectUI
extends AbstractSelectQueryFieldUI {
    private static final long serialVersionUID = 1L;
    private boolean isCancel = true;
    private Object fieldValue;
    private BalanceModelInfo balanceModel;
    private List<BizDataTypeEnum> bizTypefilter;

    public BalanceFieldSelectUI() throws Exception {
        this.toolBar.setVisible(false);
        this.btnOK.setEnabled(false);
        this.btnCancel.setEnabled(true);
        this.treeQueryTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BalanceFieldSelectUI.this.tree_Changed(e);
            }
        });
        FindTreeNodeUtil util = new FindTreeNodeUtil(this.treeQueryTable);
        this.txtFind = util.getFindNextTxt();
        this.btnFind = util.getFindNextBtn();
        this.btnFind.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnFind.setToolTipText(EASResource.getString((String)"com.kingdee.eas.scm.barcode.BARCODEAutoGenerateResource", (String)"196_SelectEntityUI"));
    }

    protected void tree_Changed(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeQueryTable.getLastSelectedPathComponent();
        if (treeNode == null || !treeNode.isLeaf()) {
            return;
        }
        this.btnOK.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.balanceModel = (BalanceModelInfo)this.getUIContext().get("BalanceModel");
        this.bizTypefilter = (List)this.getUIContext().get("BizTypeFilter");
        this.initBalanceFieldTree();
    }

    private void initBalanceFieldTree() {
        DefaultKingdeeTreeNode root = this.getBalanceRoot();
        if (root == null) {
            this.treeQueryTable.setModel(null);
        } else {
            this.treeQueryTable.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
            this.treeQueryTable.expandOnLevel(1);
            this.treeQueryTable.setToggleClickCount(1);
        }
    }

    public DefaultKingdeeTreeNode getBalanceRoot() {
        if (this.balanceModel == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(this.balanceModel.getName());
        BalanceFieldModelCollection coll = this.balanceModel.getEntry();
        BalanceFieldModelInfo field = null;
        coll.sort("seq");
        for (int i = 0; i < coll.size(); ++i) {
            field = coll.get(i);
            if (!this.isMatchBizType(field)) continue;
            DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)field);
            treeNode.setText(field.getAlias());
            root.add((MutableTreeNode)treeNode);
        }
        return root;
    }

    private boolean isMatchBizType(BalanceFieldModelInfo field) {
        if (this.bizTypefilter == null) {
            return true;
        }
        return this.bizTypefilter.indexOf((Object)field.getBizDataType()) > -1;
    }

    @Override
    protected void treeQueryTable_mouseClicked(MouseEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeQueryTable.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && treeNode != null && treeNode.isLeaf()) {
            this.getSelectField();
            this.isCancel = false;
            this.disposeUIWindow();
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectField();
        this.isCancel = false;
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        return this.fieldValue;
    }

    private void getSelectField() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeQueryTable.getLastSelectedPathComponent();
        Object nodeObject = treeNode.getUserObject();
        if (!(nodeObject instanceof BalanceFieldModelInfo)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"94_BalanceFieldSelectUI"));
            SysUtil.abort();
        }
        this.fieldValue = treeNode.getUserObject();
    }
}

