/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractBalanceFormulaUI;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;

public class BalanceFormulaUI
extends AbstractBalanceFormulaUI {
    private static final long serialVersionUID = 1L;
    private boolean isCancel = true;
    private HashMap hash = new HashMap();
    private String expression = "";
    private String alias = "";
    private BalanceModelInfo balanceModel;
    private BalanceFieldModelInfo formulaField;

    public BalanceFormulaUI() throws Exception {
        this.kDListElement.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BalanceFormulaUI.this.kDListElement_mouseClicked(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        this.formulaField = (BalanceFieldModelInfo)this.getUIContext().get("BalanceField");
        this.balanceModel = (BalanceModelInfo)this.getUIContext().get("BalanceModel");
        this.innerLoadFields();
    }

    private void innerLoadFields() {
        if (this.balanceModel == null || this.formulaField == null) {
            return;
        }
        BalanceFieldModelCollection coll = this.balanceModel.getEntry();
        DataTypeEnum[] dataTypeArray = new DataTypeEnum[]{DataTypeEnum.Amount, DataTypeEnum.Price, DataTypeEnum.Qty};
        List dataTypeList = Arrays.asList((Object[])dataTypeArray);
        DataTypeEnum dateType = this.formulaField.getDataType();
        int m = coll.size();
        for (int i = 0; i < m; ++i) {
            BalanceFieldModelInfo fieldInfo = coll.get(i);
            if (!fieldInfo.getDataType().equals((Object)dateType) && (!dataTypeList.contains((Object)dateType) || !dataTypeList.contains((Object)fieldInfo.getDataType()))) continue;
            this.hash.put(fieldInfo.getAlias(), fieldInfo);
            this.kDListElement.addElement((Object)new FieldElement(fieldInfo));
        }
        this.hash.put(this.formulaField.getAlias(), this.formulaField);
        String formulaAlias = "";
        if (StringUtil.isEmpty((String)this.formulaField.getCalExpression())) {
            formulaAlias = this.formulaField.getAlias() + " = ";
            this.expression = "formula_result =";
        } else {
            this.expression = this.formulaField.getCalExpression();
            formulaAlias = this.alias = this.formulaField.getCalExpressionAlias();
        }
        this.txtExpression.setText(formulaAlias);
    }

    private void setIcon() {
        this.btnPlus.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMultiply.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivide.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if ("formula_result =".equals(this.expression)) {
            this.alias = null;
            this.expression = null;
        } else {
            boolean result;
            this.alias = this.txtExpression.getText();
            if (this.alias.trim().endsWith("=")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"VcFormulaNotValid"));
                SysUtil.abort();
            }
            if (!(result = this.checkFormular(this.alias.substring(this.alias.indexOf("=") + 1)))) {
                SysUtil.abort();
            }
        }
        this.formulaField.setCalExpression(this.expression);
        this.formulaField.setCalExpressionAlias(this.alias);
        this.isCancel = false;
        this.getUIWindow().close();
    }

    private boolean checkFormular(String formula) {
        FormularParser parser = new FormularParser();
        try {
            parser.setStringSupported(true);
            parser.parse(formula);
            return true;
        }
        catch (StringParsingException e) {
            MsgBox.showError((String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"95_BalanceFormulaUI", (String[])new String[]{e.getMessage()}));
            return false;
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    protected void kDListElement_mouseClicked(MouseEvent e) {
        FieldElement element;
        if (e.getClickCount() == 2 && (element = (FieldElement)this.kDListElement.getSelectedValue()) != null) {
            this.addAField(element);
        }
    }

    @Override
    public void actionPlus_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("+");
    }

    @Override
    public void actionMinus_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("-");
    }

    @Override
    public void actionMultiply_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("*");
    }

    @Override
    public void actionDivide_actionPerformed(ActionEvent e) throws Exception {
        this.addAWord("/");
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtExpression.setText(this.formulaField.getAlias() + " =");
        this.expression = "formula_result =";
    }

    private void addAWord(String word) {
        String formula = this.txtExpression.getText();
        if (StringUtil.isEmpty((String)formula)) {
            formula = this.formulaField.getAlias() + " =";
            this.expression = "formula_result =";
        }
        formula = formula + " " + word;
        this.expression = this.expression + " " + word;
        this.txtExpression.setText(formula);
    }

    private void addAField(FieldElement element) {
        String formula = this.txtExpression.getText();
        if (StringUtil.isEmpty((String)formula)) {
            formula = this.formulaField.getAlias() + " =";
            this.expression = "formula_result =";
        }
        formula = formula + " " + element.toString();
        this.expression = this.expression + " " + element.getFieldID();
        this.txtExpression.setText(formula);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        return this.alias;
    }

    private class FieldElement {
        BalanceFieldModelInfo field;

        FieldElement(BalanceFieldModelInfo field) {
            this.field = field;
        }

        public String toString() {
            return this.field.getAlias();
        }

        public String getFieldID() {
            return "\"" + this.field.getId().toString() + "\"";
        }
    }
}

