/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.TableIndexManageFacadeFactory;
import com.kingdee.eas.scm.framework.balance.client.AbstractBalanceIndexManageUI;
import com.kingdee.eas.scm.framework.balance.client.CreateIndexUI;
import com.kingdee.eas.scm.framework.model.TableIndexInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;

public class BalanceIndexManageUI
extends AbstractBalanceIndexManageUI {
    private static final long serialVersionUID = 1L;
    private static final String COL_NAME = "indexName";
    private static final String COL_ISUNIQUE = "isUnique";
    private static final String COL_COLUMNS = "indexColumns";
    private BalanceModelInfo balanceModel;

    public void onLoad() throws Exception {
        this.balanceModel = (BalanceModelInfo)this.getUIContext().get("BalanceModel");
        super.onLoad();
        this.loadIndexes();
    }

    private void loadIndexes() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.removeRows();
        List indexList = TableIndexManageFacadeFactory.getRemoteInstance().getIndexes(this.balanceModel.getTabName());
        TableIndexInfo indexInfo = null;
        for (int i = 0; i < indexList.size(); ++i) {
            indexInfo = (TableIndexInfo)indexList.get(i);
            this.addRow(indexInfo);
        }
    }

    private void addRow(TableIndexInfo indexInfo) {
        if (indexInfo == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.getCell(COL_NAME).setValue((Object)indexInfo.getIndexName());
        row.getCell(COL_ISUNIQUE).setValue((Object)indexInfo.isUnique());
        row.getCell(COL_COLUMNS).setValue((Object)indexInfo.getColumnsString());
        row.setUserObject((Object)indexInfo);
    }

    @Override
    public void actionNewIndex_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("BalanceModel", this.balanceModel);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CreateIndexUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        CreateIndexUI createUI = (CreateIndexUI)uiWindow.getUIObject();
        if (!createUI.isCancel()) {
            TableIndexInfo indexInfo = createUI.getData();
            this.addRow(indexInfo);
        }
    }

    @Override
    public void actionDelIndex_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmRemove()) {
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
            TableIndexInfo indexInfo = (TableIndexInfo)row.getUserObject();
            TableIndexManageFacadeFactory.getRemoteInstance().deleteIndex(indexInfo.getTableName(), indexInfo.getIndexName());
            this.getDetailTable().removeRow(row.getRowIndex());
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void actionRebuild_actionPerformed(ActionEvent e) throws Exception {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        TableIndexInfo indexInfo = (TableIndexInfo)row.getUserObject();
        TableIndexManageFacadeFactory.getRemoteInstance().rebuildIndex(indexInfo.getTableName(), indexInfo.getIndexName());
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"96_BalanceIndexManageUI"));
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

