/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.IBalanceModel;
import com.kingdee.eas.scm.framework.balance.client.AbstractBalanceModelEditUI;
import com.kingdee.eas.scm.framework.balance.client.BalanceFieldModelEditUI;
import com.kingdee.eas.scm.framework.balance.client.BalanceIndexManageUI;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

public class BalanceModelEditUI
extends AbstractBalanceModelEditUI {
    private static final long serialVersionUID = 1L;
    private static final String COL_ID = "id";
    private static final String COL_SEQ = "seq";
    private static final String COL_FIELDNAME = "fieldName";
    private static final String COL_FIELDALIAS = "fieldAlias";
    private static final String COL_DATATYPE = "dataType";
    private static final String COL_BIZDATATYPE = "bizDataType";
    private static final String COL_LENGHT = "length";
    private static final String COL_DEFAULTVALUE = "defaultValue";
    private static final String COL_ISNULLABLE = "isNullable";
    private static final String COL_BASEDATAALIAS = "baseDataAlias";
    private static final String COL_ISSCHEDULED = "isScheduled";
    private static final String COL_CALEXPRESSIONALIAS = "calExpressionAlias";

    public BalanceModelEditUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (("ADDNEW".equals(BalanceModelEditUI.this.getOprtState()) || "EDIT".equals(BalanceModelEditUI.this.getOprtState())) && e.getClickCount() == 2) {
                    BalanceModelEditUI.this.doEditField();
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.innerLoadFields();
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        super.onLoad();
    }

    private void innerLoadFields() {
        this.tblMain.removeRows();
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.editData.getEntry();
        coll.sort(COL_SEQ);
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            this.appendNewLine(fieldInfo);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        this.editData = (BalanceModelInfo)ov;
        super.setDataObject(ov);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()) && !UseStatusEnum.ACTIVE.equals((Object)this.editData.getState())) {
            this.btnAddLine.setEnabled(true);
            this.btnEditLine.setEnabled(true);
            this.btnDeleteLine.setEnabled(true);
        } else {
            this.btnAddLine.setEnabled(false);
            this.btnEditLine.setEnabled(false);
            this.btnDeleteLine.setEnabled(false);
        }
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        if ("ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()) && UseStatusEnum.SAVED.equals((Object)this.editData.getState())) {
            this.txtNumber.setEnabled(true);
            this.cmbBalanceType.setEnabled(true);
            this.txtTabName.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
            this.cmbBalanceType.setEnabled(false);
            this.txtTabName.setEnabled(false);
        }
        if (UseStatusEnum.SAVED.equals((Object)this.editData.getState())) {
            this.btnIndexMge.setEnabled(false);
            this.menuItemAddIndex.setEnabled(false);
        } else {
            this.btnIndexMge.setEnabled(true);
            this.menuItemAddIndex.setEnabled(true);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String message = null;
        IBalanceModel iFactory = (IBalanceModel)this.getBizInterface();
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iFactory.checkNumberDup(this.editData);
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setName(this.txtName.getEditor().getItem().toString().trim());
            this.txtName.requestFocus();
            iFactory.checkNameDup(this.editData);
        }
        if (StringUtil.isEmpty((String)this.txtTabName.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"97_BalanceModelEditUI"));
            this.txtTabName.requestFocus();
            SysUtil.abort();
        }
        if (this.cmbBalanceType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"98_BalanceModelEditUI"));
            this.cmbBalanceType.requestFocus();
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        BalanceModelInfo info = new BalanceModelInfo();
        info.setBalanceType(BalanceTypeEnum.Period);
        info.setState(UseStatusEnum.SAVED);
        BalanceFieldModelInfo fieldInfo = (BalanceFieldModelInfo)this.createNewDetailData();
        fieldInfo.setName("ID");
        fieldInfo.setAlias(EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"99_BalanceModelEditUI"));
        fieldInfo.setSeq(1);
        fieldInfo.setDataType(DataTypeEnum.BOSUuid);
        fieldInfo.setBizDataType(BizDataTypeEnum.PrimaryKey);
        fieldInfo.setIsNullable(false);
        fieldInfo.setIsScheduled(true);
        fieldInfo.setParent(info);
        info.getEntry().add(fieldInfo);
        return info;
    }

    protected IObjectValue createNewDetailData() {
        BalanceFieldModelInfo info = new BalanceFieldModelInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        if (this.editData != null) {
            info.setSeq(this.editData.getEntry().size() + 1);
            info.setName("Field" + info.getSeq());
        }
        info.setIsNullable(true);
        if (this.editData != null && this.editData.getState().equals((Object)UseStatusEnum.SAVED)) {
            info.setIsScheduled(true);
        } else {
            info.setIsScheduled(false);
        }
        info.setParent(this.editData);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BalanceModelFactory.getRemoteInstance();
    }

    private String getFieldModelEditUI() {
        return "com.kingdee.eas.scm.framework.balance.client.BalanceFieldModelEditUI";
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.name"));
        sic.add(new SelectorItemInfo("entry.alias"));
        sic.add(new SelectorItemInfo("entry.dataType"));
        sic.add(new SelectorItemInfo("entry.bizDataType"));
        sic.add(new SelectorItemInfo("entry.length"));
        sic.add(new SelectorItemInfo("entry.isNullable"));
        sic.add(new SelectorItemInfo("entry.defaultValue"));
        sic.add(new SelectorItemInfo("entry.calExpression"));
        sic.add(new SelectorItemInfo("entry.calExpressionAlias"));
        sic.add(new SelectorItemInfo("entry.isScheduled"));
        sic.add(new SelectorItemInfo("entry.baseDataBOSType"));
        sic.add(new SelectorItemInfo("entry.baseDataAlias"));
        sic.add(new SelectorItemInfo("entry.isSPvisible"));
        return sic;
    }

    private void appendNewLine(BalanceFieldModelInfo fieldInfo) {
        if (fieldInfo == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        this.updateLineData(fieldInfo, row);
    }

    private void updateLineData(BalanceFieldModelInfo fieldInfo, IRow row) {
        if (fieldInfo == null || row == null) {
            return;
        }
        row.getCell(COL_ID).setValue((Object)fieldInfo.getId());
        row.getCell(COL_SEQ).setValue((Object)fieldInfo.getSeq());
        row.getCell(COL_FIELDNAME).setValue((Object)fieldInfo.getName());
        row.getCell(COL_FIELDALIAS).setValue((Object)fieldInfo.getAlias());
        row.getCell(COL_DATATYPE).setValue((Object)fieldInfo.getDataType());
        row.getCell(COL_BIZDATATYPE).setValue((Object)fieldInfo.getBizDataType());
        row.getCell(COL_LENGHT).setValue(fieldInfo.getLength() == 0 ? null : Integer.valueOf(fieldInfo.getLength()));
        row.getCell(COL_DEFAULTVALUE).setValue((Object)fieldInfo.getDefaultValue());
        row.getCell(COL_ISNULLABLE).setValue((Object)fieldInfo.isIsNullable());
        row.getCell(COL_BASEDATAALIAS).setValue((Object)fieldInfo.getBaseDataAlias());
        row.getCell(COL_ISSCHEDULED).setValue((Object)fieldInfo.isIsScheduled());
        row.getCell(COL_CALEXPRESSIONALIAS).setValue((Object)fieldInfo.getCalExpressionAlias());
        row.setUserObject((Object)fieldInfo);
        if (fieldInfo.isIsScheduled()) {
            row.getStyleAttributes().setBackground(new Color(192, 192, 192));
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"100_BalanceModelEditUI"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        if (this.editData.getState().getValue() != 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"101_BalanceModelEditUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setOprtState("EDIT");
        this.initDataStatus();
        this.unLockUI();
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
        this.setOprtState("VIEW");
        this.initDataStatus();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        BalanceFieldModelInfo fieldInfo = (BalanceFieldModelInfo)this.createNewDetailData();
        UIContext uiContext = new UIContext();
        this.checkBalanceType();
        uiContext.put("BalanceModel", this.editData);
        uiContext.put("BalanceField", fieldInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getFieldModelEditUI(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        BalanceFieldModelEditUI fieldEditUI = (BalanceFieldModelEditUI)uiWindow.getUIObject();
        if (fieldEditUI.isConfirm()) {
            this.innerLoadFields();
        }
    }

    private void checkBalanceType() {
        if (this.cmbBalanceType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"102_BalanceModelEditUI"));
            SysUtil.abort();
        }
        this.editData.setBalanceType((BalanceTypeEnum)((Object)this.cmbBalanceType.getSelectedItem()));
    }

    @Override
    public void actionEditLine_actionPerformed(ActionEvent e) throws Exception {
        this.doEditField();
    }

    private void doEditField() {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        BalanceFieldModelInfo oldField = (BalanceFieldModelInfo)row.getUserObject();
        if (!UseStatusEnum.SAVED.equals((Object)this.editData.getState()) && oldField.isIsScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"103_BalanceModelEditUI"));
            return;
        }
        this.checkBalanceType();
        BalanceFieldModelInfo newField = (BalanceFieldModelInfo)oldField.clone();
        UIContext uiContext = new UIContext();
        uiContext.put("BalanceModel", this.editData);
        uiContext.put("BalanceField", newField);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getFieldModelEditUI(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        BalanceFieldModelEditUI fieldEditUI = (BalanceFieldModelEditUI)uiWindow.getUIObject();
        if (fieldEditUI.isConfirm()) {
            newField.setParent(this.editData);
            this.editData.getEntry().remove(oldField);
            this.editData.getEntry().add(newField);
            this.updateLineData(newField, row);
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        BalanceFieldModelInfo fieldInfo = (BalanceFieldModelInfo)row.getUserObject();
        if (fieldInfo.isIsScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"104_BalanceModelEditUI"));
            return;
        }
        if (this.isReference(fieldInfo)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"105_BalanceModelEditUI"));
            return;
        }
        if (this.confirmRemove()) {
            if (row.getRowIndex() == this.tblMain.getRowCount() - 1) {
                this.tblMain.removeRow(row.getRowIndex());
                this.editData.getEntry().remove(fieldInfo);
            } else {
                this.editData.getEntry().remove(fieldInfo);
                this.adjustEntrySeq(fieldInfo.getSeq());
                this.innerLoadFields();
            }
        }
    }

    private boolean isReference(BalanceFieldModelInfo field) {
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.editData.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (StringUtil.isEmpty((String)fieldInfo.getCalExpression()) || fieldInfo.getCalExpression().indexOf(field.getId().toString()) <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionSetQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"106_BalanceModelEditUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext();
        uiContext.put("ParentNode", this.editData);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.scm.framework.balance.client.DataQueryListUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionIndexMge_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("BalanceModel", this.editData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BalanceIndexManageUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionSetDataModel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"106_BalanceModelEditUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext();
        uiContext.put("ParentNode", this.editData);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.scm.framework.balance.client.BalanceDataModelListUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionPlugInManage_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"106_BalanceModelEditUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext();
        uiContext.put("ParentNode", this.editData);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.framework.balance.client.BalancePlugInManageUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private void adjustEntrySeq(int beginIndex) {
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.editData.getEntry();
        for (int i = beginIndex - 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            fieldInfo.setSeq(i + 1);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        BalanceModelInfo info = (BalanceModelInfo)newData;
        info.setNumber(null);
        info.setName(null);
        info.setTabName(null);
        info.setDescription(null);
        info.setState(UseStatusEnum.SAVED);
    }

    public boolean isModify() {
        if ("VIEW".equals(this.getOprtState())) {
            return false;
        }
        if (!"ADDNEW".equals(this.getOprtState()) && this.editData.compareNewToOld()) {
            return false;
        }
        return super.isModify();
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

