/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.client.BaseCommonFilterPanel;
import com.kingdee.eas.scm.framework.client.CommonFilterPanelUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.Vector;

public class CommonBalanceFilterPanel
extends BaseCommonFilterPanel {
    private static final long serialVersionUID = 1L;
    private BalanceModelInfo balanceModel;
    private int defaultFieldMaxLenth = 80;

    public CommonBalanceFilterPanel(BalanceModelInfo balanceModel, FilterInfo filterInfo, int width, int height, int defaultRows) throws Exception {
        super(filterInfo, width, height, defaultRows);
        this.balanceModel = balanceModel;
        this.jbInit();
    }

    @Override
    protected void loadCondition(int rowIndex, RowObject rowObject) throws Exception {
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(1);
        KDComboBox comboBox = CommonFilterPanelUtil.setComboBoxField(iCell, CommonFilterPanelUtil.addObjectToArray(this.getFieldArray(), null));
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            Object[] fieldArray = this.getFieldArray();
            int selectIndex = -1;
            Object value = null;
            BalanceFieldModelInfo info = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                info = (BalanceFieldModelInfo)fieldArray[i];
                if (!info.getFieldName().equalsIgnoreCase(strCondition)) continue;
                selectIndex = i;
                value = fieldArray[i];
                break;
            }
            comboBox.setSelectedIndex(++selectIndex);
            comboBox.setSelectedItem(value);
            iCell.setValue(comboBox.getItemAt(selectIndex));
        }
    }

    @Override
    protected void loadCompareValue(int rowIndex, RowObject rowObject) throws Exception {
        Object compareValue = rowObject.getCompareValue();
        ICell compareValueCell = this.kdtTable.getRow(rowIndex).getCell(3);
        Object signValue = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
        if (CompareSignEnum.LIKESIGN.equals(signValue)) {
            if (compareValue.toString().startsWith("%") && compareValue.toString().endsWith("%")) {
                compareValue = compareValue.toString().substring(1, compareValue.toString().length() - 1);
            }
        } else if (CommonFilterPanelUtil.isNullJudge(signValue)) {
            this.kdtTable.getRow(rowIndex).getCell(3).setValue(null);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            return;
        }
        if (compareValue instanceof Set) {
            compareValue = ((Set)compareValue).iterator().next();
        }
        BalanceFieldModelInfo field = (BalanceFieldModelInfo)this.kdtTable.getRow(rowIndex).getCell(1).getValue();
        this.setFieldCompareValue(field, rowIndex, compareValueCell, compareValue.toString());
    }

    @Override
    protected void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        super.editedCondtionCellAfter(e);
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtTable.getRow(rowIndex);
        Object val = row.getCell(1).getValue();
        if (val != null && !StringUtil.isEmpty((String)String.valueOf(val))) {
            ICell compareValueCell = row.getCell(3);
            BalanceFieldModelInfo field = (BalanceFieldModelInfo)row.getCell(1).getValue();
            if (!ToolUtils.equalObject((Object)e.getValue(), (Object)e.getOldValue())) {
                this.setFieldCompareValue(field, rowIndex, compareValueCell, null);
            }
        }
    }

    @Override
    protected void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        IRow row = this.kdtTable.getRow(e.getRowIndex());
        ICell conditionCell = row.getCell(1);
        ICell compareValueCell = row.getCell(3);
        if (compareValueCell.getValue() == null || conditionCell.getValue() == null) {
            return;
        }
        BalanceFieldModelInfo field = (BalanceFieldModelInfo)conditionCell.getValue();
        if ((DataTypeEnum.Amount.equals((Object)field.getDataType()) || DataTypeEnum.Qty.equals((Object)field.getDataType()) || DataTypeEnum.Price.equals((Object)field.getDataType()) || DataTypeEnum.Integer.equals((Object)field.getDataType())) && this.checkNumberIsInValid(compareValueCell.getValue(), field.getDataType())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonFilterPanel", (String)"compareValueWarning"));
            compareValueCell.setValue(null);
        }
    }

    private boolean checkNumberIsInValid(Object value, DataTypeEnum dataType) {
        boolean flag = false;
        try {
            if (DataTypeEnum.Integer.equals((Object)dataType)) {
                new Integer(value.toString());
            } else if (DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
                NumberFormat nf = CtrlFormatUtilities.getDecimalFormat();
                String formatValue = "";
                try {
                    formatValue = nf.parse(value.toString()).toString();
                    new BigDecimal(formatValue);
                }
                catch (ParseException e) {
                    flag = true;
                }
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private void setFieldCompareValue(BalanceFieldModelInfo field, int rowIndex, ICell compareValueCell, String compareValue) throws Exception {
        if (DataTypeEnum.Boolean.equals((Object)field.getDataType())) {
            CommonFilterPanelUtil.setBooleanComboBox(compareValueCell, compareValue == null ? -1 : Integer.valueOf(compareValue));
        } else if (DataTypeEnum.Enum.equals((Object)field.getDataType())) {
            CommonFilterPanelUtil.setEnumComboBoxField(compareValueCell, field.getBaseDataBOSType(), compareValue);
        } else if (DataTypeEnum.BOSUuid.equals((Object)field.getDataType()) && !StringUtil.isEmpty((String)field.getBaseDataBOSType())) {
            this.setF7CtrlField(compareValueCell, field.getBaseDataBOSType(), compareValue);
        } else if (DataTypeEnum.Date.equals((Object)field.getDataType())) {
            Date initDate = new Date();
            if (compareValue != null) {
                DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
                initDate = dtformat.parse(compareValue);
            }
            CommonFilterPanelUtil.setDateCtrlField(compareValueCell, initDate);
            String format = "%{" + CtrlFormatUtilities.getDateFormatString() + "}t";
            compareValueCell.getStyleAttributes().setNumberFormat(format);
            compareValueCell.getStyleAttributes().setLocked(false);
            if (compareValue != null) {
                compareValueCell.setValue((Object)initDate);
            } else {
                compareValueCell.setValue(null);
            }
        } else if (DataTypeEnum.Amount.equals((Object)field.getDataType()) || DataTypeEnum.Qty.equals((Object)field.getDataType()) || DataTypeEnum.Price.equals((Object)field.getDataType()) || DataTypeEnum.Integer.equals((Object)field.getDataType())) {
            CommonFilterPanelUtil.setTextFieldCell(compareValueCell, compareValue);
        } else {
            CommonFilterPanelUtil.setTextFieldCell(compareValueCell, compareValue);
        }
    }

    private void setF7CtrlField(ICell iCell, String bosType, String value) throws BOSException {
        KDBizPromptBox f7 = CommonFilterPanelUtil.createF7WithBosType(bosType);
        if (f7 == null) {
            CommonFilterPanelUtil.setTextFieldCell(iCell, null);
            return;
        }
        if ("BBE9F8AE".equals(bosType)) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.whState", (Object)1, CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            f7.setEntityViewInfo(viewInfo);
        }
        f7.setEditable(false);
        String f7Data = value;
        if (f7Data != null && (f7Data = DynamicObjectFactory.getRemoteInstance().getValue(BOSObjectType.create((String)bosType), (IObjectPK)new ObjectUuidPK(value))) == null) {
            f7Data = value;
        }
        f7.setData((Object)f7Data);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(f7.getDisplayFormatter().toString()));
        iCell.setRenderer((IBasicRender)avr);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        iCell.getStyleAttributes().setNumberFormat("");
        iCell.getStyleAttributes().setLocked(false);
        iCell.setValue((Object)f7Data);
    }

    @Override
    protected void setConditionCell(int rowIndex) throws Exception {
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(1);
        CommonFilterPanelUtil.setComboBoxField(iCell, CommonFilterPanelUtil.addObjectToArray(this.getFieldArray(), null));
    }

    private Object[] getFieldArray() {
        BalanceFieldModelCollection coll = this.balanceModel.getEntry();
        coll.sort("seq");
        ArrayList<BalanceFieldModelInfo> fieldList = new ArrayList<BalanceFieldModelInfo>();
        for (int i = 1; i < coll.size(); ++i) {
            if (BizDataTypeEnum.PrimaryKey.equals((Object)coll.get(i).getBizDataType()) || BizDataTypeEnum.AssistInfo.equals((Object)coll.get(i).getBizDataType()) && coll.get(i).isIsScheduled()) continue;
            fieldList.add(coll.get(i));
        }
        return fieldList.toArray();
    }

    @Override
    protected String getConditionString(IRow iRow) {
        BalanceFieldModelInfo condition = (BalanceFieldModelInfo)iRow.getCell(1).getValue();
        return condition.getFieldName();
    }

    @Override
    protected Object getCompareValue(IRow iRow) throws Exception {
        Object compareValue = iRow.getCell(3).getValue();
        Object compareSign = iRow.getCell(2).getValue();
        BalanceFieldModelInfo condition = (BalanceFieldModelInfo)iRow.getCell(1).getValue();
        if (compareValue instanceof IObjectValue) {
            compareValue = ((IObjectValue)compareValue).get("id");
        } else if (DataTypeEnum.Amount.equals((Object)condition.getDataType()) || DataTypeEnum.Price.equals((Object)condition.getDataType()) || DataTypeEnum.Qty.equals((Object)condition.getDataType())) {
            NumberFormat nf = CtrlFormatUtilities.getDecimalFormat();
            compareValue = nf.parse(compareValue.toString());
        } else {
            compareValue = DataTypeEnum.Integer.equals((Object)condition.getDataType()) ? new Integer(compareValue.toString()) : Util.getValue((Object)compareValue);
        }
        if (CommonFilterUtil.isLikeSign((Object)compareSign) && compareValue instanceof String) {
            compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
        }
        return compareValue;
    }

    public BalanceModelInfo getBalanceModel() {
        return this.balanceModel;
    }

    public void setBalanceModel(BalanceModelInfo balanceModel) {
        this.balanceModel = balanceModel;
    }

    @Override
    protected boolean checkInvaildFilter() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            if (this.checkCurrentHasBlankCol(i)) {
                return true;
            }
            if (!this.checkCurrentHasTooLongCol(i)) continue;
            return true;
        }
        return false;
    }

    private boolean checkCurrentHasTooLongCol(int rowIndex) {
        IRow iRow = this.kdtTable.getRow(rowIndex);
        Object compareValue = null;
        BalanceFieldModelInfo field = (BalanceFieldModelInfo)this.kdtTable.getRow(rowIndex).getCell(1).getValue();
        String compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
        DataTypeEnum dataType = field.getDataType();
        if (!dataType.equals((Object)DataTypeEnum.String)) {
            return false;
        }
        if (!Util.isF7CompareValue((IRow)iRow) && !CommonFilterPanelUtil.isFieldJudge(compare) && (compareValue = Util.getValue((Object)iRow.getCell(3).getValue())) instanceof String) {
            Vector vec = CommonFilterPanelUtil.processStringValue((String)compareValue);
            if (!compare.equalsIgnoreCase("IN") && !compare.equalsIgnoreCase("NOT IN") && vec.size() > 500) {
                return true;
            }
            int maxlength = field.getLength();
            maxlength = maxlength > 0 ? maxlength : this.defaultFieldMaxLenth;
            for (int i = 0; i < vec.size(); ++i) {
                String tmp = (String)vec.get(i);
                if (tmp == null || tmp.length() <= maxlength) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonFilterPanel", (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    @Override
    protected void setCurrentFilterInfo() throws Exception {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            FilterItemInfo filterItemInfo;
            if (this.isBlankRow(i)) continue;
            IRow iRow = this.kdtTable.getRow(i);
            String leftBracket = Util.getValue((Object)iRow.getCell(0).getValue()).toString();
            String conditionStr = this.getConditionString(iRow);
            String rightBracket = Util.getValue((Object)iRow.getCell(4).getValue()).toString();
            String logic = Util.getValue((Object)iRow.getCell(5).getValue()).toString();
            if (logic == null || "".equals(logic)) {
                logic = "AND";
            }
            String compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
            Object compareSign = iRow.getCell(2).getValue();
            if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                filterItemInfo = new FilterItemInfo(conditionStr, null, CompareType.EQUALS);
                newFilterInfo.getFilterItems().add(filterItemInfo);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                continue;
            }
            if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                filterItemInfo = new FilterItemInfo(conditionStr, null, CompareType.NOTEQUALS);
                newFilterInfo.getFilterItems().add(filterItemInfo);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                continue;
            }
            Object compareValue = this.getCompareValue(iRow);
            if (compare.equalsIgnoreCase("IN") || compare.equalsIgnoreCase("NOT IN")) {
                compareValue = compareValue.toString().replaceAll(";", ",");
                FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionStr, compareValue, CompareType.getEnum((String)compare));
                newFilterInfo.getFilterItems().add(filterItemInfo2);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                continue;
            }
            if (compareValue instanceof Date) {
                SimpleDateFormat sic = new SimpleDateFormat("yyyy-MM-dd");
                compareValue = sic.parse(sic.format(compareValue));
                FilterItemInfo filterItemInfo3 = new FilterItemInfo(conditionStr, compareValue, CompareType.getEnum((String)compare));
                newFilterInfo.getFilterItems().add(filterItemInfo3);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                continue;
            }
            if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                if (compareSign == CompareSignEnum.LEFTLIKESIGN) {
                    compare = compare.substring(compare.length() - 4, compare.length());
                } else if (compareSign == CompareSignEnum.RIGHTLIKESIGN) {
                    compare = compare.substring(compare.length() - 4, compare.length());
                } else if (compareSign == CompareSignEnum.NOTLEFTLIKESIGN) {
                    compare = "not like";
                }
            }
            Object[] value = QueryUtils.setStringFilter((String)leftBracket, (String)rightBracket, (String)logic, (FilterInfo)newFilterInfo, (StringBuffer)sbFormula, (String)conditionStr, (Vector)CommonFilterPanelUtil.processStringValue(compareValue.toString()), (CompareType)CompareType.getEnum((String)compare));
            newFilterInfo = (FilterInfo)value[0];
            sbFormula = (StringBuffer)value[1];
        }
        String strFormula = sbFormula.toString();
        if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
            if ((strFormula = strFormula.trim()).endsWith("AND")) {
                strFormula = strFormula.substring(0, strFormula.length() - "AND".length());
            }
            newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
        }
        this.filterInfo = newFilterInfo;
    }
}

