/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.TableUI;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.DataQueryFactory;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.DataTableCollection;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import com.kingdee.eas.scm.framework.balance.client.AbstractDataQueryEditUI;
import com.kingdee.eas.scm.framework.balance.client.CommonDataQueryFilterUI;
import com.kingdee.eas.scm.framework.balance.client.DataTableEditUI;
import com.kingdee.eas.scm.framework.balance.client.DataTableImportUI;
import com.kingdee.eas.scm.framework.client.EntitySelector;
import com.kingdee.eas.scm.framework.client.EntitySelectorType;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataQueryEditUI
extends AbstractDataQueryEditUI {
    private static final long serialVersionUID = 1L;
    private BalanceModelInfo balanceModelInfo;
    private SelectorListener billSelectorListener = new SelectorListener(){

        public void willShow(SelectorEvent e) {
            DataQueryEditUI.this.initQueryBillF7(e);
        }
    };
    private PreChangeListener billPreChangeListener = new PreChangeListener(){

        public void preChange(PreChangeEvent e) {
            try {
                DataQueryEditUI.this.transBillTypeResult(e);
                e.setResult(1);
            }
            catch (Exception err) {
                ExceptionHandler.handle((Throwable)err);
            }
        }
    };
    private DataChangeListener changeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            try {
                DataQueryEditUI.this.mainTableChanged(e);
            }
            catch (Exception err) {
                ExceptionHandler.handle((Throwable)err);
            }
        }
    };
    private DefaultKingdeeTreeNode root;

    public void onLoad() throws Exception {
        this.balanceModelInfo = (BalanceModelInfo)this.getUIContext().get("ParentNode");
        super.onLoad();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.innerLoadFileds();
        this.addListener();
    }

    public void innerLoadFileds() {
        DataTableInfo mainTable = this.editData.getMainTable();
        if (mainTable != null) {
            this.prmtMainTable.setValue((Object)mainTable.getName());
        } else {
            this.prmtMainTable.setValue(null);
        }
        this.fillTreeNode(mainTable);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            this.btnNew.setEnabled(true);
            this.btnImport.setEnabled(true);
            this.btnModify.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else {
            this.btnNew.setEnabled(false);
            this.btnImport.setEnabled(false);
            this.btnModify.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
        this.prmtMainTable.setEditable(false);
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
    }

    private void fillTreeNode(DataTableInfo mainTable) {
        if (mainTable == null) {
            this.treeQueryTable.setModel(null);
            return;
        }
        this.root = this.addTreeNode(null, mainTable);
        this.fillChildrenNode(this.root, mainTable);
        this.treeQueryTable.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.treeQueryTable.expandAllNodes(true, (TreeNode)this.root);
    }

    private void fillChildrenNode(DefaultKingdeeTreeNode root, DataTableInfo table) {
        if (table == null) {
            return;
        }
        DataTableCollection coll = table.getChildren(this.editData.getEntry());
        for (int i = 0; i < coll.size(); ++i) {
            DefaultKingdeeTreeNode node = this.addTreeNode(root, coll.get(i));
            this.fillChildrenNode(node, coll.get(i));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (StringUtil.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"117_DataQueryEditUI"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)this.txtName.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"118_DataQueryEditUI"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtMainTable.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"119_DataQueryEditUI"));
            this.prmtMainTable.requestFocus();
            SysUtil.abort();
        }
    }

    private void removeListener() {
        this.prmtMainTable.removeSelectorListener(this.billSelectorListener);
        this.prmtMainTable.removePreChangeListener(this.billPreChangeListener);
        this.prmtMainTable.removeDataChangeListener(this.changeListener);
    }

    private void addListener() {
        this.prmtMainTable.addSelectorListener(this.billSelectorListener);
        this.prmtMainTable.addPreChangeListener(this.billPreChangeListener);
        this.prmtMainTable.addDataChangeListener(this.changeListener);
    }

    protected IObjectValue createNewData() {
        DataQueryInfo info = new DataQueryInfo();
        info.setBalanceModel(this.balanceModelInfo);
        info.setState(UseStatusEnum.SAVED);
        info.setIsScheduled(false);
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billBosType"));
        sic.add(new SelectorItemInfo("filterString"));
        sic.add(new SelectorItemInfo("entry.name"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.bosType"));
        sic.add(new SelectorItemInfo("entry.tableName"));
        sic.add(new SelectorItemInfo("entry.tableAlias"));
        sic.add(new SelectorItemInfo("entry.joinType"));
        sic.add(new SelectorItemInfo("entry.joinCondition"));
        sic.add(new SelectorItemInfo("entry.isMainTable"));
        sic.add(new SelectorItemInfo("entry.parentTable.id"));
        sic.add(new SelectorItemInfo("entry.parentTable.name"));
        sic.add(new SelectorItemInfo("entry.parentTable.bosType"));
        sic.add(new SelectorItemInfo("entry.parentTable.tableName"));
        sic.add(new SelectorItemInfo("entry.parentTable.tableAlias"));
        sic.add(new SelectorItemInfo("entry.parentTable.joinType"));
        sic.add(new SelectorItemInfo("entry.parentTable.joinCondition"));
        sic.add(new SelectorItemInfo("entry.parentTable.isMainTable"));
        return sic;
    }

    private DataTableInfo createNewTableData() {
        DataTableInfo info = new DataTableInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setIsMainTable(false);
        info.setParent(this.editData);
        return info;
    }

    private void initQueryBillF7(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            EntitySelector selector = new EntitySelector(this.getUIWindow(), EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"120_DataQueryEditUI"), EntitySelectorType.BizBill);
            f7Box.setSelector((KDPromptSelector)selector);
        }
    }

    private void transBillTypeResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            EntityObjectInfo entity = (EntityObjectInfo)e.getData();
            if (entity != null) {
                e.setData((Object)MetaDataUtil.getDisplayName((EntityObjectInfo)entity));
                f7Box.setUserObject((Object)entity);
            } else {
                e.setData(null);
                f7Box.setUserObject(null);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void mainTableChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == e.getOldValue()) {
            return;
        }
        EntityObjectInfo srcEntity = (EntityObjectInfo)this.prmtMainTable.getUserObject();
        this.editData.getEntry().clear();
        this.treeQueryTable.setModel(null);
        if (srcEntity != null) {
            DataTableInfo table = this.createNewTableData();
            table.setIsMainTable(true);
            table.setBosType(srcEntity.getType().toString());
            table.setName(srcEntity.getAlias());
            table.setTableName(srcEntity.getTable().getName());
            table.setTableAlias(srcEntity.getName());
            this.editData.setBillBosType(srcEntity.getType().toString());
            this.editData.getEntry().add(table);
            this.root = this.addTreeNode(null, table);
            this.treeQueryTable.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
            if (this.txtName.getText() == null) {
                this.txtName.setText(srcEntity.getAlias());
            }
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"75_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"76_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
        if (this.editData.isIsScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"77_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setOprtState("EDIT");
        this.initDataStatus();
        this.unLockUI();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
        this.setOprtState("VIEW");
        this.initDataStatus();
    }

    @Override
    public void actionNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectPath();
        TreePath path = this.treeQueryTable.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        DataTableInfo parent = (DataTableInfo)node.getUserObject();
        DataTableInfo table = this.createNewTableData();
        table.setParentTable(parent);
        UIContext uiContext = new UIContext();
        uiContext.put("DataQuery", this.editData);
        uiContext.put("DataTable", table);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataTableEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        DataTableEditUI tableEditUI = (DataTableEditUI)uiWindow.getUIObject();
        if (tableEditUI.isConfirm()) {
            this.editData.getEntry().add(table);
            this.addTreeNode(node, table);
            this.treeQueryTable.repaint();
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("BosType", this.editData.getBillBosType());
        uiContext.put("DataQuery", this.editData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataTableImportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        DataTableImportUI importUI = (DataTableImportUI)uiWindow.getUIObject();
        if (importUI.isConfirm()) {
            this.fillTreeNode(this.editData.getMainTable());
            this.treeQueryTable.repaint();
        }
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectPath();
        TreePath path = this.treeQueryTable.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node.isRoot()) {
            return;
        }
        DataTableInfo oldTable = (DataTableInfo)node.getUserObject();
        DataTableInfo newTable = (DataTableInfo)oldTable.clone();
        UIContext uiContext = new UIContext();
        uiContext.put("DataQuery", this.editData);
        uiContext.put("DataTable", newTable);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataTableEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        DataTableEditUI tableEditUI = (DataTableEditUI)uiWindow.getUIObject();
        if (tableEditUI.isConfirm()) {
            newTable.setParent(this.editData);
            this.editData.getEntry().remove(oldTable);
            this.editData.getEntry().add(newTable);
            this.updateTreeNode(node, newTable);
            this.treeQueryTable.repaint();
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectPath();
        TreePath path = this.treeQueryTable.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node.isRoot()) {
            return;
        }
        if (this.confirmRemove()) {
            this.deleteTreeNode(node);
            this.treeQueryTable.removeAllChildrenFromParent((MutableTreeNode)node);
            this.treeQueryTable.removeNodeFromParent((MutableTreeNode)node);
            this.treeQueryTable.repaint();
        }
    }

    private DefaultKingdeeTreeNode addTreeNode(DefaultKingdeeTreeNode parent, DataTableInfo table) {
        if (table == null) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)table);
        treeNode.setText(table.getDisplayName());
        treeNode.setCustomIcon((Icon)ResourceManager.getIcon(TableUI.class, (String)"bos_table.gif"));
        if (parent == null) {
            return treeNode;
        }
        this.treeQueryTable.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parent);
        this.treeQueryTable.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.root));
        this.treeQueryTable.expandAllNodes(true, (TreeNode)this.root);
        return treeNode;
    }

    private void updateTreeNode(DefaultKingdeeTreeNode node, DataTableInfo table) {
        if (node == null || table == null) {
            return;
        }
        node.setText(table.getDisplayName());
        node.setUserObject((Object)table);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue objectValue;
        if (!UtilRequest.isPrepare((String)"ActionCopy", (CoreUIObject)this)) {
            this.checkModified();
        }
        if (this.editData != null && !OprtState.VIEW.equals(this.getOprtState()) && (objectValue = (IObjectValue)this.getUIContext().get("CURRENT.VO")) != null) {
            try {
                String id = this.idList.getID(this.idList.getCurrentIndex());
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.copyDataQueryInfo(this.editData);
        this.unLockUI();
        this.setFieldsNull((AbstractObjectValue)this.editData);
        this.setOprtState("ADDNEW");
        this.setDataObject((IObjectValue)this.editData);
        EventListener[] lsts = this.removeDetailTableListener(KDTPropertyChangeListener.class);
        this.loadFields();
        this.restoreDetailTableListener(KDTPropertyChangeListener.class, lsts);
        this.showCopyAddNew();
        this.actionCopy.setEnabled(false);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.setDefaultFocused();
    }

    @Override
    public void actionSetFilter_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        uiContext.put("DataQuery", this.editData);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CommonDataQueryFilterUI.class.getName(), (Map)uiContext);
        CommonDataQueryFilterUI filterPanel = (CommonDataQueryFilterUI)uiWindow.getUIObject();
        uiWindow.show();
        if (!filterPanel.isCancel()) {
            this.editData.setFilterString(filterPanel.getFilterInfo().toString());
        }
    }

    private void copyDataQueryInfo(DataQueryInfo editData) {
        editData.setId(null);
        editData.setNumber(null);
        DataTableInfo table = null;
        DataTableInfo otherTable = null;
        DataTableCollection coll = editData.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            table = coll.get(i);
            BOSUuid oldId = table.getId();
            BOSUuid newId = BOSUuid.create((BOSObjectType)editData.getBOSType());
            table.setId(newId);
            for (int j = 0; j < coll.size(); ++j) {
                otherTable = coll.get(j);
                if (otherTable.getParentTable() == null || !otherTable.getParentTable().getId().equals((Object)oldId)) continue;
                otherTable.setParentTable(table);
            }
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        DataQueryInfo info = (DataQueryInfo)newData;
        info.setState(UseStatusEnum.SAVED);
        info.setIsScheduled(false);
    }

    private void deleteTreeNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        int count = node.getChildCount();
        DefaultKingdeeTreeNode child = null;
        for (int i = 0; i < count; ++i) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.deleteTreeNode(child);
        }
        DataTableInfo table = (DataTableInfo)node.getUserObject();
        this.editData.getEntry().remove(table);
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private void checkSelectPath() {
        TreePath path = this.treeQueryTable.getSelectionPath();
        if (path == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"121_DataQueryEditUI"));
            SysUtil.abort();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataQueryFactory.getRemoteInstance();
    }
}

