/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractDataQueryEnumFieldSelectUI;
import com.kingdee.eas.scm.framework.model.RuleSegementInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;

public class DataQueryEnumFieldSelectUI
extends AbstractDataQueryEnumFieldSelectUI {
    private static final long serialVersionUID = 1L;
    private BizEnumInfo bizEnum;
    private static final String ENUMKEY = "key";
    private static final String ENUMVALUE = "value";
    private static final String ENUMALIAS = "alias";
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";

    public DataQueryEnumFieldSelectUI() throws Exception {
        this.tblEnumValue.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                DataQueryEnumFieldSelectUI.this.tblEnum_tableClicked(e);
            }
        });
    }

    @Override
    protected void initValueTable() {
        BalanceFieldModelInfo fieldModel = super.getFieldModel();
        this.tblEnumValue.checkParsed();
        this.tblEnumValue.setEditable(false);
        this.tblEnumValue.getSelectManager().setSelectMode(2);
        if (fieldModel.getDataType().equals((Object)DataTypeEnum.Enum)) {
            String enumName = fieldModel.getBaseDataBOSType();
            if (enumName == null) {
                return;
            }
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            this.bizEnum = loader.getEnum((IMetaDataPK)MetaDataPK.create((String)enumName));
            BizEnumValueCollection enumItemCol = this.bizEnum.getEnumValue();
            for (BizEnumValueInfo enumItem : enumItemCol) {
                IRow row = this.tblEnumValue.addRow();
                row.setUserObject((Object)enumItem);
                ICell cellkey = row.getCell(ENUMKEY);
                cellkey.setValue((Object)enumItem.getName());
                ICell cellvalue = row.getCell(ENUMVALUE);
                cellvalue.setValue(enumItem.getValue());
                ICell cellalias = row.getCell(ENUMALIAS);
                cellalias.setValue((Object)enumItem.getAlias());
            }
        } else if (fieldModel.getDataType().equals((Object)DataTypeEnum.Boolean)) {
            this.initBooleanRow(this.tblEnumValue, Boolean.TRUE);
            this.initBooleanRow(this.tblEnumValue, Boolean.FALSE);
        }
        this.tblEnumValue.doLayout();
    }

    private void initBooleanRow(KDTable table, Boolean value) {
        IRow row = this.tblEnumValue.addRow();
        row.setUserObject((Object)value);
        ICell cellkey = row.getCell(ENUMKEY);
        cellkey.setValue((Object)value.toString());
        ICell cellvalue = row.getCell(ENUMVALUE);
        cellvalue.setValue((Object)value.toString());
        ICell cellalias = row.getCell(ENUMALIAS);
        cellalias.setValue((Object)EASResource.getString((String)RESXFILENAME, (String)value.toString().toUpperCase()));
    }

    protected void tblEnum_tableClicked(KDTMouseEvent e) {
        KDTSelectBlock selectBlock;
        if (e.getClickCount() == 2 && (selectBlock = this.tblEnumValue.getSelectManager().get()) != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblEnumValue.getRow(rowIndex);
            BalanceFieldModelInfo fieldModel = super.getFieldModel();
            if (fieldModel.getDataType().equals((Object)DataTypeEnum.Enum)) {
                BizEnumValueInfo enumItem = (BizEnumValueInfo)row.getUserObject();
                RuleSegementInfo result = (RuleSegementInfo)super.getData();
                if (BizEnumValueType.STRING.equals((Object)this.bizEnum.getDataType())) {
                    result.setExpression("return \"" + enumItem.getValue().toString() + "\"");
                } else {
                    result.setExpression("return " + enumItem.getValue().toString());
                }
                result.setProperty(false);
                result.setExpressionAlias(enumItem.getAlias());
                this.txtValueExpression.setText(result.getExpressionAlias());
            } else if (fieldModel.getDataType().equals((Object)DataTypeEnum.Boolean)) {
                String alias_zh_cn = ResourceBase.getString((String)RESXFILENAME, (String)row.getUserObject().toString().toUpperCase(), (Locale)zh_cn);
                RuleSegementInfo result = (RuleSegementInfo)super.getData();
                if (((Boolean)row.getUserObject()).booleanValue()) {
                    result.setExpression("return 1");
                } else {
                    result.setExpression("return 0");
                }
                result.setProperty(false);
                result.setExpressionAlias(alias_zh_cn);
                this.txtValueExpression.setText(result.getExpressionAlias());
            }
        }
    }
}

