/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.client.AbstractDataQueryFieldSelectUI;
import com.kingdee.eas.scm.framework.balance.client.DataQueryFormulaUI;
import com.kingdee.eas.scm.framework.balance.client.formula.DataQueryFormula;
import com.kingdee.eas.scm.framework.balance.model.PropertyMeta;
import com.kingdee.eas.scm.framework.balance.util.DataQueryTreeUtil;
import com.kingdee.eas.scm.framework.model.RuleSegementInfo;
import com.kingdee.util.LocaleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataQueryFieldSelectUI
extends AbstractDataQueryFieldSelectUI {
    private static final long serialVersionUID = 1L;
    public static Locale zh_en = LocaleUtils.locale_en_US;
    public static Locale zh_cn = LocaleUtils.locale_zh_CN;
    public static Locale zh_hk = LocaleUtils.locale_zh_TW;
    private boolean isCancel;
    private DataQueryInfo dataQuery;
    private BalanceFieldModelInfo fieldModel;
    private RuleSegementInfo result;

    public DataQueryFieldSelectUI() throws Exception {
        this.treeDataQuery.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DataQueryFieldSelectUI.this.treeDataQuery_mouseClicked(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dataQuery = (DataQueryInfo)this.getUIContext().get("DataQuery");
        this.fieldModel = (BalanceFieldModelInfo)this.getUIContext().get("BalanceField");
        this.result = this.getUIContext().get("RuleSegementInfo") != null ? (RuleSegementInfo)this.getUIContext().get("RuleSegementInfo") : new RuleSegementInfo();
        this.txtValueExpression.setText(this.result.getExpressionAlias());
        this.initDataQueryTree();
        this.initValueTable();
    }

    private void initDataQueryTree() {
        DefaultKingdeeTreeNode root = DataQueryTreeUtil.getDataQueryRoot(this.dataQuery, this.fieldModel);
        if (root == null) {
            this.treeDataQuery.setModel(null);
        } else {
            this.treeDataQuery.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
            this.treeDataQuery.expandOnLevel(1);
            this.treeDataQuery.setToggleClickCount(1);
        }
    }

    protected void initValueTable() {
    }

    private void treeDataQuery_mouseClicked(MouseEvent e) {
        Object obj;
        TreePath tp = this.treeDataQuery.getSelectionPath();
        if (tp == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        if (e.getClickCount() == 2 && treeNode != null && (obj = treeNode.getUserObject()) instanceof PropertyMeta) {
            this.result.setProperty(true);
            this.result.setExpression(((PropertyMeta)obj).getFullSQLFieldName());
            this.result.setExpressionAlias(((PropertyMeta)obj).getFullAlias());
            this.txtValueExpression.setText(this.result.getExpressionAlias());
        }
    }

    @Override
    public void actionSetFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        DataQueryFormula formulaInfo = new DataQueryFormula(this.dataQuery);
        if (this.result.getExpression() != null && !this.result.getExpression().startsWith("return")) {
            formulaInfo.setFormulaExpr(this.result.getExpression());
        }
        uiContext.put("DataQueryFormula", formulaInfo);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DataQueryFormulaUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        DataQueryFormulaUI formulaUI = (DataQueryFormulaUI)uiWindow.getUIObject();
        if (!formulaUI.isCancel()) {
            formulaInfo = (DataQueryFormula)formulaUI.getData();
            this.result.setProperty(false);
            this.result.setExpression(formulaInfo.getFormulaExpr());
            this.result.setExpressionAlias(formulaInfo.getFormualAlias());
            this.txtValueExpression.setText(this.result.getExpressionAlias());
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        return this.result;
    }

    public DataQueryInfo getDataQuery() {
        return this.dataQuery;
    }

    public BalanceFieldModelInfo getFieldModel() {
        return this.fieldModel;
    }
}

