/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.event.TreeWillExpandAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import com.kingdee.eas.scm.framework.balance.RelationTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractDataTableImportUI;
import com.kingdee.eas.scm.framework.model.JoinCondition;
import com.kingdee.eas.scm.framework.model.JoinField;
import com.kingdee.eas.scm.framework.util.SCMMDUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class DataTableImportUI
extends AbstractDataTableImportUI {
    private static final long serialVersionUID = 1L;
    public static final String BOSTYPE = "BosType";
    public static final String DATAQUERY = "DataQuery";
    private static final String IS_NEW = "IS_NEW";
    private static final String IS_REMOVED = "IS_REMOVED";
    private EntityObjectInfo entity;
    private DataQueryInfo dataQuery;
    private boolean isConfirm;
    private List<DataTableInfo> changeList = new ArrayList<DataTableInfo>();

    public DataTableImportUI() throws Exception {
        this.treeEntity.addTreeWillExpandListener((TreeWillExpandListener)new TreeWillExpandAdapter(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DataTableImportUI.this.expandChildProperty(event);
            }
        });
        this.treeEntity.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                DataTableImportUI.this.nodeStateChanged(event);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String bosType = (String)this.getUIContext().get(BOSTYPE);
        this.dataQuery = (DataQueryInfo)this.getUIContext().get(DATAQUERY);
        this.entity = SCMMDUtil.getEntityByBosType(bosType);
        this.initEntityTree();
    }

    public void initEntityTree() {
        NodeObject object = new NodeObject(null, null, this.dataQuery.getMainTable());
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)object);
        root.setText(this.entity.getDisplayName());
        root.setChecked(true);
        this.addEntityChildNode(this.entity, root);
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        model.setAsksAllowsChildren(true);
        this.treeEntity.setModel((TreeModel)model);
        this.treeEntity.setShowCheckBox(true);
        this.treeEntity.expandOnLevel(0);
    }

    private void addEntityChildNode(EntityObjectInfo entity, DefaultKingdeeTreeNode parent) {
        if (entity == null) {
            return;
        }
        PropertyCollection headProColl = entity.getProperties();
        headProColl.addObjectCollection((IObjectCollection)entity.getInheritedProperties());
        for (PropertyInfo property : headProColl) {
            DataTableInfo parentTable;
            DataTableInfo childTable;
            RelationshipInfo relation;
            if (!(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getSupplierObject().equals((Object)entity)) continue;
            NodeObject object = new NodeObject(property, relation, null);
            DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)object);
            treeNode.setText(property.getAlias());
            treeNode.setChecked(false);
            treeNode.setAllowsChildren(true);
            this.treeEntity.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parent);
            if (!parent.isChecked()) continue;
            String tableName = relation.getSupplierObject().getTable().getName();
            String fieldName = relation.getClientProperty().getMappingField().getName();
            if (property.getMappingField() != null) {
                fieldName = property.getMappingField().getName();
            }
            if ((childTable = (parentTable = (object = (NodeObject)parent.getUserObject()).getTable()).findChildByRelaField(this.dataQuery.getEntry(), tableName, fieldName)) == null) continue;
            treeNode.setChecked(true);
            ((NodeObject)treeNode.getUserObject()).setTable(childTable);
        }
    }

    private void expandChildProperty(TreeExpansionEvent event) {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
        if (treeNode.getChildCount() > 0) {
            return;
        }
        NodeObject object = (NodeObject)treeNode.getUserObject();
        EntityObjectInfo supplyObject = object.getRelation().getSupplierObject();
        this.addEntityChildNode(supplyObject, treeNode);
    }

    private void nodeStateChanged(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getNode();
        if (treeNode.isRoot()) {
            treeNode.setChecked(true);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"133_DataTableImportUI"));
            return;
        }
        this.handleNodeChange(treeNode);
        this.treeEntity.repaint();
    }

    private void handleNodeChange(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        DataTableInfo table = null;
        NodeObject object = (NodeObject)node.getUserObject();
        if (node.isChecked()) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
            if (parent != null && !parent.isChecked()) {
                parent.setChecked(true);
                this.handleNodeChange(parent);
            }
            table = this.createNewDataTable(node, parent);
            object.setTable(table);
        } else {
            table = object.getTable();
            if (table.getBoolean(IS_NEW)) {
                this.changeList.remove(table);
            } else {
                table.setBoolean(IS_REMOVED, true);
                this.changeList.add(table);
            }
        }
    }

    private DataTableInfo createNewDataTable(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode parentNode) {
        if (node == null) {
            return null;
        }
        NodeObject object = (NodeObject)node.getUserObject();
        DataTableInfo table = new DataTableInfo();
        table.setId(BOSUuid.create((BOSObjectType)table.getBOSType()));
        RelationshipInfo relation = object.getRelation();
        table.setBosType(relation.getSupplierObject().getType().toString());
        table.setTableName(relation.getSupplierObject().getTable().getName());
        String tableAlias = this.dataQuery.getNoDumplicateTableAlias(object.getProperty().getName());
        table.setTableAlias(tableAlias);
        table.setName(object.getProperty().getAlias());
        table.setJoinType(RelationTypeEnum.Inner_Join);
        NodeObject parentObject = (NodeObject)parentNode.getUserObject();
        JoinField child = new JoinField(tableAlias, relation.getSupplierProperty().getMappingField().getName());
        String fieldName = relation.getClientProperty().getMappingField().getName();
        if (object.getProperty().getMappingField() != null) {
            fieldName = object.getProperty().getMappingField().getName();
        }
        JoinField parent = new JoinField(parentObject.getTable().getTableAlias(), fieldName);
        JoinCondition condition = new JoinCondition(child, parent);
        table.setJoinCondition(condition.toString());
        table.setParentTable(parentObject.getTable());
        table.setBoolean(IS_NEW, true);
        this.changeList.add(table);
        return table;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        DataTableInfo table = null;
        for (int i = 0; i < this.changeList.size(); ++i) {
            table = this.changeList.get(i);
            if (table.getBoolean(IS_NEW)) {
                table.setParent(this.dataQuery);
                this.dataQuery.getEntry().add(table);
            } else if (table.getBoolean(IS_REMOVED)) {
                this.dataQuery.getEntry().remove(table);
            }
            table.remove(IS_NEW);
            table.remove(IS_REMOVED);
        }
        this.isConfirm = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        this.getUIWindow().close();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    class NodeObject {
        PropertyInfo property;
        RelationshipInfo relation;
        DataTableInfo table;

        public NodeObject(PropertyInfo property, RelationshipInfo relation, DataTableInfo table) {
            this.property = property;
            this.relation = relation;
            this.table = table;
        }

        public PropertyInfo getProperty() {
            return this.property;
        }

        public void setProperty(PropertyInfo property) {
            this.property = property;
        }

        public RelationshipInfo getRelation() {
            return this.relation;
        }

        public void setRelation(RelationshipInfo relation) {
            this.relation = relation;
        }

        public DataTableInfo getTable() {
            return this.table;
        }

        public void setTable(DataTableInfo table) {
            this.table = table;
        }
    }
}

