/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client.formula;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.engine.AliasTransformer;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DQBOSObjectTransformerHelper {
    public static String TYPE_VARINFO = "varinfo";
    public static String TYPE_PROPERTY = "property";
    public static String TYPE_METHOD = "method";
    public static String TYPE_OTHER = "other";
    public static String TYPE_CONSTANT = "constant";
    public static String TYPE_ENUM = "enum";
    private TokenList tokenlist;
    private List<IVarInfo> varList;
    private Map<String, DataTableInfo> tableMap;
    private List<BizEnumInfo> enumList;
    private List analyseList = new ArrayList();
    private HashMap enumItem2Enum = new HashMap();

    public DQBOSObjectTransformerHelper(Map<String, DataTableInfo> tableMap, List<IVarInfo> vars, List<BizEnumInfo> enums, TokenList tokens) {
        this.tableMap = tableMap;
        this.varList = vars;
        this.enumList = enums;
        this.tokenlist = tokens;
        try {
            this.analyse();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    private void analyse() throws ParserException {
        Token token;
        if (this.tokenlist == null) {
            return;
        }
        this.analyseList.clear();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            if (this.isVarinfo(index)) {
                this.analyseList.add(TYPE_VARINFO);
            } else if (this.isEnum(index)) {
                this.analyseList.add(TYPE_ENUM);
            } else if (this.isProperty(index)) {
                this.analyseList.add(TYPE_PROPERTY);
            } else if (this.isMethod(index)) {
                this.analyseList.add(TYPE_METHOD);
            } else if (this.isConstant(index)) {
                this.analyseList.add(TYPE_CONSTANT);
            } else {
                this.analyseList.add(TYPE_OTHER);
            }
            ++index;
        }
    }

    private boolean isVarinfo(int index) throws ParserException {
        if (this.tokenlist != null && index >= 0) {
            Token self = this.tokenlist.lookup(index);
            if (self != null && self.type != 1) {
                return false;
            }
            if (index > 0) {
                Token token = this.tokenlist.lookup(index - 1);
                if (token.value.equals(".")) {
                    return false;
                }
            }
            if (this.varList != null && self != null) {
                for (IVarInfo varinfo : this.varList) {
                    String alias = varinfo.getVarAlias();
                    if (!alias.equals(self.value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isProperty(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            if (self != null && self.type != 1) {
                return false;
            }
            Token token = this.tokenlist.lookup(index + 1);
            if (token == null || token.type == 12 || Token.PeriodToken.equals(token) || 4 == token.type || token.value.equals(";") || 5 == token.type && !Token.OpenBraceToken.equals(token) || token.value.equalsIgnoreCase("CASE") || token.value.equalsIgnoreCase("WHEN") || token.value.equalsIgnoreCase("THEN") || token.value.equalsIgnoreCase("ELSE") || token.value.equalsIgnoreCase("END") || token.value.equalsIgnoreCase("NULL")) {
                return true;
            }
        }
        return false;
    }

    private boolean isMethod(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            Token token = this.tokenlist.lookup(index + 1);
            Token bToken = this.tokenlist.lookup(index - 1);
            if (1 == self.type && 5 == token.type && Token.OpenBraceToken.equals(token) && bToken.value != null && bToken.value.equals(".")) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstant(int index) throws ParserException {
        if (index < 1) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 6 == token.type;
    }

    private boolean isEnum(int index) throws ParserException {
        if (index < 0 || this.enumList == null) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        String ei = token.value;
        int size = this.enumList.size();
        for (int i = 0; i < size; ++i) {
            BizEnumInfo enumInfo = this.enumList.get(i);
            BizEnumValueCollection evCol = enumInfo.getEnumValue();
            int esi = evCol.size();
            for (int j = 0; j < esi; ++j) {
                BizEnumValueInfo ev = evCol.get(j);
                if (ev.getAlias() == null || !ev.getAlias().equals(ei)) continue;
                this.enumItem2Enum.put(ei, enumInfo);
                return true;
            }
        }
        return false;
    }

    private boolean isCaseWord(int index) throws ParserException {
        if (index < 0) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 1 == token.type && (token.value.equalsIgnoreCase("CASE") || token.value.equalsIgnoreCase("WHEN") || token.value.equalsIgnoreCase("THEN") || token.value.equalsIgnoreCase("ELSE") || token.value.equalsIgnoreCase("END") || token.value.equalsIgnoreCase("NULL"));
    }

    private DataTableInfo getPropertyOrMethodBO(int index) throws ParserException {
        if (index < 2) {
            return null;
        }
        Token beforToken = this.tokenlist.lookup(index - 2);
        String type = (String)this.analyseList.get(index - 2);
        while (!(TYPE_VARINFO.equals(type) || TYPE_PROPERTY.equals(type) || TYPE_METHOD.equals(type) || --index < 0)) {
            beforToken = this.tokenlist.lookup(index);
            type = (String)this.analyseList.get(index);
        }
        if (TYPE_VARINFO.equals(type)) {
            IVarInfo var = this.getVarinfoByAlias(beforToken.value);
            return this.tableMap.get(var.getVarName());
        }
        return null;
    }

    private IVarInfo getVarinfoByAlias(String varAlias) {
        if (this.varList != null) {
            for (IVarInfo varinfo : this.varList) {
                String alias = varinfo.getVarAlias();
                if (!alias.equals(varAlias)) continue;
                return varinfo;
            }
        }
        return null;
    }

    public TokenList getScriptTokenList() throws ParserException {
        Token token;
        StringBuffer scriptsb = new StringBuffer();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            int j;
            EntityObjectInfo bo;
            DataTableInfo table;
            if (this.isVarinfo(index)) {
                IVarInfo var = this.getVarinfoByAlias(token.value);
                scriptsb.append(var.getVarName());
            } else if (this.isEnum(index)) {
                String value = token.value;
                BizEnumInfo enumInfo = (BizEnumInfo)this.enumItem2Enum.get(value);
                BizEnumValueType vt = enumInfo.getDataType();
                boolean isStr = false;
                if (vt.equals((Object)BizEnumValueType.STRING)) {
                    isStr = true;
                }
                BizEnumValueCollection evCol = enumInfo.getEnumValue();
                int esi = evCol.size();
                for (int j2 = 0; j2 < esi; ++j2) {
                    BizEnumValueInfo ev = evCol.get(j2);
                    if (ev.getAlias() == null || !ev.getAlias().equals(value)) continue;
                    Object obj = ev.getValue();
                    scriptsb.append(" ");
                    if (isStr) {
                        scriptsb.append("\"");
                    }
                    scriptsb.append(obj.toString());
                    if (isStr) {
                        scriptsb.append("\"");
                    }
                    scriptsb.append(" ");
                    break;
                }
            } else if (this.isCaseWord(index)) {
                scriptsb.append(" ");
                scriptsb.append(token.value);
                scriptsb.append(" ");
            } else if (this.isProperty(index)) {
                table = this.getPropertyOrMethodBO(index);
                bo = table.getEntity();
                boolean find = false;
                if (bo != null) {
                    PropertyCollection pc = bo.getInheritedNoDuplicatedProperties();
                    j = pc.size();
                    for (int i = 0; i < j; ++i) {
                        PropertyInfo pro = pc.get(i);
                        if (pro.getAlias() == null || !AliasTransformer.propTransform((String)pro.getAlias()).equals(token.value)) continue;
                        scriptsb.append(pro.getMappingField().getName());
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    scriptsb.append(token.value);
                }
            } else if (this.isMethod(index)) {
                table = this.getPropertyOrMethodBO(index);
                bo = table.getEntity();
                boolean find = false;
                if (bo != null) {
                    MethodCollection mc = bo.getAllMethods();
                    j = mc.size();
                    for (int i = 0; i < j; ++i) {
                        MethodInfo method = mc.get(i);
                        if (method.getAlias() == null || !AliasTransformer.methodTransform((String)method.getAlias()).equals(token.value)) continue;
                        scriptsb.append(method.getName());
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    scriptsb.append(token.value);
                }
            } else if (this.isConstant(index)) {
                scriptsb.append("\"");
                scriptsb.append(token.value);
                scriptsb.append("\"");
            } else if (6 == token.type) {
                scriptsb.append("\"").append(token.value).append("\"");
            } else {
                scriptsb.append(token.value);
            }
            ++index;
        }
        Lexer _lexer = new Lexer(scriptsb.toString());
        TokenList _tokenList = new TokenList(_lexer);
        return _tokenList;
    }
}

