/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.model;

import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.scm.framework.balance.DataTableInfo;
import java.io.Serializable;
import java.util.Locale;

public class PropertyMeta
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataTableInfo dataTable;
    private PropertyInfo property;

    public PropertyMeta(DataTableInfo dataTable, PropertyInfo property) {
        this.dataTable = dataTable;
        this.property = property;
    }

    public String getName() {
        return this.property.getName();
    }

    public String getFullName() {
        return this.dataTable.getTableAlias() + "." + this.property.getName();
    }

    public String getAlias() {
        return this.property.getAlias();
    }

    public String getFullAlias() {
        return this.dataTable.getName() + "." + this.property.getAlias();
    }

    public String getAlias(Locale locale) {
        return this.property.getAlias(locale);
    }

    public String getFullAlias(Locale locale) {
        return this.dataTable.getName(locale) + "." + this.property.getAlias(locale);
    }

    public String getFullSQLFieldName() {
        return this.dataTable.getTableAlias() + "." + this.property.getMappingField().getName();
    }

    public String getDescription() {
        return this.property.getDescription();
    }

    public String getDescription(Locale locale) {
        return this.property.getDescription(locale);
    }

    public ColumnInfo getMappingField() {
        return this.property.getMappingField();
    }

    public String getDataType() {
        String dataType = this.property.getString("dataType");
        if (this.property instanceof LinkPropertyInfo) {
            dataType = "F7";
        }
        return dataType;
    }

    public String getRelationBosType() {
        if (this.property instanceof LinkPropertyInfo) {
            return ((LinkPropertyInfo)this.property).getRelationship().getSupplierObject().getType().toString();
        }
        return null;
    }

    public String getEnumClassName() {
        return this.property.getString("metadataRef");
    }

    public String toString() {
        return this.property.getAlias();
    }

    public int hashCode() {
        return this.property.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyMeta) {
            return this.property.equals((Object)((PropertyMeta)o).property);
        }
        return false;
    }

    public DataTableInfo getDataTable() {
        return this.dataTable;
    }

    public PropertyInfo getProperty() {
        return this.property;
    }
}

