/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.scm.framework.bizflow.ProcessFactory;
import com.kingdee.eas.scm.framework.bizflow.client.AbstractImportImageUI;
import com.kingdee.eas.scm.framework.bizflow.util.DataExportUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

public class ImportImageUI
extends AbstractImportImageUI {
    private static final long serialVersionUID = 1L;
    private File[] files = null;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnImport.setEnabled(true);
        this.btnSelectFile.setEnabled(true);
        this.btnClose.setEnabled(true);
    }

    @Override
    public void actionImportImage_actionPerformed(ActionEvent e) throws Exception {
        if (this.files == null || this.files.length == 0) {
            return;
        }
        Map<String, byte[]> map = DataExportUtil.outFile2Map(this.files);
        ProcessFactory.getRemoteInstance().importImageData(map, this.cbImportType.isSelected());
        super.disposeUIWindow();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
        super.disposeUIWindow();
    }

    @Override
    public void actionOpenFile_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpenFile_actionPerformed(e);
        try {
            String path = System.getProperty("user.home");
            KDFileChooser chooser = new KDFileChooser(path);
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setMultiSelectionEnabled(true);
            SimpleFileFilter ff1 = new SimpleFileFilter("jpg", EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"101_ImportImageUI"));
            chooser.setFileFilter((FileFilter)ff1);
            int returnValue = chooser.showOpenDialog((Component)((Object)this));
            if (returnValue == 0) {
                this.files = chooser.getSelectedFiles();
                StringBuilder filePath = new StringBuilder();
                if (this.files != null && this.files.length > 0) {
                    int len = this.files.length;
                    for (int i = 0; i < len; ++i) {
                        if (i != 0) {
                            filePath.append(";");
                        }
                        filePath.append(this.files[i].getPath());
                    }
                }
                this.txtFilePath.setText(filePath.toString());
            }
        }
        catch (Exception err) {
            MsgBox.showError((String)err.getMessage());
        }
    }
}

