/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.framework.bizflow.FilterModeEnum;
import com.kingdee.eas.scm.framework.bizflow.WriteBackFilterConfigInfo;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleInfo;
import com.kingdee.eas.scm.framework.bizflow.client.AbstractWriteBackFilterConfigUI;
import com.kingdee.eas.scm.framework.bizflow.client.WriteBackRuleEditUI;
import com.kingdee.eas.scm.framework.bizflow.client.formula.MessageConfigFormulaUI;
import com.kingdee.eas.scm.framework.bizflow.client.formula.WriteBackFormulaUI;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackFormula;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;

public class WriteBackFilterConfigUI
extends AbstractWriteBackFilterConfigUI {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE = "com.kingdee.eas.scm.framework.bizflow.WriteBackFilterConfigResource";
    private static final String TB_WRITEFILTER = "writeBackFilter";
    private static final String TB_WRITEFILTERALIAS = "writeBackFilterAlias";
    private static final String TB_FILTERMODE = "filterMode";
    private static final String TB_MESSAGE = "message";
    protected EntityObjectInfo entityDest = null;
    protected EntityObjectInfo entitySrc = null;
    private WriteBackRuleInfo editData = null;
    private String oprtSatate = null;
    private KDTEditAdapter kdtEditAdapter = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.entitySrc = (EntityObjectInfo)this.getUIContext().get("ENTIRY_SRC");
        this.entityDest = (EntityObjectInfo)this.getUIContext().get("ENTIRY_DEST");
        this.editData = (WriteBackRuleInfo)this.getUIContext().get("InitDataObject");
        WriteBackRuleEditUI editUI = (WriteBackRuleEditUI)((Object)this.getUIContext().get("parent"));
        this.oprtSatate = editUI.getOprtState();
        this.initBtnStatus();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onShow() throws Exception {
        this.removeListeners();
        super.onShow();
        if ("ADDNEW".equals(this.oprtSatate) && this.editData != null && this.editData.getFilterConfig() != null && this.editData.getFilterConfig().size() == 0) {
            this.addLine(this.getDetailTable());
        }
        this.loadData();
        this.initTableF7();
    }

    protected void initListener() {
        this.kdtEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    WriteBackFilterConfigUI.this.table_EditStopped(e);
                }
                catch (Exception exc) {
                    WriteBackFilterConfigUI.this.handUIException(exc);
                }
            }

            public void editStarting(KDTEditEvent e) {
                try {
                    WriteBackFilterConfigUI.this.table_EditStarting(e);
                }
                catch (Exception exc) {
                    WriteBackFilterConfigUI.this.handUIException(exc);
                }
            }
        };
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.kdtEditAdapter);
    }

    private void loadData() {
        IRow row = null;
        WriteBackFilterConfigInfo info = null;
        if (this.editData != null && this.editData.getFilterConfig() != null && this.editData.getFilterConfig().size() > 0) {
            int size = this.editData.getFilterConfig().size();
            for (int i = 0; i < size; ++i) {
                info = this.editData.getFilterConfig().get(i);
                row = this.getDetailTable().addRow(i);
                row.getCell(TB_WRITEFILTERALIAS).setValue((Object)info.getWriteBackFilterAlias());
                row.getCell(TB_WRITEFILTER).setValue((Object)info.getWriteBackFilter());
                row.getCell(TB_FILTERMODE).setValue((Object)info.getWriteFilterMode());
                row.getCell(TB_MESSAGE).setValue((Object)info.getMessage());
                row.setUserObject((Object)info);
            }
        }
    }

    private void removeListeners() {
        if (this.kdtEditAdapter != null) {
            this.getDetailTable().removeKDTEditListener((KDTEditListener)this.kdtEditAdapter);
        }
    }

    public void table_EditStopped(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        WriteBackFilterConfigInfo info = null;
        if (this.getDetailTable().getRow(rowIndex).getUserObject() != null) {
            info = (WriteBackFilterConfigInfo)this.getDetailTable().getRow(rowIndex).getUserObject();
        }
        if (TB_FILTERMODE.equals(fieldName) && info != null && newValue != null) {
            info.setWriteFilterMode((FilterModeEnum)((Object)newValue));
        }
        if (TB_MESSAGE.equals(fieldName) && info != null) {
            if (newValue != null) {
                info.setMessage(newValue.toString());
            } else {
                info.setMessage("");
            }
        }
    }

    public void table_EditStarting(KDTEditEvent e) throws Exception {
        FilterModeEnum modeEnum;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.getDetailTable().getColumnKey(colIndex);
        if (TB_MESSAGE.equals(fieldName) && this.getDetailTable().getCell(rowIndex, TB_FILTERMODE).getValue() != null && FilterModeEnum.NORMAL == (modeEnum = (FilterModeEnum)((Object)this.getDetailTable().getCell(rowIndex, TB_FILTERMODE).getValue()))) {
            e.setCancel(true);
        }
    }

    private IObjectValue createNewData() {
        WriteBackFilterConfigInfo info = new WriteBackFilterConfigInfo();
        return info;
    }

    private void initBtnStatus() {
        this.btnAdd.setText("");
        this.btnInsert.setText("");
        this.btnRemove.setText("");
        if ("VIEW".equals(this.oprtSatate) || "STATUS_CANCELCANCEL".equals(this.oprtSatate)) {
            this.actionOK.setEnabled(false);
            this.actionCancel.setEnabled(true);
            this.actionAdd.setEnabled(false);
            this.actionInsert.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else if ("ADDNEW".equals(this.oprtSatate) || "EDIT".equals(this.oprtSatate)) {
            this.actionOK.setEnabled(true);
            this.actionCancel.setEnabled(true);
            this.actionAdd.setEnabled(true);
            this.actionInsert.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.doCheckData();
        WriteBackFilterConfigInfo info = null;
        this.editData.getFilterConfig().clear();
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            if (this.getDetailTable().getRow(i).getUserObject() == null || (info = (WriteBackFilterConfigInfo)this.getDetailTable().getRow(i).getUserObject()) == null) continue;
            this.editData.getFilterConfig().add(info);
        }
        this.actionCancel_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void insertLine(KDTable table) {
        IRow row = null;
        if (table == null) {
            return;
        }
        if (table.getStyleAttributes().isLocked()) {
            return;
        }
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        row.setUserObject((Object)this.createNewData());
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getStyleAttributes().isLocked()) {
            return;
        }
        IRow row = table.addRow();
        row.setUserObject((Object)this.createNewData());
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.getDetailTable());
        this.initTableF7();
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.getDetailTable());
        this.initTableF7();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.getDetailTable());
    }

    private void initTableF7() {
        KDComboBox filterModeComboBox = new KDComboBox();
        filterModeComboBox.addItems(FilterModeEnum.getEnumList().toArray());
        this.getDetailTable().getColumn(TB_FILTERMODE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)filterModeComboBox));
        this.getDetailTable().getColumn(TB_WRITEFILTERALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initWriteFilterEditor(this.getDetailTable(), TB_WRITEFILTERALIAS)));
        this.getDetailTable().getColumn(TB_MESSAGE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initWriteFilterEditor(this.getDetailTable(), TB_MESSAGE)));
    }

    protected KDPromptBox initWriteFilterEditor(final KDTable table, final String column) {
        KDPromptBox f7Box = new KDPromptBox();
        f7Box.setReadOnly(true);
        f7Box.setEditable(false);
        f7Box.setAccessAuthority(1);
        f7Box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    if (WriteBackFilterConfigUI.TB_WRITEFILTERALIAS.equals(column)) {
                        WriteBackFilterConfigUI.this.showFormulaUI(table);
                    } else if (WriteBackFilterConfigUI.TB_MESSAGE.equals(column)) {
                        WriteBackFilterConfigUI.this.showMessageConfigUI(table);
                    }
                }
                catch (Exception e1) {
                    WriteBackFilterConfigUI.this.handleException(e1);
                }
            }
        });
        return f7Box;
    }

    protected KDTable getDetailTable() {
        return this.kdtFilterConfig;
    }

    private void showMessageConfigUI(KDTable table) throws UIException, ParserException {
        String valueExpression = "";
        int rowIndex = table.getEditManager().getEditRowIndex();
        if (table.getRow(rowIndex).getCell(TB_MESSAGE).getValue() != null) {
            valueExpression = table.getRow(rowIndex).getCell(TB_MESSAGE).getValue().toString();
        }
        WriteBackFormula formula = new WriteBackFormula(this.entitySrc, this.entityDest, valueExpression);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("InitDataObject", formula);
        uiContext.put("IsCheckFormual", Boolean.FALSE);
        uiContext.put("ChildUI", "MessageConfigFormulaUI");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MessageConfigFormulaUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        MessageConfigFormulaUI wbFormulaUI = (MessageConfigFormulaUI)uiWindow.getUIObject();
        if (!wbFormulaUI.isCancel() && ("ADDNEW".equals(this.oprtSatate) || "EDIT".equals(this.oprtSatate)) && (formula = wbFormulaUI.getWriteBackFormula()) != null) {
            table.getRow(rowIndex).getCell(TB_MESSAGE).setValue((Object)formula.getValueExpression());
            if (table.getRow(rowIndex).getUserObject() != null) {
                WriteBackFilterConfigInfo filterConfigInfo = (WriteBackFilterConfigInfo)table.getRow(rowIndex).getUserObject();
                filterConfigInfo.setMessage(formula.getValueExpression());
            }
        }
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                table.removeRow(rowIndex);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private void showFormulaUI(KDTable table) throws Exception {
        String valueExpression = "";
        int rowIndex = table.getEditManager().getEditRowIndex();
        if (table.getRow(rowIndex).getCell(TB_WRITEFILTER).getValue() != null) {
            valueExpression = table.getRow(rowIndex).getCell(TB_WRITEFILTER).getValue().toString();
        }
        WriteBackFormula formula = new WriteBackFormula(this.entitySrc, this.entityDest, valueExpression);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("InitDataObject", formula);
        uiContext.put("IsCheckFormual", Boolean.TRUE);
        uiContext.put("isFromWriteBackFilterConfigUI", Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WriteBackFormulaUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        WriteBackFormulaUI wbFormulaUI = (WriteBackFormulaUI)uiWindow.getUIObject();
        if (!wbFormulaUI.isCancel() && ("ADDNEW".equals(this.oprtSatate) || "EDIT".equals(this.oprtSatate)) && (formula = wbFormulaUI.getWriteBackFormula()) != null) {
            table.getRow(rowIndex).getCell(TB_WRITEFILTER).setValue((Object)formula.getValueExpression());
            table.getRow(rowIndex).getCell(TB_WRITEFILTERALIAS).setValue((Object)formula.getFormualAlias());
            if (table.getRow(rowIndex).getUserObject() != null) {
                WriteBackFilterConfigInfo filterConfigInfo = (WriteBackFilterConfigInfo)table.getRow(rowIndex).getUserObject();
                filterConfigInfo.setWriteBackFilter(formula.getValueExpression());
                filterConfigInfo.setWriteBackFilterAlias(formula.getFormualAlias());
            }
        }
    }

    private void doCheckData() {
        IRow row = null;
        String msg = EASResource.getString((String)RESOURCE, (String)"check_msg");
        int size = this.getDetailTable().getRowCount();
        for (int i = 0; i < size; ++i) {
            FilterModeEnum modeEnum;
            row = this.getDetailTable().getRow(i);
            if (row.getCell(TB_WRITEFILTERALIAS).getValue() != null && row.getCell(TB_FILTERMODE).getValue() == null) {
                MsgBox.showInfo((String)MessageFormat.format(msg, String.valueOf(i + 1), this.getDetailTable().getHeadRow(0).getCell(TB_FILTERMODE).getValue().toString()));
                this.getDetailTable().getEditManager().editCellAt(i, this.getDetailTable().getColumnIndex(TB_FILTERMODE));
                SysUtil.abort();
            }
            if (row.getCell(TB_FILTERMODE).getValue() == null) continue;
            if (row.getCell(TB_WRITEFILTERALIAS).getValue() == null) {
                MsgBox.showInfo((String)MessageFormat.format(msg, String.valueOf(i + 1), this.getDetailTable().getHeadRow(0).getCell(TB_WRITEFILTERALIAS).getValue().toString()));
                this.getDetailTable().getEditManager().editCellAt(i, this.getDetailTable().getColumnIndex(TB_WRITEFILTERALIAS));
                SysUtil.abort();
            }
            if (FilterModeEnum.ABORT != (modeEnum = (FilterModeEnum)((Object)row.getCell(TB_FILTERMODE).getValue())) || row.getCell(TB_MESSAGE).getValue() != null) continue;
            MsgBox.showInfo((String)MessageFormat.format(msg, String.valueOf(i + 1), this.getDetailTable().getHeadRow(0).getCell(TB_MESSAGE).getValue().toString()));
            this.getDetailTable().getEditManager().editCellAt(i, this.getDetailTable().getColumnIndex(TB_MESSAGE));
            SysUtil.abort();
        }
    }
}

