/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.framework.bizflow.SimpleStatusEnum;
import com.kingdee.eas.scm.framework.bizflow.WriteBackRuleFactory;
import com.kingdee.eas.scm.framework.bizflow.client.AbstractWriteBackRuleListUI;
import com.kingdee.eas.scm.framework.bizflow.client.WriteBackRuleEditUI;
import com.kingdee.eas.scm.framework.solutionmgr.tools.SolutionMgrActionUI;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WriteBackRuleListUI
extends AbstractWriteBackRuleListUI {
    private static final long serialVersionUID = 1L;
    public static final String RESOURCEPATH = "com.kingdee.eas.scm.framework.bizflow.BizProcessResource";
    private KDTreeNode rootNode = null;
    private static final String rootNodeNum = "root";
    private DefaultTreeModel treeModel = null;
    FilterInfo selectNodeFilterInfo = null;
    private SolutionMgrActionUI solutionMgrActionUI = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(false, false);

    public WriteBackRuleListUI() throws Exception {
        this.solutionMgrActionUI = new SolutionMgrActionUI((ListUI)this, this.toolBar, this.tblMain, "number", "FNumber", "EXP_WriteBack");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadMenu2Toolbar();
        this.initGroupTree();
    }

    protected void loadMenu2Toolbar() {
        this.hideOrShowAuditResult(false);
        this.menuBiz.setVisible(false);
        this.menuBiz.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.MenuItemAttachment.setEnabled(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAttachment.setEnabled(false);
        this.btnCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WriteBackRuleFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return WriteBackRuleEditUI.class.getName();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)RESOURCEPATH, (String)"95_Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancel", (CoreUIObject)this)) {
                this.prepareCancel(null).callHandler();
            }
            this.cancel();
        }
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancelCancel();
        this.refreshList();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("destBillBosType"));
        sic.add(new SelectorItemInfo("srcBillBosType"));
        sic.add(new SelectorItemInfo("srcBillEntityAlias"));
        sic.add(new SelectorItemInfo("destBillEntityAlias"));
        return sic;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain)[0];
        Boolean isSystem = (Boolean)this.tblMain.getRow(selectIndex).getCell("isSystem").getValue();
        if (isSystem.booleanValue()) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"98_ProcessCheck"));
            SysUtil.abort();
        }
        BizEnumValueDTO status = (BizEnumValueDTO)this.tblMain.getRow(selectIndex).getCell("status").getValue();
        if (SimpleStatusEnum.ACTIVE.getName().equals(status.getName())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"15_ProcessCheck"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected ArrayList getExportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.WriteBackRule";
        if (this.mainQuery != null) {
            EntityViewInfo env = new EntityViewInfo();
            if (this.mainQuery.getFilter() != null) {
                env.setFilter(this.mainQuery.getFilter());
            }
            if (this.mainQuery.getSorter() != null) {
                env.setSorter(this.mainQuery.getSorter());
            }
            param.putContextParam((Object)"mainQueryPK", (Object)MetaDataPK.create((String)"com.kingdee.eas.scm.framework.bizflow.app.WriteBackRuleExportQuery"));
            param.putContextParam((Object)"mainQuery", (Object)env);
        }
        param.alias = EASResource.getString((String)RESOURCEPATH, (String)"WriteBack");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        Context ctx = this.getMainOrgContext();
        dc.setMainOrgContext(ctx);
        dc.invoke(para, 1);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.WriteBackRule";
        param.alias = EASResource.getString((String)RESOURCEPATH, (String)"WriteBack");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void setMainQueryEntityView() {
        EntityViewInfo view = new EntityViewInfo();
        TreePath treePath = this.kDTreeMain.getSelectionPath();
        this.selectNodeFilterInfo = new FilterInfo();
        if (treePath == null) {
            this.mainQuery = view;
            return;
        }
        KDTreeNode node = (KDTreeNode)treePath.getLastPathComponent();
        BillTypeInfo nodeInfo = (BillTypeInfo)node.getUserObject();
        if (StringUtil.isEmpty((String)nodeInfo.getBosType()) || rootNodeNum.equals(nodeInfo.getNumber())) {
            this.mainQuery = view;
            return;
        }
        this.selectNodeFilterInfo.getFilterItems().add(new FilterItemInfo("destBillBosType", (Object)nodeInfo.getBosType(), CompareType.EQUALS));
        this.mainQuery.setFilter(this.selectNodeFilterInfo);
    }

    private void initGroupTree() throws BOSException {
        BillTypeInfo rootNodeInfo = new BillTypeInfo();
        rootNodeInfo.setNumber(rootNodeNum);
        String rootName = ResourceUtil.getMessage((String)RESOURCEPATH, (String)"billTypeName");
        rootNodeInfo.setName(rootName);
        this.rootNode = new KDTreeNode((Object)rootNodeInfo);
        List<BillTypeInfo> billTypeList = this.getBillTypeList();
        BillTypeInfo nodeInfo = null;
        KDTreeNode treeNode = null;
        int size = billTypeList.size();
        for (int i = 0; i < size; ++i) {
            nodeInfo = billTypeList.get(i);
            treeNode = new KDTreeNode((Object)nodeInfo);
            this.rootNode.add((MutableTreeNode)treeNode);
        }
        this.treeModel = new DefaultTreeModel((TreeNode)this.rootNode);
        this.kDTreeMain.setModel((TreeModel)this.treeModel);
        this.kDTreeMain.setEditable(false);
        this.kDTreeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    WriteBackRuleListUI.this.setMainQueryEntityView();
                    WriteBackRuleListUI.this.refresh(null);
                }
                catch (Exception exe) {
                    WriteBackRuleListUI.this.handUIException(exe);
                }
            }
        });
    }

    private List<BillTypeInfo> getBillTypeList() throws BOSException {
        ArrayList<BillTypeInfo> billTypeList = new ArrayList<BillTypeInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("destBillEntityAlias");
        sic.add("destBillBosType");
        view.setSelector(sic);
        SorterItemCollection sortIC = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("destBillEntityAlias");
        item.setSortType(SortType.DESCEND);
        sortIC.add(item);
        view.setSorter(sortIC);
        StringBuilder sql = new StringBuilder(128);
        sql.append(" select DISTINCT fdestBillEntityAlias, fdestBillBosType ");
        sql.append(" from T_BPM_WriteBackRule ");
        sql.append(" order by fdestBillEntityAlias desc ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        BillTypeInfo billType = null;
        try {
            while (rs.next()) {
                billType = new BillTypeInfo();
                billType.setId(BOSUuid.create((String)"463ED552"));
                billType.setName(rs.getString("fdestBillEntityAlias"));
                billType.setBosType(rs.getString("fdestBillBosType"));
                billTypeList.add(billType);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql exception: " + e.getMessage());
        }
        return billTypeList;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        try {
            if (this.mainQuery.getFilter() != null) {
                this.mainQuery.getFilter().mergeFilter(this.selectNodeFilterInfo, "and");
            } else {
                this.mainQuery.setFilter(this.selectNodeFilterInfo);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return exec;
    }

    private KDTreeNode getSelectedTreeNode() {
        TreePath treePath = this.kDTreeMain.getSelectionPath();
        if (treePath != null) {
            return (KDTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.solutionMgrActionUI.registImpBtn(32);
        this.solutionMgrActionUI.registExpBtn(33);
    }
}

