/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client.util;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class EditorRuler
extends JComponent
implements MouseMotionListener,
DropTargetListener {
    private static final long serialVersionUID = -6310912355878668096L;
    public static int ORIENTATION_HORIZONTAL = 0;
    public static int ORIENTATION_VERTICAL = 1;
    protected static int INCH = 72;
    protected static int DEFAULT_PAGESCALE = 1;
    protected static boolean DEFAULT_ISMETRIC = true;
    public static final NumberFormat numberFormat = NumberFormat.getInstance();
    protected Color inactiveBackground = new Color(170, 170, 170);
    protected int orientation = ORIENTATION_HORIZONTAL;
    protected int activeoffset;
    protected int activelength;
    protected double scale = DEFAULT_PAGESCALE;
    protected boolean metric = DEFAULT_ISMETRIC;
    protected Font labelFont = new Font("Tahoma", 0, 9);
    protected int rulerSize = 16;
    protected int tickDistance = 30;
    protected mxGraphComponent graphComponent;
    protected Point mouse = new Point();
    protected double increment;
    protected double units;
    protected transient mxEventSource.mxIEventListener repaintHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            EditorRuler.this.repaint();
        }
    };

    public EditorRuler(mxGraphComponent graphComponent, int orientation) {
        this.orientation = orientation;
        this.graphComponent = graphComponent;
        this.updateIncrementAndUnits();
        graphComponent.getGraph().getView().addListener("scale", this.repaintHandler);
        graphComponent.getGraph().getView().addListener("translate", this.repaintHandler);
        graphComponent.getGraph().getView().addListener("scaleAndTranslate", this.repaintHandler);
        graphComponent.getGraphControl().addMouseMotionListener(this);
        DropTarget dropTarget = graphComponent.getDropTarget();
        try {
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(this);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void setActiveOffset(int offset) {
        this.activeoffset = (int)((double)offset * this.scale);
    }

    public void setActiveLength(int length) {
        this.activelength = (int)((double)length * this.scale);
    }

    public boolean isMetric() {
        return this.metric;
    }

    public void setMetric(boolean isMetric) {
        this.metric = isMetric;
        this.updateIncrementAndUnits();
        this.repaint();
    }

    public int getRulerSize() {
        return this.rulerSize;
    }

    public void setRulerSize(int rulerSize) {
        this.rulerSize = rulerSize;
    }

    public void setTickDistance(int tickDistance) {
        this.tickDistance = tickDistance;
    }

    public int getTickDistance() {
        return this.tickDistance;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.graphComponent.getGraphControl().getPreferredSize();
        if (this.orientation == ORIENTATION_VERTICAL) {
            dim.width = this.rulerSize;
        } else {
            dim.height = this.rulerSize;
        }
        return dim;
    }

    @Override
    public void dragEnter(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
        this.updateMousePosition(arg0.getLocation());
    }

    @Override
    public void drop(DropTargetDropEvent arg0) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateMousePosition(e.getPoint());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateMousePosition(e.getPoint());
    }

    protected void updateMousePosition(Point pt) {
        Point old = this.mouse;
        this.mouse = pt;
        this.repaint(old.x, old.y);
        this.repaint(this.mouse.x, this.mouse.y);
    }

    protected void updateIncrementAndUnits() {
        double graphScale = this.graphComponent.getGraph().getView().getScale();
        if (this.metric) {
            this.units = (double)INCH / 2.54;
            this.units *= this.graphComponent.getPageScale() * graphScale;
            this.increment = this.units;
        } else {
            this.units = INCH;
            this.units *= this.graphComponent.getPageScale() * graphScale;
            this.increment = this.units / 2.0;
        }
    }

    public void repaint(int x, int y) {
        if (this.orientation == ORIENTATION_VERTICAL) {
            this.repaint(0, y, this.rulerSize, 1);
        } else {
            this.repaint(x, 0, 1, this.rulerSize);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        mxGraph graph = this.graphComponent.getGraph();
        Rectangle clip = g.getClipBounds();
        this.updateIncrementAndUnits();
        if (this.activelength > 0 && this.inactiveBackground != null) {
            g.setColor(this.inactiveBackground);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(this.getBackground());
        Point2D.Double p = new Point2D.Double(this.activeoffset, this.activelength);
        if (this.orientation == ORIENTATION_HORIZONTAL) {
            g.fillRect((int)((Point2D)p).getX(), clip.y, (int)((Point2D)p).getY(), clip.height);
        } else {
            g.fillRect(clip.x, (int)((Point2D)p).getX(), clip.width, (int)((Point2D)p).getY());
        }
        double left = clip.getX();
        double top = clip.getY();
        double right = left + clip.getWidth();
        double bottom = top + clip.getHeight();
        mxPoint trans = graph.getView().getTranslate();
        double scale = graph.getView().getScale();
        double tx = trans.getX() * scale;
        double ty = trans.getY() * scale;
        double stepping = this.increment;
        if (stepping < (double)this.tickDistance) {
            int count = (int)Math.round(Math.ceil((double)this.tickDistance / stepping) / 2.0) * 2;
            stepping = (double)count * stepping;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(this.labelFont);
        g.setColor(Color.black);
        int smallTick = this.rulerSize - this.rulerSize / 3;
        int middleTick = this.rulerSize / 2;
        if (this.orientation == ORIENTATION_HORIZONTAL) {
            double xs = Math.floor((left - tx) / stepping) * stepping + tx;
            double xe = Math.ceil(right / stepping) * stepping;
            xe += (double)((int)Math.ceil(stepping));
            for (double x = xs; x <= xe; x += stepping) {
                double xx = (double)Math.round((x - tx) / stepping) * stepping + tx;
                int ix = (int)Math.round(xx);
                g.drawLine(ix, this.rulerSize, ix, 0);
                String text = this.format((x - tx) / this.increment);
                g.drawString(text, ix + 2, this.labelFont.getSize());
                g.drawLine(ix += (int)Math.round(stepping / 4.0), this.rulerSize, ix, smallTick);
                g.drawLine(ix += (int)Math.round(stepping / 4.0), this.rulerSize, ix, middleTick);
                g.drawLine(ix += (int)Math.round(stepping / 4.0), this.rulerSize, ix, smallTick);
            }
        } else {
            double ys = Math.floor((top - ty) / stepping) * stepping + ty;
            double ye = Math.ceil(bottom / stepping) * stepping;
            ye += (double)((int)Math.ceil(stepping));
            for (double y = ys; y <= ye; y += stepping) {
                y = (double)Math.round((y - ty) / stepping) * stepping + ty;
                int iy = (int)Math.round(y);
                g.drawLine(this.rulerSize, iy, 0, iy);
                String text = this.format((y - ty) / this.increment);
                AffineTransform at = ((Graphics2D)g).getTransform();
                ((Graphics2D)g).rotate(-1.5707963267948966, 0.0, iy);
                g.drawString(text, 1, iy + this.labelFont.getSize());
                ((Graphics2D)g).setTransform(at);
                g.drawLine(this.rulerSize, iy += (int)Math.round(stepping / 4.0), smallTick, iy);
                g.drawLine(this.rulerSize, iy += (int)Math.round(stepping / 4.0), middleTick, iy);
                g.drawLine(this.rulerSize, iy += (int)Math.round(stepping / 4.0), smallTick, iy);
            }
        }
        g.setColor(Color.green);
        if (this.orientation == ORIENTATION_HORIZONTAL) {
            g.drawLine(this.mouse.x, this.rulerSize, this.mouse.x, 0);
        } else {
            g.drawLine(this.rulerSize, this.mouse.y, 0, this.mouse.y);
        }
    }

    private final String format(double value) {
        String text = numberFormat.format(value);
        if (text.equals("-0")) {
            text = "0";
        }
        return text;
    }

    static {
        numberFormat.setMaximumFractionDigits(2);
    }
}

