/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.client.util;

import com.kingdee.eas.scm.framework.bizflow.client.RightPanel;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class GraphActions {
    static final Action deleteAction = new DeleteAction("delete");
    static final Action editAction = new EditAction("edit");
    static final Action removeFromParentAction = new RemoveFromParentAction("removeFromParent");
    static final Action selectAllAction = new SelectAction("selectAll");
    static final Action selectVerticesAction = new SelectAction("vertices");
    static final Action selectEdgesAction = new SelectAction("edges");
    static final Action selectNextAction = new SelectAction("selectNext");
    static final Action selectPreviousAction = new SelectAction("selectPrevious");
    static final Action selectParentAction = new SelectAction("selectParent");
    static final Action selectChildAction = new SelectAction("selectChild");
    static final Action moveUpAction = new MoveCellAction("moveUp");
    static final Action moveDownAction = new MoveCellAction("moveDown");
    static final Action moveLeftAction = new MoveCellAction("moveLeft");
    static final Action moveRightAction = new MoveCellAction("moveRight");
    static final Action alignLeftAction = new AlignCellsAction("left");
    static final Action alignCenterAction = new AlignCellsAction("center");
    static final Action alignRightAction = new AlignCellsAction("right");
    static final Action alignTopAction = new AlignCellsAction("top");
    static final Action alignMiddleAction = new AlignCellsAction("middle");
    static final Action alignBottomAction = new AlignCellsAction("bottom");
    static final Action undoAction = new HistoryAction(true);
    static final Action redoAction = new HistoryAction(false);
    static final String ZOOM_IN = "zoomIn";
    static final String ZOOM_OUT = "zoomOut";
    static final String ZOOM_ACTUAL = "zoomActual";
    static final String ZOOM_CENTER = "zoomCenter";
    static final Action zoomInAction = new ZoomAction("zoomIn");
    static final Action zoomOutAction = new ZoomAction("zoomOut");
    static final Action zoomActualAction = new ZoomAction("zoomActual");
    static final Action zoomCenterAction = new ZoomAction("zoomCenter");

    public static Action getZoomInAction() {
        return zoomInAction;
    }

    public static Action getZoomOutAction() {
        return zoomOutAction;
    }

    public static Action getZoomActualAction() {
        return zoomActualAction;
    }

    public static Action getZoomCenterAction() {
        return zoomCenterAction;
    }

    public static Action getUndoAction() {
        return undoAction;
    }

    public static Action getRedoAction() {
        return redoAction;
    }

    public static Action getAlignLeftAction() {
        return alignLeftAction;
    }

    public static Action getAlignCenterAction() {
        return alignCenterAction;
    }

    public static Action getAlignRightAction() {
        return alignRightAction;
    }

    public static Action getAlignTopAction() {
        return alignTopAction;
    }

    public static Action getAlignMiddleAction() {
        return alignMiddleAction;
    }

    public static Action getAlignBottomAction() {
        return alignBottomAction;
    }

    public static Action getDeleteAction() {
        return deleteAction;
    }

    public static Action getEditAction() {
        return editAction;
    }

    public static Action getRemoveFromParentAction() {
        return removeFromParentAction;
    }

    public static Action getSelectAllAction() {
        return selectAllAction;
    }

    public static Action getSelectVerticesAction() {
        return selectVerticesAction;
    }

    public static Action getSelectEdgesAction() {
        return selectEdgesAction;
    }

    public static Action getSelectNextAction() {
        return selectNextAction;
    }

    public static Action getSelectPreviousAction() {
        return selectPreviousAction;
    }

    public static Action getSelectParentAction() {
        return selectParentAction;
    }

    public static Action getSelectChildAction() {
        return selectChildAction;
    }

    public static Action getMoveUpAction() {
        return moveUpAction;
    }

    public static Action getMoveDownAction() {
        return moveDownAction;
    }

    public static Action getMoveLeftAction() {
        return moveLeftAction;
    }

    public static Action getMoveRightAction() {
        return moveRightAction;
    }

    public static final mxGraph getGraph(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof RightPanel) {
            return ((RightPanel)source).getGraph();
        }
        return null;
    }

    public static final RightPanel getEditor(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof RightPanel) {
            return (RightPanel)source;
        }
        return null;
    }

    public static class SelectAction
    extends AbstractAction {
        private static final long serialVersionUID = 6501585024845668187L;

        public SelectAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = GraphActions.getGraph(e);
            if (graph != null) {
                String name = this.getValue("Name").toString();
                if (name.equalsIgnoreCase("selectAll")) {
                    graph.selectAll();
                } else if (name.equalsIgnoreCase("selectNone")) {
                    graph.clearSelection();
                } else if (name.equalsIgnoreCase("selectNext")) {
                    graph.selectNextCell();
                } else if (name.equalsIgnoreCase("selectPrevious")) {
                    graph.selectPreviousCell();
                } else if (name.equalsIgnoreCase("selectParent")) {
                    graph.selectParentCell();
                } else if (name.equalsIgnoreCase("vertices")) {
                    graph.selectVertices();
                } else if (name.equalsIgnoreCase("edges")) {
                    graph.selectEdges();
                } else {
                    graph.selectChildCell();
                }
            }
        }
    }

    public static class ZoomAction
    extends AbstractAction {
        private static final long serialVersionUID = -6311444995358312531L;
        private String zoomModel;

        public ZoomAction(String zoomModel) {
            this.zoomModel = zoomModel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RightPanel editor = GraphActions.getEditor(e);
            if (editor != null) {
                if (StringUtil.isEmpty((String)this.zoomModel)) {
                    return;
                }
                if (GraphActions.ZOOM_IN.equals(this.zoomModel)) {
                    editor.zoomIn();
                } else if (GraphActions.ZOOM_OUT.equals(this.zoomModel)) {
                    editor.zoomOut();
                } else if (GraphActions.ZOOM_ACTUAL.equals(this.zoomModel)) {
                    editor.zoomActual();
                } else if (GraphActions.ZOOM_CENTER.equals(this.zoomModel)) {
                    editor.setPageVisible(true);
                    editor.zoomAndCenter();
                    mxGraph graph = GraphActions.getGraph(e);
                    graph.groupCells(null, -1.0, graph.getSelectionCells());
                }
            }
        }
    }

    public static class HistoryAction
    extends AbstractAction {
        protected boolean undo;

        public HistoryAction(boolean undo) {
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RightPanel editor = GraphActions.getEditor(e);
            if (editor != null) {
                if (this.undo) {
                    editor.getUndoManager().undo();
                } else {
                    editor.getUndoManager().redo();
                }
            }
        }
    }

    public static class AlignCellsAction
    extends AbstractAction {
        private static final long serialVersionUID = 2556251973959636771L;
        protected String align;

        public AlignCellsAction(String align) {
            this.align = align;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = GraphActions.getGraph(e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.alignCells(this.align);
            }
        }
    }

    public static class MoveCellAction
    extends AbstractAction {
        private static final long serialVersionUID = -7971908047885927534L;

        public MoveCellAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = GraphActions.getGraph(e);
            if (graph != null) {
                Object[] cells = graph.getSelectionCells();
                int len = cells.length;
                for (int i = 0; i < len; ++i) {
                    if (len != 1 || !((mxCell)cells[i]).isEdge()) continue;
                    return;
                }
                String name = this.getValue("Name").toString();
                if ("MOVEUP".equalsIgnoreCase(name)) {
                    graph.moveCells(graph.getSelectionCells(), 0.0, -1.0);
                } else if ("MOVEDOWN".equalsIgnoreCase(name)) {
                    graph.moveCells(graph.getSelectionCells(), 0.0, 1.0);
                } else if ("MOVELEFT".equalsIgnoreCase(name)) {
                    graph.moveCells(graph.getSelectionCells(), -1.0, 0.0);
                } else if ("MOVERIGHT".equalsIgnoreCase(name)) {
                    graph.moveCells(graph.getSelectionCells(), 1.0, 0.0);
                }
            }
        }
    }

    public static class RemoveFromParentAction
    extends AbstractAction {
        private static final long serialVersionUID = 7169443038859140811L;

        public RemoveFromParentAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = GraphActions.getGraph(e);
            if (graph != null) {
                graph.removeCellsFromParent();
            }
        }
    }

    public static class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -8212339796803275529L;

        public DeleteAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = GraphActions.getGraph(e);
            if (graph != null) {
                graph.removeCells();
            }
        }
    }

    public static class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 4610112721356742702L;

        public EditAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof RightPanel) {
                ((RightPanel)e.getSource()).startEditing();
            }
        }
    }
}

