/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.expression;

import java.util.regex.Pattern;

class ExpressionUtils {
    private static final Pattern PATTERN_NUMBER = Pattern.compile("^([-]?\\d+([.]\\d+)?)$");
    private static final Pattern PATTERN_VARIABLE = Pattern.compile("^([_a-zA-Z]+\\w*([.][_a-zA-Z]+\\w*)*)$");

    ExpressionUtils() {
    }

    static boolean isNumber(String expression) {
        return PATTERN_NUMBER.matcher(expression).find();
    }

    static boolean isNull(String expression) {
        return null == expression || "null".equalsIgnoreCase(expression);
    }

    static boolean isBoolean(String expression) {
        return "true".equalsIgnoreCase(expression) || "false".equalsIgnoreCase(expression);
    }

    public static boolean isVariable(String expression) {
        return PATTERN_VARIABLE.matcher(expression).find();
    }
}

