/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.expression;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.scm.framework.bizflow.expression.ComparisonExpressions;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicExpressions {
    private static final Logger logger = LoggerFactory.getLogger(LogicExpressions.class);
    private String expression;
    private List<Object> postfixList;
    public static final String RESOURCEPATH = "com.kingdee.eas.scm.framework.bizflow.BizProcessResource";

    public LogicExpressions(String expression) throws BOSException {
        this.expression = expression;
        this.parse();
    }

    public boolean getResult(IObjectValue info) throws BOSException {
        if (null == info) {
            logger.error("info\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8868\u8fbe\u5f0f\u65e0\u6cd5\u8ba1\u7b97\uff1a" + this.expression);
            return false;
        }
        return this.execute(info);
    }

    private void parse() throws BOSException {
        if (StringUtils.isEmpty((String)this.expression)) {
            logger.error("expression\u8868\u8fbe\u5f0f\u4e3a\u7a7a\uff0c\u6761\u4ef6\u8868\u8fbe\u5f0f\u65e0\u6cd5\u89e3\u6790");
            return;
        }
        Stack<Object> stack = this.parse2NifixExpression();
        this.debugStackInfo(stack);
        List<Object> postfixList = this.parse2PostfixExpression(stack);
        this.setPostfixList(postfixList);
    }

    private void setPostfixList(List<Object> postfixList) {
        this.postfixList = postfixList;
    }

    private void debugStackInfo(Stack<Object> stack) {
        if (!logger.isDebugEnabled()) {
            return;
        }
    }

    private boolean execute(IObjectValue info) throws BOSException {
        if (null == this.postfixList || this.postfixList.size() == 0) {
            return false;
        }
        Stack<ComparisonExpressions> operandStack = new Stack<ComparisonExpressions>();
        for (Object obj : this.postfixList) {
            if (this.isCharacter(obj)) {
                ComparisonExpressions comExpr1 = (ComparisonExpressions)operandStack.pop();
                ComparisonExpressions comExpr2 = (ComparisonExpressions)operandStack.pop();
                Character c = (Character)obj;
                boolean result = false;
                if (c.charValue() == '|') {
                    result = comExpr1.getValue(info) || comExpr2.getValue(info);
                } else if (c.charValue() == '&') {
                    result = comExpr1.getValue(info) && comExpr2.getValue(info);
                }
                operandStack.push(new ComparisonExpressions(result));
                continue;
            }
            if (!this.isComparisonExpression(obj)) continue;
            operandStack.push((ComparisonExpressions)obj);
        }
        if (operandStack.isEmpty()) {
            return false;
        }
        return ((ComparisonExpressions)operandStack.pop()).getValue(info);
    }

    private Stack<Object> parse2NifixExpression() throws BOSException {
        char[] charArray;
        boolean isInCharArray = false;
        Stack<Object> stack = new Stack<Object>();
        StringBuilder sb = new StringBuilder();
        char preChar = '\u0000';
        block7: for (char c : charArray = this.expression.trim().toCharArray()) {
            switch (c) {
                case '(': {
                    if (isInCharArray) {
                        sb.append(c);
                        break;
                    }
                    stack.push(Character.valueOf('('));
                    break;
                }
                case ')': {
                    ComparisonExpressions compExpr;
                    if (isInCharArray) {
                        sb.append(c);
                        break;
                    }
                    Object pre = stack.peek();
                    if (Character.valueOf('(').equals(pre)) {
                        stack.pop();
                        if (sb.length() > 0) {
                            compExpr = new ComparisonExpressions(sb.toString());
                            stack.push(compExpr);
                            sb.setLength(0);
                            break;
                        }
                        throw new BOSException(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
                    }
                    if (Character.valueOf('|').equals(pre) || Character.valueOf('&').equals(pre)) {
                        compExpr = new ComparisonExpressions(sb.toString());
                        stack.push(compExpr);
                        stack.push(Character.valueOf(')'));
                        sb.setLength(0);
                        break;
                    }
                    stack.push(Character.valueOf(')'));
                    break;
                }
                case '&': 
                case '|': {
                    if (isInCharArray) {
                        sb.append(c);
                        break;
                    }
                    if (preChar != c) break;
                    if (sb.length() > 0) {
                        if (!stack.isEmpty() && stack.peek() instanceof ComparisonExpressions) {
                            throw new IllegalAccessError(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
                        }
                        ComparisonExpressions compExpr = new ComparisonExpressions(sb.toString());
                        stack.push(compExpr);
                        sb.setLength(0);
                    }
                    stack.push(c == '|' ? Character.valueOf('|') : Character.valueOf('&'));
                    break;
                }
                case '\'': {
                    if (preChar != '\\') {
                        isInCharArray = !isInCharArray;
                    }
                    sb.append(c);
                    break;
                }
                case ' ': {
                    if (!isInCharArray) continue block7;
                    sb.append(c);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            preChar = c;
        }
        if (sb.length() > 0) {
            stack.push(new ComparisonExpressions(sb.toString()));
        } else if (preChar != ')') {
            throw new BOSException(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
        }
        return stack;
    }

    private List<Object> parse2PostfixExpression(Stack<Object> stack) throws BOSException {
        if (stack == null || stack.isEmpty() || stack.size() == 1) {
            return stack;
        }
        ArrayList<Object> postfixList = new ArrayList<Object>();
        Stack<Character> operator = new Stack<Character>();
        block6: for (Object e : stack) {
            if (this.isComparisonExpression(e)) {
                postfixList.add(e);
                continue;
            }
            if (!this.isCharacter(e)) continue;
            Character c = (Character)e;
            switch (c.charValue()) {
                case '(': {
                    operator.push(c);
                    break;
                }
                case ')': {
                    Character ch = null;
                    while (!operator.isEmpty() && (ch = (Character)operator.pop()).charValue() != '(') {
                        postfixList.add(ch);
                    }
                    if (ch != null && ch.charValue() == '(') continue block6;
                    throw new BOSException(EASResource.getString((String)RESOURCEPATH, (String)"54_ExpressionError"));
                }
                case '|': {
                    Character character;
                    while (!operator.isEmpty() && (character = (Character)operator.peek()).charValue() != '(') {
                        postfixList.add(operator.pop());
                    }
                    operator.push(c);
                    break;
                }
                case '&': {
                    Character character;
                    while (!operator.isEmpty() && (character = (Character)operator.peek()).charValue() == '&') {
                        postfixList.add(operator.pop());
                    }
                    operator.push(c);
                }
            }
        }
        while (!operator.isEmpty()) {
            postfixList.add(operator.pop());
        }
        return postfixList;
    }

    private boolean isCharacter(Object obj) {
        return null != obj && obj instanceof Character;
    }

    private boolean isComparisonExpression(Object obj) {
        return null != obj && obj instanceof ComparisonExpressions;
    }
}

