/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IFilterPanel;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.scm.framework.client.CommonFilterConstant;
import com.kingdee.eas.scm.framework.client.CommonFilterPanelUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JScrollBar;

public abstract class BaseCommonFilterPanel
extends CustomerQueryPanel
implements IFilterPanel {
    private static final long serialVersionUID = 1L;
    public static final String commonFilterRes = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";
    private int SPACE = 3;
    private int SMALL_SPACE = 1;
    private int SMALL_BUTTON_WIDTH = 22;
    private int SMALL_BUTTON_HEIGHT = 19;
    protected KDTable kdtTable;
    private KDWorkButton addRowButton;
    private KDWorkButton delRowButton;
    private KDWorkButton clearButton;
    private int width;
    private int height;
    private String panelName;
    private int defaultRows = 10;
    private int[] FILTER_COLUMN_WIDTHs;
    protected FilterInfo filterInfo;

    public BaseCommonFilterPanel(FilterInfo filterInfo, int width, int height, int defaultRows) throws Exception {
        this.filterInfo = filterInfo;
        this.width = width;
        this.height = height;
        this.defaultRows = defaultRows;
        this.FILTER_COLUMN_WIDTHs = this.calculateWidths();
    }

    protected abstract void loadCondition(int var1, RowObject var2) throws Exception;

    protected abstract void loadCompareValue(int var1, RowObject var2) throws Exception;

    protected abstract void setConditionCell(int var1) throws Exception;

    protected void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtTable.getRow(rowIndex);
        if (row.getCell(1).getValue() == null) {
            row.getCell(2).getStyleAttributes().setLocked(true);
            row.getCell(3).getStyleAttributes().setLocked(true);
        } else {
            row.getCell(2).getStyleAttributes().setLocked(false);
            row.getCell(3).getStyleAttributes().setLocked(false);
            row.getCell(2).setValue((Object)CompareSignEnum.EQUALSSIGN);
        }
    }

    protected abstract void editedCompareValueCellAfter(KDTEditEvent var1) throws Exception;

    protected String getConditionString(IRow iRow) throws Exception {
        return iRow.getCell(1).getValue().toString();
    }

    protected Object getCompareValue(IRow iRow) throws Exception {
        return iRow.getCell(3).getValue();
    }

    protected void setCurrentFilterInfo() throws Exception {
        int rowCount = this.kdtTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            FilterItemInfo filterItemInfo;
            String compare;
            if (this.isBlankRow(i)) continue;
            IRow iRow = this.kdtTable.getRow(i);
            String leftBracket = Util.getValue((Object)iRow.getCell(0).getValue()).toString();
            String conditionStr = this.getConditionString(iRow);
            String rightBracket = Util.getValue((Object)iRow.getCell(4).getValue()).toString();
            String logic = Util.getValue((Object)iRow.getCell(5).getValue()).toString();
            if (logic == null || "".equals(logic)) {
                logic = "AND";
            }
            if ("left like".equals(compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase()) || "right like".equals(compare)) {
                compare = "like";
            } else if ("not left like".equals(compare)) {
                compare = "not like";
            }
            if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                filterItemInfo = new FilterItemInfo(conditionStr, null, CompareType.EQUALS);
                newFilterInfo.getFilterItems().add(filterItemInfo);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                continue;
            }
            if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                filterItemInfo = new FilterItemInfo(conditionStr, null, CompareType.NOTEQUALS);
                newFilterInfo.getFilterItems().add(filterItemInfo);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                continue;
            }
            Object compareValue = this.getCompareValue(iRow);
            if (compare.equalsIgnoreCase("IN") || compare.equalsIgnoreCase("NOT IN")) {
                compareValue = compareValue.toString();
            }
            if (compareValue instanceof Date) {
                SimpleDateFormat sic = new SimpleDateFormat("yyyy-MM-dd");
                compareValue = sic.parse(sic.format(compareValue));
            }
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionStr, compareValue, CompareType.getEnum((String)compare));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
            sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
        }
        String strFormula = sbFormula.toString();
        if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
            if ((strFormula = strFormula.trim()).endsWith("AND")) {
                strFormula = strFormula.substring(0, strFormula.length() - "AND".length());
            }
            newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
        }
        this.filterInfo = newFilterInfo;
    }

    protected int[] calculateWidths() {
        int unit = (this.width - 8 - 8) / 5;
        return new int[]{unit / 2, unit, unit, unit, unit / 2, unit - 45};
    }

    public int getWidth() {
        return this.width;
    }

    protected void jbInit() throws Exception {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addRowButton = new KDWorkButton();
        this.addRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.addRowButton.setToolTipText(EASResource.getString((String)commonFilterRes, (String)"addRow"));
        this.addRowButton.setBounds(this.width - (this.SMALL_BUTTON_WIDTH + this.SPACE) * 3, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCommonFilterPanel.this.addRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.addRowButton);
        this.delRowButton = new KDWorkButton();
        this.delRowButton.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.delRowButton.setToolTipText(EASResource.getString((String)commonFilterRes, (String)"removeRow"));
        this.delRowButton.setBounds(this.width - (this.SMALL_BUTTON_WIDTH + this.SPACE) * 2, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.delRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCommonFilterPanel.this.delRowButton_actionPerformed(e);
            }
        });
        this.add((Component)this.delRowButton);
        this.clearButton = new KDWorkButton();
        this.clearButton.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.clearButton.setToolTipText(EASResource.getString((String)commonFilterRes, (String)"clear"));
        this.clearButton.setBounds(this.width - this.SMALL_BUTTON_WIDTH - this.SPACE, this.SPACE, this.SMALL_BUTTON_WIDTH, this.SMALL_BUTTON_HEIGHT);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCommonFilterPanel.this.clearButton_actionPerformed(e);
            }
        });
        this.add((Component)this.clearButton);
        this.kdtTable = new KDTable();
        this.initTable();
        this.kdtTable.setBounds(this.SPACE, this.SPACE + this.SMALL_BUTTON_HEIGHT + this.SMALL_SPACE, this.width - this.SPACE * 2, this.height - this.SPACE * 3 - this.SMALL_BUTTON_HEIGHT);
        this.add((Component)this.kdtTable);
    }

    protected void initTable() throws Exception {
        this.kdtTable.removeColumns();
        int columnSize = CommonFilterConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.kdtTable.addColumn();
            iColumn.setWidth(this.FILTER_COLUMN_WIDTHs[i]);
        }
        IRow headRow = this.kdtTable.addHeadRow();
        for (int i = 0; i < columnSize; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)CommonFilterConstant.FILTER_COLUMN_CODEs[i]));
        }
        this.fillFilterTableBody();
        this.addTableListener();
        this.kdtTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kdtTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.fillLeftRows();
    }

    protected void fillFilterTableBody() throws Exception {
        if (this.filterInfo == null) {
            return;
        }
        int filterSize = this.filterInfo.getFilterItems().size();
        ArrayList rowInfos = CommonFilterPanelUtil.getRowInfos(this.filterInfo);
        for (int i = 0; i < filterSize; ++i) {
            RowObject rowObject = (RowObject)rowInfos.get(i);
            FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
            this.kdtTable.addRow(i);
            rowObject.setLeftBracket(rowObject.getLeftBracket());
            rowObject.setCondition(filterItemInfo.getPropertyName());
            if (filterItemInfo.getCompareValue() == null) {
                if (CompareType.EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    rowObject.setCompare(CompareType.EMPTY.getName());
                } else {
                    rowObject.setCompare(CompareType.NOTEMPTY.getName());
                }
            } else {
                rowObject.setCompare(filterItemInfo.getCompareType().getName());
            }
            rowObject.setCompareValue(filterItemInfo.getCompareValue());
            rowObject.setRightBracket(rowObject.getRightBracket());
            rowObject.setLogic(rowObject.getLogic());
            this.loadFilter(i, rowObject);
        }
    }

    private void addTableListener() {
        this.kdtTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BaseCommonFilterPanel.this.kdtTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kdtTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BaseCommonFilterPanel.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    protected void kdtTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int columnIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 1: {
                    break;
                }
                case 2: {
                    this.setCompareSignCell(rowIndex);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private void increaseRow(KDTEditEvent e) throws Exception {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && rowIndex == this.kdtTable.getRowCount() - 1 && (object = this.kdtTable.getRow(rowIndex).getCell(5).getValue()) != null && object.toString() != null && !this.isBlankRow(rowIndex) && !this.checkCurrentHasBlankCol(rowIndex)) {
            this.addRow();
        }
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kdtTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null) {
            if (colIndex == 1) {
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(2));
                this.resetCell(this.kdtTable.getRow(rowIndex).getCell(3));
            }
            return;
        }
        switch (colIndex) {
            case 1: {
                this.editedCondtionCellAfter(e);
                return;
            }
            case 2: {
                this.editedCompareSignCellAfter(e);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
        }
    }

    protected void editedCompareSignCellAfter(KDTEditEvent e) throws Exception {
        IRow row = this.kdtTable.getRow(e.getRowIndex());
        ICell iCell = row.getCell(3);
        ICell iSignCell = row.getCell(2);
        Object signValue = iSignCell.getValue();
        String filterCompareSign = Util.getValue((Object)signValue).toString();
        if (CommonFilterUtil.isNullJudge((String)filterCompareSign)) {
            iCell.setValue(null);
            iCell.getStyleAttributes().setLocked(true);
            return;
        }
    }

    protected void initTableEditor(int rowIndex) throws Exception {
        this.setLeftBracketCell(rowIndex);
        this.setConditionCell(rowIndex);
        this.setRightBracketCell(rowIndex);
        this.setLogicSignCell(rowIndex);
    }

    protected void setLeftBracketCell(int rowIndex) {
        int columnIndex = 0;
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(columnIndex);
        if (iCell.getEditor() == null) {
            CommonFilterPanelUtil.setComboBoxField(iCell, CommonFilterPanelUtil.addObjectToArray(LeftBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    protected void setRightBracketCell(int rowIndex) {
        int columnIndex = 4;
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(columnIndex);
        if (iCell.getEditor() == null) {
            CommonFilterPanelUtil.setComboBoxField(iCell, CommonFilterPanelUtil.addObjectToArray(RightBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    protected void setLogicSignCell(int rowIndex) {
        int columnIndex = 5;
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(columnIndex);
        if (iCell.getEditor() == null) {
            CommonFilterPanelUtil.setComboBoxField(iCell, CommonFilterPanelUtil.addObjectToArray(LogicSignEnum.getEnumList().toArray(), null));
        }
    }

    protected void setCompareSignCell(int rowIndex) {
        int columnIndex = 2;
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(columnIndex);
        if (this.kdtTable.getRow(rowIndex).getCell(1).getValue() == null) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            if (iCell.getEditor() == null) {
                CommonFilterPanelUtil.setComboBoxField(iCell, CommonFilterPanelUtil.addObjectToArray(this.getCompareSignEnumArray().toArray(), null));
            }
        }
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws Exception {
        int length = CommonFilterConstant.FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    private void loadLeftBracket(int rowIndex, RowObject rowObject) {
        List valueList = EnumUtils.getEnumList((String)LeftBracketSignEnum.class.getName());
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(0);
        CommonFilterPanelUtil.setEnumComboBoxField(iCell, valueList, rowObject.getLeftBracket());
    }

    protected void loadCompareSign(int rowIndex, RowObject rowObject) {
        Object compareValue = rowObject.getCompareValue();
        String compare = null;
        if (compareValue == null) {
            compare = rowObject.getCompare();
            if (!"is".equalsIgnoreCase(compare) && !"is not".equalsIgnoreCase(compare)) {
                return;
            }
        } else {
            compare = compareValue.toString().startsWith("%") && !compareValue.toString().endsWith("%") ? "right like" : (!compareValue.toString().startsWith("%") && compareValue.toString().endsWith("%") ? (rowObject.getCompare().toString().equalsIgnoreCase("not like") ? "NOT LEFT LIKE" : "left like") : rowObject.getCompare());
        }
        List<CompareSignEnum> valueList = this.getCompareSignEnumArray();
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(2);
        CommonFilterPanelUtil.setEnumComboBoxField(iCell, valueList, compare);
    }

    protected void loadRightBracket(int rowIndex, RowObject rowObject) {
        List valueList = EnumUtils.getEnumList((String)RightBracketSignEnum.class.getName());
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(4);
        CommonFilterPanelUtil.setEnumComboBoxField(iCell, valueList, rowObject.getRightBracket());
    }

    protected void loadLogicSign(int rowIndex, RowObject rowObject) {
        List valueList = EnumUtils.getEnumList((String)LogicSignEnum.class.getName());
        ICell iCell = this.kdtTable.getRow(rowIndex).getCell(5);
        CommonFilterPanelUtil.setEnumComboBoxField(iCell, valueList, rowObject.getLogic());
    }

    private void fillLeftRows() throws Exception {
        int rowCount = this.kdtTable.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                IRow row = this.kdtTable.addRow();
                this.initTableEditor(row.getRowIndex());
            }
        }
    }

    public void reInitCondition() throws Exception {
        for (int i = 0; i < this.kdtTable.getRowCount(); ++i) {
            this.setConditionCell(i);
        }
        this.clear();
    }

    public void reInitTable() throws Exception {
        this.remove((Component)this.kdtTable);
        this.initTable();
        this.kdtTable.setBounds(this.SPACE, this.SPACE + this.SMALL_BUTTON_HEIGHT + this.SMALL_SPACE, this.width - this.SPACE * 2, this.height - this.SPACE * 3 - this.SMALL_BUTTON_HEIGHT);
        this.add((Component)this.kdtTable);
        this.validate();
        this.repaint();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearTable();
        this.setFilterInfo(entityViewInfo.getFilter());
        try {
            this.fillFilterTableBody();
            this.fillLeftRows();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void resetCell(ICell cell) {
        cell.setEditor(null);
        cell.setValue(null);
        if (cell.getStyleAttributes() != null) {
            cell.getStyleAttributes().setNumberFormat("");
        }
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        try {
            this.addRow();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex > -1) {
            this.delRow();
        }
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    private void addRow() throws Exception {
        int currentRowSize = this.kdtTable.getRowCount();
        this.kdtTable.addRow(currentRowSize);
        this.initTableEditor(currentRowSize);
    }

    private void delRow() {
        int selectedRowIndex = this.kdtTable.getSelectManager().getActiveRowIndex();
        this.kdtTable.removeRow(selectedRowIndex);
    }

    protected void clearTable() {
        this.kdtTable.removeRows();
    }

    public void clear() {
        this.clearTable();
        try {
            this.fillLeftRows();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public FilterInfo getFilterInfo() {
        try {
            this.setCurrentFilterInfo();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return this.filterInfo;
    }

    public FilterInfo getInnerFilterInfo() {
        return this.getFilterInfo();
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public boolean verify() {
        boolean flag = true;
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        return flag;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = CommonFilterConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            if (Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    protected boolean checkInvaildFilter() {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i) || !this.checkCurrentHasBlankCol(i)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkCurrentHasBlankCol(int rowIndex) {
        boolean flag = false;
        int columnSize = CommonFilterConstant.FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue;
            if (i == 0 || i == 4) continue;
            if (i == 5) {
                if (this.isLastUsefulRow(rowIndex)) {
                    return !this.isExistLogicSign(rowIndex);
                }
                filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue();
                if (filterValue == null || filterValue.toString().trim().length() == 0) {
                    this.kdtTable.getRow(rowIndex).getCell(i).setValue((Object)LogicSignEnum.AND);
                }
            }
            if ((filterValue = this.kdtTable.getRow(rowIndex).getCell(i).getValue()) == null) {
                String compareSign = Util.getValue((Object)this.kdtTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (compareSign.equalsIgnoreCase("YESTERDAY") || compareSign.equalsIgnoreCase("TODAY") || compareSign.equalsIgnoreCase("TOMORROW") || compareSign.equalsIgnoreCase("LASTWEEK") || compareSign.equalsIgnoreCase("THISWEEK") || compareSign.equalsIgnoreCase("NEXTWEEK") || compareSign.equalsIgnoreCase("LASTMONTH") || compareSign.equalsIgnoreCase("THISMONTH") || compareSign.equalsIgnoreCase("NEXTMONTH") || compareSign.equalsIgnoreCase("BEFORETODAY") || compareSign.equalsIgnoreCase("AFTERTODAY") || compareSign.equalsIgnoreCase("IS") || compareSign.equalsIgnoreCase("IS NOT")) {
                    if (this.kdtTable.getRow(rowIndex).getCell(3).getValue() != null) continue;
                    continue;
                }
                return true;
            }
            String strFilterValue = filterValue.toString();
            if (strFilterValue == null) {
                return true;
            }
            if (!strFilterValue.trim().equalsIgnoreCase("")) continue;
            return true;
        }
        return flag;
    }

    protected boolean isLastUsefulRow(int rowIndex) {
        int rowCount = this.kdtTable.getRowCount();
        for (int i = rowIndex + 1; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExistLogicSign(int rowIndex) {
        Object object = this.kdtTable.getRow(rowIndex).getCell(5).getValue();
        return object == null || object.toString() == null || object.toString().equalsIgnoreCase("");
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.kdtTable.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketSignEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = null;
            object = this.kdtTable.getRow(i).getCell(0).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketSignEnum)object) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.kdtTable.getRow(i).getCell(4).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketSignEnum)object) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    protected List<CompareSignEnum> getCompareSignEnumArray() {
        ArrayList<CompareSignEnum> compareSignList = new ArrayList<CompareSignEnum>();
        compareSignList.add(CompareSignEnum.EQUALSSIGN);
        compareSignList.add(CompareSignEnum.NOTEQULASSIGN);
        compareSignList.add(CompareSignEnum.LARGESIGN);
        compareSignList.add(CompareSignEnum.LARGEEQUALSSIGN);
        compareSignList.add(CompareSignEnum.SMALLSIGN);
        compareSignList.add(CompareSignEnum.SMALLEQUALSSIGN);
        compareSignList.add(CompareSignEnum.LIKESIGN);
        compareSignList.add(CompareSignEnum.NULLSIGN);
        compareSignList.add(CompareSignEnum.NOTNULLSIGN);
        compareSignList.add(CompareSignEnum.INCLUDESIGN);
        compareSignList.add(CompareSignEnum.NOTINCLUDESIGN);
        compareSignList.add(CompareSignEnum.RIGHTLIKESIGN);
        compareSignList.add(CompareSignEnum.LEFTLIKESIGN);
        compareSignList.add(CompareSignEnum.NOTLIKESIGN);
        return compareSignList;
    }
}

