/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.client;

import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.scm.framework.util.SCMMDUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public final class CommonFilterPanelUtil {
    public static final String DEFAULT_F7_UI = "defaultF7UI";
    public static final String DEFAULT_F7_QUERY = "defaultF7Query";

    public static KDDatePicker setDateCtrlField(ICell iCell, Date initData) {
        KDDatePicker datePicker = new KDDatePicker();
        datePicker.setTimeEnabled(true);
        datePicker.setValue((Object)initData);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        return datePicker;
    }

    public static KDTextField setTextFieldCell(ICell iCell, String value) {
        KDTextField field = new KDTextField();
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
        iCell.setValue((Object)value);
        return field;
    }

    public static KDBizPromptBox createF7WithBosType(String bosType) {
        KDBizPromptBox f7Ctrl = null;
        f7Ctrl = new KDBizPromptBox();
        ExtendParser parser = new ExtendParser(f7Ctrl);
        f7Ctrl.setCommitParser((IParser)parser);
        f7Ctrl.setDisplayFormat("$name$");
        f7Ctrl.setEditFormat("$number$");
        f7Ctrl.setCommitFormat("$number$");
        f7Ctrl.setEditable(true);
        EntityObjectInfo entity = SCMMDUtil.getEntityByBosType(bosType);
        String defaultF7UI = entity.getExtendedProperty(DEFAULT_F7_UI);
        String defaultF7Query = entity.getExtendedProperty(DEFAULT_F7_QUERY);
        if (!StringUtil.isEmpty((String)defaultF7UI)) {
            f7Ctrl.setDefaultF7UIName(defaultF7UI);
        }
        if (StringUtil.isEmpty((String)defaultF7Query)) {
            return null;
        }
        f7Ctrl.setQueryInfo(defaultF7Query);
        return f7Ctrl;
    }

    public static KDComboBox setBooleanComboBox(ICell iCell, int value) {
        Object[] boolValue = BooleanEnum.getEnumList().toArray();
        boolValue = CommonFilterPanelUtil.addObjectToArray(boolValue, null);
        KDComboBox kdComboBox = new KDComboBox(boolValue);
        kdComboBox.setMaximumRowCount(10);
        BooleanEnum booleanValue = BooleanEnum.getEnum((int)value);
        if (booleanValue != null) {
            kdComboBox.setSelectedIndex(1 - booleanValue.getValue());
            kdComboBox.setSelectedItem((Object)booleanValue);
        }
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        iCell.setValue((Object)booleanValue);
        return kdComboBox;
    }

    public static KDComboBox setComboBoxField(ICell iCell, Object[] objs) {
        KDComboBox kdComboBox = new KDComboBox(objs);
        kdComboBox.setMaximumRowCount(10);
        kdComboBox.setCanSearch(true);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        return kdComboBox;
    }

    public static KDComboBox setEnumComboBoxField(ICell iCell, List valueList, String fieldValue) {
        Object[] array = valueList.toArray();
        Object[] temp = CommonFilterPanelUtil.addObjectToArray(array, "");
        KDComboBox comboBox = CommonFilterPanelUtil.setComboBoxField(iCell, temp);
        comboBox.setMaximumRowCount(10);
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        for (int i = 0; i < count; ++i) {
            Object obj = comboBox.getItemAt(i);
            Object value = null;
            if (obj == null || !(obj instanceof Enum) || !(value = CommonFilterPanelUtil.getEnumValue((Enum)obj)).toString().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem(temp[selectedIndex]);
        iCell.setValue(comboBox.getItemAt(selectedIndex));
        return comboBox;
    }

    public static KDComboBox setEnumComboBoxField(ICell iCell, String enumClassName, String fieldValue) {
        List list = EnumUtils.getEnumList((String)enumClassName);
        return CommonFilterPanelUtil.setEnumComboBoxField(iCell, list, fieldValue);
    }

    public static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        }
        return value;
    }

    public static Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] DEFAULT_OBJECTs = new Object[]{insertObject};
        if (objects == null) {
            return DEFAULT_OBJECTs;
        }
        int length = objects.length;
        if (length == 0) {
            return DEFAULT_OBJECTs;
        }
        Object[] results = new Object[length + 1];
        results[0] = DEFAULT_OBJECTs[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }

    public static boolean isNullJudge(Object compare) {
        return compare != null && (compare.equals(CompareSignEnum.NULLSIGN) || compare.equals("IS") || compare.equals(CompareSignEnum.NOTNULLSIGN) || compare.equals("IS NOT"));
    }

    public static ArrayList getRowInfos(FilterInfo filterInfo) {
        int size;
        char[] exp;
        int size2;
        ArrayList<RowObject> target = new ArrayList<RowObject>();
        String expression = filterInfo.getMaskString();
        if (StringUtils.isEmpty((String)expression) && (size2 = filterInfo.getFilterItems().size()) > 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < size2; ++i) {
                if (i == size2 - 1) {
                    buffer.append("#").append(i);
                    continue;
                }
                buffer.append("#").append(i).append(" AND ");
            }
            expression = buffer.toString();
        }
        if ((exp = (expression = expression + " AND ").toLowerCase().toCharArray()) != null) {
            int length = exp.length;
            StringBuffer leftBracket = new StringBuffer();
            StringBuffer rightBracket = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                RowObject rowObject;
                char c = exp[i];
                if ("(".equalsIgnoreCase(String.valueOf(c))) {
                    leftBracket.append(String.valueOf(c));
                    continue;
                }
                if (")".equalsIgnoreCase(String.valueOf(c))) {
                    rightBracket.append(String.valueOf(c));
                    continue;
                }
                if ("A".equalsIgnoreCase(String.valueOf(c))) {
                    rowObject = new RowObject();
                    rowObject.setLeftBracket(leftBracket.toString());
                    rowObject.setRightBracket(rightBracket.toString());
                    rowObject.setLogic("AND");
                    target.add(rowObject);
                    leftBracket = new StringBuffer();
                    rightBracket = new StringBuffer();
                    continue;
                }
                if (!"O".equalsIgnoreCase(String.valueOf(c))) continue;
                rowObject = new RowObject();
                rowObject.setLeftBracket(leftBracket.toString());
                rowObject.setRightBracket(rightBracket.toString());
                rowObject.setLogic("OR");
                target.add(rowObject);
                leftBracket = new StringBuffer();
                rightBracket = new StringBuffer();
            }
        }
        if ((size = target.size()) > 0) {
            ((RowObject)target.get(size - 1)).setLogic("");
        }
        return target;
    }

    public static boolean isFieldJudge(String compare) {
        return compare != null && (compare.equalsIgnoreCase(CompareSignEnum.FIELDEQUAL.toString()) || compare.equalsIgnoreCase(CompareSignEnum.FIELDNOTEQUAL.toString()) || compare.equalsIgnoreCase("FIELDEQUAL") || compare.equalsIgnoreCase("FIELDNOTEQUAL") || compare.equalsIgnoreCase("FIELDLARGE") || compare.equalsIgnoreCase(CompareSignEnum.FIELDLARGE.toString()) || compare.equalsIgnoreCase("FIELDLARGEEQUAL") || compare.equalsIgnoreCase(CompareSignEnum.FIELDLARGEEQUAL.toString()) || compare.equalsIgnoreCase("FIELDLESS") || compare.equalsIgnoreCase(CompareSignEnum.FIELDLESS.toString()) || compare.equalsIgnoreCase("FIELDLESSEQUAL") || compare.equalsIgnoreCase(CompareSignEnum.FIELDLESSEQUAL.toString()));
    }

    public static Vector processStringValue(String str) {
        Vector<String> vect = new Vector<String>();
        if (str.indexOf(",") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else {
            vect.add(str);
        }
        return vect;
    }
}

