/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.condition.AccessSequenceFactory;
import com.kingdee.eas.scm.framework.condition.AccessSequenceInfo;
import com.kingdee.eas.scm.framework.condition.AccessesInfo;
import com.kingdee.eas.scm.framework.condition.ConditionTableInfo;
import com.kingdee.eas.scm.framework.condition.IAccessSequence;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeFactory;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeInfo;
import com.kingdee.eas.scm.framework.condition.client.AbstractAccessSequenceEditUI;
import com.kingdee.eas.scm.framework.condition.client.formula.RequirementFormulaUI;
import com.kingdee.eas.scm.framework.condition.formula.RequiremenFormula;
import com.kingdee.eas.scm.framework.condition.util.ConditionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AccessSequenceEditUI
extends AbstractAccessSequenceEditUI {
    private static final long serialVersionUID = -6575438625360309329L;
    private static final String CL_CONTABNUM = "conTabNum";
    private static final String CL_CONTABNAME = "conTabName";
    private static final String CL_DESCRIPTION = "description";
    private static final String TB_COLNAME_STEP = "no";
    private static final String TB_COLNAME_REQUIREMENT_EXPER = "requirementExper";
    private static final String TB_COLNAME_REQUIREMENT_ALIAS = "requirementAlias";
    final KDBizPromptBox prmtConditionTable = new KDBizPromptBox();
    private String bdScmRes = "com.kingdee.eas.basedata.scm.common.SCMResource";
    private String bdScmImRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";
    EntityObjectInfo entityDest = ConditionUtil.getEntityObjectInfo(null, "C48A423A");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.getDetailTable().checkParsed();
        super.onLoad();
        this.prmtConditionTable.setQueryInfo("com.kingdee.eas.scm.framework.condition.F7ConditionTableQuery");
        this.prmtConditionTable.setEditFormat("$number$");
        this.prmtConditionTable.setCommitFormat("$number$");
        this.prmtConditionTable.setDisplayFormat("$number$");
        this.getDetailTable().getColumn(CL_CONTABNUM).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtConditionTable));
        this.kdtAccesses.addKDTEditListener(new KDTEditListener(){

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                int rowIndex = e.getRowIndex();
                if (AccessSequenceEditUI.this.kdtAccesses.getColumnIndex(AccessSequenceEditUI.CL_CONTABNUM) == colIndex) {
                    ConditionTableInfo tabInfo = (ConditionTableInfo)AccessSequenceEditUI.this.kdtAccesses.getCell(rowIndex, colIndex).getValue();
                    if (null == tabInfo) {
                        AccessSequenceEditUI.this.kdtAccesses.getCell(rowIndex, AccessSequenceEditUI.CL_CONTABNAME).setValue(null);
                        AccessSequenceEditUI.this.kdtAccesses.getCell(rowIndex, AccessSequenceEditUI.CL_DESCRIPTION).setValue(null);
                    } else {
                        AccessSequenceEditUI.this.kdtAccesses.getCell(rowIndex, AccessSequenceEditUI.CL_CONTABNAME).setValue((Object)tabInfo.getName());
                        AccessSequenceEditUI.this.kdtAccesses.getCell(rowIndex, AccessSequenceEditUI.CL_DESCRIPTION).setValue((Object)tabInfo.getDescription());
                    }
                }
            }
        });
        this.prmtProcedureType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ProcedureTypeInfo oldValue = (ProcedureTypeInfo)eventObj.getOldValue();
                ProcedureTypeInfo info = (ProcedureTypeInfo)eventObj.getNewValue();
                if (null == oldValue && null == info || null != oldValue && null != info && oldValue.equals(info)) {
                    return;
                }
                AccessSequenceEditUI.this.kdtAccesses.removeRows();
                EntityViewInfo v = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("procedureType.id", (Object)info.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                v.setFilter(filter);
                AccessSequenceEditUI.this.prmtConditionTable.setEntityViewInfo(v);
            }
        });
        if (this.editData.getProcedureType() != null) {
            EntityViewInfo v = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("procedureType.id", (Object)this.editData.getProcedureType().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
            v.setFilter(filter);
            this.prmtConditionTable.setEntityViewInfo(v);
        }
    }

    protected IObjectValue createNewData() {
        AccessSequenceInfo info = new AccessSequenceInfo();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        info.setCreator(user);
        info.setLastUpdateUser(user);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        info.setCreateTime(time);
        info.setLastUpdateTime(time);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccessSequenceFactory.getRemoteInstance();
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtAccesses);
        int len = selectRows.length;
        for (i = 0; i < len; ++i) {
            AccessesInfo info = (AccessesInfo)this.kdtAccesses.getRow(i).getUserObject();
            if (info == null || !info.isSysDef()) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"ASSYSTEM_DATA_NOT_DELETE", (Object[])new Object[]{i + 1}));
            SysUtil.abort();
        }
        for (i = selectRows.length - 1; i >= 0; --i) {
            this.kdtAccesses.removeRow(i);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkProcedureTypeSelected();
        KDTable table = this.getDetailTable();
        AccessesInfo info = this.createNewDetailData(table);
        int step = this.getMaxStep() + 10;
        if (info != null) {
            IRow row = table.addRow();
            info.setNo(step);
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, (IObjectValue)info);
            this.dataBinder.loadLineFields(table, row, (IObjectValue)info);
        }
    }

    private void checkProcedureTypeSelected() {
        if (this.prmtProcedureType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"PROCEDURETYPE_ISNULL"));
            this.prmtProcedureType.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkProcedureTypeSelected();
        this.checkSelected();
        int step = this.getMaxStep() + 10;
        KDTable table = this.getDetailTable();
        AccessesInfo info = this.createNewDetailData(table);
        if (info != null) {
            int rowIndex = table.getSelectManager().get().getTop();
            IRow row = table.addRow(rowIndex + 1);
            info.setNo(step);
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, (IObjectValue)info);
            this.dataBinder.loadLineFields(table, row, (IObjectValue)info);
        }
    }

    protected void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected AccessesInfo createNewDetailData(KDTable table) {
        AccessesInfo info = new AccessesInfo();
        info.setExclusive(true);
        return info;
    }

    protected KDTable getDetailTable() {
        return this.kdtAccesses;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String message = null;
        IAccessSequence iAccessSequence = (IAccessSequence)this.getBizInterface();
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iAccessSequence.checkNumberDup(this.editData);
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setName(this.txtName.getEditor().getItem().toString().trim());
            this.txtName.requestFocus();
            iAccessSequence.checkNameDup(this.editData);
        }
        if (this.prmtProcedureType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"PROCEDURETYPE_ISNULL2"));
            this.prmtProcedureType.requestFocus();
            SysUtil.abort();
        }
        this.checkValidate();
    }

    private void checkValidate() {
        if (this.getDetailTable().getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"ENTRY_IS_NULL"));
            this.getDetailTable().requestFocus();
            SysUtil.abort();
        }
        IRow row = null;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int rowCount = this.kdtAccesses.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtAccesses.getRow(i);
            if (i == 0 && row.getCell(CL_CONTABNUM).getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"CONDITIONTABLE_IS_NULL", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (row.getCell(TB_COLNAME_STEP).getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"NUMBER_IS_NULL", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            map.put(row.getCell(TB_COLNAME_STEP).getValue(), row.getCell(TB_COLNAME_STEP).getValue());
        }
        if (rowCount != map.size()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"NUMBER_REPEAT"));
            SysUtil.abort();
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().getValue() == 1) {
            MsgBox.showInfo((String)ConditionUtil.getResourceString("ACCESSSEQ_HAS_ACTIVE"));
            SysUtil.abort();
        }
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"ORDER_NOT_SAVE"));
            SysUtil.abort();
        }
        this.beforeStoreFields(e);
        this.storeFields();
        this.setState(UseStatusEnum.ACTIVE);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus().getValue() != 1) {
            MsgBox.showInfo((String)ConditionUtil.getResourceString("ACCESSSEQ_CANNOT_INACTIVE"));
            SysUtil.abort();
        }
        this.setState(UseStatusEnum.INACTIVE);
    }

    public void setState(UseStatusEnum status) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add(this.editData.getId().toString());
        List errors = AccessSequenceFactory.getRemoteInstance().setState(pkList, status);
        String msg = "";
        msg = UseStatusEnum.ACTIVE.equals((Object)status) ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess");
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
            this.unLockUI();
        }
        StringBuffer errMsg = new StringBuffer();
        boolean isSuccess = true;
        if (null != errors && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"EnableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Start_Error");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)this.bdScmRes, (String)"DisableSuccess") : EASResource.getString((String)this.bdScmImRes, (String)"Msg_Forbid_Error");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)2);
        }
        this.setDataObject((IObjectValue)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), this.getSelectors()));
        this.loadFields();
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initDetailFormulaF7();
        this.initRequirementFormulaAlias();
        this.setControlStatus();
    }

    private void setControlStatus() {
        this.actionCancelCancel.setEnabled(UseStatusEnum.ACTIVE != this.editData.getStatus());
        this.btnCancelCancel.setEnabled(UseStatusEnum.ACTIVE != this.editData.getStatus());
        this.actionCancel.setEnabled(UseStatusEnum.ACTIVE == this.editData.getStatus());
        this.btnCancel.setEnabled(UseStatusEnum.ACTIVE == this.editData.getStatus());
        this.btnAddLine.setEnabled(UseStatusEnum.ACTIVE != this.editData.getStatus());
        this.btnInsertLine.setEnabled(UseStatusEnum.ACTIVE != this.editData.getStatus());
        this.btnDelLine.setEnabled(UseStatusEnum.ACTIVE != this.editData.getStatus());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (UseStatusEnum.ACTIVE == this.editData.getStatus()) {
            MsgBox.showInfo((String)ConditionUtil.getResourceString("ACCESSSEQ_HAS_ACTIVE_CANNOT_EDIT"));
            SysUtil.abort();
        }
    }

    protected void checkStateEnableDel() throws Exception {
        if (UseStatusEnum.ACTIVE == this.editData.getStatus()) {
            MsgBox.showInfo((String)ConditionUtil.getResourceString("ACCESSSEQ_HAS_ACTIVE_CANNOT_DEL"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableDel();
        super.actionRemove_actionPerformed(e);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        AccessSequenceInfo accessSeq = (AccessSequenceInfo)newData;
        accessSeq.setStatus(UseStatusEnum.SAVED);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accesses.*"));
        sic.add(new SelectorItemInfo("accesses.conditionTable.*"));
        return sic;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        ProcedureTypeInfo procedureType = (ProcedureTypeInfo)this.prmtProcedureType.getValue();
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("procedureType.id", (Object)procedureType.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        v.setFilter(filter);
        this.prmtConditionTable.setEntityViewInfo(v);
    }

    private int getMaxStep() {
        int maxStep = 0;
        KDTable table = this.getDetailTable();
        IRow row = null;
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int step;
            row = table.getRow(i);
            if (row.getCell(TB_COLNAME_STEP).getValue() == null || (step = ((Integer)row.getCell(TB_COLNAME_STEP).getValue()).intValue()) <= maxStep) continue;
            maxStep = step;
        }
        return maxStep;
    }

    protected void initDetailFormulaF7() {
        if (this.entityDest != null) {
            this.kdtAccesses.getColumn(TB_COLNAME_REQUIREMENT_ALIAS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.initRequirementEditor(this.kdtAccesses)));
        }
    }

    protected KDPromptBox initRequirementEditor(final KDTable table) {
        KDPromptBox f7Box = new KDPromptBox();
        f7Box.setReadOnly(true);
        f7Box.setEditable(false);
        f7Box.setAccessAuthority(1);
        f7Box.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (AccessSequenceEditUI.this.prmtProcedureType.getValue() == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"PROCEDURETYPE_ISNULL"));
                    SysUtil.abort();
                }
                ProcedureTypeInfo info = (ProcedureTypeInfo)AccessSequenceEditUI.this.prmtProcedureType.getValue();
                try {
                    info = ProcedureTypeFactory.getRemoteInstance().getProcedureTypeInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int rowIndex = table.getEditManager().getEditRowIndex();
                String valueExpression = "";
                if (table.getRow(rowIndex).getCell(AccessSequenceEditUI.TB_COLNAME_REQUIREMENT_EXPER).getValue() != null) {
                    valueExpression = table.getRow(rowIndex).getCell(AccessSequenceEditUI.TB_COLNAME_REQUIREMENT_EXPER).getValue().toString();
                }
                RequiremenFormula formula = new RequiremenFormula(info, valueExpression);
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put("InitDataObject", formula);
                uiContext.put("IsCheckFormual", Boolean.FALSE);
                uiContext.put("ID", info.getId().toString());
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.framework.condition.client.formula.RequirementFormulaUI", (Map)uiContext);
                }
                catch (UIException e1) {
                    e1.printStackTrace();
                }
                uiWindow.show();
                RequirementFormulaUI ui = (RequirementFormulaUI)uiWindow.getUIObject();
                if (!ui.isCancel()) {
                    table.getRow(rowIndex).getCell(AccessSequenceEditUI.TB_COLNAME_REQUIREMENT_ALIAS).setValue((Object)ui.getFormulaAlias());
                    table.getRow(rowIndex).getCell(AccessSequenceEditUI.TB_COLNAME_REQUIREMENT_EXPER).setValue((Object)ui.getFormulaExper());
                }
            }
        });
        return f7Box;
    }

    private void initRequirementFormulaAlias() {
        ProcedureTypeInfo info = (ProcedureTypeInfo)this.prmtProcedureType.getValue();
        try {
            info = ProcedureTypeFactory.getRemoteInstance().getProcedureTypeInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            String formulaExp = "";
            String formulaAlias = "";
            int rowCount = this.kdtAccesses.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.kdtAccesses.getRow(i);
                formulaExp = row.getCell(TB_COLNAME_REQUIREMENT_EXPER).getValue() != null ? row.getCell(TB_COLNAME_REQUIREMENT_EXPER).getValue().toString() : "";
                RequiremenFormula formula = new RequiremenFormula(info, formulaExp);
                formulaAlias = formula.getFormualAlias();
                row.getCell(TB_COLNAME_REQUIREMENT_ALIAS).setValue((Object)formulaAlias);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

