/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.condition.AccessSequenceInfo;
import com.kingdee.eas.scm.framework.condition.ConditionTypeFactory;
import com.kingdee.eas.scm.framework.condition.ConditionTypeInfo;
import com.kingdee.eas.scm.framework.condition.IConditionType;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeInfo;
import com.kingdee.eas.scm.framework.condition.client.AbstractConditionTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;

public class ConditionTypeEditUI
extends AbstractConditionTypeEditUI {
    private static final long serialVersionUID = -747765821428282093L;

    protected IObjectValue createNewData() {
        ConditionTypeInfo info = new ConditionTypeInfo();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        info.setCreator(userInfo);
        info.setLastUpdateUser(userInfo);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        info.setCreateTime(time);
        info.setLastUpdateTime(time);
        info.setStatus(UseStatusEnum.SAVED);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ConditionTypeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtProcedureType.setEntityViewInfo(view);
        this.prmtAccessSequence.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                AccessSequenceInfo accSeqInfo = (AccessSequenceInfo)e.getNewValue();
                if (accSeqInfo == null) {
                    ConditionTypeEditUI.this.txtAccessSequenceName.setText("");
                } else {
                    ConditionTypeEditUI.this.txtAccessSequenceName.setText(accSeqInfo.getName());
                }
            }
        });
        this.prmtProcedureType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ProcedureTypeInfo oldValue = (ProcedureTypeInfo)eventObj.getOldValue();
                ProcedureTypeInfo info = (ProcedureTypeInfo)eventObj.getNewValue();
                if (null == oldValue && null == info || null != oldValue && null != info && oldValue.equals(info)) {
                    return;
                }
                ConditionTypeEditUI.this.prmtAccessSequence.setValue(null);
                ConditionTypeEditUI.this.filterAccessSequence();
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (null != this.editData && UseStatusEnum.ACTIVE.equals((Object)this.editData.getStatus())) {
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
        } else {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
        }
        this.filterAccessSequence();
    }

    private void filterAccessSequence() {
        ProcedureTypeInfo info = (ProcedureTypeInfo)this.prmtProcedureType.getValue();
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        if (null == info) {
            filter.getFilterItems().add(new FilterItemInfo("procedureType.id", (Object)"null"));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("procedureType.id", (Object)info.getId().toString()));
        }
        v.setFilter(filter);
        this.prmtAccessSequence.setEntityViewInfo(v);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String message = null;
        IConditionType iConditionType = (IConditionType)this.getBizInterface();
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iConditionType.checkNumberDup(this.editData);
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setName(this.txtName.getEditor().getItem().toString().trim());
            this.txtName.requestFocus();
            iConditionType.checkNameDup(this.editData);
        }
        if (this.prmtProcedureType.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"PROCEDURETYPE_ISNULL2"));
            this.prmtProcedureType.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtAccessSequence.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"ORDER_IS_NULL"));
            this.prmtAccessSequence.requestFocus();
            SysUtil.abort();
        }
        if (this.pkEffectiveDate.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"EFFECT_DATE_IS_NULL"));
            this.pkEffectiveDate.requestFocus();
            SysUtil.abort();
        }
        if (this.pkExpirationDate.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"INEFFECT_DATE_IS_NULL"));
            this.pkExpirationDate.requestFocus();
            SysUtil.abort();
        }
    }
}

