/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.client.helper;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.framework.condition.DebugMsgInfo;
import com.kingdee.eas.scm.framework.condition.client.helper.AbstractConditionLogUI;
import com.kingdee.eas.scm.framework.condition.model.ConditionLogModel;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class ConditionLogUI
extends AbstractConditionLogUI {
    private static final Logger logger = CoreUIObject.getLogger(ConditionLogUI.class);
    private DebugMsgInfo cliengMsg;
    private DebugMsgInfo serverMsg;
    private DebugMsgInfo sqlMsg;
    private DebugMsgInfo tempClientMsg;
    private DebugMsgInfo tempServerMsg;
    private DebugMsgInfo tempSqlMsg;
    List<ConditionLogModel> logModelList;
    Color[] arr = new Color[]{Color.WHITE, Color.LIGHT_GRAY};

    public ConditionLogUI() throws Exception {
        this.tbLogGeneral.checkParsed();
        this.tbLogDetails.checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionClean_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    void refresh() {
    }

    void setClientMsg(DebugMsgInfo msg) {
        this.tempClientMsg = msg;
    }

    void setServerMsg(DebugMsgInfo msg) {
        this.tempServerMsg = msg;
    }

    void setSQlMsg(DebugMsgInfo msg) {
        this.tempSqlMsg = msg;
    }

    public void onLoad() throws Exception {
        this.tbLogGeneral.checkParsed();
        this.tbLogDetails.checkParsed();
        super.onLoad();
        this.tbLogGeneral.getStyleAttributes().setLocked(true);
        this.tbLogDetails.getStyleAttributes().setLocked(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillLogGeneralData(this.logModelList);
    }

    public void fillLogGeneralData(List<ConditionLogModel> logModelList) {
        this.tbLogGeneral.removeRows();
        if (CollectionUtil.isEmpty(logModelList)) {
            return;
        }
        int triggerCounter = 0;
        Color color = null;
        int colorIndex = 0;
        this.arr = new Color[]{Color.WHITE, Color.LIGHT_GRAY};
        int size = logModelList.size();
        for (int i = 0; i < size; ++i) {
            ConditionLogModel logModel = logModelList.get(i);
            IRow row = this.tbLogGeneral.addRow();
            if (triggerCounter != logModel.getLogCounter()) {
                triggerCounter = logModel.getLogCounter();
                colorIndex = colorIndex == 0 ? 1 : 0;
                color = this.arr[colorIndex];
            }
            row.getStyleAttributes().setBackground(color);
            row.getCell("logSeq").setValue((Object)logModel.getLogCounter());
            row.getCell("procedureType").setValue((Object)logModel.getProcedureType());
            row.getCell("procedure").setValue((Object)logModel.getProcedure());
            row.getCell("outputObj").setValue((Object)logModel.getOutputObj());
            row.getCell("outputValue").setValue(logModel.getOutputValue());
            row.getCell("isReplace").setValue((Object)logModel.isReplace());
            row.getCell("msg").setValue((Object)logModel.getMsg());
        }
        this.setMergeColumnGeneral();
    }

    public void fillLogDetailsData(List<ConditionLogModel> detailsLogModelList) {
        this.tbLogDetails.removeRows();
        if (CollectionUtil.isEmpty(detailsLogModelList)) {
            return;
        }
        int triggerCounter = 0;
        Color color = null;
        int colorIndex = 0;
        this.arr = new Color[]{Color.WHITE, Color.LIGHT_GRAY};
        int size = detailsLogModelList.size();
        for (int i = 0; i < size; ++i) {
            ConditionLogModel logModel = detailsLogModelList.get(i);
            IRow row = this.tbLogDetails.addRow();
            if (triggerCounter != logModel.getLogCounter()) {
                triggerCounter = logModel.getLogCounter();
                colorIndex = colorIndex == 0 ? 1 : 0;
                color = this.arr[colorIndex];
            }
            row.getStyleAttributes().setBackground(color);
            row.getCell("logSeq").setValue((Object)logModel.getLogCounter());
            row.getCell("procedureType").setValue((Object)logModel.getProcedureType());
            row.getCell("procedure").setValue((Object)logModel.getProcedure());
            row.getCell("procedureItem").setValue((Object)logModel.getProcedureItem());
            row.getCell("procedureItemRequire").setValue((Object)logModel.isProcedureItemRequired());
            row.getCell("procedureItemFormula").setValue((Object)logModel.getProcedureItemFormula());
            row.getCell("conditionType").setValue((Object)logModel.getConditionType());
            row.getCell("accessSeq").setValue((Object)logModel.getAccessSeq());
            row.getCell("access").setValue((Object)logModel.getAccesses());
            row.getCell("accessRequired").setValue((Object)logModel.isAccessRequired());
            row.getCell("conditionTable").setValue((Object)logModel.getConditionTable());
            row.getCell("outputObj").setValue((Object)logModel.getOutputObj());
            row.getCell("outputObjSeq").setValue((Object)logModel.getSeq());
            if (logModel.getSeq() != -1 && !StringUtil.isEmpty((String)logModel.getOutputObj())) {
                row.getCell("outputObj").setValue((Object)EASResource.getString((String)"com.kingdee.eas.scm.framework.condition.ConditionResource", (String)"ENTRY_MSG", (Object[])new Object[]{logModel.getSeq(), logModel.getOutputObj()}));
            }
            row.getCell("outputValue").setValue(logModel.getOutputValue());
            row.getCell("isReplace").setValue((Object)logModel.isReplace());
            row.getCell("msg").setValue((Object)logModel.getMsg());
        }
        this.setMergeColumnDetails();
    }

    private void setMergeColumnGeneral() {
        String[] mergeColumnKeys = new String[]{"logSeq", "procedureType", "procedure"};
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tbLogGeneral.checkParsed();
            this.tbLogGeneral.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tbLogGeneral.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    private void setMergeColumnDetails() {
        String[] mergeColumnKeys = new String[]{"logSeq", "procedureType", "procedure", "procedureItem", "procedureItemRequire", "procedureItemFormula", "conditionType", "accessSeq"};
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tbLogDetails.checkParsed();
            this.tbLogDetails.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tbLogDetails.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }
}

