/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.log.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.framework.log.client.AbstractLogConditionUI;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class LogConditionUI
extends AbstractLogConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(LogConditionUI.class);
    private NewCtrlF7 ctrlF7 = null;
    private static final String PERMISSIONITEM = "paySecurityList_view";

    public LogConditionUI() throws Exception {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Date currentDate = new Date(System.currentTimeMillis());
        SingleFilterElement element = new SingleFilterElement("dateFrom", (Component)this.dateFrom);
        element.setDefaultValue((Object)new Timestamp(System.currentTimeMillis() - 86400000L));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateTo", (Component)this.dateTo);
        element.setDefaultValue((Object)currentDate);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("FCUnumber", (Component)this.bizPromptCU);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("FOperateOrg", (Component)this.kDBizOprateOrg);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("FFunctionName", (Component)this.txtFunction);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("FOperateObj", (Component)this.txtOprateObj);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("FLogContent", (Component)this.txtLogText);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("FLogType", (Component)this.comboLogType);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.ctrlF7 = new NewCtrlF7((IUIObject)this);
        this.ctrlF7.setMultiSelect(false);
        this.ctrlF7.setPermissionItem(PERMISSIONITEM);
        this.bizPromptCU.setSelector((KDPromptSelector)this.ctrlF7);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromptCU.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                LogConditionUI.this.setOprateOrgFilter();
            }
        });
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        ArrayList infoList = new ArrayList();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            CtrlUnitCollection data;
            FilterInfo orgfilterInfo;
            EntityViewInfo orgViewInfo;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            SelectorItemCollection sic = this.getSelectors();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("FCUnumber")) {
                String CUnumber = (String)filterItemInfo.getCompareValue();
                try {
                    orgViewInfo = new EntityViewInfo();
                    orgfilterInfo = new FilterInfo();
                    orgfilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)CUnumber, CompareType.EQUALS));
                    orgViewInfo.setFilter(orgfilterInfo);
                    orgViewInfo.setSelector(sic);
                    data = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(orgViewInfo);
                    if (data != null && data.size() > 0) {
                        this.bizPromptCU.setData((Object)data.get(0));
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("FOperateOrg")) continue;
            String operateOrg = (String)filterItemInfo.getCompareValue();
            try {
                orgViewInfo = new EntityViewInfo();
                orgfilterInfo = new FilterInfo();
                orgfilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)operateOrg, CompareType.EQUALS));
                orgViewInfo.setFilter(orgfilterInfo);
                orgViewInfo.setSelector(sic);
                data = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(orgViewInfo);
                if (data == null || data.size() <= 0) continue;
                this.kDBizOprateOrg.setData((Object)data.get(0));
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void setOprateOrgFilter() {
        OrgUnitInfo ctrlUnitInfo = (OrgUnitInfo)this.bizPromptCU.getValue();
        if (ctrlUnitInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ctrlUnitInfo.getId().toString(), CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("isCU", (Object)0, CompareType.EQUALS));
            viewInfo.setFilter(fi);
            this.kDBizOprateOrg.setEntityViewInfo(viewInfo);
        } else {
            this.kDBizOprateOrg.setEntityViewInfo(null);
        }
    }
}

