/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.log.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.framework.log.LogRptFacadeFactory;
import com.kingdee.eas.scm.framework.log.LogType;
import com.kingdee.eas.scm.framework.log.client.AbstractLogRptUI;
import com.kingdee.eas.scm.framework.log.client.LogConditionUI;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogRptUI
extends AbstractLogRptUI {
    private static final Logger logger = CoreUIObject.getLogger(LogRptUI.class);
    private boolean isGetData = false;
    private LogConditionUI conditionUI = null;
    public static final String COL_LOGTYPE = "FLogType";

    public LogRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return LogRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        if (this.conditionUI == null) {
            this.conditionUI = new LogConditionUI();
        }
        return this.conditionUI;
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            logger.error((Object)e);
                        }
                    }
                }
            }
            boolean ok = false;
            if (cp == null || !useDefaultSolution) {
                this.queryDialog.setDisShowRowCount(true);
                this.conditionUI.onShow();
                if (this.queryDialog.show()) {
                    rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                    this.params = rbqp.getCustomCondition();
                    ok = true;
                }
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setWidth(600);
            this.queryDialog.setHeight(400);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    public boolean isAsynchronism() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String longFormat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("FOccurTime").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        this.tblMain.getColumn("FOccurTime").getStyleAttributes().setNumberFormat(longFormat);
    }

    protected void query() {
        this.isGetData = false;
        this.tblMain.removeRows();
        this.initUserConfig();
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams pp = new RptParams();
            pp.putAll(this.params.toMap());
            if (!this.isGetData) {
                RptParams rpt = this.getRemoteInstance().createTempTable(pp);
                this.params.setObject("listData", rpt.getObject("listData"));
                this.tblMain.setRowCount(rpt.getInt("rowCount"));
            }
            List list = (List)this.params.getObject("listData");
            ArrayList dataList = new ArrayList();
            int to = len + from;
            for (int i = from; i < to; ++i) {
                if (i >= list.size()) continue;
                dataList.add(list.get(i));
            }
            ArrayList rs = dataList;
            if (rs != null) {
                this.insertRows(rs, from, (CoreUI)this, this.tblMain, this.tHelper, true);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.initUserConfig();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    public void insertRows(List rs, int insertRowIndex, CoreUI ui, KDTable table, ITablePreferenceHelper tHelper, boolean refreshUI) {
        table.setRefresh(false);
        Object[] rowData = null;
        if (rs != null && rs.size() > 0) {
            for (int i = 0; i < rs.size(); ++i) {
                Map mapData = (Map)rs.get(i);
                Collection coll = mapData.values();
                IRow row = table.setRow(insertRowIndex++);
                rowData = this.sortRowData(coll.toArray(), mapData, ui, table, tHelper);
                this.setTableRowData(row, rowData);
            }
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.size() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    public Object[] sortRowData(Object[] rowData, Map mapData, CoreUI ui, KDTable table, ITablePreferenceHelper tHelper) {
        UserCustomConfigItemData defaultConfig = tHelper.getDefaultUserData(table);
        UserPreferenceData userDBData = tHelper.getUserDataFromUI();
        String key = ui.getClass().getName() + "." + table.getName();
        UserCustomConfigItemData curConfig = userDBData.getTableCurrentSetting(key);
        return this.sortRowData(rowData, mapData, defaultConfig, curConfig);
    }

    private Object[] sortRowData(Object[] rowData, Map mapData, UserCustomConfigItemData defaultConfig, UserCustomConfigItemData curConfig) {
        Object[] resultData = Arrays.copyOf((Object[])rowData, (int)rowData.length);
        List curColumnList = Arrays.asList((Object[])curConfig.getColumnData().keySet().toArray());
        Object[] result = new Object[curColumnList.size()];
        ColumnItemData columnData = null;
        String key2 = null;
        int expectIndex = -1;
        int originalIndex = -1;
        Object temp = null;
        for (String key2 : curColumnList) {
            columnData = (ColumnItemData)curConfig.getColumnData().get(key2);
            if (columnData == null) continue;
            expectIndex = columnData.getIndex();
            if (COL_LOGTYPE.equals(key2)) {
                LogType logType = LogType.getEnum(Integer.valueOf(mapData.get(key2).toString()));
                mapData.put(key2, logType.getAlias());
            }
            result[expectIndex] = mapData.get(key2);
        }
        return result;
    }

    public void setTableRowData(IRow row, Object[] rowData) {
        int n = rowData.length;
        for (int i = 0; i < n; ++i) {
            row.getCell(i).setValue(rowData[i]);
        }
    }
}

