/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.log.listener;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.contrast.InfoAccess;
import com.kingdee.bos.dao.ormapping.contrast.ValueAccess;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.app.adapter.PermissionServiceAdapterHelper;
import com.kingdee.eas.base.permission.app.util.BizObjectOrgHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.log.LogConfigEntryInfo;
import com.kingdee.eas.scm.framework.log.SCMBizLogCache;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogService;
import com.kingdee.eas.scm.framework.log.model.SCMBizLogBillConfigInfo;
import com.kingdee.eas.scm.framework.log.util.SCMBizLogUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SCMBizLogAdapter
extends AbstractServiceAdapter
implements IServiceAdapter {
    private static Logger logger = Logger.getLogger(SCMBizLogAdapter.class);
    private static final String PLUGIN_SERVICE_SCMBIZLOG = "PLUGIN_SERVICE_SCMBIZLOG";
    private static final String ENABLE_SCM_BIZ_LOG = "ENABLE_SCM_BIZ_LOG";
    private static ThreadLocal<Integer> firstWriteLogLevel = new ThreadLocal();
    private static final int PLUGIN_PRIORITY = 0;

    public int getPriority() {
        return 0;
    }

    public String getName() {
        return PLUGIN_SERVICE_SCMBIZLOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IServiceContext serviceContext) throws BOSException {
        block26: {
            try {
                Context ctx;
                ServiceStateManager.getInstance().enableNextCallService(PLUGIN_SERVICE_SCMBIZLOG);
                if (serviceContext.getExecutionMode() == 0 && ServiceStateManager.getInstance().getServiceState().getLevel() == 1 && firstWriteLogLevel.get() != null) {
                    firstWriteLogLevel.remove();
                }
                if (!SCMBizLogCache.getBooleanBackgroundParam(ctx = serviceContext.getContext(), ENABLE_SCM_BIZ_LOG).booleanValue()) {
                    return;
                }
                LuceneEngine engine = LuceneEngine.getEngine4EasLog();
                if (engine == null) {
                    ServiceStateManager.getInstance().disableNextCallService(PLUGIN_SERVICE_SCMBIZLOG);
                    return;
                }
                if (serviceContext == null) {
                    return;
                }
                if (!serviceContext.getMetaType().equals((Object)MetaDataTypeList.ENTITY)) {
                    return;
                }
                BusinessObjectInfo entityInfo = this.getEntityInfo(serviceContext);
                if (entityInfo == null) {
                    logger.error((Object)"not a entityInfo object!");
                    return;
                }
                String className = entityInfo.getFullName();
                if (!SCMBizLogAdapter.checkClassPath(ctx, className)) {
                    logger.debug((Object)("checkClassPath not pass:" + className));
                    return;
                }
                if (!SCMBizLogAdapter.checkMethod(ctx, entityInfo, serviceContext.getOperationPK()).booleanValue()) {
                    return;
                }
                Set<String> selfPkSet = SCMBizLogAdapter.getSelfPkSet(serviceContext);
                if (selfPkSet == null || selfPkSet.size() == 0) {
                    logger.debug((Object)"getSelfPkSet is NULL!");
                    return;
                }
                if (serviceContext.getExecutionMode() == 0) {
                    if (firstWriteLogLevel.get() != null) {
                        if (firstWriteLogLevel.get() < ServiceStateManager.getInstance().getServiceState().getLevel()) {
                            ServiceStateManager.getInstance().getServiceState().disableSpecialService(PLUGIN_SERVICE_SCMBIZLOG);
                        }
                    } else {
                        firstWriteLogLevel.set(ServiceStateManager.getInstance().getServiceState().getLevel());
                    }
                    break block26;
                }
                if (serviceContext.getExecutionMode() != 1) break block26;
                try {
                    if (firstWriteLogLevel.get() != null && firstWriteLogLevel.get().intValue() == ServiceStateManager.getInstance().getServiceState().getLevel()) {
                        LowTimer lowTimer = new LowTimer();
                        long beginTime = lowTimer.msValue();
                        IObjectPK mainBizOrgPk = SCMBizLogAdapter.getMainBizOrgPK(serviceContext);
                        if (mainBizOrgPk == null) {
                            logger.error((Object)"getMainBizOrgPK is NULL");
                            return;
                        }
                        Map<String, List<LogConfigEntryInfo>> fieldsMap = SCMBizLogCache.getLogConfigMap(ctx, mainBizOrgPk);
                        if (fieldsMap == null || fieldsMap.isEmpty()) {
                            logger.error((Object)("getLogConfigMap is NULL mainBizOrgPk:" + mainBizOrgPk));
                            return;
                        }
                        HashMap<String, Object> newValues = new HashMap<String, Object>();
                        HashMap<String, Object> oldValues = new HashMap<String, Object>();
                        HashMap<String, Set<String>> hasQueryedIdMap = new HashMap<String, Set<String>>();
                        HashMap<String, Set<String>> rootIdMap = new HashMap<String, Set<String>>();
                        SCMBizLogAdapter.addRelationObject(ctx, serviceContext.getBoType().toString(), fieldsMap, selfPkSet, newValues, oldValues, hasQueryedIdMap, rootIdMap);
                        if (newValues.isEmpty() && oldValues.isEmpty()) {
                            logger.error((Object)"newValues and oldValuesL is NULL!");
                            return;
                        }
                        HashMap<String, Object> logItem = SCMBizLogAdapter.getLogItem(serviceContext, mainBizOrgPk, entityInfo);
                        CompareDataAndWriteLogThread compareWriteThread = new CompareDataAndWriteLogThread(ctx, logItem, newValues, oldValues, fieldsMap, rootIdMap);
                        compareWriteThread.start();
                        ServiceStateManager.getInstance().disableNextCallService(PLUGIN_SERVICE_SCMBIZLOG);
                        long endTime = lowTimer.msValue();
                        logger.error((Object)("PLUGIN_SERVICE_SCMBIZLOG INVOKE_AFTER_BUSINESS(" + logItem.get("FEntityName") + logItem.get("FMethodName") + "):" + (endTime - beginTime)));
                    }
                }
                finally {
                    if (firstWriteLogLevel.get() != null) {
                        firstWriteLogLevel.remove();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public static void writeBizLogForWriteOff(Context ctx, HashMap<String, Object> logItem, IObjectPK mainBizOrgPk, Set selfPkSet) {
        try {
            if (selfPkSet.size() == 0 || mainBizOrgPk == null) {
                return;
            }
            BOSObjectType bosType = BOSUuid.read((String)selfPkSet.iterator().next().toString()).getType();
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
            logItem.put("FEntityID", bosType.toString());
            logItem.put("FEntityName", entityInfo.getName());
            logItem.put("FEntityAlias", entityInfo.getAlias());
            if (mainBizOrgPk != null) {
                SelectorItemCollection select = new SelectorItemCollection();
                select.add("number");
                select.add("name");
                FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(mainBizOrgPk);
                if (orgUnit != null) {
                    logItem.put("FOperateOrg", orgUnit.getNumber());
                    logItem.put("FOperateOrgName", orgUnit.getName());
                }
            }
            Map<String, List<LogConfigEntryInfo>> fieldsMap = SCMBizLogCache.getLogConfigMap(ctx, mainBizOrgPk);
            HashMap<String, Object> newValues = new HashMap<String, Object>();
            HashMap<String, Object> oldValues = new HashMap<String, Object>();
            HashMap<String, Set<String>> hasQueryedIdMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> rootIdMap = new HashMap<String, Set<String>>();
            SCMBizLogAdapter.addRelationObject(ctx, bosType.toString(), fieldsMap, selfPkSet, newValues, oldValues, hasQueryedIdMap, rootIdMap);
            if (newValues.isEmpty() && oldValues.isEmpty()) {
                logger.error((Object)"newValues and oldValuesL is NULL!");
                return;
            }
            CompareDataAndWriteLogThread compareWriteThread = new CompareDataAndWriteLogThread(ctx, logItem, newValues, oldValues, fieldsMap, rootIdMap);
            compareWriteThread.start();
            if (firstWriteLogLevel.get() != null) {
                firstWriteLogLevel.remove();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void writeBizLog(Context ctx, HashMap<String, Object> logItem, IObjectPK mainBizOrgPk, Map<String, Set> idMap, Map<String, Set<String>> rootIdMap) {
        try {
            Map<String, List<LogConfigEntryInfo>> fieldsMap = SCMBizLogCache.getLogConfigMap(ctx, mainBizOrgPk);
            HashMap<String, Object> newValues = new HashMap<String, Object>();
            HashMap<String, Object> oldValues = new HashMap<String, Object>();
            for (Map.Entry<String, Set> entry : idMap.entrySet()) {
                if (!fieldsMap.containsKey(entry.getKey())) continue;
                IObjectCollection newColl = SCMBizLogAdapter.getColl(ctx, fieldsMap, BOSObjectType.create((String)entry.getKey()), entry.getValue());
                IObjectCollection oldColl = SCMBizLogAdapter.getCollByRequiresNew(ctx, fieldsMap, BOSObjectType.create((String)entry.getKey()), entry.getValue());
                if (newColl.size() > 0) {
                    if (newValues.containsKey(entry.getKey())) {
                        ((IObjectCollection)newValues.get(entry.getKey())).addObjectCollection(newColl);
                    } else {
                        newValues.put(entry.getKey(), newColl);
                    }
                }
                if (oldColl.size() <= 0) continue;
                if (oldValues.containsKey(entry.getKey())) {
                    ((IObjectCollection)oldValues.get(entry.getKey())).addObjectCollection(oldColl);
                    continue;
                }
                oldValues.put(entry.getKey(), oldColl);
            }
            if (oldValues.isEmpty() && newValues.isEmpty()) {
                return;
            }
            CompareDataAndWriteLogThread compareWriteThread = new CompareDataAndWriteLogThread(ctx, logItem, newValues, oldValues, fieldsMap, rootIdMap);
            compareWriteThread.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static void addRelationObject(Context ctx, String bosType, Map<String, List<LogConfigEntryInfo>> fieldsMap, Set<String> idSet, Map<String, Object> newValues, Map<String, Object> oldValues, Map<String, Set<String>> hasQueryeIdMap, Map<String, Set<String>> rootIdMap) throws Exception {
        int i;
        IObjectCollection selfNewColl = SCMBizLogAdapter.getColl(ctx, fieldsMap, BOSObjectType.create((String)bosType), idSet);
        IObjectCollection selfOldColl = SCMBizLogAdapter.getCollByRequiresNew(ctx, fieldsMap, BOSObjectType.create((String)bosType), idSet);
        if (selfNewColl.isEmpty() && selfOldColl.isEmpty()) {
            return;
        }
        if (fieldsMap.containsKey(bosType)) {
            if (newValues.get(bosType) != null) {
                ((IObjectCollection)newValues.get(bosType)).addObjectCollection(selfNewColl);
            } else {
                newValues.put(bosType, selfNewColl);
            }
            if (oldValues.get(bosType) != null) {
                ((IObjectCollection)oldValues.get(bosType)).addObjectCollection(selfOldColl);
            } else {
                oldValues.put(bosType, selfOldColl);
            }
        }
        SCMBizLogBillConfigInfo slbci = SCMBizLogCache.getSCMBizLogBillConfigInfo(ctx, bosType);
        ArrayList<IObjectValue> tempList = new ArrayList<IObjectValue>(selfOldColl.size() + selfNewColl.size());
        for (i = 0; i < selfOldColl.size(); ++i) {
            tempList.add(selfOldColl.getObject(i));
        }
        for (i = 0; i < selfNewColl.size(); ++i) {
            tempList.add(selfNewColl.getObject(i));
        }
        if (rootIdMap.isEmpty()) {
            for (i = 0; i < tempList.size(); ++i) {
                String id = ((IObjectValue)tempList.get(i)).get("id").toString();
                String number = ((IObjectValue)tempList.get(i)).get(slbci.getNumberField()).toString();
                if (StringUtils.isEmpty((String)number)) continue;
                HashSet<String> idStrSet = new HashSet<String>();
                idStrSet.add(id);
                rootIdMap.put(number, idStrSet);
            }
        }
        IObjectValue bill = null;
        HashMap<String, Set<String>> relationIdMap = new HashMap<String, Set<String>>();
        for (int i2 = 0; i2 < tempList.size(); ++i2) {
            bill = (IObjectValue)tempList.get(i2);
            if (bill == null) continue;
            HashSet<String> coreIdSet = new HashSet<String>();
            HashSet<String> sourceIdSet = new HashSet<String>();
            IObjectCollection entryColl = (IObjectCollection)bill.get(slbci.getEntryField());
            if (entryColl != null && !entryColl.isEmpty()) {
                for (int j = 0; j < entryColl.size(); ++j) {
                    if (!StringUtils.isEmpty((String)slbci.getCoreBillField()) && entryColl.getObject(j).getString(slbci.getCoreBillField()) != null) {
                        coreIdSet.add(entryColl.getObject(j).getString(slbci.getCoreBillField()));
                    }
                    if (StringUtils.isEmpty((String)slbci.getSourceBillField()) || entryColl.getObject(j).getString(slbci.getSourceBillField()) == null) continue;
                    sourceIdSet.add(entryColl.getObject(j).getString(slbci.getSourceBillField()));
                }
                SCMBizLogAdapter.addRelationId(coreIdSet, relationIdMap);
                SCMBizLogAdapter.addRelationId(sourceIdSet, relationIdMap);
            } else {
                logger.error((Object)("\u4e0d\u5b58\u5728\u5206\u5f55\u5b57\u6bb5\u4e3a\uff1a" + slbci.getEntryField() + "\u5206\u5f55\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u914d\u7f6e\u4fe1\u606f(T_SCM_BIZLOGBILLCONFIG)\u662f\u5426\u6b63\u786e\uff01"));
            }
            String sourceBillId = bill.getString("sourceBillId");
            if (!StringUtils.isEmpty((String)sourceBillId)) {
                HashSet<String> sourceBillIdSet = new HashSet<String>(1);
                sourceBillIdSet.add(sourceBillId);
                SCMBizLogAdapter.addRelationId(sourceBillIdSet, relationIdMap);
                SCMBizLogAdapter.addRootIdSet(bill.get("id").toString(), sourceBillIdSet, rootIdMap);
            }
            SCMBizLogAdapter.addRootIdSet(bill.get("id").toString(), coreIdSet, rootIdMap);
            SCMBizLogAdapter.addRootIdSet(bill.get("id").toString(), sourceIdSet, rootIdMap);
        }
        if (relationIdMap.isEmpty()) {
            return;
        }
        Set relationSet = relationIdMap.entrySet();
        for (Map.Entry entry : relationSet) {
            Set needQuerySet = (Set)entry.getValue();
            if (needQuerySet.isEmpty()) continue;
            if (hasQueryeIdMap.containsKey(entry.getKey())) {
                needQuerySet.removeAll((Collection)hasQueryeIdMap.get(entry.getKey()));
            }
            if (needQuerySet.size() <= 0) continue;
            if (hasQueryeIdMap.containsKey(entry.getKey())) {
                hasQueryeIdMap.get(entry.getKey()).addAll(needQuerySet);
            } else {
                hasQueryeIdMap.put((String)entry.getKey(), needQuerySet);
            }
            SCMBizLogAdapter.addRelationObject(ctx, (String)entry.getKey(), fieldsMap, needQuerySet, newValues, oldValues, hasQueryeIdMap, rootIdMap);
        }
    }

    private static void addRelationId(Set<String> idSet, Map<String, Set<String>> relationIdMap) {
        if (!idSet.isEmpty()) {
            for (String id : idSet) {
                String tempBosType = BOSUuid.read((String)id).getType().toString();
                if (relationIdMap.get(tempBosType) != null) {
                    relationIdMap.get(tempBosType).add(id);
                    continue;
                }
                HashSet<String> tempSet = new HashSet<String>();
                tempSet.add(id);
                relationIdMap.put(tempBosType, tempSet);
            }
        }
    }

    private static void addRootIdSet(String id, Set<String> relationIdSet, Map<String, Set<String>> rootIdMap) {
        if (rootIdMap.isEmpty()) {
            return;
        }
        Collection<Set<String>> rootEntry = rootIdMap.values();
        for (Set<String> entry : rootEntry) {
            if (!entry.contains(id)) continue;
            entry.addAll(relationIdSet);
        }
    }

    public static IObjectCollection getColl(Context ctx, Map<String, List<LogConfigEntryInfo>> fieldsMap, BOSObjectType bosType, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        String oql = SCMBizLogAdapter.getOql(ctx, fieldsMap, bosType, idSet);
        IDynamicObject idynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection objectColl = idynObj.getCollection(bosType, oql.toString());
        return objectColl;
    }

    public static IObjectCollection getCollByRequiresNew(Context ctx, Map<String, List<LogConfigEntryInfo>> fieldsMap, BOSObjectType bosType, Set idSet, SelectorItemCollection select) throws Exception {
        try {
            if (idSet == null || idSet.isEmpty()) {
                return null;
            }
            String oql = SCMBizLogAdapter.getOql(ctx, fieldsMap, bosType, idSet, select);
            IDynamicObject idynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
            Method method = idynObj.getClass().getMethod("getCollection", BOSObjectType.class, String.class);
            Object[] params = new Object[]{bosType, oql};
            int transaction = 3;
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)idynObj);
            Object resutl = txInvoker.invoke(method, params, transaction);
            return (IObjectCollection)resutl;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    public static IObjectCollection getCollByRequiresNew(Context ctx, Map<String, List<LogConfigEntryInfo>> fieldsMap, BOSObjectType bosType, Set idSet) throws Exception {
        return SCMBizLogAdapter.getCollByRequiresNew(ctx, fieldsMap, bosType, idSet, null);
    }

    private static String getOql(Context ctx, Map<String, List<LogConfigEntryInfo>> fieldsMap, BOSObjectType bosType, Set<Object> idSet, SelectorItemCollection select) throws BOSException, EASBizException {
        if (select == null) {
            select = SCMBizLogAdapter.getSelect(ctx, fieldsMap, bosType);
        }
        StringBuffer oql = new StringBuffer(100);
        oql.append(" SELECT ").append(select.toString());
        oql.append(" WHERE ID IN ").append(SCMBizLogUtils.transIDList2String(idSet));
        return oql.toString();
    }

    private static String getOql(Context ctx, Map<String, List<LogConfigEntryInfo>> fieldsMap, BOSObjectType bosType, Set<Object> idSet) throws BOSException, EASBizException {
        return SCMBizLogAdapter.getOql(ctx, fieldsMap, bosType, idSet, null);
    }

    private static void compareDataAndWriteLog(Context ctx, HashMap<String, Object> logItem, Map<String, Object> newValues, Map<String, Object> oldValues, Map<String, List<LogConfigEntryInfo>> fieldsMap, Map<String, Set<String>> rootIdMap) throws Exception {
        HashSet<String> allKeys = new HashSet<String>(oldValues.keySet());
        allKeys.addAll(newValues.keySet());
        for (String bosType : allKeys) {
            IObjectCollection newValueColl;
            List<LogConfigEntryInfo> entryInfoList = fieldsMap.get(bosType);
            Object oldValueObj = oldValues.get(bosType);
            Object newValueObj = newValues.get(bosType);
            HashMap<String, String> fieldsAliasMap = new HashMap<String, String>(100);
            for (LogConfigEntryInfo entryInfo : entryInfoList) {
                fieldsAliasMap.put(entryInfo.getField(), entryInfo.getFieldName());
            }
            EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
            logItem.put("FCurrentEntityAlias", bo.getAlias());
            IObjectCollection oldValueColl = (IObjectCollection)oldValueObj;
            if (oldValueColl != null) {
                for (int i = 0; i < oldValueColl.size(); ++i) {
                    if (newValueObj == null) {
                        SCMBizLogAdapter.writeModifyLog(ctx, logItem, entryInfoList, oldValueColl.getObject(i), null, bosType, bo, fieldsAliasMap, rootIdMap);
                        continue;
                    }
                    IObjectCollection newValueColl2 = (IObjectCollection)newValueObj;
                    IObjectValue newValue = newValueColl2.getObject(oldValueColl.getObject(i).get("id"));
                    SCMBizLogAdapter.writeModifyLog(ctx, logItem, entryInfoList, oldValueColl.getObject(i), newValue, bosType, bo, fieldsAliasMap, rootIdMap);
                }
            }
            if ((newValueColl = (IObjectCollection)newValueObj) == null) continue;
            for (int i = 0; i < newValueColl.size(); ++i) {
                if (oldValueColl != null && oldValueColl.getObject(newValueColl.getObject(i).get("id")) != null) continue;
                SCMBizLogAdapter.writeModifyLog(ctx, logItem, entryInfoList, null, newValueColl.getObject(i), bosType, bo, fieldsAliasMap, rootIdMap);
            }
        }
    }

    private static void innerWriteModifyLog(Context ctx, HashMap<String, Object> logItem, Object newValueStr, Object oldValueStr, Map<String, String> fieldsAliasMap, String entryFieldName, String fieldName) {
        String innerOldValueStr;
        String innerNewValueStr = newValueStr == null ? "" : newValueStr.toString();
        String string = innerOldValueStr = oldValueStr == null ? "" : oldValueStr.toString();
        if (StringUtils.isEmpty((String)innerNewValueStr) && StringUtils.isEmpty((String)innerOldValueStr)) {
            return;
        }
        String key = "";
        if (entryFieldName != null) {
            key = entryFieldName + ".";
            if (!StringUtils.isEmpty((String)innerNewValueStr)) {
                innerNewValueStr = innerNewValueStr.substring(0, innerNewValueStr.length() - 1);
            }
            if (!StringUtils.isEmpty((String)innerOldValueStr)) {
                innerOldValueStr = innerOldValueStr.substring(0, innerOldValueStr.length() - 1);
            }
        }
        key = key + fieldName;
        String fieldAlias = fieldsAliasMap.get(key);
        HashMap<String, Object> templogItem = new HashMap<String, Object>();
        templogItem.putAll(logItem);
        templogItem.put("FLogContent", templogItem.get("FEntityAlias") + "(" + templogItem.get("FOperateNumber") + "):" + templogItem.get("FMethodAlias"));
        templogItem.put("FLogType", 1);
        templogItem.put("FNewValue", innerNewValueStr);
        templogItem.put("FOldValue", innerOldValueStr);
        templogItem.put("FFunctionName", fieldAlias);
        templogItem.put("FfieldName", key);
        SCMBizLogService.putLogItem(ctx, templogItem, SCMBizLogService.SCM_LOG);
    }

    private static void addLogItemForBill(Context ctx, HashMap<String, Object> logItem, IObjectValue oldInfo, IObjectValue newInfo, String bosTypeStr, Map<String, Set<String>> rootIdMap) throws EASBizException, BOSException {
        BizObjectOrgHelper bizObjectHelper;
        String companyFieldName;
        SCMBizLogBillConfigInfo sblbc = SCMBizLogCache.getSCMBizLogBillConfigInfo(ctx, bosTypeStr);
        Object value = SCMBizLogAdapter.getObjFromValue(oldInfo, newInfo, sblbc.getNumberField());
        if (value != null) {
            logItem.put("FOperateObj", value.toString());
        }
        if ((value = SCMBizLogAdapter.getObjFromValue(oldInfo, newInfo, companyFieldName = (bizObjectHelper = new BizObjectOrgHelper()).getBizObjOrgPropertyName(ctx, BOSObjectType.create((String)bosTypeStr)))) != null && value instanceof OrgUnitInfo) {
            OrgUnitInfo org = (OrgUnitInfo)value;
            String cuNumber = org.getCU().getNumber();
            logItem.put("FCUnumber", cuNumber);
        }
        if ((value = SCMBizLogAdapter.getObjFromValue(oldInfo, newInfo, "id")) != null) {
            String id = value.toString();
            Set<Map.Entry<String, Set<String>>> entrySet = rootIdMap.entrySet();
            for (Map.Entry<String, Set<String>> entry : entrySet) {
                if (!entry.getValue().contains(id)) continue;
                logItem.put("FOperateNumber", entry.getKey());
            }
        }
    }

    private static Object getObjFromValue(IObjectValue oldInfo, IObjectValue newInfo, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        Object value = null;
        if (newInfo != null) {
            value = newInfo.get(fieldName);
        }
        if (value == null && oldInfo != null) {
            value = oldInfo.get(fieldName);
        }
        return value;
    }

    private static void writeModifyLog(Context ctx, HashMap<String, Object> logItem, List<LogConfigEntryInfo> entryInfoList, IObjectValue oldInfo, IObjectValue newInfo, String bosTypeStr, EntityObjectInfo bo, Map<String, String> fieldsAliasMap, Map<String, Set<String>> rootIdMap) throws Exception {
        block23: {
            IObjectValue tempObjectValue;
            Map<String, List<String>> fieldsMap;
            block22: {
                Map deleteMap;
                List<String> fieldsList;
                Map addMap;
                int index;
                String fieldName;
                List<String> fieldsList2;
                if (oldInfo == null && newInfo == null) {
                    return;
                }
                fieldsMap = SCMBizLogAdapter.getFieldMap(SCMBizLogAdapter.getFieldList(entryInfoList));
                SCMBizLogAdapter.addLogItemForBill(ctx, logItem, oldInfo, newInfo, bosTypeStr, rootIdMap);
                if (oldInfo == null || newInfo == null) break block22;
                InfoAccess infoAccess = new InfoAccess(bo, newInfo, oldInfo);
                Map result = infoAccess.contrastInfoToMap();
                if (result == null) break block23;
                Map updateMap = (Map)result.get("updateMap");
                if (updateMap != null && !updateMap.isEmpty()) {
                    for (Map.Entry objEntry : updateMap.entrySet()) {
                        if (fieldsMap.containsKey((String)objEntry.getKey())) {
                            ValueAccess valueAccess = (ValueAccess)objEntry.getValue();
                            List infoList = valueAccess.getInfoList();
                            if (infoList == null) continue;
                            fieldsList2 = fieldsMap.get((String)objEntry.getKey());
                            Iterator<String> fieldsIt = fieldsList2.iterator();
                            while (fieldsIt.hasNext()) {
                                StringBuffer newValueStrBuffer = new StringBuffer();
                                StringBuffer oldValueStrBuffer = new StringBuffer();
                                fieldName = fieldsIt.next();
                                for (int i = 0; i < infoList.size(); ++i) {
                                    ValueAccess innerValueAccess;
                                    Map innerUpdateMap;
                                    Map info = (Map)infoList.get(i);
                                    index = (Integer)info.get("index");
                                    Map infoMap = (Map)info.get("infoMap");
                                    if (infoMap == null || (innerUpdateMap = (Map)infoMap.get("updateMap")) == null || (innerValueAccess = (ValueAccess)innerUpdateMap.get(fieldName)) == null) continue;
                                    newValueStrBuffer.append(index + 1).append("\u884c:").append(innerValueAccess.getNewVal()).append(",");
                                    oldValueStrBuffer.append(index + 1).append("\u884c:").append(innerValueAccess.getOldVal()).append(",");
                                }
                                SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, newValueStrBuffer.toString(), oldValueStrBuffer.toString(), fieldsAliasMap, (String)objEntry.getKey(), fieldName);
                            }
                            continue;
                        }
                        List<String> fieldsList3 = fieldsMap.get("bill");
                        fieldName = (String)objEntry.getKey();
                        if (fieldsList3 == null || !fieldsList3.contains(fieldName)) continue;
                        ValueAccess valueAccess = (ValueAccess)objEntry.getValue();
                        SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, valueAccess.getNewVal(), valueAccess.getOldVal(), fieldsAliasMap, null, (String)objEntry.getKey());
                    }
                }
                if ((addMap = (Map)result.get("addMap")) != null && !addMap.isEmpty()) {
                    for (Map.Entry addEntry : addMap.entrySet()) {
                        ValueAccess addValueAccess = (ValueAccess)addEntry.getValue();
                        if (addValueAccess != null && fieldsMap.containsKey((String)addEntry.getKey())) {
                            List addInfoList = addValueAccess.getInfoList();
                            if (addInfoList == null) continue;
                            fieldsList = fieldsMap.get((String)addEntry.getKey());
                            Iterator<String> fieldsIt = fieldsList.iterator();
                            while (fieldsIt.hasNext()) {
                                StringBuffer valueStrBuffer = new StringBuffer();
                                fieldName = fieldsIt.next();
                                for (Map addRowInfo : addInfoList) {
                                    if (addRowInfo == null) continue;
                                    index = (Integer)addRowInfo.get("index");
                                    IObjectValue newValueInfo = (IObjectValue)addRowInfo.get("newVal");
                                    valueStrBuffer.append(index + 1).append("\u884c:").append(newValueInfo.get(fieldName)).append(",");
                                }
                                SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, valueStrBuffer.toString(), null, fieldsAliasMap, (String)addEntry.getKey(), fieldName);
                            }
                            continue;
                        }
                        fieldsList2 = fieldsMap.get("bill");
                        fieldName = (String)addEntry.getKey();
                        if (fieldsList2 == null || !fieldsList2.contains(fieldName)) continue;
                        SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, addValueAccess.getNewVal(), addValueAccess.getOldVal(), fieldsAliasMap, null, fieldName);
                    }
                }
                if ((deleteMap = (Map)result.get("deleteMap")) == null || deleteMap.isEmpty()) break block23;
                for (Map.Entry deleteEntry : deleteMap.entrySet()) {
                    ValueAccess deleteValueAccess = (ValueAccess)deleteEntry.getValue();
                    if (deleteValueAccess != null && fieldsMap.containsKey((String)deleteEntry.getKey())) {
                        List deleteInfoList = deleteValueAccess.getInfoList();
                        List<String> fieldsList4 = fieldsMap.get((String)deleteEntry.getKey());
                        Iterator<String> fieldsIt = fieldsList4.iterator();
                        while (fieldsIt.hasNext()) {
                            StringBuffer valueStrBuffer = new StringBuffer();
                            fieldName = fieldsIt.next();
                            for (Map deleteRowInfo : deleteInfoList) {
                                if (deleteRowInfo == null) continue;
                                int index2 = (Integer)deleteRowInfo.get("index");
                                IObjectValue newValueInfo = (IObjectValue)deleteRowInfo.get("oldVal");
                                valueStrBuffer.append(index2 + 1).append("\u884c:").append(newValueInfo.get(fieldName)).append(",");
                            }
                            SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, null, valueStrBuffer.toString(), fieldsAliasMap, (String)deleteEntry.getKey(), fieldName);
                        }
                        continue;
                    }
                    fieldsList = fieldsMap.get("bill");
                    fieldName = (String)deleteEntry.getKey();
                    if (fieldsList == null || !fieldsList.contains(fieldName)) continue;
                    SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, deleteValueAccess.getNewVal(), deleteValueAccess.getOldVal(), fieldsAliasMap, null, fieldName);
                }
                break block23;
            }
            boolean isAdd = false;
            if (oldInfo == null) {
                tempObjectValue = newInfo;
                isAdd = true;
            } else {
                tempObjectValue = oldInfo;
            }
            for (Map.Entry<String, List<String>> e : fieldsMap.entrySet()) {
                Object value;
                List<String> fieldsList;
                if ("bill".equals(e.getKey())) {
                    fieldsList = e.getValue();
                    for (String fieldName : fieldsList) {
                        value = tempObjectValue.get(fieldName);
                        SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, isAdd ? value : null, isAdd ? "" : value, fieldsAliasMap, null, fieldName);
                    }
                    continue;
                }
                if (!(tempObjectValue.get(e.getKey()) instanceof IObjectCollection)) continue;
                fieldsList = e.getValue();
                IObjectCollection entryColl = (IObjectCollection)tempObjectValue.get(e.getKey());
                Iterator<String> fieldsIt = fieldsList.iterator();
                while (fieldsIt.hasNext()) {
                    String fieldName;
                    StringBuffer valueStrBuffer = new StringBuffer();
                    fieldName = fieldsIt.next();
                    for (int i = 0; i < entryColl.size(); ++i) {
                        value = entryColl.getObject(i).get(fieldName);
                        valueStrBuffer.append(i + 1).append("\u884c:").append(value).append(",");
                    }
                    SCMBizLogAdapter.innerWriteModifyLog(ctx, logItem, isAdd ? valueStrBuffer : null, isAdd ? null : valueStrBuffer, fieldsAliasMap, e.getKey(), fieldName);
                }
            }
        }
    }

    private static HashMap<String, Object> getLogItem(IServiceContext serviceContext, IObjectPK mainBizOrgPk, BusinessObjectInfo entityInfo) throws BOSException, EASBizException {
        Context ctx = serviceContext.getContext();
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        hashLog.put("FEntityID", serviceContext.getBoType().toString());
        if (entityInfo != null) {
            hashLog.put("FEntityName", entityInfo.getName());
            hashLog.put("FEntityAlias", entityInfo.getAlias());
            MethodInfo mInfo = SCMBizLogAdapter.getMethodInfo(entityInfo, serviceContext.getOperationPK());
            if (mInfo != null) {
                String methodName = mInfo.getName();
                hashLog.put("FMethodName", methodName);
                hashLog.put("FMethodAlias", mInfo.getAlias());
            }
        }
        if (mainBizOrgPk != null) {
            SelectorItemCollection select = new SelectorItemCollection();
            select.add("number");
            select.add("name");
            FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(mainBizOrgPk);
            if (orgUnit != null) {
                hashLog.put("FOperateOrg", orgUnit.getNumber());
                hashLog.put("FOperateOrgName", orgUnit.getName());
            }
        }
        return hashLog;
    }

    private static MethodInfo getMethodInfo(BusinessObjectInfo info, IMetaDataPK operationPK) {
        MethodInfo methodInfo = null;
        if (operationPK == null) {
            return methodInfo;
        }
        for (MethodInfo method : info.getAllMethodsRuntime()) {
            if (!method.getString("innerID").equals(operationPK.toString())) continue;
            methodInfo = method;
            break;
        }
        return methodInfo;
    }

    private static List<String> getFieldList(List<LogConfigEntryInfo> list) {
        ArrayList<String> fieldList = new ArrayList<String>(list.size());
        Iterator<LogConfigEntryInfo> it = list.iterator();
        while (it.hasNext()) {
            fieldList.add(it.next().getField());
        }
        return fieldList;
    }

    public static Map<String, List<String>> getFieldMap(List<String> fieldList) {
        HashMap<String, List<String>> fieldsMap = new HashMap<String, List<String>>();
        for (String field : fieldList) {
            ArrayList<String> innerFieldList;
            if (StringUtils.isEmpty((String)field)) continue;
            String[] fieldArr = field.split("\\.");
            if (fieldArr.length == 1) {
                if (fieldsMap.get("bill") == null) {
                    innerFieldList = new ArrayList<String>();
                    innerFieldList.add(fieldArr[0]);
                    fieldsMap.put("bill", innerFieldList);
                    continue;
                }
                ((List)fieldsMap.get("bill")).add(fieldArr[0]);
                continue;
            }
            if (fieldArr.length != 2) continue;
            if (fieldsMap.get(fieldArr[0]) == null) {
                innerFieldList = new ArrayList();
                innerFieldList.add(fieldArr[1]);
                fieldsMap.put(fieldArr[0], innerFieldList);
                continue;
            }
            ((List)fieldsMap.get(fieldArr[0])).add(fieldArr[1]);
        }
        return fieldsMap;
    }

    private static SelectorItemCollection getSelect(Context ctx, Map<String, List<LogConfigEntryInfo>> fieldsMap, BOSObjectType bosType) throws BOSException, EASBizException {
        BizObjectOrgHelper bizObjectHelper;
        String companyFieldName;
        SCMBizLogBillConfigInfo slbci;
        List<LogConfigEntryInfo> thisFieldsList;
        SelectorItemCollection select = new SelectorItemCollection();
        if (fieldsMap != null && (thisFieldsList = fieldsMap.get(bosType.toString())) != null) {
            for (int i = 0; i < thisFieldsList.size(); ++i) {
                LogConfigEntryInfo entryInfo = thisFieldsList.get(i);
                String field = entryInfo.getField();
                if (entryInfo.isIsRelationField()) {
                    select.add(field + ".id");
                    select.add(field + ".name");
                    select.add(field + ".number");
                    continue;
                }
                select.add(field);
            }
        }
        if ((slbci = SCMBizLogCache.getSCMBizLogBillConfigInfo(ctx, bosType.toString())) != null) {
            if (!StringUtils.isEmpty((String)slbci.getEntryField())) {
                if (!StringUtils.isEmpty((String)slbci.getCoreBillField())) {
                    select.add(slbci.getEntryField() + "." + slbci.getCoreBillField());
                }
                if (!StringUtils.isEmpty((String)slbci.getSourceBillField())) {
                    select.add(slbci.getEntryField() + "." + slbci.getSourceBillField());
                }
            }
            if (!StringUtils.isEmpty((String)slbci.getNumberField())) {
                select.add(slbci.getNumberField());
            }
        }
        if (!StringUtils.isEmpty((String)(companyFieldName = (bizObjectHelper = new BizObjectOrgHelper()).getBizObjOrgPropertyName(ctx, bosType)))) {
            select.add(companyFieldName + ".CU.number");
            select.add(companyFieldName + ".name");
        }
        select.add("sourceBillId");
        select.add("id");
        return select;
    }

    private static boolean checkClassPath(Context ctx, String className) throws BOSException {
        if (StringUtils.isEmpty((String)className)) {
            return false;
        }
        Set<String> packageSet = SCMBizLogCache.getPackageCheckConfig(ctx);
        if (packageSet == null || packageSet.isEmpty()) {
            logger.error((Object)"packageCheckConfig not exist!");
            return false;
        }
        boolean isPass = false;
        for (String packageStr : packageSet) {
            if (!className.startsWith(packageStr)) continue;
            isPass = true;
            break;
        }
        return isPass;
    }

    private static Boolean checkMethod(Context ctx, BusinessObjectInfo entityInfo, IMetaDataPK operationPK) throws BOSException {
        boolean isPass = true;
        Set<String> methodSet = SCMBizLogCache.getMethodCheckConfig(ctx);
        if (methodSet == null || methodSet.isEmpty()) {
            return true;
        }
        MethodInfo info = SCMBizLogAdapter.getMethodInfo(entityInfo, operationPK);
        if (info == null) {
            return false;
        }
        for (String methodName : methodSet) {
            if (!methodName.equals(info.getName())) continue;
            isPass = false;
            logger.debug((Object)("checkMethod not pass:" + info.getAlias() + info.getName()));
            break;
        }
        return isPass;
    }

    private static Set<String> getSelfPkSet(IServiceContext serviceContext) {
        Object[] params = serviceContext.getOperationParameters();
        if (params == null) {
            return null;
        }
        HashSet<String> selfPkSet = new HashSet<String>();
        BOSObjectType objectType = serviceContext.getBoType();
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            Collection coll;
            Object objectID;
            if (params[i] == null) continue;
            if (params[i] instanceof IObjectPK) {
                IObjectPK objectPK = (IObjectPK)params[i];
                BOSUuid objectID2 = null;
                try {
                    objectID2 = BOSUuid.read((String)objectPK.toString());
                }
                catch (Exception e) {
                    logger.error((Object)" type is not right !", (Throwable)e);
                }
                if (objectID2 == null || !objectType.equals((Object)objectID2.getType())) continue;
                selfPkSet.add(objectPK.toString());
                return selfPkSet;
            }
            if (params[i] instanceof BOSUuid) {
                objectID = (BOSUuid)params[i];
                if (!objectType.equals((Object)objectID.getType())) continue;
                selfPkSet.add(objectID.toString());
                return selfPkSet;
            }
            if (params[i] instanceof String) {
                objectID = (String)params[i];
                if (objectID == null || !BOSUuid.isValid((String)objectID, (boolean)true) || !objectType.equals((Object)BOSUuid.read((String)objectID).getType())) continue;
                selfPkSet.add((String)objectID);
                return selfPkSet;
            }
            if (params[i] instanceof CoreBaseInfo) {
                CoreBaseInfo model = (CoreBaseInfo)params[i];
                BOSUuid objectID3 = model.getId();
                if (!objectType.equals((Object)model.getBOSType())) continue;
                if (objectID3 != null) {
                    selfPkSet.add(objectID3.toString());
                } else {
                    selfPkSet.add(new ObjectUuidPK(BOSUuid.create((BOSObjectType)model.getBOSType())).toString());
                }
                return selfPkSet;
            }
            if (params[i] instanceof IObjectPK[]) {
                IObjectPK[] objectUuidPKAry = (IObjectPK[])params[i];
                if (objectUuidPKAry == null) continue;
                for (int j = 0; j < objectUuidPKAry.length; ++j) {
                    try {
                        if (!objectType.equals((Object)BOSUuid.read((String)objectUuidPKAry[j].toString()).getType())) continue;
                        selfPkSet.add(objectUuidPKAry[j].toString());
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)" type is not right !", (Throwable)e);
                    }
                }
                if (selfPkSet.isEmpty()) continue;
                return selfPkSet;
            }
            if (params[i] instanceof BOSUuid[]) {
                BOSUuid[] bOSUuidAry = (BOSUuid[])params[i];
                for (int j = 0; j < bOSUuidAry.length; ++j) {
                    if (!objectType.equals((Object)bOSUuidAry[j].getType())) continue;
                    selfPkSet.add(bOSUuidAry[j].toString());
                }
                if (selfPkSet.isEmpty()) continue;
                return selfPkSet;
            }
            if (params[i] instanceof String[]) {
                String[] strPK = (String[])params[i];
                for (int j = 0; j < strPK.length; ++j) {
                    if (strPK[j] == null || !BOSUuid.isValid((String)strPK[j], (boolean)true) || !objectType.equals((Object)BOSUuid.read((String)strPK[j]).getType())) continue;
                    selfPkSet.add(strPK[j]);
                }
                if (selfPkSet.isEmpty()) continue;
                return selfPkSet;
            }
            if (params[i] instanceof Set || params[i] instanceof List) {
                coll = (Collection)params[i];
                for (Object value : coll) {
                    String strValue;
                    if (value == null || !BOSUuid.isValid((String)(strValue = value.toString()), (boolean)true) || !objectType.equals((Object)BOSUuid.read((String)strValue).getType())) continue;
                    selfPkSet.add(strValue);
                }
                if (selfPkSet.isEmpty()) continue;
                return selfPkSet;
            }
            if (!(params[i] instanceof AbstractObjectCollection)) continue;
            coll = (AbstractObjectCollection)params[i];
            for (Object value : coll) {
                if (value == null || !(value instanceof CoreBaseInfo)) continue;
                CoreBaseInfo model = (CoreBaseInfo)value;
                BOSUuid objectID4 = model.getId();
                if (!objectType.equals((Object)model.getBOSType())) continue;
                if (objectID4 != null) {
                    selfPkSet.add(objectID4.toString());
                    continue;
                }
                selfPkSet.add(new ObjectUuidPK(BOSUuid.create((BOSObjectType)model.getBOSType())).toString());
            }
            if (selfPkSet.isEmpty()) continue;
            return selfPkSet;
        }
        return null;
    }

    private static IObjectPK getMainBizOrgPK(IServiceContext serviceContext) throws Exception {
        IObjectPK bizOrgPK;
        BizObjectOrgHelper bizObjectHelper = new BizObjectOrgHelper();
        BOSObjectType bosType = serviceContext.getBoType();
        Context context = serviceContext.getContext();
        IObjectValue bizData = null;
        bizData = PermissionServiceAdapterHelper.getObjectValue((IServiceContext)serviceContext, (BOSObjectType)bosType);
        Set<String> idSet = null;
        if (bizData == null && !(idSet = SCMBizLogAdapter.getSelfPkSet(serviceContext)).isEmpty()) {
            bizData = new ObjectUuidPK(idSet.iterator().next());
        }
        BOSObjectType objectType = serviceContext.getBoType();
        if (bizData != null && (bizOrgPK = bizObjectHelper.getCoreBillBaseBizOrgPK(context, objectType, (Object)bizData)) != null) {
            return bizOrgPK;
        }
        if (bizData != null) {
            String parentPropertyName;
            HashSet<IObjectPK> tempIdSet = new HashSet<IObjectPK>(1);
            tempIdSet.add(SCMBizLogAdapter.getPKFromObj(bizData));
            if (!tempIdSet.isEmpty() && !StringUtils.isEmpty((String)(parentPropertyName = bizObjectHelper.getBizObjOrgPropertyName(context, objectType)))) {
                Object obj;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add(parentPropertyName + ".id");
                IObjectCollection coll = SCMBizLogAdapter.getCollByRequiresNew(context, null, bosType, tempIdSet, sic);
                if (coll != null && coll.size() > 0 && (obj = coll.getObject(0).get(parentPropertyName)) != null && obj instanceof AbstractCoreBaseInfo) {
                    AbstractCoreBaseInfo value = (AbstractCoreBaseInfo)obj;
                    return new ObjectStringPK(value.getId().toString());
                }
            }
        }
        return null;
    }

    private static IObjectPK getPKFromObj(Object bizData) {
        if (bizData == null) {
            return null;
        }
        if (bizData instanceof IObjectValue) {
            IObjectValue targetValueInfo = (IObjectValue)bizData;
            String idStr = StringUtils.cnulls((Object)targetValueInfo.get(targetValueInfo.getPKField()));
            if (!StringUtils.isEmpty((String)idStr)) {
                return new ObjectStringPK(idStr);
            }
        } else if (bizData instanceof IObjectPK) {
            return (IObjectPK)bizData;
        }
        return null;
    }

    private BusinessObjectInfo getEntityInfo(IServiceContext svcCtx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)svcCtx.getContext());
        BOSObjectType boType = svcCtx.getBoType();
        EntityObjectInfo boInfo = null;
        if (svcCtx.getMetaType().equals((Object)MetaDataTypeList.ENTITY)) {
            boInfo = loader.getEntity(boType);
        } else if (svcCtx.getMetaType().equals((Object)MetaDataTypeList.FACADE)) {
            boInfo = loader.getFacade(boType);
        }
        return boInfo;
    }

    static class CompareDataAndWriteLogThread
    extends Thread {
        private Context ctx;
        private HashMap<String, Object> logItem;
        private Map<String, Object> oldValues;
        private Map<String, Object> newValues;
        private Map<String, List<LogConfigEntryInfo>> fieldsMap;
        private Map<String, Set<String>> rootIdMap;

        CompareDataAndWriteLogThread(Context ctx, HashMap<String, Object> logItem, Map<String, Object> newValues, Map<String, Object> oldValues, Map<String, List<LogConfigEntryInfo>> fieldsMap, Map<String, Set<String>> rootIdMap) {
            this.ctx = ctx;
            this.logItem = logItem;
            this.newValues = newValues;
            this.oldValues = oldValues;
            this.fieldsMap = fieldsMap;
            this.rootIdMap = rootIdMap;
        }

        @Override
        public void run() {
            try {
                SCMBizLogAdapter.compareDataAndWriteLog(this.ctx, this.logItem, this.newValues, this.oldValues, this.fieldsMap, this.rootIdMap);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }
}

