/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.portrait.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitIndexFactory;
import com.kingdee.eas.scm.framework.portrait.client.AbstractSCMPortraitIndexListUI;
import com.kingdee.eas.scm.framework.portrait.util.SCMPortraitUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMPortraitIndexListUI
extends AbstractSCMPortraitIndexListUI {
    private static final Logger logger = CoreUIObject.getLogger(SCMPortraitIndexListUI.class);
    public static final String COL_STATE = "state";
    public static final String COL_IS_SYSTEM = "isSystem";
    public static final String COL_CU_ID = "cuID";
    private String RESOURCE = "com.kingdee.eas.scm.framework.portrait.SCMPortraitResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.scm.framework.portrait.client.SCMPortraitIndexEditUI";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SCMPortraitIndexFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        String orgId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        try {
            if (SCMPortraitUtil.checkFunctionPermission(null, userId, orgId, "portraitIndex_view")) {
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)orgId, CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        return filter;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        Map resultMap = SCMPortraitIndexFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).batchEnable(ids);
        boolean hasError = (Boolean)resultMap.get("hasError");
        String string = msg = hasError ? EASResource.getString((String)this.RESOURCE, (String)"anyBillNotActive") : EASResource.getString((String)this.RESOURCE, (String)"activeSucceed");
        if (hasError) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)resultMap.get("errorMsg").toString(), (int)2);
        }
        this.setMessageText(msg);
        this.refresh(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        Map resultMap = SCMPortraitIndexFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).batchDisable(ids);
        boolean hasError = (Boolean)resultMap.get("hasError");
        String string = msg = hasError ? EASResource.getString((String)this.RESOURCE, (String)"anyBillNotDisable") : EASResource.getString((String)this.RESOURCE, (String)"disableSucceed");
        if (hasError) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)resultMap.get("errorMsg").toString(), (int)2);
        }
        this.setMessageText(msg);
        this.refresh(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.editCheck();
        super.actionEdit_actionPerformed(e);
    }

    private void editCheck() throws BOSException, EASBizException {
        boolean isSystem;
        this.checkSelected();
        IRow selectedRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        BizEnumValueDTO state = (BizEnumValueDTO)selectedRow.getCell(COL_STATE).getValue();
        if (state.getInt() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE, (String)"enable2Edit"));
            SysUtil.abort();
        }
        if (isSystem = ((Boolean)selectedRow.getCell(COL_IS_SYSTEM).getValue()).booleanValue()) {
            MsgBox.showWarning((String)EASResource.getString((String)this.RESOURCE, (String)"systemNotEdit"));
            SysUtil.abort();
        }
        String orgId = (String)selectedRow.getCell(COL_CU_ID).getValue();
        UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        String permissionStr = SCMPortraitUtil.checkFunctionPermissionStr(null, currentUserInfo.getId().toString(), orgId, "portraitIndex_update");
        if (permissionStr != null) {
            MsgBox.showInfo((String)permissionStr);
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }
}

