/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.portrait.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AdvancedPermissionServiceFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.framework.portrait.client.AbstractSCMPortraitLogConditionUI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class SCMPortraitLogConditionUI
extends AbstractSCMPortraitLogConditionUI {
    private static final Logger logger = SCMPortraitLogConditionUI.getLogger(SCMPortraitLogConditionUI.class);
    private NewCtrlF7 ctrlF7 = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        ArrayList<FullOrgUnitInfo> infoList = new ArrayList<FullOrgUnitInfo>();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("cuID")) {
                String cuId = (String)filterItemInfo.getCompareValue();
                try {
                    FullOrgUnitInfo data = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuId)));
                    infoList.add(data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("occurTime")) {
                if (CompareType.GREATER_EQUALS == filterItemInfo.getCompareType()) {
                    this.dateFrom.setValue(filterItemInfo.getCompareValue());
                } else if (CompareType.LESS_EQUALS == filterItemInfo.getCompareType()) {
                    this.dateTo.setValue(filterItemInfo.getCompareValue());
                }
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("userType")) continue;
            String typeAlias = (String)filterItemInfo.getCompareValue();
            Iterator iter = UserType.iterator();
            while (iter.hasNext()) {
                UserType userType = (UserType)iter.next();
                if (!typeAlias.equals(userType.getAlias())) continue;
                this.coboUserType.setSelectedItem((Object)userType);
            }
        }
        OrgUnitInfo[] infos = new OrgUnitInfo[infoList.size()];
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = (OrgUnitInfo)infoList.get(i);
            idSet.add(infos[i].getId().toString());
        }
        this.prmtCu.setData((Object)infos);
        this.ctrlF7.setSelectedOrgIds(idSet);
    }

    private void init() {
        this.prmtCu.setDisplayFormat("$name$");
        this.prmtCu.setCommitFormat("$number$");
        this.prmtCu.setEditFormat("$number$");
        this.ctrlF7 = new NewCtrlF7((IUIObject)this);
        this.ctrlF7.setMultiSelect(false);
        this.ctrlF7.setIsCUFilter(false);
        this.ctrlF7.setNeedAddOrgRange(false);
        FilterInfo filterInfo = this.outerFilterInfo();
        this.ctrlF7.setOuterFilterInfo(filterInfo);
        this.ctrlF7.setExtraTreeFilters(filterInfo.toString().replace("unit.id", "BASEUNIT.FID"));
        this.prmtCu.setSelector((KDPromptSelector)this.ctrlF7);
        this.prmtCu.setEditable(false);
        this.initUserType();
        this.dateFrom.setTimeEnabled(true);
        this.dateTo.setTimeEnabled(true);
        long currentTimeMillis = System.currentTimeMillis();
        this.dateFrom.setValue((Object)new Timestamp(currentTimeMillis - 86400000L));
        this.dateTo.setValue((Object)new Timestamp(currentTimeMillis));
        this.prmtCu.requestFocusInWindow();
    }

    public FilterInfo outerFilterInfo() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        HashSet<String> orgUnitSet = new HashSet<String>();
        FullOrgUnitCollection unitCol = null;
        FilterInfo filter = new FilterInfo();
        try {
            unitCol = AdvancedPermissionServiceFactory.getRemoteInstance().getAuthorizedOrgsWithCU((IObjectPK)new ObjectUuidPK(user.getId()), OrgType.ControlUnit, "portraitLog_view", true);
            for (int i = 0; i < unitCol.size(); ++i) {
                orgUnitSet.add(unitCol.get(i).getId().toString());
            }
            if (!orgUnitSet.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                sb.append("unit.id in (");
                Iterator iterator = orgUnitSet.iterator();
                while (iterator.hasNext()) {
                    sb.append("'" + (String)iterator.next() + "'").append(",");
                }
                sb.replace(sb.length() - 1, sb.length() - 1, ")");
                filter.getFilterItems().add(new FilterItemInfo(sb.toString()));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("unit.id", null));
            }
        }
        catch (BOSException | EASBizException e) {
            this.handUIException(e);
        }
        return filter;
    }

    private void initUserType() {
        DefaultComboBoxModel<UserType> model = new DefaultComboBoxModel<UserType>();
        model.addElement(null);
        Iterator iter = UserType.iterator();
        while (iter.hasNext()) {
            UserType type = (UserType)iter.next();
            model.addElement(type);
        }
        this.coboUserType.setModel(model);
        this.coboUserType.setSelectedIndex(0);
    }

    public FilterInfo getFilterInfo() {
        UserType selectedUserType;
        FilterInfo filter = new FilterInfo();
        Object data = this.prmtCu.getData();
        if (data != null && data instanceof OrgUnitInfo) {
            filter.getFilterItems().add(new FilterItemInfo("cuID", (Object)((OrgUnitInfo)data).getId().toString()));
        }
        Timestamp fromDate = this.dateFrom.getTimestamp();
        Timestamp toDate = this.dateTo.getTimestamp();
        if (fromDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("occurTime", (Object)fromDate, CompareType.GREATER_EQUALS));
        }
        if (toDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("occurTime", (Object)toDate, CompareType.LESS_EQUALS));
        }
        if ((selectedUserType = (UserType)this.coboUserType.getSelectedItem()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("userType", (Object)selectedUserType.getAlias()));
        }
        return filter;
    }

    public void clear() {
        this.prmtCu.setValue(null);
        long currentTimeMillis = System.currentTimeMillis();
        this.dateFrom.setValue((Object)new Timestamp(currentTimeMillis - 86400000L));
        this.dateTo.setValue((Object)new Timestamp(currentTimeMillis));
        this.coboUserType.setSelectedIndex(0);
    }
}

