/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.solutionmgr.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.scm.framework.client.BaseCommonFilterPanel;
import com.kingdee.eas.scm.framework.client.CommonFilterPanelUtil;
import com.kingdee.eas.scm.framework.solutionmgr.SolutionMgrFacadeFactory;
import com.kingdee.eas.scm.framework.solutionmgr.tools.SolutionMgrConditionInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class SolutionMgrFilterPanel
extends BaseCommonFilterPanel {
    private static final long serialVersionUID = 1L;
    private String main_table = null;
    Object[] conditionInfoArray = null;

    public SolutionMgrFilterPanel(FilterInfo filterInfo, String mainTable, int width, int height, int defaultRows) throws Exception {
        super(filterInfo, width, height, defaultRows);
        this.main_table = mainTable;
        this.initConditionFields();
        this.jbInit();
    }

    public String getMain_table() {
        return this.main_table;
    }

    public void setMain_table(String main_table) {
        this.main_table = main_table;
    }

    private void initConditionFields() throws BOSException {
        this.conditionInfoArray = SolutionMgrFacadeFactory.getRemoteInstance().getColunmsByTable(this.main_table);
    }

    @Override
    protected void loadCondition(int rowIndex, RowObject rowObject) throws Exception {
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            KDTDefaultCellEditor kdtConditionCellEditor = this.getKDComBoBoxCellEditor();
            this.kdtTable.getRow(rowIndex).getCell(1).setEditor((ICellEditor)kdtConditionCellEditor);
            KDComboBox comboBox = (KDComboBox)kdtConditionCellEditor.getComponent();
            this.setFieldComboBoxField(this.kdtTable, comboBox, rowIndex, 1, strCondition);
            this.setCompareValueCellEditor(this.kdtTable.getRow(rowIndex), ((SolutionMgrConditionInfo)this.kdtTable.getRow(rowIndex).getCell(1).getValue()).getFieldDataType());
        }
    }

    private void setFieldComboBoxField(KDTable table, KDComboBox comboBox, int rowIndex, int colIndex, String fieldValue) {
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        for (int i = 0; i < count; ++i) {
            Object obj = comboBox.getItemAt(i);
            if (!obj.toString().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem((Object)fieldValue);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
    }

    @Override
    protected void loadCompareValue(int rowIndex, RowObject rowObject) throws Exception {
        Object compareValue = rowObject.getCompareValue();
        Object sign = this.kdtTable.getRow(rowIndex).getCell(2).getValue();
        if (CompareSignEnum.LIKESIGN.equals(sign) && compareValue.toString().startsWith("%") && compareValue.toString().endsWith("%")) {
            compareValue = compareValue.toString().substring(1, compareValue.toString().length() - 1);
        }
        this.kdtTable.getRow(rowIndex).getCell(3).setValue(compareValue);
    }

    @Override
    protected void setConditionCell(int rowIndex) throws Exception {
        KDTDefaultCellEditor kdtDefaultCellEditor = this.getKDComBoBoxCellEditor();
        this.kdtTable.getRow(rowIndex).getCell(1).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    @Override
    protected void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtTable.getRow(rowIndex);
        SolutionMgrConditionInfo conditionObj = null;
        Object contionRow = row.getCell(1).getValue();
        if (contionRow == null || StringUtil.isEmpty((String)contionRow.toString())) {
            row.getCell(2).getStyleAttributes().setLocked(true);
            row.getCell(3).getStyleAttributes().setLocked(true);
            if (row.getCell(2).getValue() != null) {
                row.getCell(2).setValue(null);
            }
            if (row.getCell(3).getValue() != null) {
                row.getCell(3).setValue(null);
            }
            if (row.getCell(3).getStyleAttributes() != null) {
                row.getCell(3).getStyleAttributes().setNumberFormat("");
            }
        } else {
            conditionObj = (SolutionMgrConditionInfo)contionRow;
            String fieldType = conditionObj.getFieldDataType();
            row.getCell(2).getStyleAttributes().setLocked(false);
            row.getCell(3).getStyleAttributes().setLocked(false);
            if (row.getCell(2).getValue() == null) {
                row.getCell(2).setValue((Object)CompareSignEnum.EQUALSSIGN);
            }
            this.setCompareValueCellEditor(row, fieldType);
        }
    }

    @Override
    protected void setCompareSignCell(int rowIndex) {
        int columnIndex = 2;
        IRow row = this.kdtTable.getRow(rowIndex);
        Object contionRow = row.getCell(1).getValue();
        if (contionRow == null || StringUtil.isEmpty((String)contionRow.toString())) {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else {
            this.kdtTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
            this.kdtTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            if (this.kdtTable.getRow(rowIndex).getCell(columnIndex).getEditor() == null) {
                CommonFilterPanelUtil.setComboBoxField(row.getCell(columnIndex), CommonFilterPanelUtil.addObjectToArray(this.getCompareSignEnumArray().toArray(), null));
            }
        }
    }

    private KDTDefaultCellEditor getKDComBoBoxCellEditor() {
        Object[] temp = CommonFilterPanelUtil.addObjectToArray(this.conditionInfoArray, "");
        KDComboBox cbox = new KDComboBox(temp);
        KDTDefaultCellEditor dbFields_CellEditor = new KDTDefaultCellEditor((JComboBox)cbox);
        return dbFields_CellEditor;
    }

    private void setCompareValueCellEditor(IRow row, String fieldType) {
        if ("datetime".equalsIgnoreCase(fieldType)) {
            KDDatePicker datePicker = new KDDatePicker();
            datePicker.setTimeEnabled(true);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
            row.getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
            row.getCell(3).getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        } else {
            KDTextField field = new KDTextField();
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
            row.getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
        }
    }

    @Override
    protected String getConditionString(IRow iRow) throws Exception {
        String fieldStr = null;
        if (iRow.getCell(1).getValue() != null) {
            fieldStr = iRow.getCell(1).getValue().toString();
            fieldStr = this.main_table + "." + fieldStr;
        }
        return fieldStr;
    }

    @Override
    protected Object getCompareValue(IRow iRow) throws Exception {
        SolutionMgrConditionInfo conditionObj = (SolutionMgrConditionInfo)iRow.getCell(1).getValue();
        Object compareValue = iRow.getCell(3).getValue();
        Object compareSign = iRow.getCell(2).getValue();
        String fieldType = "";
        if (compareValue != null) {
            if (conditionObj != null) {
                fieldType = conditionObj.getFieldDataType();
            }
            if ("datetime".equalsIgnoreCase(fieldType)) {
                compareValue = Util.getValue((Object)compareValue);
            } else if ("int".equalsIgnoreCase(fieldType)) {
                compareValue = new Integer(compareValue.toString());
            } else if ("numeric".equalsIgnoreCase(fieldType) || "decimal".equalsIgnoreCase(fieldType)) {
                NumberFormat nf = CtrlFormatUtilities.getDecimalFormat();
                compareValue = nf.parse(compareValue.toString());
            } else {
                compareValue = Util.getValue((Object)compareValue);
            }
            if (CommonFilterUtil.isLikeSign((Object)compareSign) && compareValue instanceof String) {
                compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
            }
        }
        return compareValue;
    }

    @Override
    public boolean verify() {
        boolean flag = true;
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            String tipStr = existBlankColumnWarning;
            if (!StringUtil.isEmpty((String)this.getPanelName())) {
                tipStr = this.getPanelName() + ":" + existBlankColumnWarning;
            }
            MsgBox.showWarning((Component)((Object)this), (String)tipStr);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            String tipStr = bracketNotMatchingWarning;
            if (!StringUtil.isEmpty((String)this.getPanelName())) {
                tipStr = this.getPanelName() + ":" + bracketNotMatchingWarning;
            }
            MsgBox.showWarning((Component)((Object)this), (String)tipStr);
            return false;
        }
        return flag;
    }

    @Override
    protected void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtTable.getRow(rowIndex);
        Object compareValue = row.getCell(3).getValue();
        SolutionMgrConditionInfo conditionInfo = null;
        Object conditionObj = row.getCell(1).getValue();
        if (compareValue != null && (conditionObj == null || StringUtil.isEmpty((String)conditionObj.toString()))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"15_SolutionMgrFilterPanel"));
            row.getCell(3).setValue(null);
            return;
        }
        conditionInfo = (SolutionMgrConditionInfo)conditionObj;
        if (compareValue != null) {
            String fieldName = conditionInfo.getFieldName();
            String fieldType = conditionInfo.getFieldDataType();
            if ("datetime".equalsIgnoreCase(fieldType)) {
                compareValue = Util.getValue((Object)compareValue);
                try {
                    Date date = new Date(compareValue.toString());
                }
                catch (Exception e0) {
                    MsgBox.showWarning((Component)((Object)this), (String)(fieldName + EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"16_SolutionMgrFilterPanel")));
                    row.getCell(3).setValue(null);
                    return;
                }
            }
            if ("int".equalsIgnoreCase(fieldType)) {
                try {
                    compareValue = new Integer(compareValue.toString());
                }
                catch (Exception e1) {
                    row.getCell(3).setValue(null);
                    MsgBox.showWarning((Component)((Object)this), (String)(fieldName + EASResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.SOLUTIONMGRAutoGenerateResource", (String)"17_SolutionMgrFilterPanel")));
                    return;
                }
            }
        }
    }

    @Override
    protected int[] calculateWidths() {
        int unit = (this.getWidth() - 8 - 8) / 5;
        return new int[]{unit / 2, unit + 15, unit - 30, unit + 20, unit / 2, unit - 35};
    }
}

